<?php
    session_start();

    include './load.php';
    include './templates/header.php';
    include './app/models/Users.php';

    if(isset($_GET["key"]) && !empty($_GET["key"])) {
        $key = $_GET["key"];
        $user = new Users();

        $keyMatch = $user->getUserBySecretKey($key);
        if(!$keyMatch) {
            $res =  array("status" => "danger", "message" => "Sorry, your password reset link has expired.");

            header("Location: ".BASE_URL."forgot-password.php?" . http_build_query($res) . "");
            exit();
        }
    }else {
        header("Location:./index.php");
        exit();
    }
?>

<!-- Header start -->
<header>
    <div class="header-content">
        <div class="container">
            <div class="content-wrapper">
                <div class="header-logo">
                    <a href="<?php echo BASE_URL; ?>">
                        <img src="public/images/logo-main.svg" alt="">
                    </a>
                </div>
                <div class="header-nav">
                    <ul class="d-flex list-unstyled m-0">
                        <li><a href="">Home</a></li>
                        <!-- <li><a href="">About</a></li> -->
                        <li><a href="">Contact Us</a></li>
                    </ul>
                </div>
                <div class="header-button">
                    <button class="btn butn-primary">Get Started</button>
                </div>
            </div>
        </div>
    </div>
</header>

<div class="change_pwd_form">
    <div class="form_wrapper">
        <div class="mb-30">
            <div class="mb-15">
                <h3 class="mb-15">Change password</h3>
                <p>In order to protect you account, make sure your password.</p>
            </div>
            <ul>
                <li class="mb-5">Is longer then 7 charecters</li>
                <li>Does not match or significantly contain your username, e.g. do not use 'username123'</li>
            </ul>
        </div>
        <form action="app/core/recovery.php" method="post">
            <div class="form-group mb-15">
                <label for="">New password</label>
                <input class="form-control" name="password" type="password" placeholder="New password">
            </div>
            <div class="form-group mb-15">
                <label for="">Re-type new Password</label>
                <input class="form-control" name="confirm_password" type="password" placeholder="e-type new Password">
            </div>
            <input type="hidden" name="action" value="CHANGE_PASSWORD">
            <input type="hidden" name="key" value="<?php echo $key; ?>">
            <div class="form_btn">
                <button name="change_pwd_btn" type="submit" class="btn butn-primary"> Continue </button>
                <a href="signin">&lt; Back to login</a>
            </div>
    </form>
    </div>
</div>

<footer>
    <div class="footer-top d-flex align-items-center">
        <div class="container">
            <div class="footer-content d-flex align-items-center justify-content-between">
                <div class="footer-pages">
                    <ul class="list-unstyled m-0">
                        <li><a href="<?php echo BASE_URL; ?>terms.php">Terms of USE</a></li>
                    </ul>
                </div>
                <div class="social-links">
                    <ul class="list-unstyled m-0">
                        <li>
                            <a href="">
                                <!-- <img src="public/images/linkedin.svg" alt=""> -->
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom d-flex align-items-center">
        <div class="container">
            <div class="bottom-content">
                <div class="row">
                    <div class="col-sm-12 col-md-6">
                        <div class="footer-logo">
                            <a href="<?php echo BASE_URL; ?>">
                                <img src="public/images/logo-light.svg" alt="">
                            </a>
                        </div>
                        
                    </div>
                    <div class="col-sm-12 col-md-6">
                        <div class="footer-copyright">
                            <a href="javascript:void(0);">© 2023. All rights reserved.</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php
    include './templates/footer.php';
?>