<?php
    session_start();

    include './load.php';
    include './templates/header.php';

    include './app/models/Users.php';

    if(!isSeller()) {
        
    }

    $uid = $_SESSION["user_id"];

    $users = new Users();
    // echo json_encode($messages);

    $user = $users->getUserById($uid);
?>

<div class="edit-product d-flex">
    <!-- Include Sidebar -->
    <div class="sidebar">
        <div class="sidebar-content">
            <div class="sidebar-logo d-flex align-items-center justify-content-center">
                <img src="public/images/logo-sm.svg" alt="">
            </div>
            <div class="sidebar-nav">
                <div class="nav-items">
                    <div class="item <?php echo $_SESSION["show"] === "home" ? "active" : ""; ?>">
                        <a href="seller.php?show=home">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M30.06 10.23L21.42 4.18503C19.065 2.53503 15.45 2.62503 13.185 4.38003L5.66999 10.245C4.16999 11.415 2.98499 13.815 2.98499 15.705V26.055C2.98499 29.88 6.08998 33 9.91498 33H26.085C29.91 33 33.015 29.895 33.015 26.07V15.9C33.015 13.875 31.71 11.385 30.06 10.23ZM19.125 27C19.125 27.615 18.615 28.125 18 28.125C17.385 28.125 16.875 27.615 16.875 27V22.5C16.875 21.885 17.385 21.375 18 21.375C18.615 21.375 19.125 21.885 19.125 22.5V27Z" fill="#60CB97"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "chat" ? "active" : ""; ?>" id="chatBtn">
                        <a href="seller.php?show=chat">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M33 9.375V17.025C33 18.93 32.37 20.535 31.245 21.645C30.135 22.77 28.53 23.4 26.625 23.4V26.115C26.625 27.135 25.485 27.75 24.645 27.18L23.19 26.22C23.325 25.755 23.385 25.245 23.385 24.705V18.6C23.385 15.54 21.345 13.5 18.285 13.5H8.09999C7.88999 13.5 7.695 13.515 7.5 13.53V9.375C7.5 5.55 10.05 3 13.875 3H26.625C30.45 3 33 5.55 33 9.375Z" fill="white" stroke="#60CB97" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M23.385 18.6V24.705C23.385 25.245 23.325 25.755 23.19 26.22C22.635 28.425 20.805 29.805 18.285 29.805H14.205L9.675 32.82C9 33.285 8.09999 32.79 8.09999 31.98V29.805C6.56999 29.805 5.295 29.295 4.41 28.41C3.51 27.51 3 26.235 3 24.705V18.6C3 15.75 4.77 13.785 7.5 13.53C7.695 13.515 7.88999 13.5 8.09999 13.5H18.285C21.345 13.5 23.385 15.54 23.385 18.6Z" fill="white" stroke="#60CB97" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "products" ? "active" : ""; ?>" id="productsBtn">
                        <a href="seller.php?show=products">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M30.1501 10.41C30.1501 11.22 29.7151 11.955 29.0251 12.33L26.4151 13.74L24.1951 14.925L19.5901 17.415C19.0951 17.685 18.5551 17.82 18.0001 17.82C17.4451 17.82 16.9051 17.685 16.4101 17.415L6.9751 12.33C6.2851 11.955 5.8501 11.22 5.8501 10.41C5.8501 9.6 6.2851 8.865 6.9751 8.49L9.9301 6.9L12.2851 5.625L16.4101 3.405C17.4001 2.865 18.6001 2.865 19.5901 3.405L29.0251 8.49C29.7151 8.865 30.1501 9.6 30.1501 10.41Z" fill="white"/>
                                <path d="M14.8501 19.185L6.07508 14.805C5.40008 14.46 4.62008 14.505 3.97508 14.895C3.33008 15.285 2.95508 15.975 2.95508 16.725V25.02C2.95508 26.46 3.75008 27.75 5.04008 28.395L13.8151 32.775C14.1151 32.925 14.4451 33 14.7751 33C15.1651 33 15.5551 32.895 15.9001 32.67C16.5451 32.28 16.9201 31.59 16.9201 30.84V22.545C16.9351 21.12 16.1401 19.83 14.8501 19.185Z" fill="white"/>
                                <path d="M33.0449 16.7249V25.0199C33.0449 26.4449 32.2499 27.7349 30.9599 28.3799L22.1849 32.7749C21.8849 32.9249 21.5549 32.9999 21.2249 32.9999C20.8349 32.9999 20.4449 32.8949 20.0849 32.6699C19.4549 32.2799 19.0649 31.5899 19.0649 30.8399V22.5599C19.0649 21.1199 19.8599 19.8299 21.1499 19.1849L24.3749 17.5799L26.6249 16.4549L29.9249 14.8049C30.5999 14.4599 31.3799 14.4899 32.0249 14.8949C32.6549 15.2849 33.0449 15.9749 33.0449 16.7249Z" fill="white"/>
                                <path d="M26.4149 13.74L24.1949 14.925L9.92993 6.9L12.2849 5.625L26.0549 13.395C26.2049 13.485 26.3249 13.605 26.4149 13.74Z" fill="white"/>
                                <path d="M26.625 16.4551V19.8601C26.625 20.4751 26.115 20.9851 25.5 20.9851C24.885 20.9851 24.375 20.4751 24.375 19.8601V17.5801L26.625 16.4551Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "notifications" ? "active" : ""; ?>" id="notificationsBtn">
                        <a href="seller.php?show=notifications">
                            <div class="unread-notif-counter" style="display: none;">0</div>
                            <svg width="28" height="28" viewBox="0 0 27 31" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path id="Vector" d="M26.4096 21.3609C25.5799 19.9266 24.5815 17.1984 24.5815 12.375V11.3766C24.5815 5.14688 19.5893 0.0421875 13.444 0H13.3596C11.8841 0.00184556 10.4234 0.2943 9.06089 0.860664C7.69839 1.42703 6.46079 2.25621 5.41874 3.30087C4.37669 4.34553 3.55061 5.58521 2.98766 6.94912C2.4247 8.31304 2.13591 9.77448 2.13776 11.25V12.375C2.13776 17.1984 1.13932 19.9266 0.30963 21.3609C0.108973 21.7028 0.00217139 22.0915 3.2762e-05 22.4879C-0.00210587 22.8842 0.100495 23.2741 0.297451 23.6181C0.494407 23.962 0.778729 24.2478 1.12164 24.4466C1.46456 24.6454 1.8539 24.75 2.25026 24.75H7.73463C7.73463 26.2418 8.32726 27.6726 9.38216 28.7275C10.437 29.7824 11.8678 30.375 13.3596 30.375C14.8515 30.375 16.2822 29.7824 17.3371 28.7275C18.392 27.6726 18.9846 26.2418 18.9846 24.75H24.469C24.8653 24.7525 25.2551 24.6497 25.5986 24.452C25.942 24.2543 26.2268 23.9689 26.4237 23.625C26.6189 23.2791 26.7203 22.8882 26.7178 22.4911C26.7154 22.094 26.6091 21.7044 26.4096 21.3609ZM13.3596 28.125C12.4657 28.1213 11.6094 27.7645 10.9772 27.1324C10.3451 26.5003 9.98833 25.644 9.98463 24.75H16.7346C16.7309 25.644 16.3742 26.5003 15.742 27.1324C15.1099 27.7645 14.2536 28.1213 13.3596 28.125Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div class="logout-btn">
                <a class="button" href="logout.php">
                    <img src="public/images/fi-sr-sign-out-alt.svg" alt="">
                </a>
            </div>
        </div>
    </div>

    <div class="main">
        <div class="header">
            <div class="header-wrap">
                <div class="menu-bar">
                    <img src="public/images/fi-sr-bar.svg" alt="">
                </div>
                <div class="header-left">
                    <div class="header-title">
                        <h3 class="m-0">Seller Page</h3>
                    </div>
                    <div class="header-logo">
                        <img src="public/images/logo-main.svg" alt="">
                    </div>
                </div>
                <div class="header-right">
                    <div class="search">
                        <div class="icon">
                            <img src="public/images/bi_search-heart-fill.svg" alt="">
                        </div>
                        <input class="form-control" type="search" name="" id="" placeholder="Search your query">
                    </div>
                    <div class="notification">

                    </div>
                    <div class="profile">
                        <div class="profile-item">
                            <div class="left">
                                <div class="user-name">
                                    <h6><?php echo $_SESSION["userData"]["company_name"]; ?></h6>
                                </div>
                                <div class="profile-nav">
                                    <!-- <p class="m-0"></p> -->
                                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" role="button" data-bs-toggle="dropdown" aria-expanded="false">My Account</a>
                                </div>
                            </div>
                            <div class="right">
                                <div class="profile-image">
                                    <img src="public/images/<?php echo $_SESSION["userData"]["company_logo"]; ?>" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <ul class="dropdown-menu header-dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                <li>
                                    <a class="dropdown-item" href="change-password.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" data-name="Layer 1" viewBox="0 0 24 24" id="edit">
                                            <path d="M3.5,24h15A3.51,3.51,0,0,0,22,20.487V12.95a1,1,0,0,0-2,0v7.537A1.508,1.508,0,0,1,18.5,22H3.5A1.508,1.508,0,0,1,2,20.487V5.513A1.508,1.508,0,0,1,3.5,4H11a1,1,0,0,0,0-2H3.5A3.51,3.51,0,0,0,0,5.513V20.487A3.51,3.51,0,0,0,3.5,24Z"></path><path d="M9.455,10.544l-.789,3.614a1,1,0,0,0,.271.921,1.038,1.038,0,0,0,.92.269l3.606-.791a1,1,0,0,0,.494-.271l9.114-9.114a3,3,0,0,0,0-4.243,3.07,3.07,0,0,0-4.242,0l-9.1,9.123A1,1,0,0,0,9.455,10.544Zm10.788-8.2a1.022,1.022,0,0,1,1.414,0,1.009,1.009,0,0,1,0,1.413l-.707.707L19.536,3.05Zm-8.9,8.914,6.774-6.791,1.4,1.407-6.777,6.793-1.795.394Z"></path>
                                        </svg>
                                        <span class="ml-5 text-muted" style="font-weight: 500;">Edit</span>
                                    </a>
                                </li>
                                <hr>
                                <li>
                                    <a class="dropdown-item" href="logout.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="25" viewBox="0 0 24 24" id="logout">
                                            <path d="M12.59,13l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76,1,1,0,0,0-.21-.33l-4-4a1,1,0,1,0-1.42,1.42L12.59,11H3a1,1,0,0,0,0,2ZM12,2A10,10,0,0,0,3,7.55a1,1,0,0,0,1.8.9A8,8,0,1,1,12,20a7.93,7.93,0,0,1-7.16-4.45,1,1,0,0,0-1.8.9A10,10,0,1,0,12,2Z"></path>
                                        </svg>
                                        <span class="ml-5 text-muted">Logout</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="main-content">
            <div class="">
                <div class="update-product">
                    <?php
                        if(isset($response) && $response["type"] === "form-msg") {
                            ?>
                                <div class="alert alert-<?php echo $response["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                                    <?php echo $response["message"]; ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            <?php
                        }

                        if(isset($_GET["status"]) && isset($_GET["message"])) {
                            ?>
                                <div class="alert alert-<?php echo $_GET["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                                    <?php echo $_GET["message"]; ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                </div>
                            <?php
                        }
                    ?>

                    <div class="card mb-3">
                        <div class="card-header">Update Preferences</div>
                        <div class="card-body">
                            <div class="form-group product-list mb-15">
                                <label for="" class="d-flex align-items-center gap-2">
                                    <input type="checkbox" name="notifications" id="notifications" <?php echo $user["newsletter_preference"] === '1' ? 'checked' : ''; ?>> Notifications
                                </label>
                            </div>
                        </div>
                    </div>
    
                    <div class="card">
                        <div class="card-header">Change Password</div>
                        <div class="card-body">
                            <form action="app/core/change-password.php" method="POST">
                                <div class="form-group product-list mb-15">
                                    <label for="">Current Password</label>
                                    <input type="password" name="current-password" class="form-control" id="" required>
                                </div>
                                <div class="form-group product-list mb-15">
                                    <label for="">New Password</label>
                                    <input type="password" name="new-password" class="form-control" id="" required>
                                </div>
                                <div class="form-group product-list mb-15">
                                    <label for="">Confirm Password</label>
                                    <input type="password" name="confirm-password" class="form-control" id="" required>
                                </div>
                                <div class="form-group">
                                    <button type="submit" name="change-password" value="1" class="btn butn-primary">Change Password</button>
                                </div>
                            </form>
                        </div>
                    </div>
    
                </div>
            </div>
            
            <!-- Include Footer -->
            <footer>
                <div class="footer-top d-flex align-items-center">
                    <div class="container">
                        <div class="footer-content d-flex align-items-center justify-content-between">
                            <div class="footer-pages">
                                <ul class="list-unstyled m-0">
                                    <li><a href="<?php echo BASE_URL; ?>terms.php">Terms of USE</a></li>
                                </ul>
                            </div>
                            <div class="social-links">
                                <ul class="list-unstyled m-0">
                                    <li>
                                        <a href="">
                                            <!-- <img src="public/images/linkedin.svg" alt=""> -->
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="footer-bottom d-flex align-items-center">
                    <div class="container">
                        <div class="bottom-content">
                            <div class="row">
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-logo">
                                        <a href="<?php echo BASE_URL; ?>">
                                            <img src="public/images/logo-light.svg" alt="">
                                        </a>
                                    </div>
                                    
                                </div>
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-copyright">
                                        <a href="javascript:void(0);">© 2023. All rights reserved.</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
</div>

<?php
    include './templates/footer.php';
?>

<script>
    $(document).ready(function() {
        $(".menu-bar").click(function() {
            $(".sidebar").toggleClass("active");
        });
        
        $(".profile-item").click(function() {
            $(".header-dropdown-menu").toggle();
        });
    });
</script>