<?php
    session_start();

    include './load.php';
    include './templates/header.php';
?>

<!-- Header start -->
<header>
    <div class="header-content">
        <div class="container">
            <div class="content-wrapper">
                <div class="header-logo">
                    <a href="<?php echo BASE_URL; ?>">
                        <img src="public/images/logo-main.svg" alt="">
                    </a>
                </div>
                <div class="header-nav">
                    <ul class="d-flex list-unstyled m-0">
                        <li><a href="">Home</a></li>
                        <!-- <li><a href="">About</a></li> -->
                        <li><a href="mailto:guy@connectionsys.co.uk">Contact Us</a></li>
                    </ul>
                </div>
                <div class="header-button">
                    <button class="btn butn-primary">Get Started</button>
                </div>
            </div>
        </div>
    </div>
</header>

<div class="forgot_pwd_form">
    <div class="container">
        <div class="page-content mt-50 mb-50">
            <h2>Terms of Use</h2>
            <p>These Terms of Use ("Agreement") govern your use of the [Connection system] ("System"), which includes access and usage of services provided by the System. Please read this Agreement carefully before accessing or using the System. By registering as a Buyer or Seller and accessing the System, you agree to be bound by this Agreement. If you do not agree with any part of these terms, please do not use the System.</p>
    
            <h5>1. Registration</h5>
            <p>1.1. Buyer Registration: To access the System as a Buyer, you must provide your company name, work email, and password during the registration process.</p>
            <p>1.2. Seller Registration: To access the System as a Seller, you must provide your company name, work email, password, and a list of products you sell during the registration process.</p>
    
            <h5>2. Buyer's Use of the System</h5>
            <p>2.1. Publishing a Project: Buyers can use the System to publish projects. When publishing a project, the Buyer must specify the name of the product(s) they are looking to buy.</p>
            <p>2.2. Notifications to Sellers: Upon publishing a project, all registered Sellers who indicated that they sell the product(s) the Buyer is seeking will receive email notifications and updates within the System.</p>
            <p>2.3. Communication with Sellers: Sellers have the opportunity to respond to the Buyer's project by providing price quotes, sending files (quotes), and engaging in chat discussions to clarify any questions or uncertainties.</p>
            <p>2.4. Comparing Offers: Buyers can compare the offers from various Sellers to make informed decisions regarding their purchases.</p>
            <p>2.5. Best Combination: If the Buyer has advertised multiple products under a single project, they can use the "best combination" feature to view a list of products with the best price offered by different Sellers, facilitating the creation of an optimized shopping basket.</p>
    
            <h5>3. Information Security</h5>
            <p>3.1. It is the user's responsibility not to enter any sensitive or confidential information into the system. Users are encouraged to use the system for business-related information only. Connection System will not take any responsibility for any private data that users choose to input into the system.</p>
    
            <h5>4. System Operation and Availability</h5>
            <p>4.1. Availability: The System will strive to maintain a high level of availability; however, we do not guarantee uninterrupted, secure, or error-free operation of the System.</p>
    
            <h5>5. Termination</h5>
            <p>5.1. Termination by the System: The System reserves the right to terminate or suspend user accounts and access at its discretion, without notice, if users violate this Agreement or engage in any unauthorized or illegal activities.</p>
    
            <h5>6. Modifications to Terms</h5>
            <p>6.1. Changes to Agreement: The System may update or modify this Agreement from time to time. Users are responsible for checking this Agreement periodically for changes. Continued use of the System after such modifications constitutes acceptance of the revised Agreement.</p>
    
            <h5>7. Disclaimer</h5>
            <p>7.1. No Warranty: The System is provided "as is" without warranties of any kind, either express or implied. We make no representations or warranties concerning the reliability, accuracy, or completeness of the information or services provided.</p>
    
            <h5>8. Service Cost and Immediate Changes</h5>
            <p>8.1. Free Service: Currently, the use of the System is provided to users free of charge.</p>
            <p>8.2. Immediate Changes in Service Cost: The System reserves the right to change the cost of the service at any time without prior notice, and such changes may take effect immediately upon implementation. While the service is currently free, it may be subject to fees or charges at any time.</p>
            <p>8.3. Notification of Changes: If there are immediate changes in the service cost, users will be notified via email to the address provided during registration. It is the user's responsibility to check their email and stay informed about any immediate changes in the service cost.</p>
    
            <h5>9. Email Communication</h5>
            <p>9.1. System Notifications: By registering with the System, you acknowledge and consent to receive emails from the System to the email address provided during registration. These emails may include, but are not limited to, notifications about project updates, responses from Sellers, changes in service cost (as described in Section 9), and other information related to your use of the System. The System will use reasonable efforts to ensure that email communications are as relevant and necessary as possible for your use of the System, but it does not commit to guaranteeing their relevance.</p>
            
            <h5>10. Communication Protocol</h5>
            <p>10.1. Exclusive Website Chat Communication: To maintain the transparency and structured nature of the communication process, all communication between Buyers and Sellers should exclusively take place through the chat feature provided on the website. Any attempt to communicate outside the System, including via email or phone, is strictly prohibited.</p>
            <p>10.2. Account Closure: Any user found in violation of Section 10.1 by attempting to communicate outside of the website's chat system may have their account terminated or suspended at the discretion of the System, without notice. The System reserves the right to take such action to protect the user experience and the integrity of the system.</p>
            
            <h5>11. User Responsibility and Disclaimer of Connection System Liability.</h5>
            <p>By accessing or using Connection System, you agree to the following terms and conditions. Connection System shall not be held responsible for any transactions, purchases, or sales made by users on the system. It is the sole responsibility of the user to thoroughly review and assess any products, services, or information before engaging in any transactions. Connection System disclaims any liability for the accuracy, reliability, or suitability of any content, products, or services offered by third parties on the system. Users are advised to exercise caution and conduct their own due diligence before making any purchases or sales. By using the system, users acknowledge and accept that they are solely responsible for their actions and any consequences thereof.</p>
            
            <p>By using the System, you acknowledge that you have read, understood, and agreed to these Terms of Use, including the provision of email notifications. If you do not agree with these terms, please refrain from using the System. If you have any questions or concerns, please contact guy@connectionsys.co.uk.</p>
        </div>
    </div>
</div>

<footer>
    <div class="footer-top d-flex align-items-center">
        <div class="container">
            <div class="footer-content d-flex align-items-center justify-content-between">
                <div class="footer-pages">
                    <ul class="list-unstyled m-0">
                        <li><a href="<?php echo BASE_URL; ?>terms.php">Terms of USE</a></li>
                    </ul>
                </div>
                <div class="social-links">
                    <ul class="list-unstyled m-0">
                        <li>
                            <a href="">
                                <!-- <img src="public/images/linkedin.svg" alt=""> -->
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom d-flex align-items-center">
        <div class="container">
            <div class="bottom-content">
                <div class="row">
                    <div class="col-sm-12 col-md-6">
                        <div class="footer-logo">
                            <a href="<?php echo BASE_URL; ?>">
                                <img src="public/images/logo-light.svg" alt="">
                            </a>
                        </div>
                        
                    </div>
                    <div class="col-sm-12 col-md-6">
                        <div class="footer-copyright">
                            <a href="javascript:void(0);">© 2023. All rights reserved.</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php
    include './templates/footer.php';
?>