<?php
    session_start();

    include './load.php';
    include './templates/header.php';

    // include './app/models/Users.php';
    include './app/models/Projects.php';

    if(!isSeller()) {
        
    }

    $uid = $_SESSION["user_id"];

    $projects = new Projects();

    // $users = new Users();
    // $user = $users->getUserById($uid);
    // echo json_encode($messages);

?>

<style>
    .search-results a {
        font-size: 17px;
        text-decoration: none;
        color: #000;
    }

    .search-results a:hover {
        text-decoration: underline;
        text-decoration-color: #60cb97; 
    }
    input{
        background-color: #f1f1f1 !important;
    }
</style>

<style>
    .header-right .search {
        position: relative;
        /* min-width: 300px;
        width: 420px; */
    }

    /* For small screens (mobile devices) */
    @media screen and (max-width: 480px) {
        .header-right .search {
            min-width: 200px;
            width: 280px !important;
        }
    }

    /* For medium screens (tablets or smaller laptops) */
    @media screen and (min-width: 481px) and (max-width: 768px) {
        .header-right .search {
            min-width: 250px;
            width: 350px !important;
        }
    }

    /* For larger screens (desktops and large laptops) */
    @media screen and (min-width: 769px) and (max-width: 1200px) {
        .header-right .search {
            /* min-width: 300px; */
            width: 420px !important;
        }
    }

    /* For extra-large screens (wide desktops or high-res monitors) */
    @media screen and (min-width: 1201px) and (max-width: 1600px) {
        .header-right .search {
            min-width: 350px;
            width: 500px !important;
        }
    }

    /* For very large screens (extremely wide monitors) */
    @media screen and (min-width: 1601px) {
        .header-right .search {
            min-width: 400px;
            width: 600px !important;
        }
    }
</style>

<div class="edit-product d-flex">
    <!-- Include Sidebar -->
    <div class="sidebar">
        <div class="sidebar-content">
            <div class="sidebar-logo d-flex align-items-center justify-content-center">
                <img src="public/images/logo-sm.svg" alt="">
            </div>
            <div class="sidebar-nav">
                <div class="nav-items">
                    <div class="item">
                        <a href="buyer.php?action=home">Projects</a>
                    </div>
                    <div class="item" id="chatBtn">
                        <a href="product-list.php">Products</a>
                    </div>
                    <div class="item active" id="addBtn">
                        <a href="search.php">Search</a>
                    </div>
                </div>
            </div>
            <div class="logout-btn">
                <a class="button" href="logout.php">
                    <img src="public/images/fi-sr-sign-out-alt.svg" alt="">
                </a>
            </div>
        </div>
    </div>

    <div class="main">
        <div class="header">
            <div class="header-wrap">
                <div class="menu-bar">
                    <img src="public/images/fi-sr-bar.svg" alt="">
                </div>
                <div class="header-left">
                    <div class="header-title">
                        <h3 class="m-0">Search</h3>
                    </div>
                    <div class="header-logo">
                        <img src="public/images/logo-main.svg" alt="">
                    </div>
                </div>
                <div class="header-right">
                <div class="search">
                        <form action="search.php" method="GET">
                            <div class="icon">
                                <button type="submit" style="height: auto; border: 0; background-color: transparent;">
                                    <svg width="18" height="18" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.5 13C7.88314 13.0022 9.23062 12.5613 10.345 11.742H10.344C10.374 11.782 10.406 11.82 10.442 11.857L14.292 15.707C14.4795 15.8946 14.7339 16.0001 14.9991 16.0002C15.2644 16.0003 15.5189 15.895 15.7065 15.7075C15.8941 15.52 15.9996 15.2656 15.9997 15.0004C15.9998 14.7351 15.8945 14.4806 15.707 14.293L11.857 10.443C11.8212 10.4068 11.7828 10.3734 11.742 10.343C12.5611 9.22927 13.002 7.88249 13 6.5C12.9995 4.77626 12.3145 3.12326 11.0956 1.90439C9.87674 0.68552 8.22374 0.000530138 6.5 0C4.77609 0 3.12279 0.684819 1.90381 1.90381C0.684819 3.12279 0 4.77609 0 6.5C0 8.22391 0.684819 9.87721 1.90381 11.0962C3.12279 12.3152 4.77609 13 6.5 13Z" fill="#60CB97"/>
                                    </svg>
                                </button>
                                </div>
                            <input class="form-control" type="text" name="search_key" id="search-input" placeholder="Search your query">
                        </form>
                    </div>

                    <div class="notification">
                    </div>

                    <div class="profile">
                        <div class="profile-item">
                            <div class="left">
                                <div class="user-name">
                                    <h6><?php echo $_SESSION["userData"]["company_name"]; ?></h6>
                                </div>
                                <div class="profile-nav">
                                    <!-- <p class="m-0"></p> -->
                                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" role="button" data-bs-toggle="dropdown" aria-expanded="false">My Account</a>
                                </div>
                            </div>
                            <div class="">
                                <a href="logout.php">
                                    <svg width="30" height="30" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_3_3720)">
                                        <path d="M17.214 22.5C16.8162 22.5 16.4346 22.658 16.1533 22.9393C15.872 23.2206 15.714 23.6022 15.714 24V28.5C15.714 29.6935 15.2399 30.8381 14.396 31.682C13.5521 32.5259 12.4075 33 11.214 33H7.5C6.30653 33 5.16193 32.5259 4.31802 31.682C3.47411 30.8381 3 29.6935 3 28.5V7.5C3 6.30653 3.47411 5.16193 4.31802 4.31802C5.16193 3.47411 6.30653 3 7.5 3H11.214C12.4075 3 13.5521 3.47411 14.396 4.31802C15.2399 5.16193 15.714 6.30653 15.714 7.5V12C15.714 12.3978 15.872 12.7794 16.1533 13.0607C16.4346 13.342 16.8162 13.5 17.214 13.5C17.6118 13.5 17.9934 13.342 18.2747 13.0607C18.556 12.7794 18.714 12.3978 18.714 12V7.5C18.7116 5.51161 17.9207 3.60534 16.5147 2.19933C15.1087 0.793323 13.2024 0.00238179 11.214 0H7.5C5.51161 0.00238179 3.60534 0.793323 2.19933 2.19933C0.793323 3.60534 0.00238179 5.51161 0 7.5L0 28.5C0.00238179 30.4884 0.793323 32.3947 2.19933 33.8007C3.60534 35.2067 5.51161 35.9976 7.5 36H11.214C13.2024 35.9976 15.1087 35.2067 16.5147 33.8007C17.9207 32.3947 18.7116 30.4884 18.714 28.5V24C18.714 23.6022 18.556 23.2206 18.2747 22.9393C17.9934 22.658 17.6118 22.5 17.214 22.5Z" fill="#60CB97"/>
                                        <path d="M34.3007 14.8189L27.4217 7.93987C27.2834 7.7966 27.1179 7.68233 26.9349 7.60371C26.7518 7.5251 26.555 7.48372 26.3558 7.48199C26.1567 7.48026 25.9592 7.51821 25.7748 7.59363C25.5905 7.66905 25.423 7.78043 25.2822 7.92127C25.1413 8.06211 25.0299 8.22959 24.9545 8.41393C24.8791 8.59828 24.8411 8.7958 24.8429 8.99497C24.8446 9.19414 24.886 9.39097 24.9646 9.57397C25.0432 9.75698 25.1575 9.9225 25.3007 10.0609L31.6952 16.4554L9.00024 16.5004C8.60242 16.5004 8.22089 16.6584 7.93958 16.9397C7.65828 17.221 7.50024 17.6025 7.50024 18.0004C7.50024 18.3982 7.65828 18.7797 7.93958 19.061C8.22089 19.3423 8.60242 19.5004 9.00024 19.5004L31.7822 19.4554L25.2977 25.9399C25.1545 26.0782 25.0402 26.2438 24.9616 26.4268C24.883 26.6098 24.8416 26.8066 24.8399 27.0058C24.8381 27.2049 24.8761 27.4025 24.9515 27.5868C25.0269 27.7711 25.1383 27.9386 25.2792 28.0795C25.42 28.2203 25.5875 28.3317 25.7718 28.4071C25.9562 28.4825 26.1537 28.5205 26.3528 28.5187C26.552 28.517 26.7488 28.4756 26.9319 28.397C27.1149 28.3184 27.2804 28.2041 27.4187 28.0609L34.2977 21.1819C35.1418 20.3384 35.6162 19.1942 35.6168 18.001C35.6173 16.8077 35.144 15.6631 34.3007 14.8189Z" fill="#60CB97"/>
                                        </g>
                                        <defs>
                                        <clipPath id="clip0_3_3720">
                                        <rect width="36" height="36" fill="white"/>
                                        </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                            <div class="right">
                                <div class="profile-image">
                                    <img src="public/images/<?php echo $_SESSION["userData"]["company_logo"]; ?>" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <ul class="dropdown-menu header-dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                <li>
                                    <a class="dropdown-item" href="change-password.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" data-name="Layer 1" viewBox="0 0 24 24" id="edit">
                                            <path d="M3.5,24h15A3.51,3.51,0,0,0,22,20.487V12.95a1,1,0,0,0-2,0v7.537A1.508,1.508,0,0,1,18.5,22H3.5A1.508,1.508,0,0,1,2,20.487V5.513A1.508,1.508,0,0,1,3.5,4H11a1,1,0,0,0,0-2H3.5A3.51,3.51,0,0,0,0,5.513V20.487A3.51,3.51,0,0,0,3.5,24Z"></path><path d="M9.455,10.544l-.789,3.614a1,1,0,0,0,.271.921,1.038,1.038,0,0,0,.92.269l3.606-.791a1,1,0,0,0,.494-.271l9.114-9.114a3,3,0,0,0,0-4.243,3.07,3.07,0,0,0-4.242,0l-9.1,9.123A1,1,0,0,0,9.455,10.544Zm10.788-8.2a1.022,1.022,0,0,1,1.414,0,1.009,1.009,0,0,1,0,1.413l-.707.707L19.536,3.05Zm-8.9,8.914,6.774-6.791,1.4,1.407-6.777,6.793-1.795.394Z"></path>
                                        </svg>
                                        <span class="ml-5 text-muted" style="font-weight: 500;">Edit</span>
                                    </a>
                                </li>
                                <hr>
                                <li>
                                    <a class="dropdown-item" href="logout.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="25" viewBox="0 0 24 24" id="logout">
                                            <path d="M12.59,13l-2.3,2.29a1,1,0,0,0,0,1.42,1,1,0,0,0,1.42,0l4-4a1,1,0,0,0,.21-.33,1,1,0,0,0,0-.76,1,1,0,0,0-.21-.33l-4-4a1,1,0,1,0-1.42,1.42L12.59,11H3a1,1,0,0,0,0,2ZM12,2A10,10,0,0,0,3,7.55a1,1,0,0,0,1.8.9A8,8,0,1,1,12,20a7.93,7.93,0,0,1-7.16-4.45,1,1,0,0,0-1.8.9A10,10,0,1,0,12,2Z"></path>
                                        </svg>
                                        <span class="ml-5 text-muted">Logout</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="main-content">
            <div class="p-3" style="margin: 5px 0; background-color: #fff; width: 100%; height: 100%;">
                <div class="form_wraper">
                    <form id="searchForm">
                        <div class="input-group" style="position: relative;">
                            <input type="text" name="" class="form-control" id="searchTerm" style="background-color: #f5f5f5; border-radius: 10px;">

                            <div class="search-btn" id="submitForm" style="position: absolute; top: 10px; right: 10px; z-index: 99; cursor: pointer;">
                                <svg xmlns="http://www.w3.org/2000/svg" width="25px" height="25px" fill="#60cb97" viewBox="0 0 24 24" id="search"><path d="M3.624,15a8.03,8.03,0,0,0,10.619.659l5.318,5.318a1,1,0,0,0,1.414-1.414l-5.318-5.318A8.04,8.04,0,0,0,3.624,3.624,8.042,8.042,0,0,0,3.624,15Zm1.414-9.96a6.043,6.043,0,1,1-1.77,4.274A6,6,0,0,1,5.038,5.038Z"></path></svg>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="search-results mt-20">
                    <ul class="list-unstyled">
                        <?php
                            if (isset($_GET['search_key']) && !empty($_GET['search_key'])) {
                                $search_key = $_GET["search_key"];
                            
                                $results = $projects->getProductsBySearchKey($search_key, $uid);
                                // echo json_encode($results);

                                if ($results) {
                                    // Loop through results and generate HTML for each project
                                    foreach ($results as $project) {
                                        echo '<li><a href="buyer.php?action=load-products&pid='.$project["id"].'">' . htmlspecialchars($project['project_name']) . ' - ' . htmlspecialchars($project['project_description']) . '</a></li>';
                                    }
                                }else {
                                    echo '<li>No projects found.</li>';
                                }
                            }
                        ?>
                    </ul>
                </div>
            </div>
            
            <!-- Include Footer -->
            <footer>
                <div class="footer-top d-flex align-items-center">
                    <div class="container">
                        <div class="footer-content d-flex align-items-center justify-content-between">
                            <div class="footer-pages">
                                <ul class="list-unstyled m-0">
                                    <li><a href="<?php echo BASE_URL; ?>terms.php">Terms of USE</a></li>
                                </ul>
                            </div>
                            <div class="social-links">
                                <ul class="list-unstyled m-0">
                                    <li>
                                        <a href="">
                                            <!-- <img src="public/images/linkedin.svg" alt=""> -->
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="footer-bottom d-flex align-items-center">
                    <div class="container">
                        <div class="bottom-content">
                            <div class="row">
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-logo">
                                        <a href="<?php echo BASE_URL; ?>">
                                            <img src="public/images/logo-light.svg" alt="">
                                        </a>
                                    </div>
                                    
                                </div>
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-copyright">
                                        <a href="javascript:void(0);">© 2023. All rights reserved.</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
</div>

<?php
    include './templates/footer.php';
?>

<script>
    $(document).ready(function() {
        $(".menu-bar").click(function() {
            $(".sidebar").toggleClass("active");
        });
        
        $(".profile-item").click(function() {
            $(".header-dropdown-menu").toggle();
        });

        $('#searchForm').on('submit', function(e) {
            e.preventDefault(); // Prevent default form submission
            
            // Perform search
            performSearch();
        });

        // Click event for search button
        $('#submitForm').on('click', function(e) {
            e.preventDefault(); // Prevent default action of button click
            
            // Perform search
            performSearch();
        });

        // Function to perform search via AJAX
        function performSearch() {
            var searchTerm = $('#searchTerm').val().trim();
            
            if (searchTerm === '') {
                // alert('Please enter a search term.');
                return;
            }
            
            // Perform AJAX request
            $.ajax({
                url: 'app/core/search.php',
                method: 'POST',
                data: { search_key: searchTerm },
                dataType: 'html',
                success: function(response) {
                    // console.log(response);
                    $('.search-results ul').html(response);

                },
                error: function(xhr, status, error) {
                    console.error('AJAX error:', status, error);
                    alert('An error occurred while processing your request.');
                }
            });
        }
    });
</script>