$(document).ready(function () {
  function nav() {
    const nav = $(".js-nav");
    const navLinks = nav.find(".nav__link");
    const slideRect = nav.find(".nav__slider-rect");
    const slideContent = nav.find(".nav__slider-content");

    nav.on("click", ".nav__link", function (evt) {
      if (!$(this).hasClass("nav__link")) {
        return;
      }
      evt.preventDefault();

      navLinks.removeClass("nav__link_active");

      if (!$(this).hasClass("nav__link_active")) {
        $(this).addClass("nav__link_active");
      }

      slideRect.css("transform", `translateX(${$(this).data("transform")}%)`);
      slideContent.css(
        "transform",
        `translateX(-${$(this).data("transform")}%)`
      );
    });
  }

  nav();
});

document.addEventListener("DOMContentLoaded", function () {
  var lazyImages = [].slice.call(document.querySelectorAll("img.lazyload"));

  if ("IntersectionObserver" in window) {
    var lazyImageObserver = new IntersectionObserver(function (
      entries,
      observer
    ) {
      entries.forEach(function (entry) {
        if (entry.isIntersecting) {
          var lazyImage = entry.target;
          lazyImage.src = lazyImage.dataset.src;
          lazyImage.classList.remove("lazyload");
          lazyImageObserver.unobserve(lazyImage);
        }
      });
    });

    lazyImages.forEach(function (lazyImage) {
      lazyImageObserver.observe(lazyImage);
    });
  } else {
    // Fallback for browsers that don't support Intersection Observer
    // Load all images immediately
    lazyImages.forEach(function (lazyImage) {
      lazyImage.src = lazyImage.dataset.src;
      lazyImage.classList.remove("lazyload");
    });
  }
});

$(document).ready(function () {
  $("#notifications").change(function () {
    var isChecked = $(this).is(":checked");
    var formData = {
      action: "update_preferences",
      preferences: isChecked ? 1 : 0,
    };

    $.ajax({
      url: "app/core/update_preferences.php",
      type: "POST",
      data: formData,
      success: function (response) {
        // Handle success
        console.log(response);
      },
      error: function (xhr, status, error) {
        // Handle error
        console.error(error);
      },
    });
  });

  $(".vat-type-switch").on("change", function () {
    var isChecked = $(this).is(":checked");
    var vatType = isChecked ? "with-vat" : "without-vat";

    // Reload the page with vatType value as parameter
    var url = window.location.href.split("?")[0];

    var params = { "vat-type": vatType }; // Create parameter object
    var queryString = $.param(params); // Convert parameter object to query string
    window.location.href = url + "?" + queryString;
  });
});
