<?php
session_start();

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\SMTP;

include './load.php';
include './templates/header.php';
include './app/models/Messages.php';
include './app/models/Notifications.php';
include './app/models/Projects.php';
include './app/models/Products.php';
include './app/models/Settings.php';

if (!isBuyer()) {
    header("Location: index.php");
    exit();
}

$uid = $_SESSION["user_id"];

$authUser = new Users();
$userInfo = $authUser->getUserDetails($uid);
$dateFormat = isset($userInfo['date_format']) ? $userInfo['date_format'] : 'd/m/Y';
$userCurrency = isset($userInfo['currency']) ? $userInfo['currency'] : '£';

$msgModel = new Messages();
$notifModel = new Notifications();
$projectsModel = new Projects();
$productModel = new Products();
$settings = new Settings();
// echo json_encode($messages);

if (isset($_GET["show"])) {
    $_SESSION["show"] = $_GET["show"];

    if ($_GET["show"] === "add") {
        $_SESSION["add-new-project"] = 'show';
    }
}

$last_project_created = $projectsModel->lastProjectCreated($uid);

if ($last_project_created) {
    // $added_on = $projectData["added_on"];

    // Get the current timestamp
    $currentTimestamp = time();

    // Calculate the difference in seconds
    $timeDifference = $currentTimestamp - strtotime($last_project_created);

    if ($timeDifference >= 7 * 24 * 3600) {
        $_SESSION["add-new-project"] = 'show';
    }
}


if (isset($_GET["notif_type"])) {
    $_SESSION["notif_type"] = $_GET["notif_type"];
} else {
    $_SESSION["notif_type"] = 'all';
}

if (isset($_GET["add-to-chat"])) {
    $seller_id = $_GET["add-to-chat"];
    $addToChat = $msgModel->addToChat($uid, $seller_id);

    if ($addToChat) {
        $_SESSION["chat_id"] = $seller_id;

        $msgModel->readAll($uid);
    }
}

if (isset($_GET["chat_id"])) {
    $_SESSION["chat_id"] = $_GET["chat_id"];

    $msgModel->readAll($uid);
}

if (!(isset($_GET["add-to-chat"]) || isset($_GET["chat_id"]))) {
    unset($_SESSION["chat_id"]);
}

if (isset($_GET["update_notif_status"]) && !empty($_GET["update_notif_status"])) {
    $project_id = $_GET["project_id"];
    $seller_id = $_GET["seller_id"];
    $offer_id = $_GET["offer_id"];
    $item_id = $_GET["item_id"];
    $status = $_GET["status_type"];
    $res = $projectsModel->updateStatus($project_id, $offer_id, $item_id, $seller_id, $status);

    // echo json_encode($res);
}

$messages = null;
if (isset($_SESSION["chat_id"])) {
    $user1 = $_SESSION["user_id"];
    $user2 = $_SESSION["chat_id"];

    $chatUser = $msgModel->chatUserDetails($user2);
    $messages = $msgModel->getMessages($user1, $user2);
}

if (isset($_GET["action"]) && $_GET["action"] === "publish-project") {
    $pid = $_GET["pid"];

    $getProject = $projectsModel->getProject($pid);

    if ($getProject && $getProject["status"] === '0') {
        $projectsModel->publishProduct($pid);

        // Select all project items
        $projectItems = $projectsModel->getProjectItems($pid);

        $sellerName = 'one of the register buyer who is';
        if ($settings->get_option("hide-seller-name") === "1") {
            $sellerName = $_SESSION["userData"]["company_name"];
        }

        foreach ($projectItems as $item) {
            $product_type = $item["product_type"];
            $sellers = $projectsModel->searchByKeywords($product_type);
            // echo json_encode($sellers);
            // exit;

            if ($sellers) {
                foreach ($sellers as $seller) {
                    $seller_id = $seller["user_id"];
                    $products_list = $seller["products_list"];

                    $subject = "Looking for a new price offer";
                    $message = '<!DOCTYPE html>
                            <html>
                                <head>
                                    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
                                </head>
                                <body><div style="background-color: #f6f6f6;">
                                    <div style="width: 600px; margin: auto; background-color: #fff;">
                                        <div class="template-header" style="margin: 0 80px; background-color: #60CB97; height: 80px; display: flex; align-items: center; justify-content: center;">
                                            <h1 style="color: #fff; text-transform: uppercase; font-weight: bold; margin: auto; font-size: 32px; text-align: center;">CONNECTION <span style="color: #696969;">SYSTEM</span></h1>
                                        </div>
                                        <div class="template-body" style="">
                                            <div style="padding: 0 80px">
                                                <h1 style="text-align: center; color: #383838; line-height: 36px; margin-bottom: 0; font-family: serif; font-size: 28px; unicode-bidi: plaintext;">DO YOUR BEST IN ORDER TO BE FIRST PLACE!</h1>
                                                <div class="image" style="margin: auto; padding: 30px 0;">
                                                    <img style="width: 100%;" src="https://www.connectionsys.co.uk/public/images/image-1.png" alt="">
                                                </div>
                                            </div>
                                            <div class="box" style="position: relative; padding: 20px 80px; padding-top: 0; background-color: #60CB97;">
                                                <span style="display: block; width: 60%; margin: auto; height: 15px; background-color: #696969;"></span>
                                                <h1 style="text-align: center; text-transform: uppercase; color: #2B454E; font-family: serif; font-size: 38px; margin-top: 15px; margin-bottom: 5px;">NEW OPPORTUNITY</h1>
                                                <h3 style="text-align: center; color: #fff; font-weight: 400; font-size: 21px; line-height: 28px; margin-top: 0; unicode-bidi: plaintext;">you receive a new opportunity from ' . $sellerName . ' looking to buy:</h3>
                                                <div class="project-history" style="background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px;">
                                                    <h3 style="margin-top: 8px; margin-bottom: 5px; text-align: center;">' . $getProject["project_name"] . '</h3>
                                                    <p style="margin-top: 0; margin-bottom: 8px; text-align: center; font-size: 13px; color: #696969;"><b>Post Code:</b> ' . $getProject["post_code"] . '</p>
                                                    <div class="products-wrapper" style="background-color: #fff; margin: 5px; border-radius: 15px; text-align: left;">';

                    $products_list_array = explode(',', $products_list);

                    // Filter $projectItems based on product types in $products_list_array
                    $matchingProducts = array_filter($projectItems, function ($product) use ($products_list_array) {
                        return in_array($product['product_type'], $products_list_array);
                    });

                    // Reset array keys
                    $matchingProducts = array_values($matchingProducts);

                    foreach ($matchingProducts as $matchingProduct) {
                        $itemWidth = '100%';
                        if (count($matchingProducts) > 1) {
                            $itemWidth = '50%';
                        }

                        $quantity = '';
                        if ($matchingProduct["quantity"]) {
                            $quantity = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Quantity:</b> ' . $matchingProduct["quantity"] . '</p>';
                        }

                        $unit = '';
                        if ($matchingProduct["unit"]) {
                            $unit = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Unit:</b> ' . $matchingProduct["unit"] . '</p>';
                        }

                        $date_required = '';
                        if ($matchingProduct["date_required"]) {
                            $date_required = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Date Required:</b> ' . $matchingProduct["date_required"] . '</p>';
                        }

                        $open_to_similar_brands = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> ' . ucfirst($matchingProduct["open_to_similar_brands"]) . '</p>';

                        // $product = $productModel->getProductByName($matchingProduct["product_type"]);

                        // if(!empty($matchingProduct["product_image"])) {
                        //     $img_url = BASE_URL . $matchingProduct["product_image"];
                        // }else {
                        //     if(!empty($product["image"])) {
                        //         $img_url = BASE_URL . $product["image"];
                        //     }else {
                        //         $img_url = 'https://rakanonline.com/wp-content/uploads/2022/08/default-product-image.png';
                        //     }
                        // }

                        // <div class="">
                        //     <img style="width: 50px; margin-bottom: 5px;" src="'.$img_url.'" alt="'.ucfirst($matchingProduct["product_type"]).'" />
                        // </div>

                        $attached_file = '';
                        if (!empty($matchingProduct["product_image"])) {
                            $attached_file = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 14px;text-align: left;"><a href="' . BASE_URL . $matchingProduct["product_image"] . '">See the attached file to view how the buyer expects the materials to look.</a></p>';
                        }

                        $message .= '<div class="product-item" style="box-sizing: border-box; width: ' . $itemWidth . '; display: inline-block; padding: 7.5px;">
                                <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                                    
                                    <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">' . ucfirst($matchingProduct["product_type"]) . '</h3>
                                    <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Description:</b> ' . $matchingProduct["description"] . '</p>
                                    ' . $open_to_similar_brands . '
                                    ' . $quantity . '
                                    ' . $unit . '
                                    ' . $date_required . '
                                    ' . $attached_file . '
                                </div>
                            </div>';
                    }

                    $message .= '</div>
                                        </div>
                                            <div class="button" style="text-align: center;">
                                                <a href="https://www.connectionsys.co.uk/">
                                                    <button style="background-color: #696969; border: transparent; height: 36px; padding: 0 18px; border-radius: 5px; font-size: 16px; text-transform: uppercase; color: #fff; font-weight: bold; cursor: pointer;">Price Him</button>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="template-footer" style="margin: 0 auto; text-align: center;padding: 15px 0;">
                                        <span style="display: block; width: 32%; margin: auto; height: 8px; background-color: #60CB97; margin-bottom: 15px;"></span>
                                        <a href="https://www.connectionsys.co.uk/" style="display: block; text-align: center; font-size: 22px; text-decoration: none; color: #60CB97; font-family: Montserrat;">www.connectionsys.co.uk</a>
                                    </div>
                                </div>
                            </div>
                            </body></html>';

                    $isExists = $projectsModel->checkNotification($pid, $seller_id);
                    if (!$isExists) {
                        $email = $seller["email"];
                        $company_name = $seller["company_name"];

                        $project_name = $getProject["project_name"];
                        $description = $item["description"];

                        $desc = json_encode($description);
                        $projectsModel->addToNofications($project_name, $desc, $pid, $seller_id);

                        $mail = new PHPMailer();
                        try {
                            //Server settings
                            // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                            $mail->isSMTP();                                            //Send using SMTP
                            $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                            $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                            $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                            $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                            $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`

                            //Recipients
                            $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                            $mail->addAddress($email, $company_name);     //Add a recipient
                            // $mail->addAddress('ellen@example.com');               //Name is optional
                            // $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');

                            //Content
                            $mail->isHTML(true);                                  //Set email format to HTML
                            $mail->Subject = $subject;
                            $mail->Body    = $message;
                            // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

                            $mail->send();
                            // echo 'Message has been sent';
                        } catch (Exception $e) {
                            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                            exit;
                        }
                    }
                }
            }
        }
    } else {
        // echo "Project published already!";
    }
}

if (!isset($_SESSION["vat-type"])) {
    $_SESSION["vat-type"] = 'with-vat';
}

if (isset($_GET["vat-type"])) {
    $_SESSION["vat-type"] = $_GET["vat-type"];
}

if (!isset($_SESSION["add-new-project"])) {
    $_SESSION["add-new-project"] = 'hide';
}
?>

<!-- //**\\ -->
<link rel="stylesheet" href="public/css/image-uploader.css">

<?php
if ($settings->get_option('hide-buyer-name') === '0') {
?>
    <style>
        .hide-company-name {
            display: none !important;
        }
    </style>
<?php
}
?>

<style>
    .toggle-switch {
        position: relative;
        display: inline-block;
        width: 50px;
        height: 25px;
    }

    .switch-input {
        display: none;
    }

    .switch-label {
        display: block;
        width: 100%;
        height: 100%;
        border-radius: 17px;
        background-color: #ccc;
        position: relative;
        cursor: pointer;
    }

    .switch-label:before {
        content: '';
        position: absolute;
        top: 2px;
        left: 2px;
        width: 20px;
        height: 20px;
        border-radius: 50%;
        background-color: white;
        transition: transform 0.3s ease;
    }

    .switch-input:checked+.switch-label:before {
        transform: translateX(26px);
    }

    .switch-label:active:before {
        width: 22px;
    }

    .switch-input:checked+.switch-label {
        background: green;
    }

    .center-vertically {
        vertical-align: middle !important;
    }

    input {
        background-color: #f1f1f1 !important;
    }
</style>

<style>
    .box-button {
        height: 45px;
        display: flex;
        align-items: center;
        border: 1px solid #ccc;
        padding: 6px 10px;
        border-radius: 5px;
        margin: auto;
    }

    .label {
        margin-right: 20px;
    }

    .radio-container {
        display: flex;
    }

    .radio-container input[type="radio"] {
        display: none;
    }

    .radio-container label {
        padding: 2px 8px;
        border: 1px solid #ccc;
        border-radius: 5px;
        margin-right: 10px;
        cursor: pointer;
        margin-bottom: 0;
    }

    .radio-container input[type="radio"]:checked+label {
        background-color: #4CAF50;
        color: white;
        border: 1px solid #4CAF50;
    }

    .radio-container input[type="radio"]:checked+label.no {
        background-color: red;
        border: 1px solid red;
    }
</style>

<style>
    .filter-product .product-list li.active,
    .sort-product .filter-options li.active {
        background-color: #60cb97;
        color: #fff;
    }

    table thead th {
        font-size: 11px;
    }

    table tbody td {
        font-size: 13px;
    }

    /* .products-table {
        overflow-x: scroll;
    }

    .products-table table {
        min-width: 1024px;
        overflow-x: auto;
    } */

    @media screen and (max-width: 768px) {
        .products-table {
            overflow-x: auto;
        }
    }

    .products-table table tbody tr:nth-child(even) {
        background-color: #f1f1f175;
    }
</style>

<style>
    .header-right .search {
        position: relative;
        /* min-width: 300px;
        width: 420px; */
    }

    /* For small screens (mobile devices) */
    @media screen and (max-width: 480px) {
        .header-right .search {
            min-width: 200px;
            width: 280px !important;
        }
    }

    /* For medium screens (tablets or smaller laptops) */
    @media screen and (min-width: 481px) and (max-width: 768px) {
        .header-right .search {
            min-width: 250px;
            width: 350px !important;
        }
    }

    /* For larger screens (desktops and large laptops) */
    @media screen and (min-width: 769px) and (max-width: 1200px) {
        .header-right .search {
            /* min-width: 300px; */
            width: 420px !important;
        }
    }

    /* For extra-large screens (wide desktops or high-res monitors) */
    @media screen and (min-width: 1201px) and (max-width: 1600px) {
        .header-right .search {
            min-width: 350px;
            width: 500px !important;
        }
    }

    /* For very large screens (extremely wide monitors) */
    @media screen and (min-width: 1601px) {
        .header-right .search {
            min-width: 400px;
            width: 600px !important;
        }
    }

    .buyer .main .main-content .box-content>div .sec__heading,
    .seller .main .main-content .box-content>div .sec__heading,
    .admin .main .main-content .box-content>div .sec__heading,
    .edit-product .main .main-content .box-content>div .sec__heading,
    .seller-reviews .main .main-content .box-content>div .sec__heading {
        border-bottom: none;
    }
</style>

<div class="buyer d-flex">
    <!-- Include Sidebar -->
    <div class="sidebar">
        <div class="sidebar-content">
            <div class="sidebar-logo d-flex align-items-center justify-content-center">
                <img src="public/images/logo-sm.svg" alt="">
            </div>
            <div class="sidebar-nav">
                <div class="nav-items">
                    <div class="item">
                        <a href="buyer.php?action=home">Projects</a>
                    </div>
                    <div class="item active" id="chatBtn">
                        <a href="product-list.php">Products</a>
                    </div>
                    <div class="item" id="addBtn">
                        <a href="search.php">Search</a>
                    </div>
                </div>
            </div>
            <div class="logout-btn">
                <a class="button" href="logout.php">
                    <img src="public/images/fi-sr-sign-out-alt.svg" alt="">
                </a>
            </div>
        </div>
    </div>

    <div class="main">
        <div class="header">
            <div class="header-wrap">
                <div class="menu-bar">
                    <img src="public/images/fi-sr-bar.svg" alt="">
                </div>
                <div class="header-left d-flex gap-4 align-items-center">
                    <div class="header-title" style="width: 170px;">
                        <h3 class="m-0">Buyer Page</h3>
                    </div>
                    <div class="header-logo">
                        <img src="public/images/logo-main.svg" alt="">
                    </div>
                    <!-- <div class="d-flex flex-column align-items-center justify-between">
                        <small class="text-muted"><?php echo $_SESSION["vat-type"] === 'with-vat' ? 'With VAT' : 'Without VAT' ?></small>
                        <div class="toggle-switch inline">
                            <input type="checkbox" id="local-pickup" class="switch-input vat-type-switch" <?php echo $_SESSION["vat-type"] === 'with-vat' ? 'checked' : '' ?> />
                            <label for="local-pickup" class="switch-label"></label>
                        </div>
                    </div> -->
                </div>
                <div class="header-right">
                    <div class="search">
                        <form action="search.php" method="GET">
                            <div class="icon">
                                <button type="submit" style="height: auto; border: 0; background-color: transparent;">
                                    <svg width="18" height="18" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.5 13C7.88314 13.0022 9.23062 12.5613 10.345 11.742H10.344C10.374 11.782 10.406 11.82 10.442 11.857L14.292 15.707C14.4795 15.8946 14.7339 16.0001 14.9991 16.0002C15.2644 16.0003 15.5189 15.895 15.7065 15.7075C15.8941 15.52 15.9996 15.2656 15.9997 15.0004C15.9998 14.7351 15.8945 14.4806 15.707 14.293L11.857 10.443C11.8212 10.4068 11.7828 10.3734 11.742 10.343C12.5611 9.22927 13.002 7.88249 13 6.5C12.9995 4.77626 12.3145 3.12326 11.0956 1.90439C9.87674 0.68552 8.22374 0.000530138 6.5 0C4.77609 0 3.12279 0.684819 1.90381 1.90381C0.684819 3.12279 0 4.77609 0 6.5C0 8.22391 0.684819 9.87721 1.90381 11.0962C3.12279 12.3152 4.77609 13 6.5 13Z" fill="#60CB97" />
                                    </svg>
                                </button>
                            </div>
                            <input class="form-control" type="text" name="search_key" id="search-input" placeholder="Search your query">
                        </form>
                    </div>

                    <div class="notification">
                        <div class="dropdown-icon">
                            <div class="notif-alert" style="display: none;"></div>
                            <img src="public/images/notification-dark.svg" alt="">
                        </div>
                        <div class="notification-menu <?php echo isset($_GET["notif_type"]) ? 'active' : ''; ?>">
                            <div class="load-notifications" style="display: none;">
                                <a href="javascript:void(0);">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="reload">
                                        <path d="M21,11a1,1,0,0,0-1,1,8.05,8.05,0,1,1-2.22-5.5h-2.4a1,1,0,0,0,0,2h4.53a1,1,0,0,0,1-1V3a1,1,0,0,0-2,0V4.77A10,10,0,1,0,22,12,1,1,0,0,0,21,11Z"></path>
                                    </svg>
                                    <span>view new projects</span>
                                </a>
                            </div>
                            <div class="notif-header">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="notif-back-btn">
                                        <a href="javascript:void(0);">Back</a>
                                    </div>
                                    <div class="title">
                                        <h5 class="m-0">Notifications</h5>
                                    </div>
                                    <div class=""></div>
                                </div>
                            </div>
                            <div class="notifs">
                                <div class="d-flex align-items-center justify-content-end mr-10 mt-5 mb-5">
                                    <?php
                                    if (isset($_SESSION["notif_type"]) && $_SESSION["notif_type"] === 'marked') {
                                    ?>
                                        <a href="?notif_type=all">
                                            <img width="30" src="public/images/star.svg" alt="">
                                        </a>
                                    <?php
                                    } else {
                                    ?>
                                        <a href="?notif_type=marked">
                                            <img width="30" src="public/images/star-light.svg" alt="">
                                        </a>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <div class="lists-container">
                                    <?php
                                    $notifications = $notifModel->getBuyerNotifications($uid);

                                    if ($notifications) {
                                        foreach ($notifications["data"] as $notification) {
                                            // echo json_encode($notification);
                                    ?>
                                            <div class="list" data-id="<?php echo $notification["offer_id"]; ?>">
                                                <div class="info d-flex align-items-center justify-content-between">

                                                    <div class="p-meta">
                                                        <div class="d-flex gap-4">
                                                            <div class="notif-icon" style="width: 60px;">
                                                                <img src="public/images/notification.svg" alt="">
                                                            </div>
                                                            <div class="" style="width: 100%;">
                                                                <div class="title mb-10">
                                                                    <div class="">
                                                                        <h6><?php echo $notification["project_name"]; ?></h6>
                                                                        <span class="d-block mt-1 text-muted hide-company-name"><b><?php echo $notification["company_name"]; ?></b></span>
                                                                        <span class="text-muted"><b>Postcode:</b> <?php echo $notification["post_code"]; ?></span>
                                                                    </div>
                                                                    <div class="start">
                                                                        <!-- <img class="star-image" width="20" src="public/images/star-light.svg" alt=""> -->
                                                                        <a class="mark-notifications" href="javascript:void(0);" data-id="<?php echo $notification["offer_id"]; ?>">
                                                                            <?php
                                                                            if ($notification["is_marked"] === '0') {
                                                                            ?>
                                                                                <img class="star-image" width="20" src="public/images/star-light.svg" alt="">
                                                                            <?php
                                                                            } else {
                                                                            ?>
                                                                                <img class="star-image" width="20" src="public/images/star.svg" alt="">
                                                                            <?php
                                                                            }
                                                                            ?>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="desc">
                                                            <?php
                                                            $project_id = $notification["project_id"];
                                                            $productItems = $projectsModel->getProjectItems($project_id);

                                                            $offer_data = $notification["offer_data"];
                                                            $dataArray = json_decode($offer_data, true);

                                                            $x = 0;
                                                            foreach ($dataArray as $item) {
                                                                // echo json_encode($item);
                                                                $x++;
                                                            ?>
                                                                <div class="amount">
                                                                    <b class="d-flex gap-1 text-muted mr-10"><span><?php echo $x; ?>.</span><?php echo ucfirst($item['product']) ?>:</b>
                                                                    <div style="margin-left: 20px;">
                                                                        <table class="">
                                                                            <tr>
                                                                                <td>Product Price:</td>
                                                                                <td>
                                                                                    <b class="text-muted">£<?php echo number_format($item['price'], 2) ?> </b> <span class="text-muted"><?php echo $item["vat"] === '1' ? '(With VAT)' : '(Without VAT)' ?></span>
                                                                                </td>
                                                                            </tr>
                                                                            <?php
                                                                            if (isset($item["delivery_price"]) && $item["delivery_price"] !== null) {
                                                                            ?>
                                                                                <tr>
                                                                                    <td>Delivery Price:</td>
                                                                                    <td>
                                                                                        <b class="text-muted">£<?php echo number_format($item['delivery_price'], 2) ?> </b>
                                                                                    </td>
                                                                                </tr>
                                                                            <?php
                                                                            }
                                                                            ?>
                                                                            <?php
                                                                            if (isset($item["delivery_date"]) && $item["delivery_date"] !== null) {
                                                                            ?>
                                                                                <tr>
                                                                                    <td>Delivery Date:</td>
                                                                                    <td>
                                                                                        <b class="text-muted">£<?php echo $item['delivery_date']; ?> </b>
                                                                                    </td>
                                                                                </tr>
                                                                            <?php
                                                                            }
                                                                            ?>
                                                                            <?php
                                                                            if (isset($item["payment_term"]) && $item["payment_term"] !== null) {
                                                                            ?>
                                                                                <tr>
                                                                                    <td>Payment Term:</td>
                                                                                    <td>
                                                                                        <b class="text-muted">£<?php echo $item['payment_term']; ?> </b>
                                                                                    </td>
                                                                                </tr>
                                                                            <?php
                                                                            }
                                                                            ?>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            <?php
                                                            }
                                                            ?>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="msg-area d-flex align-items-center justify-content-between">
                                                    <div class="w-100 d-flex align-items-center justify-content-between">
                                                        <?php
                                                        if (!empty($notification["attached_file"])) {
                                                        ?>
                                                            <div class="add-attachment">
                                                                <a target="_blank" href="<?php echo $notification["attached_file"]; ?>">Attachment</a>
                                                            </div>
                                                        <?php
                                                        }
                                                        ?>
                                                        <div class="msg" style="<?php echo empty($notification["attached_file"]) ? 'display: flex; width: 100%; justify-content: end;' : '' ?>">
                                                            <a href="?add-to-chat=<?php echo $notification["seller_id"]; ?>">
                                                                <img src="public/images/messages.svg" alt="">
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php
                                        }
                                    } else {
                                        ?>
                                        <div class="text-center mt-50">
                                            <p class="no-results text-muted">Nothing to see here!</p>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                                <div class="">
                                    <?php

                                    if ($notifications && $notifications["total"] >= 20) {
                                    ?>
                                        <div class="load-more-notifications">
                                            <a href="javascript:void(0);">
                                                <span>Load More</span>
                                            </a>
                                        </div>
                                    <?php
                                    };
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="profile">
                        <div class="profile-item">
                            <div class="left">
                                <div class="user-name">
                                    <h6><?php echo $_SESSION["userData"]["company_name"]; ?></h6>
                                </div>
                                <div class="profile-nav">
                                    <!-- <p class="m-0"></p> -->
                                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" role="button" data-bs-toggle="dropdown" aria-expanded="false">My Account</a>
                                </div>
                            </div>
                            <div class="right">
                                <div class="profile-image">
                                    <img src="public/images/<?php echo $_SESSION["userData"]["company_logo"]; ?>" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <ul class="dropdown-menu header-dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                <li>
                                    <a class="dropdown-item" href="change-password.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" data-name="Layer 1" viewBox="0 0 24 24" id="edit">
                                            <path d="M3.5,24h15A3.51,3.51,0,0,0,22,20.487V12.95a1,1,0,0,0-2,0v7.537A1.508,1.508,0,0,1,18.5,22H3.5A1.508,1.508,0,0,1,2,20.487V5.513A1.508,1.508,0,0,1,3.5,4H11a1,1,0,0,0,0-2H3.5A3.51,3.51,0,0,0,0,5.513V20.487A3.51,3.51,0,0,0,3.5,24Z"></path>
                                            <path d="M9.455,10.544l-.789,3.614a1,1,0,0,0,.271.921,1.038,1.038,0,0,0,.92.269l3.606-.791a1,1,0,0,0,.494-.271l9.114-9.114a3,3,0,0,0,0-4.243,3.07,3.07,0,0,0-4.242,0l-9.1,9.123A1,1,0,0,0,9.455,10.544Zm10.788-8.2a1.022,1.022,0,0,1,1.414,0,1.009,1.009,0,0,1,0,1.413l-.707.707L19.536,3.05Zm-8.9,8.914,6.774-6.791,1.4,1.407-6.777,6.793-1.795.394Z"></path>
                                        </svg>
                                        <span class="ml-5 text-muted" style="font-weight: 500;">Edit</span>
                                    </a>
                                </li>
                                <hr>
                                <li>
                                    <a class="dropdown-item" href="logout.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 6.35 6.35" id="logout" opacity="0.8">
                                            <path fill-rule="evenodd" d="M7.953.998a3.024 3.024 0 0 0-3.006 3.004V20a3.024 3.024 0 0 0 3.006 3.004h3.994A3.022 3.022 0 0 0 14.951 20v-4.002c0-1.334-2-1.334-2 0V20a.983.983 0 0 1-1.004 1.004H7.953A.983.983 0 0 1 6.95 20V4.002a.983.983 0 0 1 1.004-1.004h3.994a.983.983 0 0 1 1.004 1.004v4.002c0 1.334 2 1.334 2 0V4.002A3.022 3.022 0 0 0 11.947.998H7.953zM1.957 4.984a1 1 0 0 0-1.01 1.02v11.994a1 1 0 0 0 2 0V6.004a1 1 0 0 0-.982-1.02 1 1 0 0 0-.008 0zm16.037 2.004a1 1 0 0 0-.096.004 1 1 0 0 0-.6 1.713L19.595 11h-9.588a1.006 1.006 0 0 0-.104 0c-1.333.07-1.23 2.071.104 2.002h9.582l-2.29 2.287a1 1 0 1 0 1.411 1.418l4.002-4.002a1 1 0 0 0 0-1.41l-4.002-4a1 1 0 0 0-.715-.307z" color="#000" font-family="sans-serif" font-weight="400" overflow="visible" paint-order="stroke fill markers" transform="scale(.26458)" style="line-height:normal;font-variant-ligatures:normal;font-variant-position:normal;font-variant-caps:normal;font-variant-numeric:normal;font-variant-alternates:normal;font-feature-settings:normal;text-indent:0;text-align:start;text-decoration-line:none;text-decoration-style:solid;text-decoration-color:#000;text-transform:none;text-orientation:mixed;shape-padding:0;isolation:auto;mix-blend-mode:normal"></path>
                                        </svg>
                                        <span class="ml-5 text-muted" style="font-weight: 500;">Logout</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="main-content <?php echo $_SESSION["show"] === "home" ? "show_all" : "show_single";  ?>">

            <div id="products-section" class="projects-list box-content <?php echo isset($_SESSION["show"]) && ($_SESSION["show"] === "home" || $_SESSION["show"] === "products") ? "show" : ""; ?>">
                <div class="">
                    <div class="sec__heading d-flex align-items-center justify-content-between">
                        <h5>Projects List</h5>
                        <a href="buyer.php?action=add-project">
                            <svg width="28" height="28" viewBox="0 0 36 36" xmlns="http://www.w3.org/2000/svg">
                                <path d="M24.285 3H11.715C6.255 3 3 6.255 3 11.715V24.27C3 29.745 6.255 33 11.715 33H24.27C29.73 33 32.985 29.745 32.985 24.285V11.715C33 6.255 29.745 3 24.285 3ZM24 19.125H19.125V24C19.125 24.615 18.615 25.125 18 25.125C17.385 25.125 16.875 24.615 16.875 24V19.125H12C11.385 19.125 10.875 18.615 10.875 18C10.875 17.385 11.385 16.875 12 16.875H16.875V12C16.875 11.385 17.385 10.875 18 10.875C18.615 10.875 19.125 11.385 19.125 12V16.875H24C24.615 16.875 25.125 17.385 25.125 18C25.125 18.615 24.615 19.125 24 19.125Z" fill="#60CB97"></path>
                            </svg>
                        </a>
                    </div>
                    <div class="inner-content">
                        <div class="projects">
                            <div class="single-project " style="border-bottom: 1px solid #ccc;">
                                <div class="" bis_skin_checked="1" style="padding: 10px 16px;">
                                    <span style="font-weight:700 ; font-size:14px !important;"> Name</span>
                                </div>
                                <div class="" bis_skin_checked="1" style="margin-left: 50px;">
                                    <span style="font-weight:700 ; font-size:14px !important ;"> Address </span>
                                </div>
                                <div bis_skin_checked="1" style="margin-left:40px;">
                                    <span style="font-weight:700 ; font-size:14px !important;">
                                        Created on
                                    </span>
                                </div>

                            </div>
                            <?php
                            $projects = $projectsModel->getProjects($uid, null, [0, 2]);

                            if ($projects) {
                                foreach ($projects as $project) {
                                    // echo json_encode($project);

                                    $style = 'display: none;';
                                    if (isset($_GET["project_id"]) && $_GET["project_id"] == $project["id"]) {
                                        $style = '';
                                    }

                                    if (isset($_GET["active-project"]) && $_GET["active-project"] == $project["id"]) {
                                        $style = '';
                                    }
                            ?>
                                    <div class="single-project" data-id="<?php echo $project["id"]; ?>">
                                        <div class="product-name">
                                            <div class="">
                                                <h6 class="mb-0">
                                                    <?php echo $project["project_name"]; ?>

                                                </h6>
                                                <?php
                                                $projectItems = $projectsModel->getProjectItems($project["id"]);
                                                $products_count = 0;
                                                if ($projectItems) {
                                                    $products_count = count($projectItems);
                                                }
                                                ?>

                                                <span class="text-muted" style="font-size: 10px;">
                                                    <?php echo $products_count . ' Product' . ($products_count > 1 ? 's' : ''); ?>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="product-name" style="padding: 0px;">
                                            <div class="">
                                                <p class="mb-0"><?php echo $project["post_code"]; ?> </p>
                                            </div>
                                        </div>
                                        <div class="product-name" style="padding: 0px;">
                                            <div>
                                                    <?php
                                                    $date = new DateTime($project["added_on"]);
                                                    echo $date->format($dateFormat);
                                                    ?>
                                            </div>
                                        </div>
                                        <?php
                                        if ($project["is_deleted"] !== '2') {
                                        ?>
                                            <div class="product-actions">
                                                <ul class="d-flex align-items-center justify-center-center list-unstyled mb-0" style="gap: 10px">
                                                
                                                    <li>
                                                        <a href="buyer.php?action=edit-project&project-id=<?php echo $project["id"]; ?>" class="text-decoration-none" style="font-size: 13px;"><img height="15px" src="public/images/edit-text.png" alt=""></a>
                                                    </li>
                                                    <li>
                                                        <a href="javascript:void(0);" class="delete-project">
                                                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="20" fill="red" id="delete">
                                                                <path d="M24.2,12.193,23.8,24.3a3.988,3.988,0,0,1-4,3.857H12.2a3.988,3.988,0,0,1-4-3.853L7.8,12.193a1,1,0,0,1,2-.066l.4,12.11a2,2,0,0,0,2,1.923h7.6a2,2,0,0,0,2-1.927l.4-12.106a1,1,0,0,1,2,.066Zm1.323-4.029a1,1,0,0,1-1,1H7.478a1,1,0,0,1,0-2h3.1a1.276,1.276,0,0,0,1.273-1.148,2.991,2.991,0,0,1,2.984-2.694h2.33a2.991,2.991,0,0,1,2.984,2.694,1.276,1.276,0,0,0,1.273,1.148h3.1A1,1,0,0,1,25.522,8.164Zm-11.936-1h4.828a3.3,3.3,0,0,1-.255-.944,1,1,0,0,0-.994-.9h-2.33a1,1,0,0,0-.994.9A3.3,3.3,0,0,1,13.586,7.164Zm1.007,15.151V13.8a1,1,0,0,0-2,0v8.519a1,1,0,0,0,2,0Zm4.814,0V13.8a1,1,0,0,0-2,0v8.519a1,1,0,0,0,2,0Z"></path>
                                                            </svg>
                                                        </a>
                                                    </li>
                                                </ul>

                                                <?php
                                                if ($project["status"] === '0') {
                                                    $btnStyle = 'gap: 5px;';
                                                    if ($products_count < 1) {
                                                        $btnStyle = 'gap: 5px; display: none !important;';
                                                    }
                                                ?>
                                                    <ul class="d-flex align-items-center justify-center-center list-unstyled mb-0 mt-2" style="<?php echo $btnStyle; ?>">
                                                        <li>
                                                            <a href="javascript:void(0);" class="text-decoration-none publish-project" data-project-id="<?php echo $project["id"]; ?>" data-location="2" style="font-size: 13px; color: #60CB97;">Publish</a>
                                                            <br>
                                                            <?php if ($project["is_deleted"] === '2') { ?>
                                                                <small><sup class="project-status"><span style="color: #e33c3c;">(Deleted)</span></sup></small>
                                                            <?php } elseif ($project["status"] === '0') { ?>
                                                                <small><sup class="text-muted project-status">(Draft)</sup></small>
                                                            <?php } else { ?>
                                                                <small><sup class="text-muted project-status"></sup></small>
                                                            <?php } ?>
                                                        </li>
                                                    </ul>
                                                <?php
                                                }
                                                ?>
                                            </div>
                                        <?php
                                        }
                                        ?>
                                    </div>
                                <?php
                                }
                            } else {
                                ?>
                                <span class="d-block text-center text-muted mt-50">Nothing to see here!</span>
                            <?php
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>

            <div id="product-list" data-id="" class="projects-list box-content" style="width: 73%; display: inline-flex; vertical-align: top;">
                <div class="">
                    <div class="bg_primary d-flex align-items-center justify-content-between" style="padding: 8px 15px;">
                        <div class="">
                            <h5 class="text-white mb-0">Product List</h5>
                        </div>
                        <div class="d-flex align-items-center" style="gap: 20px;">
                            <div class="sort-product" style="position: relative;">
                                <div class="sort-product-btn" style="cursor: pointer;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" fill="none" viewBox="0 0 128 128" id="filter">
                                        <path stroke="#fff" stroke-linecap="round" stroke-width="7" d="M104 41H24M93 64H35M82 87H46"></path>
                                    </svg>
                                </div>
                                <div class="filter-options" style="position: absolute; top: 50px; right: -12px; min-width: 200px; background-color: #fff; border: 1px solid #eee; border-radius: 10px; overflow: hidden; display: none;">
                                    <ul class="list-unstyled mb-0">
                                        <li class="" data-option="high-to-low" style="padding: 5px 10px; cursor: pointer;">Price high to low</li>
                                        <li class="" data-option="low-to-high" style="padding: 5px 10px; cursor: pointer;">Price low to high</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="filter-product" style="position: relative;">
                                <div class="filter-product-btn" style="cursor: pointer;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" viewBox="0 0 30 30" id="filter">
                                        <path fill="#fff" d="M17 11H4A1 1 0 0 1 4 9H17A1 1 0 0 1 17 11zM26 11H22a1 1 0 0 1 0-2h4A1 1 0 0 1 26 11z"></path>
                                        <path fill="#fff" d="M19.5 13.5A3.5 3.5 0 1 1 23 10 3.5 3.5 0 0 1 19.5 13.5zm0-5A1.5 1.5 0 1 0 21 10 1.5 1.5 0 0 0 19.5 8.5zM26 21H13a1 1 0 0 1 0-2H26A1 1 0 0 1 26 21zM8 21H4a1 1 0 0 1 0-2H8A1 1 0 0 1 8 21z"></path>
                                        <path fill="#fff" d="M10.5,23.5A3.5,3.5,0,1,1,14,20,3.5,3.5,0,0,1,10.5,23.5Zm0-5A1.5,1.5,0,1,0,12,20,1.5,1.5,0,0,0,10.5,18.5Z"></path>
                                    </svg>
                                </div>
                                <div class="product-list" style="position: absolute; top: 50px; right: 0; min-width: 200px; background-color: #fff; border: 1px solid #eee; border-radius: 10px; overflow: hidden; display: none;">
                                    <ul class="list-unstyled mb-0">
                                        <li class="" data-id="" data-product="" style="padding: 5px 10px; cursor: pointer;">All</li>
                                        <?php

                                        ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="products-table">
                        <table class="table">
                            <thead style="background-color: #f1f1f1;">
                                <tr>
                                    <th class="font-weight-500 text-muted" style="position: relative;margin-top:-20px !important" >Product</th>
                                    <th class="font-weight-500 text-muted text-center justify-content-center align-items-center">Seller</th>
                                    <th class="font-weight-500 text-muted text-end">Product Price (ex VAT)</th>
                                    <th class="font-weight-500 text-muted text-end">VAT amount</th>
                                    <th class="font-weight-500 text-muted text-end">Product Price (Incl VAT)</th>
                                    <th class="font-weight-500 text-muted text-center">Quantity</th>
                                    <th class="font-weight-500 text-muted text-end">Total (In VAT)</th>
                                    <th class="font-weight-500 text-muted text-end">Delivery Cost (In VAT)</th>
                                    <th class="font-weight-500 text-muted text-end">Total incl Delivery</th>
                                    <th class="font-weight-500 text-muted text-center">Delivery Date</th>
                                    <th class="font-weight-500 text-muted justify-content-center align-items-center">Payment Terms</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $price_offer = $projectsModel->getAllPriceOffers($uid);
                                // echo json_encode($price_offer);
                                ?>
                                <tr>
                                    <td class="text-muted" colspan="10" align="center">No products found for this project.</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="chat-toggle-button" style="position: fixed; bottom: 120px; left: 5px; cursor: pointer; z-index: 9999999999;">
                <div class="" style="width: 70px; height: 70px;  border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                    <img src="public/images/messages-3.png" alt="">
                </div>
                <div class="unread-msg-count"></div>
            </div>

            <div class="chat-app" style="position: fixed; width: 100%; height: 100%; top: 0; right: 0; background: #00000091;">
                <div class="chat-container" style="position: absolute; bottom: 150px; left: 50px; cursor: pointer;">
                    <div class="chat__heading">
                        <h5 class="mb-0">Chat</h5>
                    </div>
                    <div class="inner-content">
                        <div class="app-content">
                            <div class="people-list">
                                <ul class="list list-unstyled p-0 m-0">
                                    <?php
                                    $peopleList = $msgModel->getPeopleList($uid);
                                    if ($peopleList) {
                                        foreach ($peopleList as $people) {
                                            $style = '';
                                            if (isset($_SESSION["chat_id"]) && $_SESSION["chat_id"] == $people["user_id"]) {
                                                $style = 'active';
                                            }
                                    ?>
                                            <li class="chat-user <?php echo $style; ?> clearfix" data-id="<?php echo $people["user_id"]; ?>">
                                                <a href="javascript:void(0)">
                                                    <div class="profile">
                                                        <img src="public/images/<?php echo $people["company_logo"]; ?>" alt="avatar">
                                                        <div class="about">
                                                            <div class="name hide-company-name"><?php echo $people["company_name"]; ?></div>
                                                        </div>
                                                    </div>
                                                </a>
                                            </li>
                                    <?php
                                        }
                                    }
                                    ?>
                                </ul>
                            </div>

                            <div class="chat">
                                <div class="chat-history">
                                    <ul class="list-unstyled m-0">
                                        <li class="clearfix">
                                            <?php
                                            if ($messages && count($messages) >= 20) {
                                            ?>
                                                <div class="load-more-msg text-center">
                                                    <a href="javascript:void(0);">Load More</a>
                                                </div>
                                            <?php
                                            }
                                            ?>
                                            <div class="chats">
                                                <?php
                                                if ($messages) {
                                                    foreach ($messages as $message) {
                                                        if (!empty($message["chat_at"])) {
                                                ?>
                                                            <div class="date-divider">
                                                                <span class="text-muted"><?php echo displayDateOrDay($message["chat_at"]); ?></span>
                                                            </div>
                                                        <?php
                                                        }

                                                        if ($message["user_id"] == $_SESSION["user_id"]) {
                                                            $width = 'width: 100%;';
                                                        } else {
                                                            $width = 'width: calc(100% - 60px);';
                                                        }
                                                        ?>
                                                        <div data-id="<?php echo $message["message_id"]; ?>" class="chat-msg <?php if ($message["user_id"] == $_SESSION["user_id"]) {
                                                                                                                                    echo "owner";
                                                                                                                                } ?>">
                                                            <div class="chat-msg-content">
                                                                <div class="chat-msg-date text-muted"><?php echo date("h:i A", strtotime($message["chat_timestamp"])); ?></div>
                                                                <div class="msg-body">
                                                                    <div class="chat-msg-profile">
                                                                        <!-- <img class="chat-msg-img" src="public/images/<?php echo $message["company_logo"]; ?>" alt=""> -->
                                                                    </div>
                                                                    <div class="" style="<?php echo $width; ?>">
                                                                        <?php
                                                                        if (!empty($message["attached_file"]) && $message["file_name"]) {
                                                                            $allowedExtensions = array("jpg", "jpeg", "png", "gif");

                                                                            $uploadedFileName = $message["attached_file"]; // Replace with the actual uploaded file name
                                                                            $fileExtension = strtolower(pathinfo($uploadedFileName, PATHINFO_EXTENSION));

                                                                            if (in_array($fileExtension, $allowedExtensions)) {
                                                                        ?>
                                                                                <div class="chat-msg-image">
                                                                                    <a target="_blank" href="<?php echo $message["attached_file"]; ?>">
                                                                                        <img src="<?php echo $message["attached_file"]; ?>" alt="<?php echo $message["file_name"]; ?>">
                                                                                    </a>
                                                                                </div>
                                                                            <?php
                                                                            } else {
                                                                            ?>
                                                                                <div class="chat-msg-file">
                                                                                    <div class="file-icon">
                                                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256" id="file-arrow-down">
                                                                                            <rect width="25" height="25 " fill="none"></rect>
                                                                                            <polygon points="152 32 152 88 208.008 88 152 32" opacity=".2"></polygon>
                                                                                            <path fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" d="M200,224.00005H55.99219a8,8,0,0,1-8-8V40a8,8,0,0,1,8-8L152,32l56,56v128A8,8,0,0,1,200,224.00005Z"></path>
                                                                                            <polyline fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" points="152 32 152 88 208.008 88"></polyline>
                                                                                            <polyline fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" points="100 156 128 184 156 156"></polyline>
                                                                                            <line x1="128" x2="128" y1="120" y2="184" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></line>
                                                                                        </svg>
                                                                                    </div>
                                                                                    <div class="file-url">
                                                                                        <a target="_blank" href="<?php echo $message["attached_file"]; ?>"><?php echo $message["file_name"]; ?></a>
                                                                                    </div>Buyer Page
                                                                                </div>
                                                                            <?php
                                                                            }
                                                                        }

                                                                        if (!empty($message["message_text"])) {
                                                                            ?>
                                                                            <div class="chat-msg-text"><?php echo $message["message_text"]; ?></div>
                                                                        <?php
                                                                        }
                                                                        ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php
                                                    }
                                                }

                                                if (!isset($_SESSION["chat_id"])) {
                                                    ?>
                                                    <div class="msg text-muted mt-50" style="height: 100%; display: flex; align-items: center; justify-content: center; text-align: center;">
                                                        <h6>Select a chat or start a new conversation</h6>
                                                    </div>
                                                <?php
                                                }
                                                ?>
                                            </div>
                                        </li>
                                    </ul>
                                </div>

                                <div class="chat-message">
                                    <div class="">
                                        <p class="attached-file-name" style="margin-top: -3px;"></p>
                                        <div class="warning-msg" style="display: none;">
                                            <small>
                                                <p style="color: #df3079;">Terms of Service reminder: Sharing contact information is only allowed when essential for the service.</p>
                                            </small>
                                        </div>
                                        <div class="box-wrapper">
                                            <div class="input-wraper" style="position: relative;">
                                                <div class="upload-file">
                                                    <label class="upload-area">
                                                        <input id="attached-file" type="file">
                                                        <span class="file-upload-button">
                                                            <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <g id="fi-sr-clip" opacity="0.4" clip-path="url(#clip0_93_163)">
                                                                    <path id="Vector" d="M26.775 11.2001C26.5562 10.9813 26.2596 10.8585 25.9502 10.8585C25.6408 10.8585 25.3441 10.9813 25.1254 11.2001L12.418 23.9622C11.8764 24.504 11.2333 24.9337 10.5255 25.2269C9.81778 25.5202 9.0592 25.6711 8.29311 25.6712C6.74591 25.6713 5.26205 25.0568 4.16794 23.9628C3.07384 22.8689 2.45911 21.3851 2.459 19.8379C2.45889 18.2907 3.07341 16.8068 4.16736 15.7127L16.4745 3.35539C17.1326 2.70776 18.02 2.34642 18.9433 2.35007C19.8666 2.35372 20.7511 2.72207 21.404 3.37488C22.057 4.02769 22.4256 4.91207 22.4294 5.83538C22.4333 6.75869 22.0722 7.64613 21.4247 8.30439L9.11753 20.6617C8.89557 20.8744 8.60007 20.9931 8.29269 20.9931C7.98532 20.9931 7.68982 20.8744 7.46786 20.6617C7.24914 20.4429 7.12628 20.1462 7.12628 19.8369C7.12628 19.5275 7.24914 19.2308 7.46786 19.0121L18.4252 8.00455C18.6377 7.78452 18.7553 7.48982 18.7526 7.18392C18.75 6.87802 18.6273 6.58541 18.411 6.3691C18.1947 6.15279 17.9021 6.03009 17.5962 6.02743C17.2903 6.02478 16.9956 6.14237 16.7755 6.35489L5.81819 17.3624C5.49313 17.6874 5.23526 18.0733 5.05934 18.4979C4.88341 18.9226 4.79286 19.3778 4.79286 19.8375C4.79286 20.2971 4.88341 20.7523 5.05934 21.177C5.23526 21.6017 5.49313 21.9875 5.81819 22.3126C6.48508 22.9489 7.37147 23.304 8.29328 23.304C9.21508 23.304 10.1015 22.9489 10.7684 22.3126L23.0744 9.95405C24.1454 8.85541 24.7404 7.37905 24.7306 5.84479C24.7207 4.31053 24.1068 2.84191 23.0218 1.75708C21.9369 0.672249 20.4682 0.0585561 18.9339 0.0489428C17.3996 0.0393295 15.9234 0.63457 14.8249 1.70572L2.51769 14.0631C0.986068 15.5947 0.12561 17.672 0.12561 19.8381C0.12561 22.0041 0.986068 24.0814 2.51769 25.6131C4.04932 27.1447 6.12665 28.0051 8.29269 28.0051C10.4587 28.0051 12.5361 27.1447 14.0677 25.6131L26.775 12.8544C26.884 12.746 26.9705 12.6171 27.0295 12.4751C27.0886 12.3332 27.1189 12.181 27.1189 12.0272C27.1189 11.8735 27.0886 11.7213 27.0295 11.5793C26.9705 11.4374 26.884 11.3085 26.775 11.2001Z" fill="black" fill-opacity="0.4" />
                                                                </g>
                                                                <defs>
                                                                    <clipPath id="clip0_93_163">
                                                                        <rect width="28" height="28" fill="white" />
                                                                    </clipPath>
                                                                </defs>
                                                            </svg>
                                                        </span>
                                                    </label>
                                                </div>
                                                <!-- <input id="receiver_id" type="hidden" name="" value="<?php echo $_SESSION["chat_id"]; ?>"> -->
                                                <textarea id="msg-input" class="form-control" id="" cols="30" rows="2"></textarea>
                                            </div>
                                            <div id="send-msg">
                                                <a href="javascript:void(0);"><img src="public/images/fi-sr-paper-plane.svg" alt=""></a>
                                            </div>
                                            <div id="sending-msg" style="display: none">
                                                <a href="javascript:void(0);">
                                                    <svg width="30" version="1.1" id="L4" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 0 0" xml:space="preserve">
                                                        <circle fill="#fff" stroke="none" cx="6" cy="50" r="6">
                                                            <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.1"></animate>
                                                        </circle>
                                                        <circle fill="#fff" stroke="none" cx="26" cy="50" r="6">
                                                            <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.2"></animate>
                                                        </circle>
                                                        <circle fill="#fff" stroke="none" cx="46" cy="50" r="6">
                                                            <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.3"></animate>
                                                        </circle>
                                                    </svg>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Modal -->
            <div id="modal" class="w-100 h-100" style="position: absolute; top: 0; right: 0; background: #00000091;">
                <div class="modal-dialog modal-dialog-centered h-100">
                    <div class="modal-content" style="background-color: #fff; width: 600px; height: 700px; margin: auto; border-radius: 30px;">
                        <div class="modal-body" style="padding: 30px;">

                        </div>
                    </div>
                </div>
            </div>


            <!-- Include Footer -->
            <footer>
                <div class="footer-top d-flex align-items-center">
                    <div class="container">
                        <div class="footer-content d-flex align-items-center justify-content-between">
                            <div class="footer-pages">
                                <ul class="list-unstyled m-0">
                                    <li><a href="<?php echo BASE_URL; ?>terms.php">Terms of USE</a></li>
                                </ul>
                            </div>
                            <div class="social-links">
                                <ul class="list-unstyled m-0">
                                    <li>
                                        <a href="">
                                            <!-- <img src="public/images/linkedin.svg" alt=""> -->
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="footer-bottom d-flex align-items-center">
                    <div class="container">
                        <div class="bottom-content">
                            <div class="row">
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-logo">
                                        <a href="<?php echo BASE_URL; ?>">
                                            <img src="public/images/logo-light.svg" alt="">
                                        </a>
                                    </div>

                                </div>
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-copyright">
                                        <a href="javascript:void(0);">© 2023. All rights reserved.</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
</div>

<script src="public/js/image-uploader.js"></script>

<?php
include './templates/footer.php';
?>

<script>
    $(document).ready(function() {
        $(".menu-bar").click(function() {
            $(".sidebar").toggleClass("active");
        });

        $(".chat-toggle-button").click(function() {
            $(".chat-app").toggleClass("active");
        });

        $('#search-input').on('keydown', function(event) {
            if (event.key === 'Enter') {
                event.preventDefault();
                $(this).closest('form').submit();
            }
        });

        // showModal();

        // <?php
            //     if(isset($_GET["action"]) && $_GET["action"] === "add-project") {
            //         
            ?>
        //             if ($(window).width() < 768) {
        //                 $('html, body').animate({ scrollTop: $('.add-product').offset().top }, 0);
        //             }
        //         <?php
                    //     }
                    // 
                    ?>

        function showModal() {
            $("#modal").addClass('show');
        }

        function hideModal() {
            $("#modal").removeClass('show');
        }

        $(".sort-product-btn").on('click', function(e) {
            $(".filter-options").toggle();
            $(".product-list").hide();
        })

        $(".filter-product-btn").on('click', function(e) {
            $(".product-list").toggle();
            $(".filter-options").hide();
        })

        $(document).on('click', '.sort-product .filter-options li', function() {
            $(".sort-product .filter-options li").removeClass('active');
            $(this).addClass('active');

            const project_id = $('#product-list').attr('data-id');
            console.log(project_id);

            const sort_option = $(this).data('option');
            // console.log(sort_option);

            getProducts(project_id, null, sort_option);
        });

        $(document).on('click', '.filter-product .product-list li', function() {
            $(".filter-product .product-list li").removeClass('active');
            $(this).addClass('active');

            const project_id = $(this).data('id');
            const filter_option = $(this).data('product');
            // console.log(filter_option);

            getProducts(project_id, filter_option);
        });

        $(document).on('click', '.close-modal', function() {
            hideModal();
        });

        $(document).on('click', '.single-project .product-name', function() {
            $("#product-list table tbody").html(`<tr><td class="text-muted" colspan="10" align="center" style="border-bottom: 0;">
            <div class="products-list-loading-icon text-center mt-20 mb-20">
                <img src="https://media.tenor.com/On7kvXhzml4AAAAj/loading-gif.gif" width="30" height="30" alt="">
            </div>
        </td></tr>`);

            const project_id = $(this).parent().data('id');
            // console.log(project_id);


            $('#product-list').attr('data-id', project_id);

            $(".single-project").removeClass('active');
            $(this).parent().addClass('active');

            $(".product-list").hide();
            $(".filter-options").hide();

            getFilterProducts(project_id);
            getProducts(project_id);
        });

        getProducts();
        getFilterProducts();

        function getFilterProducts(project_id = null) {
            $.ajax({
                type: 'POST',
                url: 'app/core/projects.php',
                data: {
                    action: 'GET_FILTER_PRODUCTS',
                    project_id: project_id
                },
                success: function(response) {
                    // alert('Project saved successfully!');
                    // console.log(response);

                    // const data = JSON.parse(response);

                    $(".filter-product .product-list ul").html(response);
                    // $("#bids-list-section .bids-group").html('<div class="text-center py-5">No bids found.</div>');
                },
                error: function(xhr, status, error) {
                    // Handle error
                    alert('An error occurred while saving the project. Please try again.');
                }
            });
        }


        function getProducts(project_id = null, filter = null, sort = null) {
            // console.log(project_id, filter);

            $.ajax({
                type: 'POST',
                url: 'app/core/projects.php',
                data: {
                    action: 'PRODUCT_LIST',
                    project_id: project_id,
                    filter_option: filter,
                    sort_option: sort
                },
                success: function(response) {
                    // alert('Project saved successfully!');
                    // console.log(response);

                    // const data = JSON.parse(response);

                    $("#product-list table tbody").html(response);
                    // $("#bids-list-section .bids-group").html('<div class="text-center py-5">No bids found.</div>');
                },
                error: function(xhr, status, error) {
                    // Handle error
                    alert('An error occurred while saving the project. Please try again.');
                }
            });
        }

        $(document).on('click', '.publish-project', function() {
            const project_id = $(this).data('project-id');
            const location = $(this).data('location');

            publishProject(project_id, location);
        });

        function publishProject(project_id, location) {
            $(".modal-content").css({
                "width": "540px",
                "height": "600px",
            });

            $(".modal-body").html(`<div class="text-center mt-20">
                <h2 style="font-weight: 500;">Processing Your Project</h2>
            </div>
            <div class="text-center mt-50">
                <img style="width: 300px" src="public/images/processing.svg" alt="">
            </div>
            <div class="text-center mt-80">
                <h5 class="project_name" style="font-weight: 500;">Please wait...</h5>
            </div>`);

            showModal();

            if (location === 2) {
                $($(".publish-project[data-project-id='" + project_id + "']").closest(".single-project")[0]).find('.project-status').remove();
            }
            $(".publish-project[data-project-id='" + project_id + "']").hide();

            jQuery.ajax({
                type: "POST",
                url: "app/core/projects.php",
                data: {
                    action: "PUBLISH_PROJECT",
                    project_id: project_id
                },
                success: function(data) {
                    // console.log(data);

                    hideModal();

                    $(".modal-content").css({
                        "width": "600px",
                        "height": "690px",
                    });

                    $(".modal-body").html(`<div class="text-center  mt-20">
                        <h2 style="font-weight: 500;">Published Your Project</h2>
                    </div>
                    <div class="text-center mt-50">
                        <img style="width: 300px" src="public/images/published.svg" alt="">
                    </div>
                    <div class="text-center mt-30">
                        <h2 style="font-weight: 500;">Your Project is Successfully Published</h2>
                    </div>
                    <div class="mt-50 d-flex flex-column" style="gap: 15px;">
                        <a href="javascript:void(0);" class="close-modal">
                            <button class="cns_btn cns_btn__primary btn_rounded w-100">Close</button>
                        </a>
                    </div>`);

                    showModal();
                }
            });
        }

        // Delete Project
        $(".delete-project").on('click', function(e) {
            const $project = $(this).closest('.single-project')
            const $project_id = $project.data('id');
            // console.log($project_id);

            $(".modal-body").html(`<div class="text-center">
                    <h2 style="font-weight: 500;">Delete Project</h2>
                </div>
                <div class="text-center mt-50">
                    <img style="width: 250px" src="public/images/published.svg" alt="">
                </div>
                <div class="text-center mt-30">
                    <h3 style="font-weight: 500;">The new product has been added successfully</h3>
                </div>
                <div class="mt-30 d-flex flex-column" style="gap: 15px;">
                    <a href="javascript:void(0);" class="confirm-delete-project" data-type="project_only" data-id="${$project_id}">
                        <button class="cns_btn cns_btn__primary btn_rounded w-100">Delete Project Keep Products</button>
                    </a>
                    <a href="javascript:void(0);" class="confirm-delete-project" data-type="delete_all" data-id="${$project_id}">
                        <button class="cns_btn cns_btn__outline btn_rounded w-100" style="border-color: red; color: red;">Delete Project and all the Project's Products</button>
                    </a>
                    <a href="javascript:void(0);" class="close-modal">
                        <button class="cns_btn cns_btn__outline btn_rounded w-100">Cancel</button>
                    </a>
                </div>`);

            showModal();
        });

        $(document).on('click', '.confirm-delete-project', function() {
            hideModal();
            const $action_type = $(this).data('type');
            const $project_id = $(this).data('id');

            $.ajax({
                type: 'POST',
                url: 'app/core/projects.php',
                data: {
                    action: 'DELETE_PROJECT',
                    action_type: $action_type,
                    project_id: $project_id
                },
                success: function(response) {
                    // alert('Project deleted successfully!');
                    // const data = JSON.parse(response);
                    // console.log(response);

                    // Remove Project from Projects List

                    if ($action_type === 'delete_all') {
                        $('.single-project[data-id="' + $project_id + '"]').remove();
                    } else if ($action_type === 'project_only') {
                        $('.single-project[data-id="' + $project_id + '"] .product-actions').remove();
                        $('.single-project[data-id="' + $project_id + '"] .project-status').html(`<span style="color: #e33c3c;">[Deleted]</span>`);
                    }

                    $(".modal-body").html(`<div class="text-center">
                            <h2 style="font-weight: 500;">Delete Project</h2>
                        </div>
                        <div class="text-center mt-50">
                            <img style="width: 320px" src="public/images/published.svg" alt="">
                        </div>
                        <div class="text-center mt-40">
                            <h2 style="font-weight: 500;">The project has been deleted successfully</h2>
                        </div>
                        <div class="mt-70 d-flex flex-column" style="gap: 15px;">
                            <a href="javascript:void(0);" class="close-modal">
                                <button class="cns_btn cns_btn__primary btn_rounded w-100">Ok</button>
                            </a>
                        </div>`);

                    showModal();
                },
                error: function(xhr, status, error) {
                    // Handle error
                    alert('An error occurred while deleting the project. Please try again.');
                }
            });
        });

        // Remove the invalid class on input
        $('input[required], textarea[required]').on('input', function() {
            if ($(this).val() !== '') {
                $(this).removeClass('is-invalid');
            }
        });

        function updateProjectIPublished(id) {
            $.ajax({
                type: "POST",
                url: "app/core/projects.php",
                data: {
                    action: "updateProjectIPublished",
                    project_id: id
                },
                success: function(data) {
                    // console.log(data);

                    const singleProject = $("#products-section .single-project[data-id='" + id + "']");
                    if (singleProject) {
                        singleProject.remove();
                    }

                    $("#products-section .projects").prepend(data);
                }
            });
        }

        $(".publish-btn").click(function() {
            const type = $(this).data("type");
            // console.log(type);

            let formContent = $(".add-product .inner-content");

            let inputsToValidate = [];
            if (type === 'form_upload') {
                inputsToValidate = [
                    "project_name",
                    "post_code",
                    "description",
                    "quantity",
                    "unit",
                    "date_required"
                ];
            } else {
                inputsToValidate = [
                    "project_name",
                    "post_code"
                ];
            }

            for (let i = 0; i < inputsToValidate.length; i++) {
                let fieldName = inputsToValidate[i];
                let fieldValue = formContent.find(`[name='${fieldName}']`).val();

                if (fieldValue.trim() === '') {
                    formContent.find(`[name='${fieldName}']`).focus();
                    return;
                }
            }

            const project_id = formContent.find("input[name='project_id']").val();
            const project_name = formContent.find("input[name='project_name']").val();
            const post_code = formContent.find("input[name='post_code']").val();

            if (type === 'form_upload') {

            }

            // if(project_name === '' || post_code === '' || product_name === '' || description === '' || quantity === '' || unit === '' || date_required === '') {
            //     alert("Please fill all fields");
            //     return;
            // }


            let formData = new FormData();
            formData.append("project_name", project_name);
            formData.append("post_code", post_code);

            if (type === 'form_upload') {
                const product_name = formContent.find("select[name='product_name']").val();
                const description = formContent.find("textarea[name='description']").val();
                const quantity = formContent.find("input[name='quantity']").val();
                const unit = formContent.find("input[name='unit']").val();
                const date_required = formContent.find("input[name='date_required']").val();
                const open_to_similar_brands = formContent.find("input[name='open_to_similar_brands']:checked").val();

                formData.append("product_name", product_name);
                formData.append("description", description);
                formData.append("quantity", quantity);
                formData.append("unit", unit);
                formData.append("date_required", date_required);
                formData.append("open_to_similar_brands", open_to_similar_brands);

                if (project_id) {
                    formData.append("project_id", project_id);
                }

                const product_image = formContent.find("input[name='product_image']")[0].files[0];

                if (product_image) {
                    formData.append("product_image", product_image);
                }
            }

            if (type === 'excel_upload') {
                const excel_file = formContent.find("input[name='fileToUpload']")[0].files[0];

                if (excel_file) {
                    formData.append("fileToUpload", excel_file);
                } else {
                    alert("Please select a file to upload");
                    return;
                }
            }

            formData.append("status", "publish");
            formData.append("action", "ADD_PROJECT");

            // console.log(Object.fromEntries(formData));
            // return;

            $("#add-section .form-box").hide();
            $("#add-section .processing-project .project_name").text(project_name);
            $("#add-section .processing-project").show();

            $.ajax({
                type: "POST",
                url: "app/core/projects.php",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);
                    // console.log(res);
                    updateProjectIPublished(res.project_id);

                    $("#add-section .processing-project").hide();

                    $("#add-section .published-project .project_name").text(project_name);
                    $("#add-section .published-project").show();

                    // window.location.href = `buyer.php?status=published-project&project=` + project_name;
                }
            });

        });

        $(".profile-item").click(function() {
            $(".header-dropdown-menu").toggle();
        });

        $(".chat-history ul li").animate({
            scrollTop: 3031
        }, "fast");

        $("#attached-file").on("change", function() {
            let maxFileSizeMB = 10;
            let maxFileSizeBytes = maxFileSizeMB * 1024 * 1024;

            let $uploadButton = $(".file-upload-button");
            let $attachedFileName = $(".attached-file-name");
            let fileName = $(this).val().split("\\").pop();

            if ($(this).val()) {
                let uploadedFile = this.files[0];
                if (uploadedFile.size <= maxFileSizeBytes) {
                    $uploadButton.addClass("file-attached");
                    $attachedFileName.text(fileName);
                } else {
                    alert("Please upload file less than 10MB. Thanks!!");
                }
            } else {
                $uploadButton.removeClass("file-attached");
                $attachedFileName.text('');
            }
        });

        function updateChatUser() {
            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: "updateChatUser"
                },
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);

                    if (res.status === "success") {
                        $(".people-list ul").html(res.result);
                    }
                    // if(res.is_found == true) {
                    //     $(".load-notifications").show();
                    // }
                    // data && $(".chat-history ul li").append(data);
                }
            });
        }

        var termsToCheck = ["email", "skype", "phone", "contact", "details", "telephone", "number", "address"];

        function checkForContactDetails(text) {

            var lowercaseText = text.toLowerCase();
            var containsTerms = false;

            for (var i = 0; i < termsToCheck.length; i++) {
                var term = termsToCheck[i];
                if (lowercaseText.includes(term)) {
                    containsTerms = true;
                    break;
                }
            }

            // Check for words ending with "@"
            if (text.match(/\w+@$/)) {
                containsTerms = true;
            }

            var warningMessage = $('#warning-message');
            if (containsTerms) {
                // console.log("violations are not allowed");
                $(".warning-msg").show();
            } else {
                // console.log("you are going correctly");
                $(".warning-msg").hide();
            }
        }

        $('#msg-input').on('input', function() {
            var text = $(this).val();
            checkForContactDetails(text);
        });

        $(".chat-user").on('click', function() {
            $(".chat-user").removeClass('active');
            $(this).addClass('active');

            var $receiver_id = $(this).data("id");

            updateMessages($receiver_id, 0, 2);
        });

        $("#send-msg").click(function() {
            var $msg_input = $("#msg-input"); // Corrected selector
            var $file = $("#attached-file"); // Corrected selector
            var $receiver = $("#receiver_id"); // Corrected selector

            if ($msg_input.val().trim() !== "" || $file[0].files[0]) {
                let $attachedFileName = $(".attached-file-name");

                var formData = new FormData(); // Create a new FormData object
                formData.append('message_text', $msg_input.val()); // Append the message value
                formData.append('file', $file[0].files[0]); // Append the selected file
                formData.append('receiver_id', $receiver.val()); // Append the message value
                formData.append('action', 'SEND_MESSAGE'); // Append the message value

                $.ajax({
                    url: "app/core/messages.php",
                    type: "POST",
                    data: formData,
                    processData: false, // Prevent jQuery from processing data
                    contentType: false, // Let the browser set the content type
                    beforeSend: function() {
                        // console.log("Sending...");
                        $("#send-msg").hide();
                        $("#sending-msg").show();
                    },
                    success: function(data) {
                        console.log(data);
                    },
                    complete: function() {
                        // console.log("Sent successfully");
                        $msg_input.val('');
                        $file.val('');

                        // Scroll to bottom
                        let targetSection = $(".chat-history ul li");
                        let targetBottom = targetSection[0].scrollHeight
                        $(".chat-history ul li").animate({
                            scrollTop: targetBottom + 100
                        }, "fast");

                        $attachedFileName.text('');

                        $("#send-msg").show();
                        $("#sending-msg").hide();
                    }
                });
            }
        });

        $(".load-more-msg").click(function() {
            let receiver_id = $("#receiver_id").val();
            let first_id = $(".chat-msg").first().data("id");
            // console.log(first_id);

            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: "loadMoreMessages",
                    receiver_id: receiver_id,
                    first_id: first_id
                },
                success: function(data) {
                    let res = JSON.parse(data);

                    if (res.status === 'success') {
                        res.result && $(".chat-history .chats").prepend(res.result);

                        if (res.total < 20) {
                            $(".load-more-msg").hide();
                        }
                    }
                }
            });
        });

        function updateMessages(receiver_id, last_msg_id, type = 1) {
            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: "updateMessages",
                    receiver_id: receiver_id,
                    last_msg_id: last_msg_id
                },
                success: function(data) {
                    // console.log(data);

                    if (type == 2) {
                        $(".chat-history ul li .chats").html(data);
                    } else {
                        $(".chat-history ul li .chats").append(data);
                    }

                    if (data) {


                        // Scroll to bottom
                        // var element = $('.chat-history ul li');
                        // var positionFromBottom = element.prop('scrollHeight') - element.scrollTop() - element.height();

                        // console.log(positionFromBottom);
                        // if(positionFromBottom < 150) {
                        //     let targetBottom = element[0].scrollHeight
                        //     $(".chat-history ul li").animate({ scrollTop: targetBottom + 100 },"fast");
                        // }
                    }
                }
            });
        }

        function unreadMessagesCount() {
            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: 'unreadMessagesCount'
                },
                success: function(data) {
                    console.log(data);
                    let response = JSON.parse(data);
                    if (response.status === 'success') {
                        // console.log(response);
                        if (response.unread_count > 0) {
                            const badge = `<span class="position-absolute translate-middle badge rounded-pill bg-danger" style="top: 5px; right: 0;">
                                ${response.unread_count}
                                <span class="visually-hidden">unread messages</span>
                            </span>`;

                            $(".unread-msg-count").html(badge);
                        } else {
                            $(".unread-msg-count").html('');
                        }

                    }
                }
            });
        }

        setInterval(function() {
            let receiver_id = $("#receiver_id").val();

            if (receiver_id) {
                let last_msg_id = $(".chat-msg").last().data("id");
                if (!last_msg_id) {
                    last_msg_id = 0;
                }

                if ($('.chat-app').hasClass('active')) {
                    // console.log("waiting for new message!");
                    updateMessages(receiver_id, last_msg_id);
                }
            }

            checkNewNotifications();
            updateChatUser();
            unreadMessagesCount();
        }, 1500);

        $(".load-notifications a").click(function() {
            // $(".load-notifications").hide();
            updateNewNotifications();
        });

        $(".notif-back-btn").click(function() {
            $(".notification-menu").removeClass("active");
        });

        $(".load-more-notifications").click(function() {
            let last_id = $(".notifs .list").last().data("id");

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "loadMoreBuyerNotifications",
                    last_id: last_id
                },
                success: function(data) {
                    let res = JSON.parse(data);

                    if (res.has_result) {
                        $(".notifs .lists-container").append(res.data);

                        if (res.total < 10) {
                            $(".load-more-notifications").hide();
                        }
                    }
                }
            });
        });

        $(".dropdown-icon").click(function() {
            updateNewNotifications();

            $(".notification-menu").toggleClass("active");
        });

        function checkNewNotifications() {
            // console.log("Checking new notifications");

            let first_id = $(".notifs .list").first().data("id");

            if (!first_id) {
                first_id = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "checkNewBuyerNotifications",
                    first_id: first_id
                },
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);

                    if (res.is_found == true) {
                        $(".load-notifications").show();
                        $(".notif-alert").show();
                    } else {
                        $(".load-notifications").hide();
                        // console.log("not new notifications found");
                    }
                    // data && $(".chat-history ul li").append(data);
                }
            });
        }

        function updateNewNotifications() {
            // console.log("Checking new notifications");
            let last_id = $(".notifs .list").first().data("id");

            if (!last_id) {
                last_id = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "getNewBuyerNotifications",
                    last_id: last_id
                },
                success: function(data) {
                    console.log(data);
                    let res = JSON.parse(data);

                    if (res.status == 'success') {
                        $(".no-results").hide();
                        res.data && $(".notifs").prepend(res.data);

                        $(".load-notifications").hide();
                        $(".notif-alert").hide();
                    }
                }
            });
        }

        function ensureHttpsProtocol(url) {
            return url.replace(/^http:\/\//i, 'https://');
        }

        $(document).on('click', '.mark-notifications', function() {
            let offer_id = $(this).data("id");
            var imgElement = $(this).find("img");

            let src = imgElement.attr("src");

            let type = 1;
            if (src === 'public/images/star.svg') {
                type = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "markBuyerNotification",
                    offer_id: offer_id,
                    type: type
                },
                success: function(data) {
                    // console.log(data);
                    // let res = JSON.parse(data);

                    if (type === 1) {
                        imgElement.attr('src', 'public/images/star.svg');
                    } else {
                        imgElement.attr('src', 'public/images/star-light.svg');
                    }
                }
            });
        });
    });
</script>