<?php
    function isLoggedIn() {
        return isset($_SESSION['userData']);
    }
    
    // function get_options($option_name) {
    //     $connect = (new Database())->getConnection();
    //     $result = $connect->query("SELECT * FROM `options` WHERE `option_name` = '$option_name'");

    //     if ($result->rowCount() > 0) {
    //         $res = $result->fetch(PDO::FETCH_ASSOC);
    //         return $res["option_value"];
    //     }

    //     return false;
    // }

    function isAdmin() {
        return isset($_SESSION['userData']) && $_SESSION['userData']['account_type'] === 'admin';
    }

    function isSeller() {
        return isset($_SESSION['userData']) && $_SESSION['userData']['account_type'] === 'seller';
    }

    function isBuyer() {
        return isset($_SESSION['userData']) && $_SESSION['userData']['account_type'] === 'buyer';
    }

    function validateEmail($email) {
        return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
    }

    function validatePassword($password) {
        return strlen($password) >= 8;
    }

    function validateString($string, $minLength = 1, $maxLength = PHP_INT_MAX) {
        $length = strlen($string);
        return ($length >= $minLength && $length <= $maxLength);
    }

    function displayDateOrDay($dateString) {
        $timestamp = strtotime($dateString);
        $currentWeekStart = strtotime('this sunday', time());
        $currentWeekEnd = strtotime('+7 days', $currentWeekStart);
    
        if ($timestamp >= $currentWeekStart && $timestamp <= $currentWeekEnd) {
            return date("l", $timestamp); // Return day name
        } else {
            return date("Y-m-d", $timestamp); // Return full date
        }
    }

    function generateSecretKey($length = 16) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $secretKey = '';

        for ($i = 0; $i < $length; $i++) {
            $randomIndex = rand(0, $charactersLength - 1);
            $secretKey .= $characters[$randomIndex];
        }

        return $secretKey;
    }

    function shortenText($text, $maxLength, $ellipsis = '...') {
        if (strlen($text) <= $maxLength) {
            return $text;
        }
    
        $shortenedText = substr($text, 0, $maxLength);
        $lastSpacePos = strrpos($shortenedText, ' ');
    
        if ($lastSpacePos !== false) {
            $shortenedText = substr($shortenedText, 0, $lastSpacePos);
        }
    
        return $shortenedText . $ellipsis;
    }

    function ensureHttpsProtocol($url) {
        // Check if the URL starts with "http://" or "https://"
        if (stripos($url, 'http://') !== 0 && stripos($url, 'https://') !== 0) {
            // If it doesn't, add "https://"
            $url = 'https://' . $url;
        }
        return $url;
    }

    // Function to validate email domain
    function isAllowedEmailDomain($email, $allowedDomains) {
        $emailParts = explode('@', $email);
        if (count($emailParts) == 2) {
            $domain = $emailParts[1];
            foreach ($allowedDomains as $allowedDomain) {
                if (strpos($domain, $allowedDomain) !== false) {
                    return true;
                }
            }
        }
        return false;
    }

    // Function to compress and resize images (supports all image types)
    function compressAndResizeImage($source, $destination, $quality = 75, $maxWidth = 500) {
        // Load the source image
        $imageData = file_get_contents($source);
        $sourceImage = imagecreatefromstring($imageData);

        // Check if the image creation was successful
        if (!$sourceImage) {
            return false; // Failed to create image resource
        }

        // Get original dimensions
        $sourceWidth = imagesx($sourceImage);
        $sourceHeight = imagesy($sourceImage);

        // Calculate new dimensions while maintaining aspect ratio
        $aspectRatio = $sourceWidth / $sourceHeight;
        $newWidth = min($sourceWidth, $maxWidth);
        $newHeight = $newWidth / $aspectRatio;

        // Create a new blank image with the new dimensions
        $resizedImage = imagecreatetruecolor($newWidth, $newHeight);

        // Resize the source image to the new dimensions
        imagecopyresampled($resizedImage, $sourceImage, 0, 0, 0, 0, $newWidth, $newHeight, $sourceWidth, $sourceHeight);

        // Save the compressed and resized image to the destination
        $success = imagejpeg($resizedImage, $destination, $quality);

        // Free up memory
        imagedestroy($sourceImage);
        imagedestroy($resizedImage);

        return $success;
    }


    // Function to compress and resize images with maximum width
    function compressAndResizeImageX($source, $destination, $quality = 75, $maxWidth = 500) {
        // Load the source image
        $sourceImage = imagecreatefromjpeg($source);

        // Get original dimensions
        $sourceWidth = imagesx($sourceImage);
        $sourceHeight = imagesy($sourceImage);

        // Calculate new dimensions while maintaining aspect ratio
        $aspectRatio = $sourceWidth / $sourceHeight;
        $newWidth = min($sourceWidth, $maxWidth);
        $newHeight = $newWidth / $aspectRatio;

        // Create a new blank image with the new dimensions
        $resizedImage = imagecreatetruecolor($newWidth, $newHeight);

        // Resize the source image to the new dimensions
        imagecopyresampled($resizedImage, $sourceImage, 0, 0, 0, 0, $newWidth, $newHeight, $sourceWidth, $sourceHeight);

        // Save the compressed and resized image to the destination
        $success = imagejpeg($resizedImage, $destination, $quality);

        // Free up memory
        imagedestroy($sourceImage);
        imagedestroy($resizedImage);

        return $success;
    }

    function checkIfAllNotEmpty($variables) {
        foreach($variables as $variable) {
            if(empty($variable)) {
                return false;
            }
        }
        return true;
    }

?>