<?php
    session_start();

    include './load.php';
    include './templates/header.php';
    include './app/models/Products.php';

    if(isBuyer()) {
        header("Location: buyer.php");
        exit();
    }

    if(isSeller()) {
        header("Location: seller.php");
        exit();
    }

    if(isAdmin()) {
        header("Location: admin.php");
        exit();
    }
    
    $productModel = new Products();
?>
<style>
    #map {
      height: 400px;
      width: 100%;
      margin-top: 20px;
    }
   
    
</style>
<!-- Header start -->
<header>
    <div class="header-content">
        <div class="container">
            <div class="content-wrapper">
                <div class="header-logo">
                    <a href="<?php echo BASE_URL; ?>">
                        <img src="public/images/logo-main.svg" alt="">
                    </a>
                </div>
                <div class="menu-bar">
                    <img src="public/images/fi-sr-bar.svg" alt="">
                </div>
                <div class="header-nav">
                    <ul class="d-flex list-unstyled m-0">
                        <li><a href="">Home</a></li>
                        <!-- <li><a href="">About</a></li> -->
                        <li><a href="mailto:guy@connectionsys.co.uk">Contact Us</a></li>
                    </ul>
                </div>
                <div class="header-button">
                    <button class="btn butn-primary get-started">Get Started</button>
                </div>
            </div>
        </div>
    </div>
</header>

<!-- Hero section start -->
<section class="hero-section">
    <div class="container">
        <div class="content-wrapper pt-50 pb-50">
            <div class="row g-4">
                <div class="hero-left col-md-12 col-lg-7">
                    <div class="left-content">
                        <h2 class="mb-20">The problem we are determined to solve - There is no easy way to compare price of building materials and create the shopping basket of the cheapest building materials.</h2>
                        <p class="mb-30">By registering in the system and posting the product/s you are looking for, A huge amount of suppliers will receive an update on this and will have the opportunity to give the most competitive price they can (per product). Our system will go through all the prices and show you the best price/s for you.</p>
                        <div class="hero-btn">
                            <button class="btn butn-primary get-started">Get Started</button>
                        </div>
                    </div>
                </div>
                <div class="hero-right col-md-12 col-lg-5">
                    <div class="right-content">
                        <div class="hero-image">
                            <img src="public/images/10802152_4530887 1.svg" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="main-content">
    <div class="container">
        <div class="content-wrapper pt-50 pb-50">
            <div class="row g-4">
                <div class="col-md-12 col-lg-5 col-xl-7">
                    <div class="content-left h-100">
                        <div class="image d-flex align-items-center justify-content-center h-100">
                            <img src="public/images/OBJECTS.svg" alt="">
                        </div>
                    </div>
                </div>
                <div class="col-md-12 col-lg-7 col-xl-5">
                    <div class="content-right">
                        <div class="mb-30">
                            <h2>Discover a World of Possibilities – Welcome to Our Website!</h2>
                        </div>
                        <div>
                            <?php
                                if(isset($_GET["action"]) && $_GET["action"] === "buyer-register") {
                                    $nav_item1 = 'nav__link_active';
                                    $nav_slider = 'transform: translateX(0%);';
                                    $nav_content = 'transform: translateX(0%);';
                                }else if(isset($_GET["action"]) && $_GET["action"] === "seller-register") {
                                    $nav_item2 = 'nav__link_active';
                                    $nav_slider = 'transform: translateX(100%);';
                                    $nav_content = 'transform: translateX(-100%);';
                                }else if(isset($_GET["action"]) && $_GET["action"] === "user-login") {
                                    $nav_item3 = 'nav__link_active';
                                    $nav_slider = 'transform: translateX(200%);';
                                    $nav_content = 'transform: translateX(-200%);';
                                }else {
                                    $nav_item1 = 'nav__link_active';
                                }

                                function navStatus($current, $active) {
                                    if($active == 1) {
                                        $transform = 0;
                                    }else if($active == 2) {
                                        $transform = 100;
                                    }else {
                                        $transform = 200;
                                    }

                                    if($current === $active) {
                                        return '';
                                    }else {
                                        return '';
                                    }
                                }
                            ?>
                            <nav class="nav js-nav">
                                <ul class="nav__list">
                                    <li class="nav__item">
                                        <a href="#" class="nav__link <?php echo isset($nav_item1) ? $nav_item1 : '' ?>" data-transform="0">Register as a buyer</a>
                                    </li>
                                    <li class="nav__item">
                                        <a href="#" class="nav__link <?php echo isset($nav_item2) ? $nav_item2 : '' ?>" data-transform="100">Register as a Seller</a>
                                    </li>
                                    <li class="nav__item">
                                        <a href="#" class="nav__link <?php echo isset($nav_item3) ? $nav_item3 : '' ?>" data-transform="200">Login</a>
                                    </li>
                                </ul>
                                <div class="nav__slider">
                                    <div class="nav__slider-rect" style="<?php echo isset($nav_slider) ? $nav_slider : '' ?>">
                                        <!-- <h1>Hello There!</h1> -->
                                    </div>
                                </div>
                                <div class="nav__slider-main">
                                    <div class="nav__slider-content" style="<?php echo isset($nav_content) ? $nav_content : '' ?>">
                                            <div class="buyer-register">
                                                <?php
                                                    if(isset($_GET["action"]) && $_GET["action"] === "buyer-register" && isset($_GET["message"])) {
                                                        ?>
                                                            <div class="alert alert-<?php echo $_GET["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                                                                <?php echo $_GET["message"]; ?>
                                                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                                            </div>
                                                        <?php
                                                    }
                                                    
                                                    if(isset($_GET["action"]) && $_GET["action"] === "buyer-register" && isset($_GET["messages"])) {
                                                        $messages = $_GET["messages"];

                                                        foreach($messages as $message) {
                                                            ?>
                                                                <div class="alert alert-<?php echo $_GET["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                                                                    <?php echo $message; ?>
                                                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                                                </div>
                                                            <?php
                                                        }
                                                    }
                                                ?>

                                                <form action="app/core/registration.php" method="post">
                                                    <input type="hidden" name="account-type" value="buyer">
                                                    <div class="form-group mb-15">
                                                        <label for="">Company Name</label>
                                                        <input type="text" name="company" class="form-control" required>
                                                    </div>
                                                    <div class="form-group mb-15">
                                                        <label for="">Email</label>
                                                        <input type="email" name="email" class="form-control" required>
                                                    </div>
                                                    <div class="form-group mb-15">
                                                        <label for="">Password</label>
                                                        <input type="password" name="password" class="form-control" required>
                                                    </div>
                                                    <div class="form-group country-list mb-15">
                                                        <label for="">Country</label>
                                                        <details>
                                                            <summary>Choose a country</summary>
                                                            <ul>
                                                                <li>
                                                                    <label><input type="checkbox" name="country[]" value="uk" /><span>UK</span></label>
                                                                </li>
                                                                <li>
                                                                    <label><input type="checkbox" name="country[]" value="ireland" /><span>Ireland</span></label>
                                                                </li>
                                                            </ul>
                                                        </details>
                                                    </div>
                                                    <!-- Google reCAPTCHA -->
                                                    <!-- <div class="g-recaptcha mb-3" data-sitekey="6Ld6FwUoAAAAAP6QBOTbwhlp1ZCrKpTpJfJZI0hH"></div> -->                                                    
                                                    <button type="submit" class="btn butn-primary" style="width: 170px;">Create Account</button>
                                                </form>
                                            </div>
                                            <div class="seller-register">
                                                <?php
                                                    if(isset($_GET["action"]) && $_GET["action"] === "seller-register" && isset($_GET["message"])) {
                                                        ?>
                                                            <div class="alert alert-<?php echo $_GET["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                                                                <?php echo $_GET["message"]; ?>
                                                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                                            </div>
                                                        <?php
                                                    }
                                                    
                                                    if(isset($_GET["action"]) && $_GET["action"] === "seller-register" && isset($_GET["messages"])) {
                                                        $messages = $_GET["messages"];

                                                        foreach($messages as $message) {
                                                            ?>
                                                                <div class="alert alert-<?php echo $_GET["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                                                                    <?php echo $message; ?>
                                                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                                                </div>
                                                            <?php
                                                        }
                                                    }
                                                ?>

                                                <form action="app/core/registration.php" method="post">
                                                    <input type="hidden" name="account-type" value="seller">
                                                    <div class="form-group mb-15">
                                                        <label for="">Company Name</label>
                                                        <input type="text" name="company" class="form-control" required>
                                                    </div>
                                                    <div class="form-group mb-15">
                                                        <label for="">Email</label>
                                                        <input type="email" name="email" class="form-control" required>
                                                    </div>
                                                    <div class="form-group mb-15">
                                                        <label for="">Password</label>
                                                        <input type="password" name="password" class="form-control" required>
                                                    </div>
                                                    <div class="form-group product-list mb-15">
                                                        <label for="">List of Products</label>
                                                        <details>
                                                            <summary>Choose a product</summary>
                                                            <ul>
                                                                <?php
                                                                    $products = $productModel->getAllProducts();

                                                                    if($products) {
                                                                        foreach($products as $product) {
                                                                            echo '<li>
                                                                                    <label><input type="checkbox" name="product_name[]" value="'. strtolower($product["name"]). '" /><span>'. $product["name"]. '</span></label>
                                                                                </li>';
                                                                        }
                                                                    }
                                                                ?>
                                                            </ul>
                                                        </details>
                                                    </div>
                                                    <div class="form-group country-list mb-15">
                                                        <label for="">Country</label>
                                                        <details>
                                                            <summary>Choose a country</summary>
                                                            <ul>
                                                                <li>
                                                                    <label><input type="checkbox" name="country[]" value="uk" /><span>UK</span></label>
                                                                </li>
                                                                <li>
                                                                    <label><input type="checkbox" name="country[]" value="ireland" /><span>Ireland</span></label>
                                                                </li>
                                                            </ul>
                                                        </details>
                                                    </div>
                                                    <div class="form-group mb-15">
                                                        <label for="">Google Reviews Link (Optional) <small class="text-muted">Maximum 500 characters allowed</small></label>
                                                        <input type="text" name="gr_link" class="form-control" maxlength="500" placeholder="https://www.google.com/">
                                                    </div>
                                                    <!-- Google reCAPTCHA -->
                                                    <!-- <div class="g-recaptcha mb-3" data-sitekey="6Ld6FwUoAAAAAP6QBOTbwhlp1ZCrKpTpJfJZI0hH"></div> -->
                                                    <input type="hidden" id="selected-postcodes" name="postcodes" value="[]">
                                                    <div id="osm-map" style="width: 100%; height: 400px;" class="mb-2"></div>
                                                    <div id="alert-message" class="mb-2" style="display: none; text-align: center; margin-top: 20px; padding: 10px; background-color: #28a745; color: white; border-radius: 5px;"></div>
                                                    <button type="submit" class="btn butn-primary" style="width: 170px;">Create Account</button>
                                                </form>
                                            </div>
                                            <div class="user-login">
                                                <?php
                                                    if(isset($_GET["action"]) && $_GET["action"] === "user-login") {
                                                        ?>
                                                            <div class="alert alert-<?php echo $_GET["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                                                                <?php echo $_GET["message"]; ?>
                                                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                                            </div>
                                                        <?php
                                                    }
                                                ?>
                                                <form class="login-form" action="app/core/login.php" method="post">
                                                    <div class="form-group mb-15">
                                                        <label for="">Email</label>
                                                        <input type="email" name="email" class="form-control" required>
                                                    </div>
                                                    <div class="form-group mb-15">
                                                        <label for="">Password</label>
                                                        <input type="password" name="password" class="form-control" required>
                                                    </div>
                                                    <!-- Google reCAPTCHA -->
                                                    <!-- <div class="g-recaptcha mb-3" data-sitekey="6Ld6FwUoAAAAAP6QBOTbwhlp1ZCrKpTpJfJZI0hH"></div> -->
                                                    <div class="form-btn">
                                                        <button type="submit" class="btn butn-primary" style="width: 150px;">Login</button>
                                                        <a href="forgot-password.php">Forgot Password?</a>
                                                    </div>
                                                </form>
                                            </div>
                                    </div>
                                </div>
                                </nav>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<footer>
    <div class="footer-top d-flex align-items-center">
        <div class="container">
            <div class="footer-content d-flex align-items-center justify-content-between">
                <div class="footer-pages">
                    <ul class="list-unstyled m-0">
                        <li><a href="<?php echo BASE_URL; ?>terms.php">Terms of USE</a></li>
                    </ul>
                </div>
                <div class="social-links">
                    <ul class="list-unstyled m-0">
                        <li>
                            <a href="">
                                <!-- <img src="public/images/linkedin.svg" alt=""> -->
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom d-flex align-items-center">
        <div class="container">
            <div class="bottom-content">
                <div class="row">
                    <div class="col-sm-12 col-md-6">
                        <div class="footer-logo">
                            <a href="<?php echo BASE_URL; ?>">
                                <img src="public/images/logo-light.svg" alt="">
                            </a>
                        </div>
                        
                    </div>
                    <div class="col-sm-12 col-md-6">
                        <div class="footer-copyright">
                            <a href="javascript:void(0);">© 2023. All rights reserved.</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

<script>
    $(document).ready(function() {
        $(".menu-bar").click(function() {
            $(".header-nav").toggleClass("active");
        });

        $(".get-started").click(function() {
            $('html, body').animate({ scrollTop: $(document).height() }, 'fast');
        });
    });
</script>
<script src="https://unpkg.com/leaflet@1.6.0/dist/leaflet.js"></script>
<link href="https://unpkg.com/leaflet@1.6.0/dist/leaflet.css" rel="stylesheet"/>
<script>
// Initialize the map
var map = L.map('osm-map').setView([52.54510000, -1.78616000], 12);

L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
    attribution: '&copy; <a href="http://osm.org/copyright">OpenStreetMap</a> contributors',
    maxZoom: 19
}).addTo(map);

// Load UK boundary GeoJSON
$.getJSON('path/uk-boundary.geojson', function (geojson) {
    // Add GeoJSON layer to map
    var boundaryLayer = L.geoJson(geojson, {
        style: {
            color: 'gray',
            weight: 2,
            fillOpacity: 0.1
        },
        onEachFeature: function (feature, layer) {
            if (feature.properties && feature.properties.name) {
                layer.bindPopup(feature.properties.name);
            }
        }
    }).addTo(map);

    map.fitBounds(boundaryLayer.getBounds()); // Adjust map view to fit GeoJSON bounds
});

// Define a green marker icon
var greenIcon = L.icon({
    iconUrl: 'https://img.icons8.com/?size=100&id=PmnKuCaoGaNp&format=png&color=000000',
    iconSize: [50, 50],
    popupAnchor: [0, -15] // Popup will open above the marker
});

// Function to add selected postcode to a hidden input
function addPostcodeToSelection(postcode, lat, lon, marker) {
    var selectedPostcodes = JSON.parse(document.getElementById('selected-postcodes').value);

    // Prevent duplicate postcodes
    if (!selectedPostcodes.some(post => post.postcode === postcode)) {
        selectedPostcodes.push({ postcode: postcode, latitude: lat, longitude: lon });
        document.getElementById('selected-postcodes').value = JSON.stringify(selectedPostcodes);

        // Change marker color to green
        marker.setIcon(greenIcon);

        // Show alert message for 3 seconds
        var alertMessage = document.getElementById('alert-message');
        alertMessage.textContent = 'Postcode Selected: ' + postcode;
        alertMessage.style.display = 'block';
        setTimeout(function () {
            alertMessage.style.display = 'none';
        }, 3000);
    }
}

// Fetch postcodes from the server
$.ajax({
    url: 'app/core/get-postcodes.php', // Server endpoint to fetch postcodes
    method: 'GET', // Use GET as the method
    dataType: 'json', // Parse the response as JSON
    success: function (response) {
        if (response && response.postcodes && Array.isArray(response.postcodes)) {
            const postcodes = response.postcodes;
            postcodes.forEach(function (postcode) {
                var lat = postcode.latitude;
                var lon = postcode.longitude;

                // Add marker for the postcode
                var marker = L.marker([lat, lon]).addTo(map);
                marker.bindPopup(`<b>Postcode:</b> ${postcode.postcode}<br><b>Latitude:</b> ${lat}<br><b>Longitude:</b> ${lon}`);

                // Add click event to the marker
                marker.on('click', function () {
                    addPostcodeToSelection(postcode.postcode, lat, lon, marker);
                });
            });
        } else {
            console.log('No postcodes found in the response.');
        }
    },
    error: function () {
        console.log('Failed to load postcodes from the server.');
    }
});



</script>


<?php
    include './templates/footer.php';
?>