<?php
    session_start();

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use PHPMailer\PHPMailer\SMTP;

    include './load.php';
    include './templates/header.php';
    include './app/models/Messages.php';
    include './app/models/Notifications.php';
    include './app/models/Projects.php';
    include './app/models/Products.php';

    if(!isBuyer()) {
        header("Location: index.php");
        exit();
    }

    $uid = $_SESSION["user_id"];

    $msgModel = new Messages();
    $notifModel = new Notifications();
    $projectsModel = new Projects();
    $productModel = new Products();
    $usersModel = new Users();
    // echo json_encode($messages);

    if(isset($_GET["show"])) {
        $_SESSION["show"] = $_GET["show"];
    }

    if(isset($_GET["notif_type"])) {
        $_SESSION["notif_type"] = $_GET["notif_type"];
    }else {
        $_SESSION["notif_type"] = 'all';
    }

    if(isset($_GET["add-to-chat"])) {
        $seller_id = $_GET["add-to-chat"];
        $addToChat = $msgModel->addToChat($uid, $seller_id);

        if($addToChat) {
            $_SESSION["chat_id"] = $seller_id;

            $msgModel->readAll($uid);
        }
    }

    if(isset($_GET["chat_id"])) {
        $_SESSION["chat_id"] = $_GET["chat_id"];

        $msgModel->readAll($uid);
    }

    if(isset($_GET["update_notif_status"]) && !empty($_GET["update_notif_status"])) {
        $offer_id = $_GET["offer_id"];
        $item_id = $_GET["item_id"];
        $status = $_GET["status_type"];
        $res = $projectsModel->updateStatus($offer_id, $item_id, $status);

        // echo json_encode($res);
    }

    $seller_id = $_GET["uid"];
    $retings = $projectsModel->getReviews($seller_id);
    $seller = $usersModel->getUserById($seller_id);
?>

<div class="seller-reviews d-flex">
    <!-- Include Sidebar -->
    <div class="sidebar">
        <div class="sidebar-content">
            <div class="sidebar-logo d-flex align-items-center justify-content-center">
                <img src="public/images/logo-sm.svg" alt="">
            </div>
            <div class="sidebar-nav">
                <div class="nav-items">
                    <div class="item <?php echo $_SESSION["show"] === "home" ? "active" : ""; ?>">
                        <a href="buyer.php?show=home">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M30.06 10.23L21.42 4.18503C19.065 2.53503 15.45 2.62503 13.185 4.38003L5.66999 10.245C4.16999 11.415 2.98499 13.815 2.98499 15.705V26.055C2.98499 29.88 6.08998 33 9.91498 33H26.085C29.91 33 33.015 29.895 33.015 26.07V15.9C33.015 13.875 31.71 11.385 30.06 10.23ZM19.125 27C19.125 27.615 18.615 28.125 18 28.125C17.385 28.125 16.875 27.615 16.875 27V22.5C16.875 21.885 17.385 21.375 18 21.375C18.615 21.375 19.125 21.885 19.125 22.5V27Z" fill="#60CB97"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "chat" ? "active" : ""; ?>" id="chatBtn">
                        <a href="buyer.php?show=chat">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M33 9.375V17.025C33 18.93 32.37 20.535 31.245 21.645C30.135 22.77 28.53 23.4 26.625 23.4V26.115C26.625 27.135 25.485 27.75 24.645 27.18L23.19 26.22C23.325 25.755 23.385 25.245 23.385 24.705V18.6C23.385 15.54 21.345 13.5 18.285 13.5H8.09999C7.88999 13.5 7.695 13.515 7.5 13.53V9.375C7.5 5.55 10.05 3 13.875 3H26.625C30.45 3 33 5.55 33 9.375Z" fill="white" stroke="#60CB97" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M23.385 18.6V24.705C23.385 25.245 23.325 25.755 23.19 26.22C22.635 28.425 20.805 29.805 18.285 29.805H14.205L9.675 32.82C9 33.285 8.09999 32.79 8.09999 31.98V29.805C6.56999 29.805 5.295 29.295 4.41 28.41C3.51 27.51 3 26.235 3 24.705V18.6C3 15.75 4.77 13.785 7.5 13.53C7.695 13.515 7.88999 13.5 8.09999 13.5H18.285C21.345 13.5 23.385 15.54 23.385 18.6Z" fill="white" stroke="#60CB97" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "add" ? "active" : ""; ?>" id="addBtn">
                        <a href="buyer.php?show=add">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M24.285 3H11.715C6.255 3 3 6.255 3 11.715V24.27C3 29.745 6.255 33 11.715 33H24.27C29.73 33 32.985 29.745 32.985 24.285V11.715C33 6.255 29.745 3 24.285 3ZM24 19.125H19.125V24C19.125 24.615 18.615 25.125 18 25.125C17.385 25.125 16.875 24.615 16.875 24V19.125H12C11.385 19.125 10.875 18.615 10.875 18C10.875 17.385 11.385 16.875 12 16.875H16.875V12C16.875 11.385 17.385 10.875 18 10.875C18.615 10.875 19.125 11.385 19.125 12V16.875H24C24.615 16.875 25.125 17.385 25.125 18C25.125 18.615 24.615 19.125 24 19.125Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "products" ? "active" : ""; ?>" id="productsBtn">
                        <a href="buyer.php?show=products">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M24.285 3H11.715C6.255 3 3 6.255 3 11.715V24.285C3 29.745 6.255 33 11.715 33H24.285C29.745 33 33 29.745 33 24.285V11.715C33 6.255 29.745 3 24.285 3ZM14.955 22.35L11.58 25.725C11.355 25.95 11.07 26.055 10.785 26.055C10.5 26.055 10.2 25.95 9.99 25.725L8.865 24.6C8.415 24.165 8.415 23.445 8.865 23.01C9.3 22.575 10.005 22.575 10.455 23.01L10.785 23.34L13.365 20.76C13.8 20.325 14.505 20.325 14.955 20.76C15.39 21.195 15.39 21.915 14.955 22.35ZM14.955 11.85L11.58 15.225C11.355 15.45 11.07 15.555 10.785 15.555C10.5 15.555 10.2 15.45 9.99 15.225L8.865 14.1C8.415 13.665 8.415 12.945 8.865 12.51C9.3 12.075 10.005 12.075 10.455 12.51L10.785 12.84L13.365 10.26C13.8 9.825 14.505 9.825 14.955 10.26C15.39 10.695 15.39 11.415 14.955 11.85ZM26.34 24.93H18.465C17.85 24.93 17.34 24.42 17.34 23.805C17.34 23.19 17.85 22.68 18.465 22.68H26.34C26.97 22.68 27.465 23.19 27.465 23.805C27.465 24.42 26.97 24.93 26.34 24.93ZM26.34 14.43H18.465C17.85 14.43 17.34 13.92 17.34 13.305C17.34 12.69 17.85 12.18 18.465 12.18H26.34C26.97 12.18 27.465 12.69 27.465 13.305C27.465 13.92 26.97 14.43 26.34 14.43Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "combinations" ? "active" : ""; ?>" id="combinationsBtn">
                        <a href="buyer.php?show=combinations">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M17.91 3.31499L14.295 11.73H10.68C10.08 11.73 9.49505 11.775 8.92505 11.895L10.425 8.29499L10.485 8.15999L10.575 7.91999C10.62 7.81499 10.65 7.72499 10.695 7.64999C12.435 3.61499 14.385 2.35499 17.91 3.31499Z" fill="white"/>
                                <path d="M28.0951 12.135L28.0651 12.12C27.1651 11.865 26.2501 11.73 25.3201 11.73H15.9301L19.3051 3.88503L19.3501 3.78003C19.5601 3.85503 19.7851 3.96003 20.0101 4.03503L23.3251 5.43003C25.1701 6.19503 26.4601 6.99003 27.2551 7.95003C27.3901 8.13003 27.5101 8.29503 27.6301 8.49003C27.7651 8.70003 27.8701 8.91003 27.9301 9.13503C27.9901 9.27003 28.0351 9.39003 28.0651 9.52503C28.2901 10.29 28.3051 11.16 28.0951 12.135Z" fill="white"/>
                                <path d="M27.435 14.28C26.76 14.085 26.055 13.98 25.32 13.98H10.68C9.65999 13.98 8.69999 14.175 7.79998 14.565C5.18999 15.69 3.35999 18.285 3.35999 21.3V24.225C3.35999 24.585 3.38999 24.93 3.43499 25.29C3.76499 30.06 6.31498 32.61 11.085 32.925C11.43 32.97 11.775 33 12.15 33H23.85C29.4 33 32.325 30.36 32.61 25.11C32.625 24.825 32.64 24.525 32.64 24.225V21.3C32.64 17.985 30.435 15.195 27.435 14.28ZM21.75 25.125H14.25C13.635 25.125 13.125 24.615 13.125 24C13.125 23.385 13.635 22.875 14.25 22.875H21.75C22.365 22.875 22.875 23.385 22.875 24C22.875 24.615 22.365 25.125 21.75 25.125Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div class="logout-btn">
                <a class="button" href="logout.php">
                    <img src="public/images/fi-sr-sign-out-alt.svg" alt="">
                </a>
            </div>
        </div>
    </div>

    <div class="main">
        <div class="header">
            <div class="header-wrap">
                <div class="menu-bar">
                    <img src="public/images/fi-sr-bar.svg" alt="">
                </div>
                <div class="header-left">
                    <div class="header-title">
                        <h1 class="m-0">Buyer Page</h1>
                    </div>
                    <div class="header-logo">
                        <img src="public/images/logo-main.svg" alt="">
                    </div>
                </div>
                <div class="header-right">
                    <div class="search">
                        <div class="icon">
                            <img src="public/images/bi_search-heart-fill.svg" alt="">
                        </div>
                        <input class="form-control" type="search" name="" id="" placeholder="Search your query">
                    </div>
                    <div class="notification">
                        <div class="dropdown-icon">
                            <div class="notif-alert" style="display: none;"></div>
                            <img src="public/images/notification-dark.svg" alt="">
                        </div>
                        <div class="notification-menu <?php echo isset($_GET["notif_type"]) ? 'active' : ''; ?>">
                            <div class="load-notifications" style="display: none;">
                                <a href="javascript:void(0);">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="reload">
                                        <path d="M21,11a1,1,0,0,0-1,1,8.05,8.05,0,1,1-2.22-5.5h-2.4a1,1,0,0,0,0,2h4.53a1,1,0,0,0,1-1V3a1,1,0,0,0-2,0V4.77A10,10,0,1,0,22,12,1,1,0,0,0,21,11Z"></path>
                                    </svg>
                                    <span>view new projects</span>
                                </a>
                            </div>
                            <div class="notif-header">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="notif-back-btn">
                                        <a href="javascript:void(0);">Back</a>
                                    </div>
                                    <div class="title">
                                        <h5  class="m-0">Notifications</h5>
                                    </div>
                                    <div class=""></div>
                                </div>
                            </div>
                            <div class="notifs">
                                <div class="d-flex align-items-center justify-content-end mr-10 mt-5 mb-5">
                                    <?php 
                                        if(isset($_SESSION["notif_type"]) && $_SESSION["notif_type"] === 'marked') {
                                            ?>
                                                <a href="?notif_type=all">
                                                    <img width="30" src="public/images/star.svg" alt="">
                                                </a>
                                            <?php
                                        }else {
                                            ?>
                                                <a href="?notif_type=marked">
                                                    <img width="30" src="public/images/star-light.svg" alt="">
                                                </a>
                                            <?php
                                        }
                                    ?>
                                </div>
                                <div class="lists-container">
                                    <?php
                                        $notifications = $notifModel->getBuyerNotifications($uid);

                                        if( $notifications) {
                                            foreach($notifications["data"] as $notification) {
                                                // echo json_encode($notification);
                                                ?>
                                                    <div class="list" data-id="<?php echo $notification["offer_id"]; ?>">
                                                        <div class="info d-flex align-items-center justify-content-between">
                                                            <div class="notif-icon">
                                                                <img src="public/images/notification.svg" alt="">
                                                            </div>
                                                            <div class="p-meta">
                                                                <div class="title mb-10">
                                                                    <div class="">
                                                                        <h6><?php echo $notification["project_name"]; ?></h6>
                                                                        <span class="d-block mt-1 text-muted"><b><?php echo $notification["company_name"]; ?></b></span>
                                                                        <span class="text-muted"><b>Postcode:</b> <?php echo $notification["post_code"]; ?></span>
                                                                    </div>
                                                                    <div class="start">
                                                                        <!-- <img class="star-image" width="20" src="public/images/star-light.svg" alt=""> -->
                                                                        <a class="mark-notifications" href="javascript:void(0);" data-id="<?php echo $notification["offer_id"]; ?>">
                                                                            <?php
                                                                                if($notification["is_marked"] === '0') {
                                                                                    ?>
                                                                                        <img class="star-image" width="20" src="public/images/star-light.svg" alt="">
                                                                                    <?php
                                                                                }else {
                                                                                    ?>
                                                                                        <img class="star-image" width="20" src="public/images/star.svg" alt="">
                                                                                    <?php
                                                                                }
                                                                            ?>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                                <div class="desc">
                                                                    <?php
                                                                        $project_id = $notification["project_id"];
                                                                        $productItems = $projectsModel->getProjectItems($project_id);

                                                                        $offer_data = $notification["offer_data"];
                                                                        $dataArray = json_decode($offer_data, true);
                                                                        foreach ($dataArray as $item) {
                                                                            ?>
                                                                                <div class="amount d-flex">
                                                                                    <span class="text-muted mr-10"><?php echo ucfirst($item['product']) ?>:</span>
                                                                                    <b class="text-muted">+£<?php echo number_format($item['price'], 2) ?></b>
                                                                                </div>
                                                                            <?php
                                                                        }
                                                                    ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="msg-area d-flex align-items-center justify-content-between">
                                                            <div class="w-100 d-flex align-items-center justify-content-between">
                                                                <?php
                                                                    if(!empty($notification["attached_file"])) {
                                                                        ?>
                                                                            <div class="add-attachment">
                                                                                <a target="_blank" href="<?php echo $notification["attached_file"]; ?>">Attachment</a>
                                                                            </div>
                                                                        <?php
                                                                    }
                                                                ?>
                                                                <div class="msg" style="<?php echo empty($notification["attached_file"]) ? 'display: flex; width: 100%; justify-content: end;' : '' ?>">
                                                                    <a href="?add-to-chat=<?php echo $notification["seller_id"]; ?>">
                                                                        <img src="public/images/messages.svg" alt="">
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php
                                            }
                                        }else {
                                            ?>
                                                <div class="text-center mt-50">
                                                    <p class="no-results text-muted">Nothing to see here!</p>
                                                </div>
                                            <?php
                                        }
                                    ?>
                                </div>
                                <div class="">
                                    <?php

                                        if($notifications && $notifications["total"] >= 20) {
                                            ?>
                                                <div class="load-more-notifications">
                                                    <a href="javascript:void(0);">
                                                        <span>Load More</span>
                                                    </a>
                                                </div>
                                            <?php
                                        };
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="profile">
                        <div class="profile-item">
                            <div class="left">
                                <div class="user-name">
                                    <h6><?php echo $_SESSION["userData"]["company_name"]; ?></h6>
                                </div>
                                <div class="profile-nav">
                                    <!-- <p class="m-0"></p> -->
                                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" role="button" data-bs-toggle="dropdown" aria-expanded="false">My Account</a>
                                </div>
                            </div>
                            <div class="right">
                                <div class="profile-image">
                                    <img src="public/images/<?php echo $_SESSION["userData"]["company_logo"]; ?>" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <ul class="dropdown-menu header-dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                <li>
                                    <a class="dropdown-item" href="logout.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 6.35 6.35" id="logout" opacity="0.8">
                                            <path fill-rule="evenodd" d="M7.953.998a3.024 3.024 0 0 0-3.006 3.004V20a3.024 3.024 0 0 0 3.006 3.004h3.994A3.022 3.022 0 0 0 14.951 20v-4.002c0-1.334-2-1.334-2 0V20a.983.983 0 0 1-1.004 1.004H7.953A.983.983 0 0 1 6.95 20V4.002a.983.983 0 0 1 1.004-1.004h3.994a.983.983 0 0 1 1.004 1.004v4.002c0 1.334 2 1.334 2 0V4.002A3.022 3.022 0 0 0 11.947.998H7.953zM1.957 4.984a1 1 0 0 0-1.01 1.02v11.994a1 1 0 0 0 2 0V6.004a1 1 0 0 0-.982-1.02 1 1 0 0 0-.008 0zm16.037 2.004a1 1 0 0 0-.096.004 1 1 0 0 0-.6 1.713L19.595 11h-9.588a1.006 1.006 0 0 0-.104 0c-1.333.07-1.23 2.071.104 2.002h9.582l-2.29 2.287a1 1 0 1 0 1.411 1.418l4.002-4.002a1 1 0 0 0 0-1.41l-4.002-4a1 1 0 0 0-.715-.307z" color="#000" font-family="sans-serif" font-weight="400" overflow="visible" paint-order="stroke fill markers" transform="scale(.26458)" style="line-height:normal;font-variant-ligatures:normal;font-variant-position:normal;font-variant-caps:normal;font-variant-numeric:normal;font-variant-alternates:normal;font-feature-settings:normal;text-indent:0;text-align:start;text-decoration-line:none;text-decoration-style:solid;text-decoration-color:#000;text-transform:none;text-orientation:mixed;shape-padding:0;isolation:auto;mix-blend-mode:normal"></path>
                                        </svg>
                                        <span class="ml-5 text-muted" style="font-weight: 500;">Logout</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="main-content <?php echo $_SESSION["show"] === "home" ? "show_all" : "show_single";  ?>">

            <div class="reviews m-2">
                <div class="card">

                    <div class="card-body">
                        <div class="supplier-rating ml-10 mt-15 d-flex align-items-center">
                            <div class="seller-name">
                                <h5 class="text-muted mb-0 mr-20">#<?php echo $seller["company_name"]; ?></h5>
                            </div>
                            <div class="seller-review d-flex align-items-center">
                                <img class="mr-5" width="20" src="public/images/star.svg" alt="">
                                <span class="text-muted"><?php echo $retings ? $retings["average_rating"] .  ' ('.$retings["total_reviews"].')' : '0 (0)'; ?></span>
                            </div>
                        </div>
                        <hr>
                        <div class="reviews-list">
                            <!-- <h5 class="">Reviews</h5> -->
                            <?php
                                $reviews = $usersModel->getSellerReviews($seller_id);
                                if($reviews) {
                                    foreach($reviews["reviews"] as $review) {
                                        ?>
                                            <div class="review">
                                                <div class="buyer-name">
                                                    <h6><?php echo $review["company_name"]; ?></h6>
                                                </div>
                                                <div class="mb-10">
                                                    <div class="rating">
                                                        <div class="Stars" style="--rating: <?php echo $review["rating"]; ?>;"></div>
                                                    </div>
                                                    <div class="date"></div>
                                                </div>
                                                <div class="comment">
                                                    <?php echo $review["comment"]; ?>
                                                </div>
                                            </div>
                                        <?php
                                    }
                                }else {
                                    ?>
                                        <div class="text-center">
                                            <p class="text-muted">No reviews found!</p>
                                        </div>
                                    <?php
                                }
    
                            ?>                
                        </div>
                    </div>
            </div>

            <!-- Include Footer -->
            <footer>
                <div class="footer-top d-flex align-items-center">
                    <div class="container">
                        <div class="footer-content d-flex align-items-center justify-content-between">
                            <div class="footer-pages">
                                <ul class="list-unstyled m-0">
                                    <li><a href="<?php echo BASE_URL; ?>terms.php">Terms of USE</a></li>
                                </ul>
                            </div>
                            <div class="social-links">
                                <ul class="list-unstyled m-0">
                                    <li>
                                        <a href="">
                                            <!-- <img src="public/images/linkedin.svg" alt=""> -->
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="footer-bottom d-flex align-items-center">
                    <div class="container">
                        <div class="bottom-content">
                            <div class="row">
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-logo">
                                        <a href="<?php echo BASE_URL; ?>">
                                            <img src="public/images/logo-light.svg" alt="">
                                        </a>
                                    </div>
                                    
                                </div>
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-copyright">
                                        <a href="javascript:void(0);">© 2023. All rights reserved.</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
</div>

<?php
    include './templates/footer.php';
?>

<script>
    $(document).ready(function() {
        $(".menu-bar").click(function() {
            $(".sidebar").toggleClass("active");
        });

        $(".profile-item").click(function() {
            $(".header-dropdown-menu").toggle();
        });

        setInterval(function(){

            checkNewNotifications();
        }, 1500);

        $(".load-notifications a").click(function(){
            // $(".load-notifications").hide();
            updateNewNotifications();
        });

        $(".notif-back-btn").click(function() {
            $(".notification-menu").removeClass("active");
        });

        $(".load-more-notifications").click(function() {
            let last_id = $(".notifs .list").last().data("id");

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "loadMoreBuyerNotifications",
                    last_id: last_id
                },
                success: function(data) {
                    let res = JSON.parse(data);

                    if(res.has_result) {
                        $(".notifs .lists-container").append(res.data);

                        if(res.total < 10)  {
                            $(".load-more-notifications").hide();
                        }
                    }
                }
            });
        });

        $(".dropdown-icon").click(function() {
            updateNewNotifications();

            $(".notification-menu").toggleClass("active");
        });

        function checkNewNotifications() {
            // console.log("Checking new notifications");

            let first_id = $(".notifs .list").first().data("id");

            if(!first_id) {
                first_id = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "checkNewBuyerNotifications",
                    first_id: first_id
                },
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);

                    if(res.is_found == true) {
                        $(".load-notifications").show();
                        $(".notif-alert").show();
                    }else {
                        // console.log("not new notifications found");
                    }
                    // data && $(".chat-history ul li").append(data);
                }
            });
        }

        function updateNewNotifications() {
            // console.log("Checking new notifications");
            let last_id = $(".notifs .list").first().data("id");

            if(!last_id) {
                last_id = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "getNewBuyerNotifications",
                    last_id: last_id
                },
                success: function(data) {
                    console.log(data);
                    let res = JSON.parse(data);

                    if(res.status == 'success') {
                        $(".no-results").hide();
                        res.data && $(".notifs").prepend(res.data);

                        $(".load-notifications").hide();
                        $(".notif-alert").hide();
                    }
                }
            });
        }

        $(document).on('click','.mark-notifications', function() {
            let offer_id = $(this).data("id");
            var imgElement = $(this).find("img");

            let src = imgElement.attr("src");

            let type = 1;
            if(src === 'public/images/star.svg') {
                type = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "markBuyerNotification",
                    offer_id: offer_id,
                    type: type
                },
                success: function(data) {
                    // console.log(data);
                    // let res = JSON.parse(data);

                    if(type === 1) {
                        imgElement.attr('src', 'public/images/star.svg');
                    }else {
                        imgElement.attr('src', 'public/images/star-light.svg');
                    }
                }
            });
        });

        $('.edit-product').on('click', function() {
            let itemId = $(this).data('id');

            $.ajax({
                url: 'app/core/products.php',
                data: {
                    action: 'getProductItem',
                    id: itemId
                },
                type: 'POST',
                success: function(data) {
                    var responseData = JSON.parse(data);

                    $('#modal-content').html(`
                        <form action="" method="post">
                            <input type="hidden" name="pid" value="${responseData.project_id}">
                            <input type="hidden" name="item_id" value="${responseData.id}">
                            <div class="form-group mb-20">
                                <label for="">Product Name:</label>
                                <input type="text" class="form-control" value="${responseData.product_type}" disabled>
                            </div>
                            <div class="form-group mb-20">
                                <label for="">Description:</label>
                                <textarea style="height: 150px;" name="description" class="form-control">${responseData.description}</textarea>
                            </div>
                            <div class="form-group mb-20">
                                <button class="btn btn-primary" type="submit" name="update_product" value="1">Update</button>
                            </div>
                        </form>
                    `);

                    $('#editProductModal').modal('show');
                }
            });
        });
    });
</script>