<?php
    session_start();

    include './load.php';
    include './templates/header.php';
?>

<!-- Header start -->
<header>
    <div class="header-content">
        <div class="container">
            <div class="content-wrapper">
                <div class="header-logo">
                    <a href="<?php echo BASE_URL; ?>">
                        <img src="public/images/logo-main.svg" alt="">
                    </a>
                </div>
                <div class="header-nav">
                    <ul class="d-flex list-unstyled m-0">
                        <li><a href="">Home</a></li>
                        <!-- <li><a href="">About</a></li> -->
                        <li><a href="mailto:guy@connectionsys.co.uk">Contact Us</a></li>
                    </ul>
                </div>
                <div class="header-button">
                    <button class="btn butn-primary">Get Started</button>
                </div>
            </div>
        </div>
    </div>
</header>

<div class="forgot_pwd_form">
    <div class="form_wrapper">
        <?php
            if(isset($_GET["status"])) {
                ?>
                    <div class="alert alert-<?php echo $_GET["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                        <?php echo $_GET["message"]; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php
            }
        ?>

        <div class="mb-30">
            <h3 class="mb-15">Forgot password</h3>
            <p class="mb-5">Enter the email address associated with your account and we'll send you a link to reset your password.</p>
        </div>
        <form action="app/core/recovery.php" method="POST">
            <label for="">Enter your email</label>
            <input class="form-control" name="user_email" type="email" placeholder="" required="">
            <input type="hidden" name="action" value="FORGOT_PASSWORD">
            <div class="form_btn mt-15">
                <button name="__user_password_reset" type="submit" class="btn butn-primary"> Continue </button>
                <a href="<?php echo BASE_URL; ?>">&lt; Back to home</a>
            </div>
        </form>
    </div>
</div>

<footer>
    <div class="footer-top d-flex align-items-center">
        <div class="container">
            <div class="footer-content d-flex align-items-center justify-content-between">
                <div class="footer-pages">
                    <ul class="list-unstyled m-0">
                        <li><a href="<?php echo BASE_URL; ?>terms.php">Terms of USE</a></li>
                    </ul>
                </div>
                <div class="social-links">
                    <ul class="list-unstyled m-0">
                        <li>
                            <a href="">
                                <!-- <img src="public/images/linkedin.svg" alt=""> -->
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom d-flex align-items-center">
        <div class="container">
            <div class="bottom-content">
                <div class="row">
                    <div class="col-sm-12 col-md-6">
                        <div class="footer-logo">
                            <a href="<?php echo BASE_URL; ?>">
                                <img src="public/images/logo-light.svg" alt="">
                            </a>
                        </div>
                        
                    </div>
                    <div class="col-sm-12 col-md-6">
                        <div class="footer-copyright">
                            <a href="javascript:void(0);">© 2023. All rights reserved.</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php
    include './templates/footer.php';
?>