<?php
    session_start();

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use PHPMailer\PHPMailer\SMTP;

    include './load.php';
    include './templates/header.php';
    include './app/models/Messages.php';
    include './app/models/Notifications.php';
    include './app/models/Projects.php';
    include './app/models/Products.php';
    include './app/models/Settings.php';

    if(!isBuyer()) {
        header("Location: index.php");
        exit();
    }

    $uid = $_SESSION["user_id"];

    $msgModel = new Messages();
    $notifModel = new Notifications();
    $projectsModel = new Projects();
    $productModel = new Products();
    $settings = new Settings();
    // echo json_encode($messages);

    if(isset($_GET["show"])) {
        $_SESSION["show"] = $_GET["show"];

        if($_GET["show"] === "add") {
            $_SESSION["add-new-project"] = 'show';
        }
    }

    $last_project_created = $projectsModel->lastProjectCreated($uid);

    if($last_project_created) {
        // $added_on = $projectData["added_on"];
    
        // Get the current timestamp
        $currentTimestamp = time();
    
        // Calculate the difference in seconds
        $timeDifference = $currentTimestamp - strtotime($last_project_created);
    
        if ($timeDifference >= 7 * 24 * 3600) {
            $_SESSION["add-new-project"] = 'show';
        }
    }


    if(isset($_GET["notif_type"])) {
        $_SESSION["notif_type"] = $_GET["notif_type"];
    }else {
        $_SESSION["notif_type"] = 'all';
    }

    if(isset($_GET["add-to-chat"])) {
        $seller_id = $_GET["add-to-chat"];
        $addToChat = $msgModel->addToChat($uid, $seller_id);

        if($addToChat) {
            $_SESSION["chat_id"] = $seller_id;

            $msgModel->readAll($uid);
        }
    }

    if(isset($_GET["chat_id"])) {
        $_SESSION["chat_id"] = $_GET["chat_id"];

        $msgModel->readAll($uid);
    }

    if(!(isset($_GET["add-to-chat"]) || isset($_GET["chat_id"]))) {
        unset($_SESSION["chat_id"]);
    }

    if(isset($_GET["update_notif_status"]) && !empty($_GET["update_notif_status"])) {
        $project_id = $_GET["project_id"];
        $seller_id = $_GET["seller_id"];
        $offer_id = $_GET["offer_id"];
        $item_id = $_GET["item_id"];
        $status = $_GET["status_type"];
        $res = $projectsModel->updateStatus($project_id, $offer_id, $item_id, $seller_id, $status);

        // echo json_encode($res);
    }

    $messages = null;
    if(isset($_SESSION["chat_id"])) {
        $user1 = $_SESSION["user_id"];
        $user2 = $_SESSION["chat_id"];

        $chatUser = $msgModel->chatUserDetails($user2);
        $messages = $msgModel->getMessages($user1, $user2);
    }

    if(isset($_GET["action"]) && $_GET["action"] === "publish-project") {
        $pid = $_GET["pid"];

        $getProject = $projectsModel->getProject($pid);

        if($getProject && $getProject["status"] === '0') {
            $projectsModel->publishProduct($pid);

            // Select all project items
            $projectItems = $projectsModel->getProjectItems($pid);

            $sellerName = 'one of the register buyer who is';
            if($settings->get_option("hide-seller-name") === "1") {
                $sellerName = $_SESSION["userData"]["company_name"];
            }
    
            foreach($projectItems as $item) {
                $product_type = $item["product_type"];
                $sellers = $projectsModel->searchByKeywords($product_type);
                // echo json_encode($sellers);
                // exit;
    
                if($sellers) {
                    foreach($sellers as $seller) {
                        $seller_id = $seller["user_id"];
                        $products_list = $seller["products_list"];

                        $subject = "Looking for a new price offer";
                        $message = '<!DOCTYPE html>
                            <html>
                                <head>
                                    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
                                </head>
                                <body><div style="background-color: #f6f6f6;">
                                    <div style="width: 600px; margin: auto; background-color: #fff;">
                                        <div class="template-header" style="margin: 0 80px; background-color: #60CB97; height: 80px; display: flex; align-items: center; justify-content: center;">
                                            <h1 style="color: #fff; text-transform: uppercase; font-weight: bold; margin: auto; font-size: 32px; text-align: center;">CONNECTION <span style="color: #696969;">SYSTEM</span></h1>
                                        </div>
                                        <div class="template-body" style="">
                                            <div style="padding: 0 80px">
                                                <h1 style="text-align: center; color: #383838; line-height: 36px; margin-bottom: 0; font-family: serif; font-size: 28px; unicode-bidi: plaintext;">DO YOUR BEST IN ORDER TO BE FIRST PLACE!</h1>
                                                <div class="image" style="margin: auto; padding: 30px 0;">
                                                    <img style="width: 100%;" src="https://www.connectionsys.co.uk/public/images/image-1.png" alt="">
                                                </div>
                                            </div>
                                            <div class="box" style="position: relative; padding: 20px 80px; padding-top: 0; background-color: #60CB97;">
                                                <span style="display: block; width: 60%; margin: auto; height: 15px; background-color: #696969;"></span>
                                                <h1 style="text-align: center; text-transform: uppercase; color: #2B454E; font-family: serif; font-size: 38px; margin-top: 15px; margin-bottom: 5px;">NEW OPPORTUNITY</h1>
                                                <h3 style="text-align: center; color: #fff; font-weight: 400; font-size: 21px; line-height: 28px; margin-top: 0; unicode-bidi: plaintext;">you receive a new opportunity from '. $sellerName .' looking to buy:</h3>
                                                <div class="project-history" style="background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px;">
                                                    <h3 style="margin-top: 8px; margin-bottom: 5px; text-align: center;">'.$getProject["project_name"].'</h3>
                                                    <p style="margin-top: 0; margin-bottom: 8px; text-align: center; font-size: 13px; color: #696969;"><b>Post Code:</b> '.$getProject["post_code"].'</p>
                                                    <div class="products-wrapper" style="background-color: #fff; margin: 5px; border-radius: 15px; text-align: left;">';

                        $products_list_array = explode(',', $products_list);

                        // Filter $projectItems based on product types in $products_list_array
                        $matchingProducts = array_filter($projectItems, function ($product) use ($products_list_array) {
                            return in_array($product['product_type'], $products_list_array);
                        });
                        
                        // Reset array keys
                        $matchingProducts = array_values($matchingProducts);

                        foreach($matchingProducts as $matchingProduct) {
                            $itemWidth = '100%';
                            if(count($matchingProducts) > 1) {
                                $itemWidth = '50%';
                            }
            
                            $quantity = '';
                            if($matchingProduct["quantity"]) {
                                $quantity = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Quantity:</b> '.$matchingProduct["quantity"].'</p>';
                            }
            
                            $unit = '';
                            if($matchingProduct["unit"]) {
                                $unit = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Unit:</b> '.$matchingProduct["unit"].'</p>';
                            }
            
                            $date_required = '';
                            if($matchingProduct["date_required"]) {
                                $date_required = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Date Required:</b> '.$matchingProduct["date_required"].'</p>';
                            }

                            $open_to_similar_brands = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> '.ucfirst($matchingProduct["open_to_similar_brands"]).'</p>';
            
                            // $product = $productModel->getProductByName($matchingProduct["product_type"]);

                            // if(!empty($matchingProduct["product_image"])) {
                            //     $img_url = BASE_URL . $matchingProduct["product_image"];
                            // }else {
                            //     if(!empty($product["image"])) {
                            //         $img_url = BASE_URL . $product["image"];
                            //     }else {
                            //         $img_url = 'https://rakanonline.com/wp-content/uploads/2022/08/default-product-image.png';
                            //     }
                            // }

                            // <div class="">
                            //     <img style="width: 50px; margin-bottom: 5px;" src="'.$img_url.'" alt="'.ucfirst($matchingProduct["product_type"]).'" />
                            // </div>

                            $attached_file = '';
                            if(!empty($matchingProduct["product_image"])) {
                                $attached_file = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 14px;text-align: left;"><a href="'. BASE_URL . $matchingProduct["product_image"].'">See the attached file to view how the buyer expects the materials to look.</a></p>';
                            }
                            
                            $message .= '<div class="product-item" style="box-sizing: border-box; width: '.$itemWidth.'; display: inline-block; padding: 7.5px;">
                                <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                                    
                                    <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">'.ucfirst($matchingProduct["product_type"]).'</h3>
                                    <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Description:</b> '.$matchingProduct["description"].'</p>
                                    '.$open_to_similar_brands.'
                                    '.$quantity.'
                                    '.$unit.'
                                    '.$date_required.'
                                    '.$attached_file.'
                                </div>
                            </div>';
                        }
                
                        $message .= '</div>
                                        </div>
                                            <div class="button" style="text-align: center;">
                                                <a href="https://www.connectionsys.co.uk/">
                                                    <button style="background-color: #696969; border: transparent; height: 36px; padding: 0 18px; border-radius: 5px; font-size: 16px; text-transform: uppercase; color: #fff; font-weight: bold; cursor: pointer;">Price Him</button>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="template-footer" style="margin: 0 auto; text-align: center;padding: 15px 0;">
                                        <span style="display: block; width: 32%; margin: auto; height: 8px; background-color: #60CB97; margin-bottom: 15px;"></span>
                                        <a href="https://www.connectionsys.co.uk/" style="display: block; text-align: center; font-size: 22px; text-decoration: none; color: #60CB97; font-family: Montserrat;">www.connectionsys.co.uk</a>
                                    </div>
                                </div>
                            </div>
                            </body></html>';
                        
                        $isExists = $projectsModel->checkNotification($pid, $seller_id);
                        if(!$isExists) {
                            $email = $seller["email"];
                            $company_name = $seller["company_name"];

                            $project_name = $getProject["project_name"];
                            $description = $item["description"];

                            $desc = json_encode($description);
                            $projectsModel->addToNofications($project_name, $desc, $pid, $seller_id);
        
                            $mail = new PHPMailer();
                            try {
                                //Server settings
                                // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                                $mail->isSMTP();                                            //Send using SMTP
                                $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                                $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                                $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                                $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                                $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
                            
                                //Recipients
                                $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                                $mail->addAddress($email, $company_name);     //Add a recipient
                                // $mail->addAddress('ellen@example.com');               //Name is optional
                                // $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');
                            
                                //Content
                                $mail->isHTML(true);                                  //Set email format to HTML
                                $mail->Subject = $subject;
                                $mail->Body    = $message;
                                // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
                            
                                $mail->send();
                                // echo 'Message has been sent';
                            } catch (Exception $e) {
                                echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                                exit;
                            }
                        }
                    }
                }
            }
        }else {
            // echo "Project published already!";
        }
    }

    if(!isset($_SESSION["vat-type"])) {
        $_SESSION["vat-type"] = 'with-vat';
    }

    if(isset($_GET["vat-type"])) {
        $_SESSION["vat-type"] = $_GET["vat-type"];
    }

    if(!isset($_SESSION["add-new-project"])) {
        $_SESSION["add-new-project"] = 'hide';
    }
?>

<!-- //**\\ -->
<link rel="stylesheet" href="public/css/image-uploader.css">

<?php
    if($settings->get_option('hide-buyer-name') === '0') {
    ?>
<style>
    .hide-company-name {
        display: none !important;
    }
</style>
    <?php
    }
?>

<style>
    .toggle-switch {
    position: relative;
    display: inline-block;
    width: 50px;
    height: 25px;
  }
  
  .switch-input {
    display: none;
  }
  
  .switch-label {
    display: block;
    width: 100%;
    height: 100%;
    border-radius: 17px;
    background-color: #ccc;
    position: relative;
    cursor: pointer;
  }
  
  .switch-label:before {
    content: '';
    position: absolute;
    top: 2px;
    left: 2px;
    width: 20px;
    height: 20px;
    border-radius: 50%;
    background-color: white;
    transition: transform 0.3s ease;
  }
  
  .switch-input:checked + .switch-label:before {
    transform: translateX(26px);
  }
  
  .switch-label:active:before {
    width: 22px;
  }

  .switch-input:checked + .switch-label {
    background: green;
  }
  
</style>

<div class="buyer d-flex">
    <!-- Include Sidebar -->
    <div class="sidebar">
        <div class="sidebar-content">
            <div class="sidebar-logo d-flex align-items-center justify-content-center">
                <img src="public/images/logo-sm.svg" alt="">
            </div>
            <div class="sidebar-nav">
                <div class="nav-items">
                    <div class="item <?php echo $_SESSION["show"] === "home" ? "active" : ""; ?>">
                        <a href="?show=home">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M30.06 10.23L21.42 4.18503C19.065 2.53503 15.45 2.62503 13.185 4.38003L5.66999 10.245C4.16999 11.415 2.98499 13.815 2.98499 15.705V26.055C2.98499 29.88 6.08998 33 9.91498 33H26.085C29.91 33 33.015 29.895 33.015 26.07V15.9C33.015 13.875 31.71 11.385 30.06 10.23ZM19.125 27C19.125 27.615 18.615 28.125 18 28.125C17.385 28.125 16.875 27.615 16.875 27V22.5C16.875 21.885 17.385 21.375 18 21.375C18.615 21.375 19.125 21.885 19.125 22.5V27Z" fill="#60CB97"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "chat" ? "active" : ""; ?>" id="chatBtn">
                        <a href="?show=chat">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M33 9.375V17.025C33 18.93 32.37 20.535 31.245 21.645C30.135 22.77 28.53 23.4 26.625 23.4V26.115C26.625 27.135 25.485 27.75 24.645 27.18L23.19 26.22C23.325 25.755 23.385 25.245 23.385 24.705V18.6C23.385 15.54 21.345 13.5 18.285 13.5H8.09999C7.88999 13.5 7.695 13.515 7.5 13.53V9.375C7.5 5.55 10.05 3 13.875 3H26.625C30.45 3 33 5.55 33 9.375Z" fill="white" stroke="#60CB97" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M23.385 18.6V24.705C23.385 25.245 23.325 25.755 23.19 26.22C22.635 28.425 20.805 29.805 18.285 29.805H14.205L9.675 32.82C9 33.285 8.09999 32.79 8.09999 31.98V29.805C6.56999 29.805 5.295 29.295 4.41 28.41C3.51 27.51 3 26.235 3 24.705V18.6C3 15.75 4.77 13.785 7.5 13.53C7.695 13.515 7.88999 13.5 8.09999 13.5H18.285C21.345 13.5 23.385 15.54 23.385 18.6Z" fill="white" stroke="#60CB97" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "add" ? "active" : ""; ?>" id="addBtn">
                        <a href="?show=add">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M24.285 3H11.715C6.255 3 3 6.255 3 11.715V24.27C3 29.745 6.255 33 11.715 33H24.27C29.73 33 32.985 29.745 32.985 24.285V11.715C33 6.255 29.745 3 24.285 3ZM24 19.125H19.125V24C19.125 24.615 18.615 25.125 18 25.125C17.385 25.125 16.875 24.615 16.875 24V19.125H12C11.385 19.125 10.875 18.615 10.875 18C10.875 17.385 11.385 16.875 12 16.875H16.875V12C16.875 11.385 17.385 10.875 18 10.875C18.615 10.875 19.125 11.385 19.125 12V16.875H24C24.615 16.875 25.125 17.385 25.125 18C25.125 18.615 24.615 19.125 24 19.125Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "products" ? "active" : ""; ?>" id="productsBtn">
                        <a href="?show=products">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M24.285 3H11.715C6.255 3 3 6.255 3 11.715V24.285C3 29.745 6.255 33 11.715 33H24.285C29.745 33 33 29.745 33 24.285V11.715C33 6.255 29.745 3 24.285 3ZM14.955 22.35L11.58 25.725C11.355 25.95 11.07 26.055 10.785 26.055C10.5 26.055 10.2 25.95 9.99 25.725L8.865 24.6C8.415 24.165 8.415 23.445 8.865 23.01C9.3 22.575 10.005 22.575 10.455 23.01L10.785 23.34L13.365 20.76C13.8 20.325 14.505 20.325 14.955 20.76C15.39 21.195 15.39 21.915 14.955 22.35ZM14.955 11.85L11.58 15.225C11.355 15.45 11.07 15.555 10.785 15.555C10.5 15.555 10.2 15.45 9.99 15.225L8.865 14.1C8.415 13.665 8.415 12.945 8.865 12.51C9.3 12.075 10.005 12.075 10.455 12.51L10.785 12.84L13.365 10.26C13.8 9.825 14.505 9.825 14.955 10.26C15.39 10.695 15.39 11.415 14.955 11.85ZM26.34 24.93H18.465C17.85 24.93 17.34 24.42 17.34 23.805C17.34 23.19 17.85 22.68 18.465 22.68H26.34C26.97 22.68 27.465 23.19 27.465 23.805C27.465 24.42 26.97 24.93 26.34 24.93ZM26.34 14.43H18.465C17.85 14.43 17.34 13.92 17.34 13.305C17.34 12.69 17.85 12.18 18.465 12.18H26.34C26.97 12.18 27.465 12.69 27.465 13.305C27.465 13.92 26.97 14.43 26.34 14.43Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "combinations" ? "active" : ""; ?>" id="combinationsBtn">
                        <a href="?show=combinations">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M17.91 3.31499L14.295 11.73H10.68C10.08 11.73 9.49505 11.775 8.92505 11.895L10.425 8.29499L10.485 8.15999L10.575 7.91999C10.62 7.81499 10.65 7.72499 10.695 7.64999C12.435 3.61499 14.385 2.35499 17.91 3.31499Z" fill="white"/>
                                <path d="M28.0951 12.135L28.0651 12.12C27.1651 11.865 26.2501 11.73 25.3201 11.73H15.9301L19.3051 3.88503L19.3501 3.78003C19.5601 3.85503 19.7851 3.96003 20.0101 4.03503L23.3251 5.43003C25.1701 6.19503 26.4601 6.99003 27.2551 7.95003C27.3901 8.13003 27.5101 8.29503 27.6301 8.49003C27.7651 8.70003 27.8701 8.91003 27.9301 9.13503C27.9901 9.27003 28.0351 9.39003 28.0651 9.52503C28.2901 10.29 28.3051 11.16 28.0951 12.135Z" fill="white"/>
                                <path d="M27.435 14.28C26.76 14.085 26.055 13.98 25.32 13.98H10.68C9.65999 13.98 8.69999 14.175 7.79998 14.565C5.18999 15.69 3.35999 18.285 3.35999 21.3V24.225C3.35999 24.585 3.38999 24.93 3.43499 25.29C3.76499 30.06 6.31498 32.61 11.085 32.925C11.43 32.97 11.775 33 12.15 33H23.85C29.4 33 32.325 30.36 32.61 25.11C32.625 24.825 32.64 24.525 32.64 24.225V21.3C32.64 17.985 30.435 15.195 27.435 14.28ZM21.75 25.125H14.25C13.635 25.125 13.125 24.615 13.125 24C13.125 23.385 13.635 22.875 14.25 22.875H21.75C22.365 22.875 22.875 23.385 22.875 24C22.875 24.615 22.365 25.125 21.75 25.125Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div class="logout-btn">
                <a class="button" href="logout.php">
                    <img src="public/images/fi-sr-sign-out-alt.svg" alt="">
                </a>
            </div>
        </div>
    </div>

    <div class="main">
        <div class="header">
            <div class="header-wrap">
                <div class="menu-bar">
                    <img src="public/images/fi-sr-bar.svg" alt="">
                </div>
                <div class="header-left d-flex gap-4 align-items-center">
                    <div class="header-title">
                        <h3 class="m-0">Buyer Page</h3>
                    </div>
                    <div class="header-logo">
                        <img src="public/images/logo-main.svg" alt="">
                    </div>
                    <div class="d-flex flex-column align-items-center justify-between">
                        <small class="text-muted"><?php echo $_SESSION["vat-type"] === 'with-vat' ? 'With VAT' : 'Without VAT' ?></small>
                        <div class="toggle-switch inline">
                            <input type="checkbox" id="local-pickup" class="switch-input vat-type-switch" <?php echo $_SESSION["vat-type"] === 'with-vat' ? 'checked' : '' ?> />
                            <label for="local-pickup" class="switch-label"></label>
                        </div>
                    </div>
                </div>
                <div class="header-right">
                    <div class="search">
                        <div class="icon">
                            <img src="public/images/bi_search-heart-fill.svg" alt="">
                        </div>
                        <input class="form-control" type="search" name="" id="" placeholder="Search your query">
                    </div>
                    <div class="notification">
                        <div class="dropdown-icon">
                            <div class="notif-alert" style="display: none;"></div>
                            <img src="public/images/notification-dark.svg" alt="">
                        </div>
                        <div class="notification-menu <?php echo isset($_GET["notif_type"]) ? 'active' : ''; ?>">
                            <div class="load-notifications" style="display: none;">
                                <a href="javascript:void(0);">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="reload">
                                        <path d="M21,11a1,1,0,0,0-1,1,8.05,8.05,0,1,1-2.22-5.5h-2.4a1,1,0,0,0,0,2h4.53a1,1,0,0,0,1-1V3a1,1,0,0,0-2,0V4.77A10,10,0,1,0,22,12,1,1,0,0,0,21,11Z"></path>
                                    </svg>
                                    <span>view new projects</span>
                                </a>
                            </div>
                            <div class="notif-header">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="notif-back-btn">
                                        <a href="javascript:void(0);">Back</a>
                                    </div>
                                    <div class="title">
                                        <h5  class="m-0">Notifications</h5>
                                    </div>
                                    <div class=""></div>
                                </div>
                            </div>
                            <div class="notifs">
                                <div class="d-flex align-items-center justify-content-end mr-10 mt-5 mb-5">
                                    <?php 
                                        if(isset($_SESSION["notif_type"]) && $_SESSION["notif_type"] === 'marked') {
                                            ?>
                                                <a href="?notif_type=all">
                                                    <img width="30" src="public/images/star.svg" alt="">
                                                </a>
                                            <?php
                                        }else {
                                            ?>
                                                <a href="?notif_type=marked">
                                                    <img width="30" src="public/images/star-light.svg" alt="">
                                                </a>
                                            <?php
                                        }
                                    ?>
                                </div>
                                <div class="lists-container">
                                    <?php
                                        $notifications = $notifModel->getBuyerNotifications($uid);

                                        if( $notifications) {
                                            foreach($notifications["data"] as $notification) {
                                                // echo json_encode($notification);
                                                ?>
                                                    <div class="list" data-id="<?php echo $notification["offer_id"]; ?>">
                                                        <div class="info d-flex align-items-center justify-content-between">

                                                            <div class="p-meta">
                                                                <div class="d-flex gap-4">
                                                                    <div class="notif-icon" style="width: 60px;">
                                                                        <img src="public/images/notification.svg" alt="">
                                                                    </div>
                                                                    <div class="" style="width: 100%;">
                                                                        <div class="title mb-10">
                                                                            <div class="">
                                                                                <h6><?php echo $notification["project_name"]; ?></h6>
                                                                                <span class="d-block mt-1 text-muted hide-company-name"><b><?php echo $notification["company_name"]; ?></b></span>
                                                                                <span class="text-muted"><b>Postcode:</b> <?php echo $notification["post_code"]; ?></span>
                                                                            </div>
                                                                            <div class="start">
                                                                                <!-- <img class="star-image" width="20" src="public/images/star-light.svg" alt=""> -->
                                                                                <a class="mark-notifications" href="javascript:void(0);" data-id="<?php echo $notification["offer_id"]; ?>">
                                                                                    <?php
                                                                                        if($notification["is_marked"] === '0') {
                                                                                            ?>
                                                                                                <img class="star-image" width="20" src="public/images/star-light.svg" alt="">
                                                                                            <?php
                                                                                        }else {
                                                                                            ?>
                                                                                                <img class="star-image" width="20" src="public/images/star.svg" alt="">
                                                                                            <?php
                                                                                        }
                                                                                    ?>
                                                                                </a>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="desc">
                                                                    <?php
                                                                        $project_id = $notification["project_id"];
                                                                        $productItems = $projectsModel->getProjectItems($project_id);

                                                                        $offer_data = $notification["offer_data"];
                                                                        $dataArray = json_decode($offer_data, true);

                                                                        $x = 0;
                                                                        foreach ($dataArray as $item) {
                                                                            // echo json_encode($item);
                                                                            $x++;
                                                                            ?>
                                                                                <div class="amount">
                                                                                    <b class="d-flex gap-1 text-muted mr-10"><span><?php echo $x; ?>.</span><?php echo ucfirst($item['product']) ?>:</b>
                                                                                    <div style="margin-left: 20px;">
                                                                                        <table class="">
                                                                                            <tr>
                                                                                                <td>Product Price:</td>
                                                                                                <td>
                                                                                                    <b class="text-muted">£<?php echo number_format($item['price'], 2) ?> </b> <span class="text-muted"><?php echo $item["vat"] === '1' ? '(With VAT)' : '(Without VAT)' ?></span>
                                                                                                </td>
                                                                                            </tr>
                                                                                            <?php
                                                                                                if(isset($item["delivery_price"]) && $item["delivery_price"] !== null) {
                                                                                                    ?>
                                                                                                        <tr>
                                                                                                            <td>Delivery Price:</td>
                                                                                                            <td>
                                                                                                                <b class="text-muted">£<?php echo number_format($item['delivery_price'], 2) ?> </b>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                    <?php
                                                                                                }
                                                                                            ?>
                                                                                            <?php
                                                                                                if(isset($item["delivery_date"]) && $item["delivery_date"] !== null) {
                                                                                                    ?>
                                                                                                        <tr>
                                                                                                            <td>Delivery Date:</td>
                                                                                                            <td>
                                                                                                                <b class="text-muted">£<?php echo $item['delivery_date']; ?> </b>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                    <?php
                                                                                                }
                                                                                            ?>
                                                                                            <?php
                                                                                                if(isset($item["payment_term"]) && $item["payment_term"] !== null) {
                                                                                                    ?>
                                                                                                        <tr>
                                                                                                            <td>Payment Term:</td>
                                                                                                            <td>
                                                                                                                <b class="text-muted">£<?php echo $item['payment_term']; ?> </b>
                                                                                                            </td>
                                                                                                        </tr>
                                                                                                    <?php
                                                                                                }
                                                                                            ?>
                                                                                        </table>
                                                                                    </div>
                                                                                </div>
                                                                            <?php
                                                                        }
                                                                    ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="msg-area d-flex align-items-center justify-content-between">
                                                            <div class="w-100 d-flex align-items-center justify-content-between">
                                                                <?php
                                                                    if(!empty($notification["attached_file"])) {
                                                                        ?>
                                                                            <div class="add-attachment">
                                                                                <a target="_blank" href="<?php echo $notification["attached_file"]; ?>">Attachment</a>
                                                                            </div>
                                                                        <?php
                                                                    }
                                                                ?>
                                                                <div class="msg" style="<?php echo empty($notification["attached_file"]) ? 'display: flex; width: 100%; justify-content: end;' : '' ?>">
                                                                    <a href="?add-to-chat=<?php echo $notification["seller_id"]; ?>">
                                                                        <img src="public/images/messages.svg" alt="">
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php
                                            }
                                        }else {
                                            ?>
                                                <div class="text-center mt-50">
                                                    <p class="no-results text-muted">Nothing to see here!</p>
                                                </div>
                                            <?php
                                        }
                                    ?>
                                </div>
                                <div class="">
                                    <?php

                                        if($notifications && $notifications["total"] >= 20) {
                                            ?>
                                                <div class="load-more-notifications">
                                                    <a href="javascript:void(0);">
                                                        <span>Load More</span>
                                                    </a>
                                                </div>
                                            <?php
                                        };
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="profile">
                        <div class="profile-item">
                            <div class="left">
                                <div class="user-name">
                                    <h6><?php echo $_SESSION["userData"]["company_name"]; ?></h6>
                                </div>
                                <div class="profile-nav">
                                    <!-- <p class="m-0"></p> -->
                                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" role="button" data-bs-toggle="dropdown" aria-expanded="false">My Account</a>
                                </div>
                            </div>
                            <div class="right">
                                <div class="profile-image">
                                    <img src="public/images/<?php echo $_SESSION["userData"]["company_logo"]; ?>" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <ul class="dropdown-menu header-dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                <li>
                                    <a class="dropdown-item" href="change-password.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" data-name="Layer 1" viewBox="0 0 24 24" id="edit">
                                            <path d="M3.5,24h15A3.51,3.51,0,0,0,22,20.487V12.95a1,1,0,0,0-2,0v7.537A1.508,1.508,0,0,1,18.5,22H3.5A1.508,1.508,0,0,1,2,20.487V5.513A1.508,1.508,0,0,1,3.5,4H11a1,1,0,0,0,0-2H3.5A3.51,3.51,0,0,0,0,5.513V20.487A3.51,3.51,0,0,0,3.5,24Z"></path><path d="M9.455,10.544l-.789,3.614a1,1,0,0,0,.271.921,1.038,1.038,0,0,0,.92.269l3.606-.791a1,1,0,0,0,.494-.271l9.114-9.114a3,3,0,0,0,0-4.243,3.07,3.07,0,0,0-4.242,0l-9.1,9.123A1,1,0,0,0,9.455,10.544Zm10.788-8.2a1.022,1.022,0,0,1,1.414,0,1.009,1.009,0,0,1,0,1.413l-.707.707L19.536,3.05Zm-8.9,8.914,6.774-6.791,1.4,1.407-6.777,6.793-1.795.394Z"></path>
                                        </svg>
                                        <span class="ml-5 text-muted" style="font-weight: 500;">Edit</span>
                                    </a>
                                </li>
                                <hr>
                                <li>
                                    <a class="dropdown-item" href="logout.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 6.35 6.35" id="logout" opacity="0.8">
                                            <path fill-rule="evenodd" d="M7.953.998a3.024 3.024 0 0 0-3.006 3.004V20a3.024 3.024 0 0 0 3.006 3.004h3.994A3.022 3.022 0 0 0 14.951 20v-4.002c0-1.334-2-1.334-2 0V20a.983.983 0 0 1-1.004 1.004H7.953A.983.983 0 0 1 6.95 20V4.002a.983.983 0 0 1 1.004-1.004h3.994a.983.983 0 0 1 1.004 1.004v4.002c0 1.334 2 1.334 2 0V4.002A3.022 3.022 0 0 0 11.947.998H7.953zM1.957 4.984a1 1 0 0 0-1.01 1.02v11.994a1 1 0 0 0 2 0V6.004a1 1 0 0 0-.982-1.02 1 1 0 0 0-.008 0zm16.037 2.004a1 1 0 0 0-.096.004 1 1 0 0 0-.6 1.713L19.595 11h-9.588a1.006 1.006 0 0 0-.104 0c-1.333.07-1.23 2.071.104 2.002h9.582l-2.29 2.287a1 1 0 1 0 1.411 1.418l4.002-4.002a1 1 0 0 0 0-1.41l-4.002-4a1 1 0 0 0-.715-.307z" color="#000" font-family="sans-serif" font-weight="400" overflow="visible" paint-order="stroke fill markers" transform="scale(.26458)" style="line-height:normal;font-variant-ligatures:normal;font-variant-position:normal;font-variant-caps:normal;font-variant-numeric:normal;font-variant-alternates:normal;font-feature-settings:normal;text-indent:0;text-align:start;text-decoration-line:none;text-decoration-style:solid;text-decoration-color:#000;text-transform:none;text-orientation:mixed;shape-padding:0;isolation:auto;mix-blend-mode:normal"></path>
                                        </svg>
                                        <span class="ml-5 text-muted" style="font-weight: 500;">Logout</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="main-content <?php echo $_SESSION["show"] === "home" ? "show_all" : "show_single";  ?>">
            <div id="chat-section" style="<?php echo $_SESSION["add-new-project"] === 'hide' && !(isset($_GET["status"]) && $_GET["status"] === "published-project") ? 'width: 50.50%' : ''; ?>" class="chat-comp box-content <?php echo isset($_SESSION["show"]) && ($_SESSION["show"] === "home" || $_SESSION["show"] === "chat") ? "show" : ""; ?>">
                <div class="">
                    <div class="sec__heading">
                        <h5>Chat</h5>
                    </div>
                    <div class="inner-content">
                        <div class="app-content">
                            <div class="people-list">
                                <ul class="list list-unstyled p-0 m-0">
                                    <?php
                                        $peopleList = $msgModel->getPeopleList($uid);
                                        if($peopleList) {
                                            foreach ($peopleList as $people) {
                                                $style = '';
                                                if(isset($_SESSION["chat_id"]) && $_SESSION["chat_id"] == $people["user_id"]) {
                                                    $style = 'active';
                                                }
                                                ?>
                                                    <li class="<?php echo $style; ?> clearfix" data-id="<?php echo $people["user_id"]; ?>">
                                                        <a href="<?php echo BASE_URL . 'buyer.php?chat_id='. $people["user_id"]; ?>">
                                                            <div class="profile">
                                                                <img src="public/images/<?php echo $people["company_logo"]; ?>" alt="avatar">
                                                                <div class="about">
                                                                    <div class="name hide-company-name"><?php echo $people["company_name"]; ?></div>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </li>
                                                <?php
                                            }
                                        }
                                    ?>
                                </ul>
                            </div>
                            <div class="chat">
                                <?php
                                    if(isset($_SESSION["chat_id"])) {
                                        ?>
                                            <div class="chat-header">
                                                <img src="public/images/<?php echo $chatUser["company_logo"]; ?>" alt="">
                                                <h6 class="hide-company-name"><?php echo $chatUser["company_name"]; ?></h6>
                                            </div>
                                        <?php
                                    }
                                ?>

                                <div class="chat-history">
                                    <ul class="list-unstyled m-0">
                                        <li class="clearfix">
                                            <?php
                                                if($messages && count($messages) >= 20) {
                                                    ?>
                                                         <div class="load-more-msg text-center">
                                                            <a href="javascript:void(0);">Load More</a>
                                                        </div>
                                                    <?php
                                                }
                                            ?>
                                            <div class="chats">
                                                <?php
                                                    if($messages) {
                                                        foreach($messages as $message) {
                                                            if(!empty($message["chat_at"])) {
                                                                ?>
                                                                    <div class="date-divider">
                                                                        <span class="text-muted"><?php echo displayDateOrDay($message["chat_at"]); ?></span>
                                                                    </div>
                                                                <?php
                                                            }

                                                            if($message["user_id"] == $_SESSION["user_id"]) {
                                                                $width = 'width: 100%;';
                                                            }else {
                                                                $width = 'width: calc(100% - 60px);';
                                                            }
                                                            ?>
                                                                <div data-id="<?php echo $message["message_id"]; ?>" class="chat-msg <?php if($message["user_id"] == $_SESSION["user_id"]) {echo "owner";} ?>">
                                                                    <div class="chat-msg-content">
                                                                        <div class="chat-msg-date text-muted"><?php echo date("h:i A", strtotime($message["chat_timestamp"])); ?></div>
                                                                        <div class="msg-body">
                                                                            <div class="chat-msg-profile">
                                                                                <img class="chat-msg-img" src="public/images/<?php echo $message["company_logo"]; ?>" alt="">
                                                                            </div>
                                                                            <div class="" style="<?php echo $width; ?>">
                                                                                <?php
                                                                                    if(!empty($message["attached_file"]) && $message["file_name"]) {
                                                                                        $allowedExtensions = array("jpg", "jpeg", "png", "gif");

                                                                                        $uploadedFileName = $message["attached_file"]; // Replace with the actual uploaded file name
                                                                                        $fileExtension = strtolower(pathinfo($uploadedFileName, PATHINFO_EXTENSION));

                                                                                        if (in_array($fileExtension, $allowedExtensions)) {
                                                                                            ?>
                                                                                                <div class="chat-msg-image">
                                                                                                    <a target="_blank" href="<?php echo $message["attached_file"]; ?>">
                                                                                                        <img src="<?php echo $message["attached_file"]; ?>" alt="<?php echo $message["file_name"]; ?>">
                                                                                                    </a>
                                                                                                </div>
                                                                                            <?php
                                                                                        } else {
                                                                                            ?>
                                                                                                <div class="chat-msg-file">
                                                                                                    <div class="file-icon">
                                                                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256" id="file-arrow-down">
                                                                                                            <rect width="25" height="25 " fill="none"></rect><polygon points="152 32 152 88 208.008 88 152 32" opacity=".2"></polygon><path fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" d="M200,224.00005H55.99219a8,8,0,0,1-8-8V40a8,8,0,0,1,8-8L152,32l56,56v128A8,8,0,0,1,200,224.00005Z"></path><polyline fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" points="152 32 152 88 208.008 88"></polyline><polyline fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" points="100 156 128 184 156 156"></polyline><line x1="128" x2="128" y1="120" y2="184" fill="none" stroke="#000" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></line>
                                                                                                        </svg>
                                                                                                    </div>
                                                                                                    <div class="file-url">
                                                                                                        <a target="_blank" href="<?php echo $message["attached_file"]; ?>"><?php echo $message["file_name"]; ?></a>
                                                                                                    </div>
                                                                                                </div>
                                                                                            <?php
                                                                                        }
                                                                                    }

                                                                                    if(!empty($message["message_text"])) {
                                                                                        ?>
                                                                                            <div class="chat-msg-text"><?php echo $message["message_text"];?></div>
                                                                                        <?php
                                                                                    }
                                                                                ?>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <?php
                                                        }
                                                    }

                                                    if(!isset($_SESSION["chat_id"])) {
                                                        ?>
                                                            <div class="msg text-muted mt-50" style="height: 100%; display: flex; align-items: center; justify-content: center; text-align: center;">
                                                                <h6>Select a chat or start a new conversation</h6>
                                                            </div>
                                                        <?php
                                                    }
                                                ?>
                                            </div>
                                        </li>
                                    </ul>
                                </div>

                                <div class="chat-message">
                                    <?php
                                        if(isset($_SESSION["chat_id"])) {
                                            ?>
                                                <div class="">
                                                    <p class="attached-file-name" style="margin-top: -3px;"></p>
                                                    <div class="warning-msg" style="display: none;">
                                                        <small><p style="color: #df3079;">Terms of Service reminder: Sharing contact information is only allowed when essential for the service.</p></small>
                                                    </div>
                                                    <div class="box-wrapper">
                                                        <div class="input-wraper" style="position: relative;">
                                                            <div class="upload-file">
                                                                <label class="upload-area">
                                                                    <input id="attached-file" type="file">
                                                                    <span class="file-upload-button">
                                                                        <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                            <g id="fi-sr-clip" opacity="0.4" clip-path="url(#clip0_93_163)">
                                                                                <path id="Vector" d="M26.775 11.2001C26.5562 10.9813 26.2596 10.8585 25.9502 10.8585C25.6408 10.8585 25.3441 10.9813 25.1254 11.2001L12.418 23.9622C11.8764 24.504 11.2333 24.9337 10.5255 25.2269C9.81778 25.5202 9.0592 25.6711 8.29311 25.6712C6.74591 25.6713 5.26205 25.0568 4.16794 23.9628C3.07384 22.8689 2.45911 21.3851 2.459 19.8379C2.45889 18.2907 3.07341 16.8068 4.16736 15.7127L16.4745 3.35539C17.1326 2.70776 18.02 2.34642 18.9433 2.35007C19.8666 2.35372 20.7511 2.72207 21.404 3.37488C22.057 4.02769 22.4256 4.91207 22.4294 5.83538C22.4333 6.75869 22.0722 7.64613 21.4247 8.30439L9.11753 20.6617C8.89557 20.8744 8.60007 20.9931 8.29269 20.9931C7.98532 20.9931 7.68982 20.8744 7.46786 20.6617C7.24914 20.4429 7.12628 20.1462 7.12628 19.8369C7.12628 19.5275 7.24914 19.2308 7.46786 19.0121L18.4252 8.00455C18.6377 7.78452 18.7553 7.48982 18.7526 7.18392C18.75 6.87802 18.6273 6.58541 18.411 6.3691C18.1947 6.15279 17.9021 6.03009 17.5962 6.02743C17.2903 6.02478 16.9956 6.14237 16.7755 6.35489L5.81819 17.3624C5.49313 17.6874 5.23526 18.0733 5.05934 18.4979C4.88341 18.9226 4.79286 19.3778 4.79286 19.8375C4.79286 20.2971 4.88341 20.7523 5.05934 21.177C5.23526 21.6017 5.49313 21.9875 5.81819 22.3126C6.48508 22.9489 7.37147 23.304 8.29328 23.304C9.21508 23.304 10.1015 22.9489 10.7684 22.3126L23.0744 9.95405C24.1454 8.85541 24.7404 7.37905 24.7306 5.84479C24.7207 4.31053 24.1068 2.84191 23.0218 1.75708C21.9369 0.672249 20.4682 0.0585561 18.9339 0.0489428C17.3996 0.0393295 15.9234 0.63457 14.8249 1.70572L2.51769 14.0631C0.986068 15.5947 0.12561 17.672 0.12561 19.8381C0.12561 22.0041 0.986068 24.0814 2.51769 25.6131C4.04932 27.1447 6.12665 28.0051 8.29269 28.0051C10.4587 28.0051 12.5361 27.1447 14.0677 25.6131L26.775 12.8544C26.884 12.746 26.9705 12.6171 27.0295 12.4751C27.0886 12.3332 27.1189 12.181 27.1189 12.0272C27.1189 11.8735 27.0886 11.7213 27.0295 11.5793C26.9705 11.4374 26.884 11.3085 26.775 11.2001Z" fill="black" fill-opacity="0.4"/>
                                                                            </g>
                                                                            <defs>
                                                                                <clipPath id="clip0_93_163">
                                                                                    <rect width="28" height="28" fill="white"/>
                                                                                </clipPath>
                                                                            </defs>
                                                                        </svg>
                                                                    </span>
                                                                </label>
                                                            </div>
                                                            <input id="receiver_id" type="hidden" name="" value="<?php echo $_SESSION["chat_id"]; ?>">
                                                            <textarea id="msg-input" class="form-control" id="" cols="30" rows="2"></textarea>
                                                        </div>
                                                        <div id="send-msg">
                                                            <a href="javascript:void(0);"><img src="public/images/fi-sr-paper-plane.svg" alt=""> Send Message</a>
                                                        </div>
                                                        <div id="sending-msg" style="display: none">
                                                            <a href="javascript:void(0);">
                                                                <svg width="30" version="1.1" id="L4" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 0 0" xml:space="preserve">
                                                                    <circle fill="#fff" stroke="none" cx="6" cy="50" r="6">
                                                                        <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.1"></animate>
                                                                    </circle>
                                                                    <circle fill="#fff" stroke="none" cx="26" cy="50" r="6">
                                                                        <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.2"></animate>
                                                                    </circle>
                                                                    <circle fill="#fff" stroke="none" cx="46" cy="50" r="6">
                                                                        <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.3"></animate>
                                                                    </circle>
                                                                </svg>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php
                if($_SESSION["add-new-project"] === 'show' || isset($_GET["status"]) && $_GET["status"] === "published-project") {
                    ?>
                        <div id="add-section" class="add-product box-content <?php echo isset($_SESSION["show"]) && ($_SESSION["show"] === "home" || $_SESSION["show"] === "add") ? "show" : ""; ?>">
                            <?php
                                if(!(isset($_GET["status"]) && $_GET["status"] === "published-project")) {
                                    ?>
                                        <div class="form-box">
                                            <div class="sec__heading">
                                                <h5>Add New Project</h5>
                                            </div>
                                            <?php
                                                if(isset($_GET["action"]) && $_GET["action"] === "add-project") {
                                                    ?>
                                                        <div class="alert alert-<?php echo $_GET["status"]; ?> alert-dismissible fade show mt-25 ml-15 mr-15" role="alert">
                                                            <?php echo $_GET["message"]; ?>
                                                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                                        </div>
                                                    <?php
                                                }
                                            ?>
                                            <div class="inner-content">
                                                <nav>
                                                    <div class="nav nav-tabs mb-3" id="nav-tab" role="tablist">
                                                        <button style="width: 50%;" class="nav-link active" id="nav-home-tab" data-bs-toggle="tab" data-bs-target="#nav-home" type="button" role="tab" aria-controls="nav-home" aria-selected="true">Manually</button>
                                                        <?php
                                                            if(!isset($_GET['insert_id'])) {
                                                                ?>
                                                                    <button style="width: 50%;" class="nav-link" id="nav-profile-tab" data-bs-toggle="tab" data-bs-target="#nav-profile" type="button" role="tab" aria-controls="nav-profile" aria-selected="false">Excel Import</button>
                                                                <?php
                                                            }
                                                        ?>
                                                    </div>
                                                </nav>
                        
                                                <form action="app/core/projects.php" method="post" enctype="multipart/form-data">
                                                    <input type="hidden" name="action" value="ADD_PROJECT">
                                                    <?php
                                                        if(isset($_GET['insert_id']) && !empty($_GET['insert_id'])) {
                                                            ?>
                                                                <input type="hidden" name="project_id" value="<?php echo $_GET['insert_id'];?>">
                                                            <?php
                                                        }
                                                    ?>
                                                    <?php
                                                        if(isset($_GET['insert_id']) && !empty($_GET['insert_id'])) {
                                                            $insert_id = $_GET['insert_id'];
                                                            $currentProject = $projectsModel->getProject($insert_id);
                        
                                                            $name = '';
                                                            if($currentProject) {
                                                            }
                                                                ?>
                                                                    <div class="form-group mb-20">
                                                                        <label for="">Project Name</label>
                                                                        <input type="text" class="form-control" name="project_name" value="<?php echo $currentProject["project_name"]; ?>" readonly>
                                                                    </div>
                                                                    <div class="form-group mb-20">
                                                                        <label for="">Postcode</label>
                                                                        <input type="text" class="form-control" name="post_code" value="<?php echo $currentProject["post_code"]; ?>" readonly>
                                                                    </div>
                                                                <?php
                                                        }else {
                                                            ?>
                                                                    <div class="form-group mb-20">
                                                                        <label for="">Project Name</label>
                                                                        <input type="text" class="form-control" name="project_name" required>
                                                                    </div>
                                                                    <div class="form-group mb-20">
                                                                        <label for="">Postcode</label>
                                                                        <input type="text" class="form-control" name="post_code" required>
                                                                    </div>
                                                                    <!-- <div class="form-group mb-20 d-none">
                                                                        <label for="">Involves</label>
                                                                        <ul class="list-unstyled">
                                                                            <li>
                                                                                <label for="price">
                                                                                    <input type="checkbox" name="show-price" id="price"> show price
                                                                                </label>
                                                                            </li>
                                                                                <label for="chat">
                                                                                    <input type="checkbox" name="show-chat" id="chat"> show chat
                                                                                </label>
                                                                            <li>
                                                                                <label for="mail-notifications">
                                                                                    <input type="checkbox" name="mail-notifications" id="mail-notifications"> mail notifications
                                                                                </label>
                                                                            </li>
                                                                            <li>
                                                                                <label for="best-combination">
                                                                                    <input type="checkbox" name="best-combinatio" id="best-combination"> best combination
                                                                                </label>
                                                                            </li>
                                                                        </ul>
                                                                    </div> -->
                                                                <?php
                                                        }
                                                    ?>
                        
                                                    <div class="">
                                                        <div class="tab-content" id="nav-tabContent">
                                                            <div class="tab-pane fade active show" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">
                                                                <div class="form-group product-list mb-20">
                                                                    <label for="">Product Name</label>
                                                                    <select class="form-control" name="product_name">
                                                                        <?php
                                                                            $products = $productModel->getAllProducts();
                        
                                                                            if($products) {
                                                                                foreach($products as $product) {
                                                                                    echo '<option value="'. strtolower($product["name"]). '">'. $product["name"]. '</option>';
                                                                                }
                                                                            }
                                                                        ?>
                                                                    </select>
                                                                </div>
                                                                <div class="form-group mb-20">
                                                                    <label for="">Description</label>
                                                                    <textarea name="description" class="form-control" id="" cols="30" rows="10" required></textarea>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col-6">
                                                                        <div class="form-group mb-20">
                                                                            <label for="">Quantity</label>
                                                                            <input type="number" class="form-control" name="quantity" min="1" value="" required>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-6">
                                                                        <div class="form-group mb-20">
                                                                            <label for="">Unit</label>
                                                                            <input type="text" class="form-control" name="unit" min="1" value="" required>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="form-group mb-20">
                                                                    <label for="">Date Required</label>
                                                                    <input type="text" class="form-control" name="date_required" value="" required>
                                                                </div>
                                                                <div class="form-group mb-20">
                                                                    <label class="d-block" for="">Attach a photo of the materials to illustrate how you expect them to look</label>
                                                                    <!-- <input type="file" class="" name="product_image" /> -->
                                                                    <div class="drop-zone">
                                                                        <span class="drop-zone__prompt">Drop file here or click to upload</span>
                                                                        <input type="file" name="product_image" class="drop-zone__input">
                                                                    </div>
                                                                </div>
                                                                <div class="form-group mb-20">
                                                                    <div class="box-sm">
                                                                        <span>are you open to similar brands?</span>
                                                                        <div class="mt-15">
                                                                            <a href="javascript:void(0);">
                                                                                <input type="radio" name="open_to_similar_brands" value="yes" checked> Yes
                                                                            </a>
                                                                            <a href="javascript:void(0);">
                                                                                <input type="radio" name="open_to_similar_brands" value="no"> No
                                                                            </a>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="form-group">
                                                                    <div class="btn-group">
                                                                        <button class="btn butn-primary" type="submit">Add Product</button>
                                                                        <button data-type="form_upload" class="publish-btn" type="button" name="status" value="publish">Publish</button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab">
                                                                <div class="mb-30">
                                                                    <a target="_blank" class="text-decoration-none" href="public/templates/products-spreadsheet.xlsx" style="color: #60CB97;">Download Template Here</a>
                                                                </div>
                                                                <div class="form-group mb-20">
                                                                    <label for="">Choose File</label>
                                                                    <input type="file" name="fileToUpload" id="fileToUpload">
                                                                </div>
                                                                <div class="form-group">
                                                                    <div class="btn-group">
                                                                        <button data-type="excel_upload" class="btn butn-primary publish-btn" type="button" name="status" value="publish">Publish</button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    <?php
                                }
                            ?>
                            <div class="processing-project" style="display: none;">
                                <div class="sec__heading">
                                    <h5>Add New Project</h5>
                                </div>
                                <div class="inner-content">
                                    <div class="message mt-10 mb-50">
                                        <h5 style="color: #4d4d4d; text-align: center;">Processing Your Project</h5>
                                    </div>
                                    <div style="max-width: 500px; margin: auto;">
                                        <img style="width: 100%" src="public/images/processing.svg" alt="">
                                    </div>
                                    <div class="mt-50">
                                        <h6 style="text-align: center; font-weight: 500;">Project Name: <p class="d-inline project_name"></p></h6>
                                    </div>
                                    <!-- <div class="mt-30">
                                        <a href="<?php echo BASE_URL; ?>">
                                            <button class="btn" style="width: 100%; height: 50px; border-radius: 10px; background-color: transparent; border: 2px solid #60cb97; color: #60cb97;">Cancel</button>
                                        </a>
                                    </div> -->
                                </div>
                            </div>
                            <!-- <?php
                                if(isset($_GET["status"]) && $_GET["status"] === "published-project") {
                                    ?>
                                    <?php
                                }
                            ?> -->
                            <div class="published-project" style="display: none;">
                                <div class="sec__heading">
                                    <h5>Add New Project</h5>
                                </div>
                                <div class="inner-content">
                                    <div class="message mt-10 mb-50">
                                        <h5 style="color: #4d4d4d; text-align: center;">Your Project is Successfully Published</h5>
                                    </div>
                                    <div style="max-width: 500px; margin: auto;">
                                        <img style="width: 100%" src="public/images/published.svg" alt="">
                                    </div>
                                    <div class="mt-50">
                                        <h6 style="text-align: center; font-weight: 500;">Project Name: <p class="d-inline project_name"></p></h6>
                                    </div>
                                    

                                    <?php
                                        if($_SESSION["show"] === 'add') {
                                            ?>
                                                <div class="mt-30">
                                                    <a href="<?php echo BASE_URL; ?>buyer.php?show=home">
                                                        <button class="btn" style="width: 100%; height: 50px; border-radius: 10px; background-color: #60cb97; border: 2px solid #60cb97; color: #fff;">Go To Home Page</button>
                                                    </a>
                                                </div>
                                            <?php
                                        }else {
                                            ?>
                                                <div class="mt-30">
                                                    <a href="<?php echo BASE_URL; ?>buyer.php?show=home">
                                                        <button class="btn" style="width: 100%; height: 50px; border-radius: 10px; background-color: #60cb97; border: 2px solid #60cb97; color: #fff;">Close</button>
                                                    </a>
                                                </div>
                                            <?php
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>
                    <?php
                }
            ?>

            <div id="products-section" class="projects-list box-content <?php echo isset($_SESSION["show"]) && ($_SESSION["show"] === "home" || $_SESSION["show"] === "products") ? "show" : ""; ?>">
                <div class="">
                    <div class="sec__heading">
                        <h5>Projects I Published</h5>
                    </div>
                    <div class="inner-content">
                        <div class="projects">
                            <?php
                                $projects = $projectsModel->getProjects($uid);

                                if($projects) {
                                    foreach($projects as $project) {
                                        // echo json_encode($project);
                                        $style = 'display: none;';
                                        if(isset($_GET["project_id"]) && $_GET["project_id"] == $project["id"]) {
                                            $style = '';
                                        }

                                        if(isset($_GET["active-project"]) && $_GET["active-project"] == $project["id"]) {
                                            $style = '';
                                        }
                                        ?>
                                        <div class="single-project" data-id="<?php echo $project["id"]; ?>">
                                            <div class="product-name">
                                                <div class="">
                                                    <h6><?php echo $project["status"] === '0' ? '<i class="text-muted">Draft - </i>' : '' ?> <?php echo $project["project_name"]; ?></h6>
                                                    
                                                    <span class="text-muted"><b>Postcode:</b> <?php echo $project["post_code"]; ?></span>
                                                </div>
                                                <div class="toggle-arrow">
                                                        <img src="public/images/arrow.svg" alt="">
                                                    </div>
                                            </div>
                                            <div class="item" data-id="<?php echo $project["id"]; ?>" style="<?php echo $style; ?>">
                                                <div class="d-flex justify-content-end mt-10 pr-10">
                                                    <?php
                                                        if($project["status"] === '0') {
                                                            ?>
                                                                <a class="text-decoration-none pr-20" style="color: #60CB97;" href="?action=publish-project&pid=<?php echo $project["id"]; ?>">Publish</a>
                                                            <?php
                                                        }
                                                    ?>
                                                    <a class="text-decoration-none" style="color: #60CB97;" href="edit-project.php?pid=<?php echo $project["id"]; ?>">Edit Project</a>
                                                </div>
                                                <hr>
                                                <div class="product-info d-flex align-items-center justify-content-between">
                                                    <div class="products">
                                                        <?php
                                                            $projectItems = $projectsModel->getProjectItems($project["id"]);
                                                            
                                                            if($projectItems) {
                                                            // echo json_encode($projectItems);
                                                                foreach($projectItems as $item) {
                                                                    // echo json_encode($item);
                                                                    ?>
                                                                        <div class="" data-type="<?php echo $item["id"]; ?>">
                                                                            <div class="product d-flex align-items-center">
                                                                                <div class="p-img">
                                                                                    <?php
                                                                                        $product = $productModel->getProductByName($item["product_type"]);
                    
                                                                                        ?>
                                                                                            <img class="lazyload" data-src="<?php echo $product["image"]; ?>" alt="<?php echo ucfirst($item["product_type"]); ?>">
                                                                                        <?php
                                                                                    ?>
                                                                                </div>
                                                                                <div class="p-name">
                                                                                    <h6><?php echo !empty($product["name"]) ? $product["name"] : 'Unknown' ; ?></h6>
                                                                                </div>
                                                                            </div>
                                                                            <div class="suppliers">
                                                                                <div class="table-head">
                                                                                    <h6 class="m-0">Suppliers</h6>
                                                                                </div>
                                                                                <div class="">
                                                                                    <div class="offers-wrapper">
                                                                                        <?php
                                                                                            $project_id = $project["id"];
                                                                                            $product_type = $item["product_type"];
                                                                                            // $offers = $projectsModel->getPriceOffers($project_id);
                                                                                            $offers = $projectsModel->getOfferItems($project_id, $product_type);
                                                                                            // echo json_encode($offers);
        
                                                                                            if($offers) {
                                                                                                foreach($offers as $offer) {
                                                                                                    // echo json_encode($offer);
                                                                                                    if($item["id"] === $offer["item_id"]) {
                                                                                                        $seller_id = $offer["seller_id"];
                                                                                                        $retings = $projectsModel->getReviews($seller_id);
                                                                                                        ?>
                                                                                                            <div class="project-history" data-id="<?php echo $offer["id"]; ?>">
                                                                                                                <ul class="position-relative m-0 list-unstyled d-flex align-items-center justify-content-between">
                                                                                                                    <li class="th-supplier">
                                                                                                                        <div class="">
                                                                                                                            <!-- <div class="position-absolute" style="top: -10px;">
                                                                                                                                <span style="color: #60CB97;"><i><?php echo $offer["vat"] === '1' ? 'With Vat' : 'Without Vat' ?></i></span>
                                                                                                                            </div> -->
                                                                                                                            <a class="text-decoration-none text-muted hide-company-name" href="reviews.php?uid=<?php echo $seller_id; ?>"><?php echo $offer["supplier_name"]; ?></a>
                                                                                                                            <?php
                                                                                                                                if(!empty($offer["gr_link"])) {
                                                                                                                                    ?>
                                                                                                                                        <br>
                                                                                                                                        <div class="mt-5">
                                                                                                                                            <a target="_blank" href="<?php echo ensureHttpsProtocol($offer["gr_link"]); ?>" class="text-decoration-none">External Reviews</a>
                                                                                                                                        </div>
                                                                                                                                    <?php
                                                                                                                                }
                                                                                                                            ?>
                                                                                                                        </div>
                                                                                                                        <?php
                                                                                                                            if($retings && $retings["total_reviews"] > 0) {
                                                                                                                                ?>
                                                                                                                                    <div class="supplier-rating mt-5">
                                                                                                                                        <img class="" width="20" src="public/images/star.svg" alt="">
                                                                                                                                        <a class="text-decoration-none text-muted" href="reviews.php?uid=<?php echo $seller_id; ?>"><span> <?php echo $retings ? $retings["average_rating"] .  ' ('.$retings["total_reviews"].')' : '0 (0)'; ?></span></a>
                                                                                                                                    </div>
                                                                                                                                <?php
                                                                                                                            }
                                                                                                                        ?>
                                                                                                                    </li>
                                                                                                                    <li class="" style="display: flex; flex-direction: column; gap: 5px;">
                                                                                                                        <div class="th-msg">
                                                                                                                            <a href="?add-to-chat=<?php echo $offer["seller_id"]; ?>&active-project=<?php echo $project["id"]; ?>">
                                                                                                                                <img src="public/images/messages-3.svg" alt="">
                                                                                                                            </a>
                                                                                                                        </div>
                                                                                                                        <div class="th-attachment">
                                                                                                                            <?php
                                                                                                                                if(!empty($offer["attached_file"])) {
                                                                                                                                    ?>
                                                                                                                                        <a target="_blank" href="<?php echo $offer["attached_file"]; ?>">Attachment</a>
                                                                                                                                    <?php
                                                                                                                                }
                                                                                                                            ?>
                                                                                                                        </div>
                                                                                                                        <div class="th-status">
                                                                                                                            <span class="mr-5">Status</span>
                                                                                                                            <svg width="15" height="9" viewBox="0 0 15 9" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                                                                                <path d="M14.5611 0.43968C14.4218 0.30029 14.2564 0.189715 14.0744 0.114273C13.8923 0.0388304 13.6972 0 13.5001 0C13.3031 0 13.1079 0.0388304 12.9259 0.114273C12.7438 0.189715 12.5784 0.30029 12.4391 0.43968L7.85313 5.02468C7.75936 5.11842 7.63221 5.17107 7.49963 5.17107C7.36704 5.17107 7.23989 5.11842 7.14613 5.02468L2.56113 0.43968C2.27986 0.158285 1.89834 0.000146217 1.50048 5.24521e-05C1.10262 -4.13131e-05 0.721021 0.157917 0.439627 0.439179C0.158232 0.720442 9.38129e-05 1.10197 4.17261e-08 1.49983C-9.37294e-05 1.89768 0.157865 2.27929 0.439127 2.56068L5.02513 7.14668C5.35014 7.47172 5.73599 7.72956 6.16065 7.90548C6.58531 8.08139 7.04047 8.17193 7.50013 8.17193C7.95978 8.17193 8.41494 8.08139 8.8396 7.90548C9.26426 7.72956 9.65012 7.47172 9.97513 7.14668L14.5611 2.56068C14.8423 2.27939 15.0003 1.89793 15.0003 1.50018C15.0003 1.10243 14.8423 0.720971 14.5611 0.43968Z" fill="#60CB97"/>
                                                                                                                            </svg>
                
                                                                                                                        </div>
                                                                                                                    </li>
                                                                                                                    <li class="th-amount">
                                                                                                                        <ul>
                                                                                                                            <?php
                                                                                                                                $product_price = $offer["product_price"];
                                                                                                                                $delivery_price = $offer["delivery_price"];
                                                                                                                                if($_SESSION["vat-type"] === 'with-vat') {
                                                                                                                                    if($offer["vat"] === '0') {
                                                                                                                                        $product_price = $offer["product_price"] * 1.2;
                                                                                                                                        $delivery_price = $offer["delivery_price"] * 1.2;
                                                                                                                                    }
                                                                                                                                }else {
                                                                                                                                    if($offer["vat"] === '1') {
                                                                                                                                        $product_price = ($offer["product_price"] * 100) / 120;
                                                                                                                                        $delivery_price = ($offer["delivery_price"] * 100) / 120;
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            ?>
                                                                                                                            <li>
                                                                                                                                <b>Product Price:</b>
                                                                                                                                
                                                                                                                                <b>£<?php echo number_format($product_price, 2); ?></b>
                                                                                                                            </li>
                                                                                                                            <li>
                                                                                                                                <b>Total per quantity:</b>
                                                                                                                                <b>£<?php echo number_format($product_price * $item["quantity"], 2); ?></b>
                                                                                                                            </li>
                                                                                                                            <li>
                                                                                                                                <b>Delivery Price:</b>
                                                                                                                                <b>£<?php echo number_format($delivery_price, 2); ?></b>
                                                                                                                            </li>
                                                                                                                            <li>
                                                                                                                                <b>Total:</b>
                                                                                                                                <b>£<?php echo number_format($product_price * $item["quantity"]  + $delivery_price, 2) ; ?></b>
                                                                                                                            </li>
                                                                                                                            <li>
                                                                                                                                <b>Delivery Date:</b>
                                                                                                                                <b><?php echo $offer["delivery_date"]; ?></b>
                                                                                                                            </li>
                                                                                                                            <li>
                                                                                                                                <b>Payment Term:</b>
                                                                                                                                <b><?php echo $offer["payment_term"]; ?></b>
                                                                                                                            </li>
                                                                                                                        </ul>
                                                                                                                    </li>
                                                                                                                </ul>
                                                                                                                <div class="status">
                                                                                                                    <form action="">
                                                                                                                        <input type="hidden" name="item_id" value="<?php echo $offer["id"]; ?>">
                                                                                                                        <input type="hidden" name="offer_id" value="<?php echo $offer["offer_id"]; ?>">
                                                                                                                        <input type="hidden" name="project_id" value="<?php echo $project["id"]; ?>">
                                                                                                                        <input type="hidden" name="seller_id" value="<?php echo $offer["seller_id"]; ?>">
                                                                                                                        <input type="hidden" name="update_notif_status" value="1">
                                                                                                                        <select class="form-control" name="status_type" id="">
                                                                                                                            <option value="" disabled selected></option>
                                                                                                                            <option value="ordered" <?php echo $offer["status"] === 'ordered' ? 'selected' : '' ?>>Ordered</option>
                                                                                                                            <option value="declined" <?php echo $offer["status"] === 'declined' ? 'selected' : '' ?>>Declined</option>
                                                                                                                            <option value="order-out-of-website" <?php echo $offer["status"] === 'order-out-of-website' ? 'selected' : '' ?>>Order Out Of Website</option>
                                                                                                                        </select>
                                                                                                                        <button type="submit" class="btn butn-primary">Update</button>
                                                                                                                    </form>
                                                                                                                </div>
                                                                                                                <div class="p-meta" style="<?php echo ($offer["status"] === 'ordered') ? '' : 'display: none' ?>">
                                                                                                                    <div class="d-none">
                                                                                                                        <div class="reiews d-flex align-items-center">
                                                                                                                            <div class="Stars" style="--rating: <?php echo $retings ? $retings["average_rating"] : '0'; ?>;"></div>
                                                                                                                            <span> <?php echo $retings ? $retings["average_rating"] .  '('.$retings["total_reviews"].')' : '0 (0)'; ?></span>
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                    <?php
                                                                                                                        $review = $projectsModel->getProjectReview($project_id, $offer["offer_id"]);
                                                                                                                        if(!$review) {
                                                                                                                            ?>
                                                                                                                                <div class="add-reiew">
                                                                                                                                    <form action="app/core/projects.php" method="post">
                                                                                                                                        <input type="hidden" name="seller_id" value="<?php echo $offer["seller_id"]; ?>">
                                                                                                                                        <input type="hidden" name="offer_id" value="<?php echo $offer["offer_id"]; ?>">
                                                                                                                                        <input type="hidden" name="item_id" value="<?php echo $offer["id"]; ?>">
                                                                                                                                        <input type="hidden" name="project_id" value="<?php echo $project["id"]; ?>">
                                                                                                                                        <input type="hidden" name="redirect" value="admin">
                                                                                                                                        <div class="input-group ml-10 mb-10">
                                                                                                                                            <div class="rating">
                                                                                                                                                <input type="radio" id="star1" name="rating" value="5" required /><label for="star1"></label>
                                                                                                                                                <input type="radio" id="star2" name="rating" value="4" required /><label for="star2"></label>
                                                                                                                                                <input type="radio" id="star3" name="rating" value="3" required /><label for="star3"></label>
                                                                                                                                                <input type="radio" id="star4" name="rating" value="2" required /><label for="star4"></label>
                                                                                                                                                <input type="radio" id="star5" name="rating" value="1" required /><label for="star5"></label>
                                                                                                                                            </div>
                                                                                                                                        </div>
                                                                                                                                        <div class="input-group">
                                                                                                                                            <input type="text" name="comment" id=""  placeholder="Enter a review" requried>
                                                                                                                                            <button type="submit" class="btn-submit" name="add-review" value="1">
                                                                                                                                                <img src="public/images/fi-sr-paper-plane.svg" alt="">
                                                                                                                                            </button>
                                                                                                                                        </div>
                                                                                                                                    </form>
                                                                                                                                </div>
                                                                                                                            <?php
                                                                                                                        }else {
                                                                                                                            ?>
                                                                                                                                <div class="Stars" style="--rating: <?php echo $retings ? $retings["average_rating"] : '0'; ?>;"></div>
                                                                                                                                <p><?php echo $review["comment"]; ?></p>
                                                                                                                            <?php
                                                                                                                        }
                                                                                                                    ?>
                                                                                                                </div>
                                                                                                            </div>
                                                                                                        <?php
                                                                                                    }
                                                                                                }
                                                                                            }else {
                                                                                                echo '<span class="no-offer-msg mt-10 mb-10 text-center text-muted" style="display: block;">No offers found!</span>';
                                                                                            }
                                                                                        ?>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    <?php
                                                                }
                                                            }
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php
                                    }
                                }else {
                                    ?>
                                        <span class="d-block text-center text-muted mt-50">Nothing to see here!</span>
                                    <?php
                                }
                            ?>
                        </div>
                    </div>
                </div>
            </div>

            <div id="combinations-section" class="best-combination box-content <?php echo isset($_SESSION["show"]) && ($_SESSION["show"] === "home" || $_SESSION["show"] === "combinations") ? "show" : ""; ?>">
                <div class="">
                    <div class="sec__heading">
                        <h5>Best Combination</h5>
                    </div>
                    <div class="inner-content">
                        <div class="combinations">
                            <!-- <div class="single-combination"></div> -->
                            <?php
                                $buyer_id = $_SESSION["user_id"];
                                // $combinationProjects = $projectsModel->getCombinationProjects($uid, $products_list);
                                $combinations = $projectsModel->bestCombination($buyer_id);
                                // echo json_encode($combinations);

                                if($combinations) {
                                    $count = count($combinations);
                                    // $index === ($count - 1) ? "display: block;" : "display: none;";
                                    foreach($combinations as $index => $combination) {
                                        // echo json_encode($combination);
                                        $projectItems = $projectsModel->getProjectItems($combination["id"]);
                                        ?>
                                            <div class="single-combination" data-id="<?php echo $combination["id"]; ?>">
                                                <div class="product-name">
                                                    <h6><?php echo $combination["project_name"]; ?></h6>
                                                    <div class="">
                                                        <img src="public/images/arrow.svg" alt="">
                                                    </div>
                                                </div>
                                                <?php
                                                    if(isset($_GET["active-combination"]) && $_GET["active-combination"] == $combination["id"]) {
                                                        $display = '';
                                                    }else {
                                                        $display = 'display: none;';
                                                    }
                                                ?>
                                                <div class="item" style="<?php echo $display; ?>">
                                                    <div class="product-info d-flex align-items-center justify-content-between">
                                                        <div class="products">
                                                            <?php
                                                                foreach($projectItems as $item) {
                                                                    // echo json_encode($item);
                                                                    ?>
                                                                        <div class="" data-type="<?php echo $item["id"]; ?>" data-qty="<?php echo $item["quantity"]; ?>">
                                                                            <div class="product d-flex align-items-center">
                                                                                <div class="p-img">
                                                                                    <?php
                                                                                        $product = $productModel->getProductByName($item["product_type"]);
                    
                                                                                        ?>
                                                                                            <img class="lazyload" data-src="<?php echo $item["image"]; ?>" alt="<?php echo ucfirst($item["product_type"]); ?>">
                                                                                        <?php
                                                                                    ?>
                                                                                </div>
                                                                                <div class="p-name">
                                                                                    <h6><?php echo !empty($product["name"]) ? $product["name"] : 'Unknown' ; ?></h6>
                                                                                </div>
                                                                            </div>
                                                                            <div class="suppliers">
                                                                                <table class="table">
                                                                                    <thead>
                                                                                        <tr>
                                                                                            <th>Suppliers</th>
                                                                                            <th></th>
                                                                                            <th>Best Price</th>
                                                                                        </tr>
                                                                                    </thead>
                                                                                    <tbody class="offers-wrapper">
                                                                                        <?php
                                                                                            $project_id = $item["project_id"];
                                                                                            $product_type = $item["product_type"];
                                                                                            // $offerItems = [];
                                                                                            $offerItems = $projectsModel->getBestCombinationItem($project_id, $product_type);

                                                                                            if($offerItems) {
                                                                                                foreach($offerItems as $offerId) {
                                                                                                    // echo json_encode($offerId);

                                                                                                    if($item["id"] === $offerId["item_id"]) {
                                                                                                        $seller_id = $offerId["user_id"];
                                                                                                        $retings = $projectsModel->getReviews($seller_id);
                                                                                                        ?>
                                                                                                            <tr class="project-history" data-id="<?php echo $offerId["id"]; ?>" data-price="<?php echo $offerId["total_price"]; ?>">
                                                                                                                <!-- <td class="supplier-name">
                                                                                                                    <span><?php echo $offerId["supplier_name"] ?></span>
                                                                                                                </td> -->
                                                                                                                <td class="th-supplier">
                                                                                                                    <div class="text-muted supplier-name">
                                                                                                                        <a class="text-decoration-none text-muted hide-company-name" href="reviews.php?uid=<?php echo $seller_id; ?>"><?php echo $offerId["supplier_name"]; ?></a>
                                                                                                                    </div>
                                                                                                                    <?php
                                                                                                                        if($retings && $retings["total_reviews"] > 0) {
                                                                                                                            ?>
                                                                                                                                <div class="supplier-rating mt-5">
                                                                                                                                    <img class="" width="20" src="public/images/star.svg" alt="">
                                                                                                                                    <a class="text-decoration-none text-muted" href="reviews.php?uid=<?php echo $seller_id; ?>"><span> <?php echo $retings ? $retings["average_rating"] .  ' ('.$retings["total_reviews"].')' : '0 (0)'; ?></span></a>
                                                                                                                                </div>
                                                                                                                            <?php
                                                                                                                        }
                                                                                                                    ?>
                                                                                                                </td>
                                                                                                                <td>
                                                                                                                    <div style="display: flex; flex-direction: column; gap: 5px;">
                                                                                                                        <div class="msg">
                                                                                                                            <a href="?add-to-chat=<?php echo $offerId["user_id"]; ?>&active-combination=<?php echo $combination["id"]; ?>">
                                                                                                                                <img src="public/images/messages-3.svg" alt="">
                                                                                                                            </a>
                                                                                                                        </div>
                                                                                                                        <div class="attachment">
                                                                                                                            <?php
                                                                                                                                if(!empty($offerId["attached_file"])) {
                                                                                                                                    ?>
                                                                                                                                        <a target="_blank" href="<?php echo $offerId["attached_file"]; ?>">Attachment</a>
                                                                                                                                    <?php
                                                                                                                                }
                                                                                                                            ?>
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </td>
                                                                                                                <td class="price">
                                                                                                                    <!-- <span class="text-muted">£<?php echo number_format($offerId["total_price"], 2); ?></span> -->
                                                                                                                    <ul class="list-unstyled">
                                                                                                                        <?php
                                                                                                                            $delivery_price = $offerId["delivery_price"];
                                                                                                                            if($_SESSION["vat-type"] === 'with-vat') {
                                                                                                                                if($offerId["vat"] === '0') {
                                                                                                                                    $delivery_price = $offerId["delivery_price"] * 1.2;
                                                                                                                                }
                                                                                                                            }else {
                                                                                                                                if($offerId["vat"] === '1') {
                                                                                                                                    $delivery_price = ($offerId["delivery_price"] * 100) / 120;
                                                                                                                                }
                                                                                                                            }
                                                                                                                        ?>
                                                                                                                        <li>
                                                                                                                            <b>Product Price:</b>
                                                                                                                            <b>£<?php echo number_format(($offerId["total_price"] - $offerId["delivery_price"]) / (float) $item["quantity"], 2); ?></b>
                                                                                                                        </li>
                                                                                                                        <li>
                                                                                                                            <b>Total per quantity:</b>
                                                                                                                            <b>£<?php echo number_format($offerId["total_price"] - $offerId["delivery_price"], 2); ?></b>
                                                                                                                        </li>
                                                                                                                        <!-- <li><i class="text-muted"><?php echo $offerId["vat"] === '1' ? 'With Vat' : 'Without Vat' ?></i></li> -->
                                                                                                                        <li>
                                                                                                                            <b>Delivery Price:</b>
                                                                                                                            <b>£<?php echo number_format($delivery_price, 2); ?></b>
                                                                                                                        </li>
                                                                                                                        <li>
                                                                                                                            <b>Total Price:</b>
                                                                                                                            <b>£<?php echo number_format((float) $offerId["total_price"], 2); ?></b>
                                                                                                                        </li>
                                                                                                                    </ul>
                                                                                                                </td>
                                                                                                            </tr>
                                                                                                        <?php
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        ?>
                                                                                    </tbody>
                                                                                </table>
                                                                            </div>
                                                                        </div>
                                                                    <?php
                                                                }
                                                            ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php
                                    }
                                }else {
                                    ?>
                                        <span class="d-block text-center text-muted mt-50">Nothing to see here!</span>
                                    <?php
                                }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Include Footer -->
            <footer>
                <div class="footer-top d-flex align-items-center">
                    <div class="container">
                        <div class="footer-content d-flex align-items-center justify-content-between">
                            <div class="footer-pages">
                                <ul class="list-unstyled m-0">
                                    <li><a href="<?php echo BASE_URL; ?>terms.php">Terms of USE</a></li>
                                </ul>
                            </div>
                            <div class="social-links">
                                <ul class="list-unstyled m-0">
                                    <li>
                                        <a href="">
                                            <!-- <img src="public/images/linkedin.svg" alt=""> -->
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="footer-bottom d-flex align-items-center">
                    <div class="container">
                        <div class="bottom-content">
                            <div class="row">
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-logo">
                                        <a href="<?php echo BASE_URL; ?>">
                                            <img src="public/images/logo-light.svg" alt="">
                                        </a>
                                    </div>
                                    
                                </div>
                                <div class="col-sm-12 col-md-6">
                                    <div class="footer-copyright">
                                        <a href="javascript:void(0);">© 2023. All rights reserved.</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
</div>

<script src="public/js/image-uploader.js"></script>

<?php
    include './templates/footer.php';
?>

<script>
    $(document).ready(function() {
        $(".menu-bar").click(function() {
            $(".sidebar").toggleClass("active");
        });

        <?php
            if(isset($_GET["action"]) && $_GET["action"] === "add-project") {
                ?>
                    if ($(window).width() < 768) {
                        $('html, body').animate({ scrollTop: $('.add-product').offset().top }, 0);
                    }
                <?php
            }
        ?>

        function updateProjectIPublished(id) {
            $.ajax({
                type: "POST",
                url: "app/core/projects.php",
                data: {
                    action: "updateProjectIPublished",
                    project_id: id
                },
                success: function(data) {
                    // console.log(data);

                    const singleProject = $("#products-section .single-project[data-id='" + id + "']");
                    if(singleProject) {
                        singleProject.remove();
                    }

                    $("#products-section .projects").prepend(data);
                }
            });
        }

        $(".publish-btn").click(function() {
            const type = $(this).data("type");
            console.log(type);

            let formContent = $(".add-product .inner-content");

            let inputsToValidate = [];
            if(type === 'form_upload') {
                inputsToValidate = [
                    "project_name",
                    "post_code",
                    "description",
                    "quantity",
                    "unit",
                    "date_required"
                ];
            }else {
                inputsToValidate = [
                    "project_name",
                    "post_code"
                ];
            }

            for (let i = 0; i < inputsToValidate.length; i++) {
                let fieldName = inputsToValidate[i];
                let fieldValue = formContent.find(`[name='${fieldName}']`).val();

                if (fieldValue.trim() === '') {
                    formContent.find(`[name='${fieldName}']`).focus();
                    return;
                }
            }

            const project_id = formContent.find("input[name='project_id']").val();
            const project_name = formContent.find("input[name='project_name']").val();
            const post_code = formContent.find("input[name='post_code']").val();

            if(type === 'form_upload') {
                
            }

            // if(project_name === '' || post_code === '' || product_name === '' || description === '' || quantity === '' || unit === '' || date_required === '') {
            //     alert("Please fill all fields");
            //     return;
            // }

            
            let formData = new FormData();
            formData.append("project_name", project_name);
            formData.append("post_code", post_code);

            if(type === 'form_upload') {
                const product_name = formContent.find("select[name='product_name']").val();
                const description = formContent.find("textarea[name='description']").val();
                const quantity = formContent.find("input[name='quantity']").val();
                const unit = formContent.find("input[name='unit']").val();
                const date_required = formContent.find("input[name='date_required']").val();
                const open_to_similar_brands = formContent.find("input[name='open_to_similar_brands']:checked").val();

                formData.append("product_name", product_name);
                formData.append("description", description);
                formData.append("quantity", quantity);
                formData.append("unit", unit);
                formData.append("date_required", date_required);
                formData.append("open_to_similar_brands", open_to_similar_brands);

                if(project_id) {
                    formData.append("project_id", project_id);
                }

                const product_image = formContent.find("input[name='product_image']")[0].files[0];

                if(product_image) {
                    formData.append("product_image", product_image);
                }
            }

            if(type === 'excel_upload') {
                const excel_file = formContent.find("input[name='fileToUpload']")[0].files[0];

                if(excel_file) {
                    formData.append("fileToUpload", excel_file);
                }else {
                    alert("Please select a file to upload");
                    return;
                }
            }

            formData.append("status", "publish");
            formData.append("action", "ADD_PROJECT");

            // console.log(Object.fromEntries(formData));
            // return;

            $("#add-section .form-box").hide();
            $("#add-section .processing-project .project_name").text(project_name);
            $("#add-section .processing-project").show();

            $.ajax({
                type: "POST",
                url: "app/core/projects.php",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);
                    console.log(res);
                    updateProjectIPublished(res.project_id);
                    
                    $("#add-section .processing-project").hide();

                    $("#add-section .published-project .project_name").text(project_name);
                    $("#add-section .published-project").show();

                    // window.location.href = `buyer.php?status=published-project&project=` + project_name;
                }
            });

        });

        $('.combinations .product-name').on('click', function() {
            // let containerHeight =  $('.combinations').height();
            var itemPositionRelativeToSection = $(this).position().top;

            if(itemPositionRelativeToSection > 500) {
                var currentScrollPosition = $('.combinations').scrollTop();
                var newScrollPosition = currentScrollPosition + 100;
                setTimeout(function() {
                    $('.combinations').animate({ scrollTop: newScrollPosition }, 'slow');
                }, 100);
            }
        });

        $('.projects .product-name').on('click', function() {
            // let containerHeight =  $('.projects').height();
            var itemPositionRelativeToSection = $(this).position().top;

            if(itemPositionRelativeToSection > 500) {
                var currentScrollPosition = $('.projects').scrollTop();
                var newScrollPosition = currentScrollPosition + 100;
                setTimeout(function() {
                    $('.projects').animate({ scrollTop: newScrollPosition }, 'slow');
                }, 100);
            }
        });

        $(".profile-item").click(function() {
            $(".header-dropdown-menu").toggle();
        });

        // Function to load data from localStorage and display corresponding .item elements
        function loadItemsFromLocalStorage() {
            var projectArray = JSON.parse(localStorage.getItem('projects')) || [];
            var combinationArray = JSON.parse(localStorage.getItem('combinations')) || [];
            
            // Display .item elements for projects
            projectArray.forEach(function(projectId) {
                $('.single-project[data-id="' + projectId + '"] .item').css('display', 'block');
            });
            
            // Display .item elements for combinations
            combinationArray.forEach(function(combinationId) {
                $('.single-combination[data-id="' + combinationId + '"] .item').css('display', 'block');
            });
        }

        function resetProjectsCombinations() {
            localStorage.removeItem('projects');
            localStorage.removeItem('combinations');
        }

        
        <?php
            if(isset($_GET["add-to-chat"]) || isset($_GET["vat-type"])) {
                ?>
                    loadItemsFromLocalStorage();
                <?php
            }else {
                ?>
                    resetProjectsCombinations();
                <?php
            }
        ?>

        // $('.product-name').click(function() {
        $(document).on('click','.product-name', function() {
            // console.log($(this).next('.item'));
            $(this).next('.item').toggle();
            $(this).find('img').toggleClass('rotated');

            // Select parent class
            var parentClass = $(this).closest('.single-project, .single-combination');
            
            // Check parent class name and toggle data-id in localStorage
            if (parentClass.hasClass('single-project')) {
                var projectId = parentClass.data('id');
                var projectArray = JSON.parse(localStorage.getItem('projects')) || [];
                var index = projectArray.indexOf(projectId);
                if (index !== -1) {
                    projectArray.splice(index, 1); // Remove ID if already exists
                } else {
                    projectArray.push(projectId); // Add ID if not exists
                }
                localStorage.setItem('projects', JSON.stringify(projectArray));
            } else if (parentClass.hasClass('single-combination')) {
                var combinationId = parentClass.data('id');
                var combinationArray = JSON.parse(localStorage.getItem('combinations')) || [];
                var index = combinationArray.indexOf(combinationId);
                if (index !== -1) {
                    combinationArray.splice(index, 1); // Remove ID if already exists
                } else {
                    combinationArray.push(combinationId); // Add ID if not exists
                }
                localStorage.setItem('combinations', JSON.stringify(combinationArray));
            }
        });

        // $('.th-status').click(function() {
        //     // Find the closest entry and toggle the visibility of the status section
        //     $(this).closest('.project-history').find('.status').toggle();
        // });

        $(document).on('click','.th-status', function() {
            $(this).closest('.project-history').find('.status').toggle();
        });

        $(".chat-history ul li").animate({ scrollTop:3031 },"fast");

        $("#attached-file").on("change", function () {
            let maxFileSizeMB = 10;
            let maxFileSizeBytes = maxFileSizeMB * 1024 * 1024;

            let $uploadButton = $(".file-upload-button");
            let $attachedFileName = $(".attached-file-name");
            let fileName = $(this).val().split("\\").pop();

            if ($(this).val()) {
                let uploadedFile = this.files[0];
                if(uploadedFile.size <= maxFileSizeBytes) {
                    $uploadButton.addClass("file-attached");
                    $attachedFileName.text(fileName);
                }else {
                    alert("Please upload file less than 10MB. Thanks!!");
                }
            } else {
                $uploadButton.removeClass("file-attached");
                $attachedFileName.text('');
            }
        });

        function updateChatUser() {
            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: "updateChatUser"
                },
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);

                    if(res.status === "success") {
                        $(".people-list ul").html(res.result);
                    }
                    // if(res.is_found == true) {
                    //     $(".load-notifications").show();
                    // }
                    // data && $(".chat-history ul li").append(data);
                }
            });
        }

        var termsToCheck = ["email", "skype", "phone", "contact", "details", "telephone", "number", "address"];

        function checkForContactDetails(text) {

            var lowercaseText = text.toLowerCase();
            var containsTerms = false;

            for (var i = 0; i < termsToCheck.length; i++) {
                var term = termsToCheck[i];
                if (lowercaseText.includes(term)) {
                    containsTerms = true;
                    break;
                }
            }

            // Check for words ending with "@"
            if (text.match(/\w+@$/)) {
                containsTerms = true;
            }

            var warningMessage = $('#warning-message');
            if (containsTerms) {
                // console.log("violations are not allowed");
                $(".warning-msg").show();
            } else {
                // console.log("you are going correctly");
                $(".warning-msg").hide();
            }
        }

        $('#msg-input').on('input', function() {
            var text = $(this).val();
            checkForContactDetails(text);
        });

        $("#send-msg").click(function() {
            var $msg_input = $("#msg-input"); // Corrected selector
            var $file = $("#attached-file"); // Corrected selector
            var $receiver = $("#receiver_id"); // Corrected selector

            if ($msg_input.val().trim() !== "" || $file[0].files[0]) {
                let $attachedFileName = $(".attached-file-name");

                var formData = new FormData(); // Create a new FormData object
                formData.append('message_text', $msg_input.val()); // Append the message value
                formData.append('file', $file[0].files[0]); // Append the selected file
                formData.append('receiver_id', $receiver.val()); // Append the message value
                formData.append('action', 'SEND_MESSAGE'); // Append the message value

                $.ajax({
                    url: "app/core/messages.php",
                    type: "POST",
                    data: formData,
                    processData: false, // Prevent jQuery from processing data
                    contentType: false, // Let the browser set the content type
                    beforeSend: function() {
                        // console.log("Sending...");
                        $("#send-msg").hide();
                        $("#sending-msg").show();
                    },
                    success: function(data) {
                        console.log(data);
                    },
                    complete: function() {
                        // console.log("Sent successfully");
                        $msg_input.val('');
                        $file.val('');

                        // Scroll to bottom
                        let targetSection = $(".chat-history ul li");
                        let targetBottom = targetSection[0].scrollHeight
                        $(".chat-history ul li").animate({ scrollTop: targetBottom + 100 },"fast");

                        $attachedFileName.text('');

                        $("#send-msg").show();
                        $("#sending-msg").hide();
                    }
                });
            }
        });

        $(".load-more-msg").click(function() {
            let receiver_id = $("#receiver_id").val();
            let first_id = $(".chat-msg").first().data("id");

            console.log(first_id);

            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: "loadMoreMessages",
                    receiver_id: receiver_id,
                    first_id: first_id
                },
                success: function(data) {
                    let res = JSON.parse(data);

                    if(res.status === 'success') {
                        res.result && $(".chat-history .chats").prepend(res.result);

                        if(res.total < 20) {
                            $(".load-more-msg").hide();
                        }
                    }
                }
            });
        });

        function updateMessages(receiver_id, last_msg_id) {
            jQuery.ajax({
                type: "POST",
                url: "app/core/messages.php",
                data: {
                    action: "updateMessages",
                    receiver_id: receiver_id,
                    last_msg_id: last_msg_id
                },
                success: function(data) {
                    if(data) {
                        $(".chat-history ul li .chats").append(data);

                        // Scroll to bottom
                        var element = $('.chat-history ul li');
                        var positionFromBottom = element.prop('scrollHeight') - element.scrollTop() - element.height();

                        console.log(positionFromBottom);
                        if(positionFromBottom < 150) {
                            let targetBottom = element[0].scrollHeight
                            $(".chat-history ul li").animate({ scrollTop: targetBottom + 100 },"fast");
                        }
                    }
                }
            });
        }

        setInterval(function(){
            // let receiver_id = $("#receiver_id").val();
            // let last_msg_id = $(".chat-msg").last().data("id");

            // if(receiver_id && last_msg_id) {
            //     // console.log("waiting for new message!");
            //     updateMessages(receiver_id, last_msg_id);
            // }

            let receiver_id = $("#receiver_id").val();
            
            if(receiver_id) {
                let last_msg_id = $(".chat-msg").last().data("id");
                if(!last_msg_id) {
                    last_msg_id = 0;
                }

                // console.log("waiting for new message!");
                updateMessages(receiver_id, last_msg_id);
            }

            checkNewNotifications();
            updateChatUser();
            updatePriceOffers();
            updateBestCombination();
            updateBestCombinationItem();
        }, 1500);

        $(".load-notifications a").click(function(){
            // $(".load-notifications").hide();
            updateNewNotifications();
        });

        $(".notif-back-btn").click(function() {
            $(".notification-menu").removeClass("active");
        });

        $(".load-more-notifications").click(function() {
            let last_id = $(".notifs .list").last().data("id");

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "loadMoreBuyerNotifications",
                    last_id: last_id
                },
                success: function(data) {
                    let res = JSON.parse(data);

                    if(res.has_result) {
                        $(".notifs .lists-container").append(res.data);

                        if(res.total < 10)  {
                            $(".load-more-notifications").hide();
                        }
                    }
                }
            });
        });

        $(".dropdown-icon").click(function() {
            updateNewNotifications();

            $(".notification-menu").toggleClass("active");
        });

        function checkNewNotifications() {
            // console.log("Checking new notifications");

            let first_id = $(".notifs .list").first().data("id");

            if(!first_id) {
                first_id = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "checkNewBuyerNotifications",
                    first_id: first_id
                },
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);

                    if(res.is_found == true) {
                        $(".load-notifications").show();
                        $(".notif-alert").show();
                    }else {
                        $(".load-notifications").hide();
                        // console.log("not new notifications found");
                    }
                    // data && $(".chat-history ul li").append(data);
                }
            });
        }

        function updateNewNotifications() {
            // console.log("Checking new notifications");
            let last_id = $(".notifs .list").first().data("id");

            if(!last_id) {
                last_id = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "getNewBuyerNotifications",
                    last_id: last_id
                },
                success: function(data) {
                    console.log(data);
                    let res = JSON.parse(data);

                    if(res.status == 'success') {
                        $(".no-results").hide();
                        res.data && $(".notifs").prepend(res.data);

                        $(".load-notifications").hide();
                        $(".notif-alert").hide();
                    }
                }
            });
        }

        function ensureHttpsProtocol(url) {
            return url.replace(/^http:\/\//i, 'https://');
        }

        function updatePriceOffers() {
            jQuery.ajax({
                type: "POST",
                url: "app/core/projects.php",
                data: {
                    action: "updatePriceOffers"
                },
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);
                    // console.log(res);

                    if(res.status == 'success') {
                        $.each(res.result, function(index, result) {
                            // console.log(result);

                            let item_id = result.id;
                            let project_id = result.project_id;
                            let product_name = result.product_name;
                            let offer_id = result.offer_id;

                            var singleProject = $('.single-project[data-id="' + result.project_id + '"]');

                            var productElement = singleProject.find('[data-type="' + result.item_id + '"]');

                            var suppliersElement = productElement.find('.suppliers');
                            let offersWrapperElement = suppliersElement.find('.offers-wrapper');


                            // console.log(suppliersElement);

                            // let selectedProduct = $('div[data-id="' + result.project_id + '"]');
                            // let suppliersSection = selectedProduct.find('.suppliers');
                            // let offersWrapper = selectedProduct.find('.offers-wrapper');

                            if (!suppliersElement.find(`.project-history[data-id="${result.id}"]`).length) {
                                // Hide the "no-offer-msg" element if it exists
                                $(".no-offer-msg").css("display", "none");

                                let subtoal = result.product_price;
                                let delivery_price = result.delivery_price;
                                <?php
                                    if($_SESSION["vat-type"] === 'with-vat') {
                                        ?>
                                            if(result.vat === '0') {
                                                subtoal = subtoal * 1.2;
                                                delivery_price = delivery_price * 1.2;
                                            }
                                        <?php
                                    }else {
                                        ?>
                                            if(result.vat === '1') {
                                                subtoal = (subtoal * 100) / 120;
                                                delivery_price = (delivery_price * 100) / 120;
                                            }
                                        <?php
                                    }
                                ?>

                                const offerHtml = `
                                    <div class="project-history" data-id="${result.id}">
                                        <ul class="position-relative m-0 list-unstyled d-flex align-items-center justify-content-between">
                                            <li class="th-supplier">
                                                <!-- <div class="position-absolute" style="top: -10px;">
                                                    <span><i class="text-muted">${result.vat === '1' ? 'With Vat' : 'Without Vat'}</i></span>
                                                </div> -->
                                                <a class="text-decoration-none text-muted hide-company-name" href="reviews.php?uid=${result.seller_id}">${result.supplier_name}</a>

                                                ${result.gr_link ? `<br><div class="mt-5"><a target="_blank" href="${ensureHttpsProtocol(result.gr_link)}" class="text-decoration-none">External Reviews</a></div>` : ''}

                                                ${result.total_reviews > 0 ? `
                                                    <div class="supplier-rating mt-5">
                                                        <img class="star-icon" width="20" src="public/images/star.svg" alt="">
                                                        <a class="text-decoration-none text-muted" href="reviews.php?uid=${result.seller_id}"><span class="rating-text">${result.average_rating} (${result.total_reviews})</span></a>
                                                    </div>
                                                ` : ''}
                                            </li>
                                            <li class="" style="display: flex; flex-direction: column; gap: 5px;">
                                                <div class="th-msg">
                                                    <a href="?add-to-chat=${result.seller_id}">
                                                        <img src="public/images/messages-3.svg" alt="">
                                                    </a>
                                                </div>
                                                
                                                ${result.attached_file ? `<div class="th-attachment"><a target="_blank" href="${result.attached_file}">Attachment</a></div>` : ''}
                                                <div class="th-status">
                                                    <span class="mr-5">Status</span>
                                                    <svg width="15" height="9" viewBox="0 0 15 9" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M14.5611 0.43968C14.4218 0.30029 14.2564 0.189715 14.0744 0.114273C13.8923 0.0388304 13.6972 0 13.5001 0C13.3031 0 13.1079 0.0388304 12.9259 0.114273C12.7438 0.189715 12.5784 0.30029 12.4391 0.43968L7.85313 5.02468C7.75936 5.11842 7.63221 5.17107 7.49963 5.17107C7.36704 5.17107 7.23989 5.11842 7.14613 5.02468L2.56113 0.43968C2.27986 0.158285 1.89834 0.000146217 1.50048 5.24521e-05C1.10262 -4.13131e-05 0.721021 0.157917 0.439627 0.439179C0.158232 0.720442 9.38129e-05 1.10197 4.17261e-08 1.49983C-9.37294e-05 1.89768 0.157865 2.27929 0.439127 2.56068L5.02513 7.14668C5.35014 7.47172 5.73599 7.72956 6.16065 7.90548C6.58531 8.08139 7.04047 8.17193 7.50013 8.17193C7.95978 8.17193 8.41494 8.08139 8.8396 7.90548C9.26426 7.72956 9.65012 7.47172 9.97513 7.14668L14.5611 2.56068C14.8423 2.27939 15.0003 1.89793 15.0003 1.50018C15.0003 1.10243 14.8423 0.720971 14.5611 0.43968Z" fill="#60CB97"/>
                                                    </svg>

                                                </div>
                                            </li>

                                            <li class="th-amount">
                                                <ul>
                                                    <li>
                                                        <b>Product Price:</b>
                                                        <b>£${parseFloat(result.product_price).toFixed(2)}</b>
                                                    </li>
                                                    <li>
                                                        <b>Total per quantity:</b>
                                                        <b>£${parseFloat(result.product_price * result.quantity).toFixed(2)}</b>
                                                    </li>
                                                    <li>
                                                        <b>Delivery Price:</b>
                                                        <b>£${parseFloat(delivery_price).toFixed(2)}</b>
                                                    </li>
                                                    <li>
                                                        <b>Total:</b>
                                                        <b>£${parseFloat(subtoal * result.quantity + Number(delivery_price)).toFixed(2)}</b>
                                                    </li>
                                                    <li>
                                                        <b>Delivery Date:</b>
                                                        <b>${result.delivery_date}</b>
                                                    </li>
                                                    <li>
                                                        <b>Payment Term:</b>
                                                        <b>${result.payment_term}</b>
                                                    </li>
                                                </ul>
                                            </li>
                                        </ul>
                                        <div class="status">
                                            <form action="">
                                                <input type="hidden" name="item_id" value="${result.id}">
                                                <input type="hidden" name="offer_id" value="${result.offer_id}">
                                                <input type="hidden" name="project_id" value="${result.project_id}">
                                                <input type="hidden" name="seller_id" value="${result.seller_id}">
                                                <input type="hidden" name="update_notif_status" value="1">
                                                <select class="form-control" name="status_type" id="">
                                                    <option value="" disabled selected></option>
                                                    <option value="ordered" ${result.status === 'ordered' ? 'selected' : ''}>Ordered</option>
                                                    <option value="declined" ${result.status === 'declined' ? 'selected' : ''}>Declined</option>
                                                    <option value="order-out-of-website" ${result.status === 'order-out-of-website' ? 'selected' : ''}>Order Out Of Website</option>
                                                </select>
                                                <button type="submit" class="btn butn-primary">Update</button>
                                            </form>
                                        </div>
                                    </div>
                                `;

                                offersWrapperElement.prepend(offerHtml);
                            }
                        });
                    }
                }
            });
        }

        function updateBestCombination() {
            let last_id = $(".combinations .single-combination").first().data("id");

            if(!last_id) {
                last_id = 0;
            }
    
            jQuery.ajax({
                type: "POST",
                url: "app/core/projects.php",
                data: {
                    action: "updateBestCombination",
                    last_id: last_id
                },
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);

                    if(res.status == 'success') {
                        $(".no-data-found").hide();
                        res.data && $(".combinations").prepend(res.data);
                    }
                }
            });
        }
        
        function updateBestCombinationItem() {
            jQuery.ajax({
                type: "POST",
                url: "app/core/projects.php",
                data: {
                    action: "updateBestCombinationItem"
                },
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);
                    // console.log(res);

                    if(res.status == 'success') {
                        $.each(res.result, function(index, result) {
                            // console.log(result);

                            let item_id = result.id;
                            let project_id = result.project_id;
                            let product_name = result.product_name;
                            let offer_id = result.offer_id;

                            var singleProject = $('.single-combination[data-id="' + result.project_id + '"]');

                            var productElement = singleProject.find('[data-type="' + result.item_id + '"]');

                            var productQty = productElement.data("qty");

                            var suppliersElement = productElement.find('.suppliers');
                            let offersWrapperElement = suppliersElement.find('.offers-wrapper');
                            
                            let projectHistoryElement = suppliersElement.find(`.project-history[data-id="${result.id}"]`);
                            
                            if (!projectHistoryElement.length) {
                                let priceOffers = suppliersElement.find(`.project-history`);
                                

                                if(result.total_price < $(priceOffers[0]).data('price')) {
                                    priceOffers.hide();
                                }

                                let delivery_price = result.delivery_price;
                                <?php
                                    if($_SESSION["vat-type"] === 'with-vat') {
                                        ?>
                                            if(result.vat === '0') {
                                                delivery_price = delivery_price * 1.2;
                                            }
                                        <?php
                                    }else {
                                        ?>
                                            if(result.vat === '1') {
                                                delivery_price = (delivery_price * 100) / 120;
                                            }
                                        <?php
                                    }
                                ?>

                                const offerHtml = `
                                    <tr class="project-history" data-id="${result.id}" data-price="${result.total_price}">
                                        <td class="th-supplier">
                                            <div class="text-muted supplier-name">
                                                <a class="text-decoration-none text-muted hide-company-name" href="reviews.php?uid=${result.seller_id}">${result.supplier_name}</a>
                                            </div>
                                            ${result.total_reviews > 0 ? `
                                                <div class="supplier-rating mt-5">
                                                    <img class="star-icon" width="20" src="public/images/star.svg" alt="">
                                                    <a class="text-decoration-none text-muted" href="reviews.php?uid=${result.seller_id}"><span class="rating-text">${result.average_rating} (${result.total_reviews})</span></a>
                                                </div>
                                            ` : ''}
                                        </td>
                                        <td>
                                            <div style="display: flex; flex-direction: column; gap: 5px;">
                                                <div class="msg">
                                                    <a href="?add-to-chat=${result.seller_id}">
                                                        <img src="public/images/messages-3.svg" alt="">
                                                    </a>
                                                </div>
                                                ${result.attached_file ? `<div class="attachment"><a target="_blank" href="${result.attached_file}">Attachment</a></div>` : ''}
                                            </div>
                                        </td>
                                        <td class="price">
                                            <ul class="list-unstyled">
                                                    <li>
                                                        <b>Product Price:</b>
                                                        <b>£${parseFloat(result.total_price / productQty).toFixed(2)}</b>
                                                    </li>
                                                    <li>
                                                        <b>Total per quantity:</b>
                                                        <b>£${parseFloat(result.total_price).toFixed(2)}</b>
                                                    </li>
                                                    <!-- <li><i class="text-muted">${result.vat === '1' ? 'With Vat' : 'Without Vat'}</i></li> -->
                                                    <li><i class="text-muted"></i></li>
                                                    <li>
                                                        <b>Delivery Price:</b>
                                                        <b>£${parseFloat(delivery_price).toFixed(2)}</b>
                                                    </li>
                                                    <li>
                                                        <b>Total Price:</b>
                                                        <b>£${parseFloat(result.total_price).toFixed(2)}</b>
                                                    </li>
                                                </ul>
                                        </td>
                                    </tr>
                                `;

                                offersWrapperElement.prepend(offerHtml);
                            }
                        });
                    }
                }
            });
        }

        $(document).on('click','.mark-notifications', function() {
            let offer_id = $(this).data("id");
            var imgElement = $(this).find("img");

            let src = imgElement.attr("src");

            let type = 1;
            if(src === 'public/images/star.svg') {
                type = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "markBuyerNotification",
                    offer_id: offer_id,
                    type: type
                },
                success: function(data) {
                    // console.log(data);
                    // let res = JSON.parse(data);

                    if(type === 1) {
                        imgElement.attr('src', 'public/images/star.svg');
                    }else {
                        imgElement.attr('src', 'public/images/star-light.svg');
                    }
                }
            });
        });
    });
</script>