<?php
    session_start();

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use PHPMailer\PHPMailer\SMTP;

    include './load.php';
    include './templates/header.php';
    include './app/models/Messages.php';
    include './app/models/Notifications.php';
    include './app/models/Projects.php';
    include './app/models/Products.php';

    ini_set('display_errors', "Off");

    if(!isBuyer()) {
        header("Location: index.php");
        exit();
    }

    $uid = $_SESSION["user_id"];

    $msgModel = new Messages();
    $notifModel = new Notifications();
    $projectsModel = new Projects();
    $productModel = new Products();
    // echo json_encode($messages);

    if(isset($_GET["show"])) {
        $_SESSION["show"] = $_GET["show"];
    }

    if(isset($_GET["notif_type"])) {
        $_SESSION["notif_type"] = $_GET["notif_type"];
    }else {
        $_SESSION["notif_type"] = 'all';
    }

    if(isset($_GET["add-to-chat"])) {
        $seller_id = $_GET["add-to-chat"];
        $addToChat = $msgModel->addToChat($uid, $seller_id);

        if($addToChat) {
            $_SESSION["chat_id"] = $seller_id;

            $msgModel->readAll($uid);
        }
    }

    if(isset($_GET["chat_id"])) {
        $_SESSION["chat_id"] = $_GET["chat_id"];

        $msgModel->readAll($uid);
    }

    if(isset($_GET["update_notif_status"]) && !empty($_GET["update_notif_status"])) {
        $offer_id = $_GET["offer_id"];
        $item_id = $_GET["item_id"];
        $status = $_GET["status_type"];
        $res = $projectsModel->updateStatus($offer_id, $item_id, $status);

        // echo json_encode($res);
    }

    $pid = $_REQUEST["pid"];

    // echo json_encode($_POST);

    if(isset($_POST["update_project"]) || isset($_POST["add_material"])) {
        $project_name = $_POST["project_name"];
        $post_code = $_POST["post_code"];
        
        $item_id = array();
        $description = array();
        $quantity = array();
        $unit = array();
        $date_required = array();
        $open_to_similar_brands = array();
        $product_image = array();

        if(!isset($_POST["empty_material"])) {
            $description = $_POST["description"];
            $quantity = $_POST["quantity"];
            $unit = $_POST["unit"];
            $date_required = $_POST["date_required"];
            $open_to_similar_brands = $_POST["open_to_similar_brands"];
            $product_image = $_FILES['product_image'];

            $item_id = $_POST["item_id"];
        }
        
        

        // Get project data
        $projectData = $projectsModel->getProject($pid);

        $res = $projectsModel->updateProject($pid, $project_name, $post_code);

        // add new material
        // $new_project_id = $_POST['new_project_id'];
        $new_description = $_POST['new_description'];
        $new_product_name = $_POST['new_product_name'];
        $new_open_to_similar_brands = $_POST['new_open_to_similar_brands'];
        $new_quantity = $_POST['new_quantity'];
        $new_unit = $_POST['new_unit'];
        $new_date_required = $_POST['new_date_required'];

        $variables = array($new_description, $new_product_name, $new_open_to_similar_brands, $new_quantity, $new_unit, $new_date_required);

        if(checkIfAllNotEmpty($variables)) {
            // echo json_encode($variables);

            $new_uploadPath = '';
            if(!empty($_FILES['new_product_image']['tmp_name'])) {
                $allowedTypes = ['jpg', 'jpeg', 'png'];
                $fileType = strtolower(pathinfo($_FILES['new_product_image']['name'], PATHINFO_EXTENSION));
    
                if (!in_array($fileType, $allowedTypes)) {
                    // echo 'Error: Invalid file type. Allowed types are JPEG and PNG.';
                } else {
                    // Validate file size (max: 5MB)
                    $maxFileSize = 5 * 1024 * 1024; // 5MB in bytes
                    if ($_FILES['new_product_image']['size'] > $maxFileSize) {
                        // echo 'Error: File size exceeds the maximum limit (5MB).';
                    } else {
                        
                    }
                }
    
                // Generate a unique filename to avoid overwriting existing files
                $fileName = uniqid('img_') . '_' . $_FILES['new_product_image']['name'];
                $uploadDir = "uploads/";
                $new_uploadPath = $uploadDir . $fileName;
    
                // Move the uploaded file to the destination directory
                if (move_uploaded_file($_FILES['new_product_image']['tmp_name'], "../../" . $new_uploadPath)) {
                    // echo 'File uploaded successfully.';
                } else {
                    // echo 'Error: Unable to upload the file.';
                    $new_uploadPath = '';
                }
            }
    
            // Insert new material
            $insert = $projectsModel->addToProjectItems($pid, $new_description, $new_product_name, $new_open_to_similar_brands, $new_quantity, $new_unit, $new_date_required, $new_uploadPath, '0');
        
            $insert_id = $insert;

            // echo json_encode(explode(',', $insert_id));

            // push $insert_id = $item_id
            // $item_id = array_push($item_id, );
            $item_id = array_merge($item_id, explode(',', $insert_id));
            $description = array_merge($description, explode(',', $new_description));
            $quantity = array_merge($quantity, explode(',', $new_quantity));
            $unit = array_merge($unit, explode(',', $new_unit));
            $date_required = array_merge($date_required, explode(',', $new_date_required));
            $open_to_similar_brands = array_merge($open_to_similar_brands, explode(',', $new_open_to_similar_brands));
            $product_image = array_merge($product_image, explode(',', $new_uploadPath));

        }
        
        if($projectData["status"] === '1') {
            function modifyEmptyString($data) {
                if(!empty($data)) {
                    return $data;
                }
                
                return '-';
            }
            
            // $projectsModel->publishProduct($pid);
            $projectsModel->updatePriceOffersEditPermission($pid, 1);

            // Select all project items
            $projectItems = $projectsModel->getProjectItems($pid);

            $uniqueProductTypes = [];

            // Create a new array to store items with unique product types
            $uniqueProjectItems = [];

            foreach ($projectItems as $item) {
                $productType = $item['product_type'];

                // Check if the product type is already in the unique array
                if (!in_array($productType, $uniqueProductTypes)) {
                    // Add the product type to the unique array
                    $uniqueProductTypes[] = $productType;
                    
                    // Add the item to the unique items array
                    $uniqueProjectItems[] = $item;
                }
            }

            // echo json_encode($item_id);

            $fileExist = false;
            foreach ($item_id as $key => $item) {
                $itemData = $productModel->getProjectItem($item);

                $project_id = $itemData["project_id"];
                $product_type = $itemData["product_type"];

                if (!empty($_FILES['product_image']['name'][$key])) {
                    $getFiles = $projectsModel->getProjectItemFiles($project_id, $product_type);
                    $itemId = $getFiles["id"];

                    if($getFiles["product_image_old"]) {
                        // unlink the file
                        unlink($getFiles["product_image_old"]);
                    }

                    if(!empty($getFiles["product_image"])) {
                        $product_image = $getFiles["product_image"];
                        $projectsModel->updateProjectItemFiles($itemId, '', $product_image);
                    }

                    // upload new file

                    // Generate a unique filename to avoid overwriting existing files
                    $fileName = uniqid('img_') . '_' . $_FILES['product_image']['name'][$key];
                    $uploadDir = "uploads/";
                    $uploadPath = $uploadDir . $fileName;

                    // Move the uploaded file to the destination directory
                    if (move_uploaded_file($_FILES['product_image']['tmp_name'][$key], $uploadPath)) {
                        // echo 'File uploaded successfully.';
                    } else {
                        // echo 'Error: Unable to upload the file.';
                        $uploadPath = '';
                    }

                    // update new file path
                    if(!empty($uploadPath)) {
                        $projectsModel->updateProjectItemFiles($itemId, $uploadPath, '');
                    }

                    $fileExist = true;
                }

            }

            if(isset($_POST["update_project"])) {
                // Change project_items status
                // $projectsModel->updateProjectItemsStatus($pid, 1);

                $uniqueSellerIds = [];
                foreach($uniqueProjectItems as $item) {
                    $product_type = $item["product_type"];
                    $sellers = $projectsModel->searchByKeywords($product_type);
                    // echo json_encode($sellers);
                    // exit;
        
                    if($sellers) {
                        foreach($sellers as $seller) {
                            $seller_id = $seller["user_id"];
                            $country = $seller["country"];
    
                            $isPriceSent = $projectsModel->isPriceSent($pid, $seller_id);
    
                            $added_on = $projectData["added_on"];
    
                            // Get the current timestamp
                            $currentTimestamp = time();
    
                            // Calculate the difference in seconds
                            $timeDifference = $currentTimestamp - strtotime($added_on);
    
                            // if ($timeDifference >= 10 * 60) { // 10 minutes = 10 * 60 seconds // 24 hours = 24 * 3600 seconds
                            //     echo "The article was added 10 minutes ago or more.";
                            // } else {
                            //     echo "The article was added less than 10 minutes ago.";
                            // }
    
                            if($isPriceSent || $timeDifference >= 24 * 3600) {
                                if($country === "all" || $_SESSION["userData"]["country"] === $country) {
                                    if (!in_array($seller_id, $uniqueSellerIds)) {
                                        $products_list = $seller["products_list"];
            
                                        $subject = "Looking for a new price offer";
                                        $message = '<!DOCTYPE html>
                                            <html>
                                                <head>
                                                    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
                                                </head>
                                                <body><div style="background-color: #f6f6f6;">
                                                    <div style="width: 600px; margin: auto; background-color: #fff;">
                                                        <div class="template-header" style="margin: 0 80px; background-color: #60CB97; height: 80px; display: flex; align-items: center; justify-content: center;">
                                                            <h1 style="color: #fff; text-transform: uppercase; font-weight: bold; margin: auto; font-size: 32px; text-align: center;">CONNECTION <span style="color: #696969;">SYSTEM</span></h1>
                                                        </div>
                                                        <div class="template-body" style="">
                                                            <div style="padding: 0 80px">
                                                                <h1 style="text-align: center; color: #383838; line-height: 36px; margin-bottom: 0; font-family: serif; font-size: 28px; unicode-bidi: plaintext;">DO YOUR BEST IN ORDER TO BE FIRST PLACE!</h1>
                                                                <div class="image" style="margin: auto; padding: 30px 0;">
                                                                    <img style="width: 100%;" src="https://www.connectionsys.co.uk/public/images/image-1.png" alt="">
                                                                </div>
                                                            </div>
                                                            <div class="box" style="position: relative; padding: 20px 80px; padding-top: 0; background-color: #60CB97;">
                                                                <span style="display: block; width: 60%; margin: auto; height: 15px; background-color: #696969;"></span>
                                                                <h1 style="text-align: center; text-transform: uppercase; color: #2B454E; font-family: serif; font-size: 38px; margin-top: 15px; margin-bottom: 5px;">This project was edit</h1>
                                                                <h3 style="text-align: center; color: #fff; font-weight: 400; font-size: 21px; line-height: 28px; margin-top: 0; unicode-bidi: plaintext;">you receive a new opportunity from '.$_SESSION["userData"]["company_name"].' looking to buy:</h3>
                                                                <div class="project-history" style="background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px;">
                                                                    <h3 style="margin-top: 8px; margin-bottom: 5px; text-align: center;">'.$project_name.'</h3>
                                                                    <p style="margin-top: 0; margin-bottom: 8px; text-align: center; font-size: 13px; color: #696969;"><b>Post Code:</b> '.$post_code.'</p>';
                                                                    
                                                                    if($projectData["project_name"] !== $project_name) {
                                                                        $message .= '<div>
                                                                        <div style="width: 46%; display: inline-block; padding: 7.5px;">
                                                                            <p style="margin-top: 5px; margin-bottom: 5px;">'.$projectData["project_name"].'</p>
                                                                        </div>
                                                                        <div style="width: 46%; display: inline-block; padding: 7.5px;">
                                                                            <p style="margin-top: 5px; margin-bottom: 5px;">'.$project_name.'</p>
                                                                        </div>
                                                                    </div>';
                                                                    }
                                                                    
                                                                    $message .= '<div class="products-wrapper" style="background-color: #fff; margin: 5px; border-radius: 15px; text-align: left;">';
            
                                        
                                        $index = 0;
                                        foreach ($item_id as $key => $item) {
                                            $itemData = $productModel->getProjectItem($item);
                                            // echo json_encode($itemData);
            
                                            // if($itemData) {
                                            // if($itemData["description"] !== $description[$key] || $itemData["quantity"] !== $quantity[$key] || $itemData["unit"] !== $unit[$key] || $itemData["date_required"] !== $date_required[$key] || $itemData["open_to_similar_brands"] !== $open_to_similar_brands[$key] || $fileExist) {
                                            // }
    
                                            $product_type = $itemData["product_type"];
                                            $listAray = explode(",", $products_list);
                                            if(in_array($product_type, $listAray)) {
                                                // $beforeDesc = '';
                                                // $afterDesc = '';
                            
                                                $descStyles = '';
                                                if($itemData["description"] !== $description[$key]) {
                                                    $descStyles = "color: #df3079; text-decoration: line-through;";
                                                }
                                                $beforeDesc = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; text-align: left; opacity: 70%;"><b style="color: #000;">Description: </b> <span style="'.$descStyles.'">'.modifyEmptyString($itemData["description"]).'</span></p>';
                                                $afterDesc = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Description: </b> '.modifyEmptyString($description[$key]).'</p>';
                                                
                                                // $beforeOpenToSimilarBrands = '';
                                                // $afterOpenToSimilarBrands = '';
    
                                                $openToSimilarBrandsStyles = '';
                                                if($itemData["open_to_similar_brands"] !== $open_to_similar_brands[$key]) {
                                                    $openToSimilarBrandsStyles = "color: #df3079; text-decoration: line-through;";
                                                }
                                                $beforeOpenToSimilarBrands = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> <span style="'.$openToSimilarBrandsStyles.'">'.ucfirst($itemData["open_to_similar_brands"]).'</span></p>';
                                                $afterOpenToSimilarBrands = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> '.ucfirst($open_to_similar_brands[$key]).'</p>';
                            
                                                // $beforeQty = '';
                                                // $afterQty = '';
                            
                                                $qtyStyles = '';
                                                if($itemData["quantity"] !== $quantity[$key]) {
                                                    $qtyStyles = "color: #df3079; text-decoration: line-through;";
                                                }
                                                $beforeQty = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; text-align: left; opacity: 70%;"><b style="color: #000;">Quantity:</b> <span style="'.$qtyStyles.'">'.modifyEmptyString($itemData["quantity"]).'</span></p>';
                                                $afterQty = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Quantity:</b> '.modifyEmptyString($quantity[$key]).'</p>';
                            
                                                // $beforeUnit = '';
                                                // $afterUnit = '';
                            
                                                $unitStyles = '';
                                                if($itemData["unit"] !== $unit[$key]) {
                                                    $unitStyles = "color: #df3079; text-decoration: line-through;";
                                                }
                                                $beforeUnit = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; text-align: left; opacity: 70%;"><b style="color: #000;">Unit:</b> <span style="'.$unitStyles.'">'.modifyEmptyString($itemData["unit"]).'</span></p>';
                                                $afterUnit = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Unit:</b> '.modifyEmptyString($unit[$key]).'</p>';
                            
                                                // $beforeDr = '';
                                                // $afterDr = '';
                            
                                                $drStyles = '';
                                                if($itemData["date_required"] !== $date_required[$key]) {
                                                    $drStyles = "color: #df3079; text-decoration: line-through;";
                                                }
                                                $beforeDr = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; text-align: left; opacity: 70%;"><b style="color: #000;">Date Required:</b> <span style="'.$drStyles.'">'.modifyEmptyString($itemData["date_required"]).'</span></p>';
                                                $afterDr = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Date Required:</b> '.modifyEmptyString($date_required[$key]).'</p>';
    
                                                $beforeFile = '';
                                                $afterFile = '';
                                                if (!empty($_FILES['product_image']['name'][$key])) {
                                                    if($itemData["product_image_old"]) {
                                                        $beforeFile = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 12px; line-height: 15px; text-align: left;"><a style="color: #df3079; text-decoration: line-through;" href="'. BASE_URL . $itemData["product_image_old"].'">See the attached file to view how the buyer expects the materials to look.</a></p>';
                                                    }
                                                }else {
                                                    if($itemData["product_image_old"]) {
                                                        $beforeFile = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 12px; line-height: 15px; text-align: left;"><a style="text-decoration: none;" href="'. BASE_URL . $itemData["product_image"].'">See the attached file to view how the buyer expects the materials to look.</a></p>';
                                                    }
                                                }
    
                                                if($itemData["product_image"]) {
                                                    $afterFile = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 12px; line-height: 15px; text-align: left;"><a style="text-decoration: none;" href="'. BASE_URL . $itemData["product_image"].'">See the attached file to view how the buyer expects the materials to look.</a></p>';
                                                }
    
                                                // $product = $productModel->getProductByName($itemData["product_type"]);
    
                                                // if(!empty($itemData["product_image"])) {
                                                //     $img_url = BASE_URL . $itemData["product_image"];
                                                // }else {
                                                //     if(!empty($product["image"])) {
                                                //         $img_url = BASE_URL . $product["image"];
                                                //     }else {
                                                //         $img_url = 'https://rakanonline.com/wp-content/uploads/2022/08/default-product-image.png';
                                                //     }
                                                // }

                                                if($itemData["status"] === '1') {
                                                    
                                                    if($itemData["description"] !== $description[$key] || $itemData["quantity"] !== $quantity[$key] || $itemData["unit"] !== $unit[$key] || $itemData["date_required"] !== $date_required[$key] || $itemData["open_to_similar_brands"] !== $open_to_similar_brands[$key] || $fileExist) {
                                                        $pImage = '';
                                                        if($itemData["product_image"]) {
                                                            $afterFile = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 12px; line-height: 15px; text-align: left;"><a style="text-decoration: none;" href="'. BASE_URL . $itemData["product_image"].'">See the attached file to view how the buyer expects the materials to look.</a></p>';
                                                        }
                                                        
                                                        $message .= '<div class="product-item" style="box-sizing: border-box; width: 50%; display: inline-block; padding: 7.5px;">
                                                            <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                                                                <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">'.ucfirst($itemData["product_type"]).'</h3>
                                                                '.$beforeDesc.'
                                                                '.$beforeOpenToSimilarBrands.'
                                                                '.$beforeQty.'
                                                                '.$beforeUnit.'
                                                                '.$beforeDr.'
                                                                '.$beforeFile.'
                                                            </div>
                                                        </div>';
                                    
                                                        $message .= '<div class="product-item" style="box-sizing: border-box; width: 50%; display: inline-block; padding: 7.5px;">
                                                            <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                                                                <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">'.ucfirst($itemData["product_type"]).'</h3>
                                                                '.$afterDesc.'
                                                                '.$afterOpenToSimilarBrands.'
                                                                '.$afterQty.'
                                                                '.$afterUnit.'
                                                                '.$afterDr.'
                                                                '.$afterFile.'
                                                            </div>
                                                        </div>';
                                                    }else {
                                                        $message .= '<div class="product-item" style="box-sizing: border-box; width: 100%; display: inline-block; padding: 7.5px;">
                                                            <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                                                                <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">'.ucfirst($itemData["product_type"]).'</h3>
                                                                <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Description:</b> '.$itemData["description"].'</p>
                                                                <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> '.ucfirst($itemData["open_to_similar_brands"]).'</p>
                                                                <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Quantity:</b> '.modifyEmptyString($itemData["quantity"]).'</p>
                                                                <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Unit:</b> '.modifyEmptyString($itemData["unit"]).'</p>
                                                                <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Date Required:</b> '.modifyEmptyString($itemData["date_required"]).'</p>
                                                                '.$pImage.'
                                                            </div>
                                                        </div>';
                                                    }
                                                }else {
                                                    $index++;

                                                    if($index === 1) {
                                                        $message .= '<h3 style="margin-top: 8px; margin-bottom: 0; margin-left: 8px; font-weight: 600; font-size: 16px; text-align: left;">New Materials:</h3>';
                                                    }

                                                    $pImage = '';
                                                    if($itemData["product_image"]) {
                                                        $afterFile = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 12px; line-height: 15px; text-align: left;"><a style="text-decoration: none;" href="'. BASE_URL . $itemData["product_image"].'">See the attached file to view how the buyer expects the materials to look.</a></p>';
                                                    }

                                                    $message .= '<div class="product-item" style="box-sizing: border-box; width: 100%; display: inline-block; padding: 7.5px;">
                                                    <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                                                        <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">'.ucfirst($itemData["product_type"]).'</h3>
                                                        <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Description:</b> '.$itemData["description"].'</p>
                                                        <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> '.ucfirst($itemData["open_to_similar_brands"]).'</p>
                                                        <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Quantity:</b> '.modifyEmptyString($itemData["quantity"]).'</p>
                                                        <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Unit:</b> '.modifyEmptyString($itemData["unit"]).'</p>
                                                        <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Date Required:</b> '.modifyEmptyString($itemData["date_required"]).'</p>
                                                        '.$pImage.'
                                                    </div>
                                                </div>';

                                                
                                                }
                                            }
                                        }
            
                                        $message .= '</div>
                                                        </div>
                                                            <div class="button" style="text-align: center;">
                                                                <a href="https://www.connectionsys.co.uk/">
                                                                    <button style="background-color: #696969; border: transparent; height: 36px; padding: 0 18px; border-radius: 5px; font-size: 16px; text-transform: uppercase; color: #fff; font-weight: bold; cursor: pointer;">Price Him</button>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="template-footer" style="margin: 0 auto; text-align: center;padding: 15px 0;">
                                                        <span style="display: block; width: 32%; margin: auto; height: 8px; background-color: #60CB97; margin-bottom: 15px;"></span>
                                                        <a href="https://www.connectionsys.co.uk/" style="display: block; text-align: center; font-size: 22px; text-decoration: none; color: #60CB97; font-family: Montserrat;">www.connectionsys.co.uk</a>
                                                    </div>
                                                </div>
                                            </div>
                                            </body></html>';
                                        
                                        // $isExists = $projectsModel->checkNotification($pid, $seller_id);
                                        // if(!$isExists) {
                                        // }
            
                                        // echo $message; 
                                        // echo exit;
                
                                        $email = $seller["email"];
                                        $company_name = $seller["company_name"];
                
                                        // $desc = json_encode($description);
                                        // $projectsModel->addToNofications($project_name, $desc, $pid, $seller_id);
                    
                                        $mail = new PHPMailer();
                                        try {
                                            //Server settings
                                            // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                                            $mail->isSMTP();                                            //Send using SMTP
                                            $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                                            $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                                            $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                                            $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                                            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                                            $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
                                        
                                            //Recipients
                                            $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                                            $mail->addAddress($email, $company_name);     //Add a recipient
                                            // $mail->addAddress('ellen@example.com');               //Name is optional
                                            // $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');
                                        
                                            //Content
                                            $mail->isHTML(true);                                  //Set email format to HTML
                                            $mail->Subject = $subject;
                                            $mail->Body    = $message;
                                            // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
                                        
                                            $mail->send();
                                            // echo 'Message has been sent';
                                        } catch (Exception $e) {
                                            echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                                            exit;
                                        }
        
                                        // Add the seller ID to the list of processed IDs
                                        $uniqueSellerIds[] = $seller_id;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            

            foreach ($item_id as $key => $item) {
                $itemData = $productModel->getProjectItem($item);

                $project_id = $itemData["project_id"];
                $product_type = $itemData["product_type"];

                if($itemData["description"] !== $description[$key] || $itemData["quantity"] !== $quantity[$key] || $itemData["unit"] !== $unit[$key] || $itemData["date_required"] !== $date_required[$key] || $itemData["open_to_similar_brands"] !== $open_to_similar_brands[$key]) {
                    $projectsModel->updateOfferItemEditable($project_id, $item, 1);

                    $itemArray = array(
                        "description" => $description[$key],
                        "quantity" => $quantity[$key],
                        "unit" => $unit[$key],
                        "date_required" => $date_required[$key],
                        "open_to_similar_brands" => $open_to_similar_brands[$key]
                    );

                    $projectsModel->updateProjectItemEditData($item, json_encode($itemArray));
                }

                if(isset($_POST["update_project"])) {
                    $projectsModel->updateProjectItem($item, $description[$key], $quantity[$key], $unit[$key], $date_required[$key], $open_to_similar_brands[$key]);
                
                    // Change project_items status
                    $projectsModel->updateProjectItemsStatus($pid, 1);
                }

                // update offer items edit_permission
                $projectsModel->updateOfferItemsEditPermission($project_id, $product_type, 1);

                
            }

            // echo $message;
        }else {
            $getProject = $projectsModel->getProject($pid);

            $projectsModel->publishProduct($pid);

            if(isset($_POST["update_project"])) {
                // Select all project items
                $projectItems = $projectsModel->getProjectItems($pid);

                // Change project_items status
                $projectsModel->updateProjectItemsStatus($pid, 1);
        
                foreach($projectItems as $item) {
                    $product_type = $item["product_type"];
                    $sellers = $projectsModel->searchByKeywords($product_type);
                    // echo json_encode($sellers);
                    // exit;
        
                    if($sellers) {
                        foreach($sellers as $seller) {
                            $seller_id = $seller["user_id"];
                            $products_list = $seller["products_list"];
    
                            $subject = "Looking for a new price offer";
                            $message = '<!DOCTYPE html>
                                <html>
                                    <head>
                                        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
                                    </head>
                                    <body><div style="background-color: #f6f6f6;">
                                        <div style="width: 600px; margin: auto; background-color: #fff;">
                                            <div class="template-header" style="margin: 0 80px; background-color: #60CB97; height: 80px; display: flex; align-items: center; justify-content: center;">
                                                <h1 style="color: #fff; text-transform: uppercase; font-weight: bold; margin: auto; font-size: 32px; text-align: center;">CONNECTION <span style="color: #696969;">SYSTEM</span></h1>
                                            </div>
                                            <div class="template-body" style="">
                                                <div style="padding: 0 80px">
                                                    <h1 style="text-align: center; color: #383838; line-height: 36px; margin-bottom: 0; font-family: serif; font-size: 28px; unicode-bidi: plaintext;">DO YOUR BEST IN ORDER TO BE FIRST PLACE!</h1>
                                                    <div class="image" style="margin: auto; padding: 30px 0;">
                                                        <img style="width: 100%;" src="https://www.connectionsys.co.uk/public/images/image-1.png" alt="">
                                                    </div>
                                                </div>
                                                <div class="box" style="position: relative; padding: 20px 80px; padding-top: 0; background-color: #60CB97;">
                                                    <span style="display: block; width: 60%; margin: auto; height: 15px; background-color: #696969;"></span>
                                                    <h1 style="text-align: center; text-transform: uppercase; color: #2B454E; font-family: serif; font-size: 38px; margin-top: 15px; margin-bottom: 5px;">NEW OPPORTUNITY</h1>
                                                    <h3 style="text-align: center; color: #fff; font-weight: 400; font-size: 21px; line-height: 28px; margin-top: 0; unicode-bidi: plaintext;">you receive a new opportunity from '.$_SESSION["userData"]["company_name"].' looking to buy:</h3>
                                                    <div class="project-history" style="background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px;">
                                                        <h3 style="margin-top: 8px; margin-bottom: 5px; text-align: center;">'.$getProject["project_name"].'</h3>
                                                        <p style="margin-top: 0; margin-bottom: 8px; text-align: center; font-size: 13px; color: #696969;"><b>Post Code:</b> '.$getProject["post_code"].'</p>
                                                        <div class="products-wrapper" style="background-color: #fff; margin: 5px; border-radius: 15px; text-align: left;">';
    
                            $products_list_array = explode(',', $products_list);
    
                            // Filter $projectItems based on product types in $products_list_array
                            $matchingProducts = array_filter($projectItems, function ($product) use ($products_list_array) {
                                return in_array($product['product_type'], $products_list_array);
                            });
                            
                            // Reset array keys
                            $matchingProducts = array_values($matchingProducts);
    
                            foreach($matchingProducts as $matchingProduct) {
                                $itemWidth = '100%';
                                if(count($matchingProducts) > 1) {
                                    $itemWidth = '50%';
                                }
                
                                $quantity = '';
                                if($matchingProduct["quantity"]) {
                                    $quantity = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Quantity:</b> '.$matchingProduct["quantity"].'</p>';
                                }
                
                                $unit = '';
                                if($matchingProduct["unit"]) {
                                    $unit = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Unit:</b> '.$matchingProduct["unit"].'</p>';
                                }
                
                                $date_required = '';
                                if($matchingProduct["date_required"]) {
                                    $date_required = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Date Required:</b> '.$matchingProduct["date_required"].'</p>';
                                }
    
                                $open_to_similar_brands = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> '.ucfirst($matchingProduct["open_to_similar_brands"]).'</p>';
    
                                $attached_file = '';
                                if(!empty($matchingProduct["product_image"])) {
                                    $attached_file = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 12px; text-align: left;"><a href="'. BASE_URL . $matchingProduct["product_image"].'">See the attached file to view how the buyer expects the materials to look.</a></p>';
                                }
                
                                $message .= '<div class="product-item" style="box-sizing: border-box; width: '.$itemWidth.'; display: inline-block; padding: 7.5px;">
                                        <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                                            <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">'.ucfirst($matchingProduct["product_type"]).'</h3>
                                            <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Description:</b> '.$matchingProduct["description"].'</p>
                                            '.$open_to_similar_brands.'
                                            '.$quantity.'
                                            '.$unit.'
                                            '.$date_required.'
                                            '.$attached_file.'
                                        </div>
                                    </div>';
                            }
    
                            $message .= '</div>
                                        </div>
                                            <div class="button" style="text-align: center;">
                                                <a href="https://www.connectionsys.co.uk/">
                                                    <button style="background-color: #696969; border: transparent; height: 36px; padding: 0 18px; border-radius: 5px; font-size: 16px; text-transform: uppercase; color: #fff; font-weight: bold; cursor: pointer;">Price Him</button>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="template-footer" style="margin: 0 auto; text-align: center;padding: 15px 0;">
                                        <span style="display: block; width: 32%; margin: auto; height: 8px; background-color: #60CB97; margin-bottom: 15px;"></span>
                                        <a href="https://www.connectionsys.co.uk/" style="display: block; text-align: center; font-size: 22px; text-decoration: none; color: #60CB97; font-family: Montserrat;">www.connectionsys.co.uk</a>
                                    </div>
                                </div>
                            </div>
                            </body></html>';
                            
                            $isExists = $projectsModel->checkNotification($pid, $seller_id);
                            if(!$isExists) {
                                $email = $seller["email"];
                                $company_name = $seller["company_name"];
    
                                $project_name = $getProject["project_name"];
                                $description = $item["description"];
    
                                $desc = json_encode($description);
                                $projectsModel->addToNofications($project_name, $desc, $pid, $seller_id);
    
                                if($seller["newsletter_preference"] === '1') {
                                    $mail = new PHPMailer();
                                    
                                    try {
                                        //Server settings
                                        // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                                        $mail->isSMTP();                                            //Send using SMTP
                                        $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                                        $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                                        $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                                        $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                                        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                                        $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
                                    
                                        //Recipients
                                        $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                                        $mail->addAddress($email, $company_name);     //Add a recipient
                                        // $mail->addAddress('ellen@example.com');               //Name is optional
                                        // $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');
                                    
                                        //Content
                                        $mail->isHTML(true);                                  //Set email format to HTML
                                        $mail->Subject = $subject;
                                        $mail->Body    = $message;
                                        // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
                                    
                                        $mail->send();
                                        // echo 'Message has been sent';
                                    } catch (Exception $e) {
                                        echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                                        exit;
                                    }
                                }
            
                            }
                        }
                    }
                }
            }
        }

        $messages = array("status" => "success", "message" => "Project updated successfully");
    }

    // if(isset($_POST["update_product"])) {
    //     $item_id = $_POST["item_id"];
    //     $description = $_POST["description"];

    //     $res = $projectsModel->updateProjectItem($item_id, $description);

    //     if($res) {
    //         $messages = array("status" => "success", "message" => "Project item updated successfully");
    //     }
    // }

    if(isset($_GET["action"]) && $_GET["action"] === "delete-project") {
        $project_id = $_GET["pid"];

        $projectsModel->deleteProject($project_id);

        header("Location: buyer.php");
        exit();
    }

    // if(isset($_GET["action"]) && $_GET["action"] === "delete-product") {
    //     $item_id = $_GET["item_id"];
    //     $res = $projectsModel->deleteProjectItem($item_id);
    // }

    if(isset($_GET["action"]) && $_GET["action"] === "delete-material") {
        $item_id = $_GET["item_id"];
        $res = $projectsModel->deleteProjectItem($item_id, $pid);

        if($res) {
            $messages = array("status" => "success", "message" => "Project item updated successfully");
        }
    }

    $project = $projectsModel->getProject($pid);

    if(!$project) {
        header("Location: buyer.php");
        exit();
    }
?>

<div class="buyer d-flex">
    <!-- Include Sidebar -->
    <div class="sidebar">
        <div class="sidebar-content">
            <div class="sidebar-logo d-flex align-items-center justify-content-center">
                <img src="public/images/logo-sm.svg" alt="">
            </div>
            <div class="sidebar-nav">
                <div class="nav-items">
                    <div class="item <?php echo $_SESSION["show"] === "home" ? "active" : ""; ?>">
                        <a href="buyer.php?show=home">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M30.06 10.23L21.42 4.18503C19.065 2.53503 15.45 2.62503 13.185 4.38003L5.66999 10.245C4.16999 11.415 2.98499 13.815 2.98499 15.705V26.055C2.98499 29.88 6.08998 33 9.91498 33H26.085C29.91 33 33.015 29.895 33.015 26.07V15.9C33.015 13.875 31.71 11.385 30.06 10.23ZM19.125 27C19.125 27.615 18.615 28.125 18 28.125C17.385 28.125 16.875 27.615 16.875 27V22.5C16.875 21.885 17.385 21.375 18 21.375C18.615 21.375 19.125 21.885 19.125 22.5V27Z" fill="#60CB97"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "chat" ? "active" : ""; ?>" id="chatBtn">
                        <a href="buyer.php?show=chat">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M33 9.375V17.025C33 18.93 32.37 20.535 31.245 21.645C30.135 22.77 28.53 23.4 26.625 23.4V26.115C26.625 27.135 25.485 27.75 24.645 27.18L23.19 26.22C23.325 25.755 23.385 25.245 23.385 24.705V18.6C23.385 15.54 21.345 13.5 18.285 13.5H8.09999C7.88999 13.5 7.695 13.515 7.5 13.53V9.375C7.5 5.55 10.05 3 13.875 3H26.625C30.45 3 33 5.55 33 9.375Z" fill="white" stroke="#60CB97" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M23.385 18.6V24.705C23.385 25.245 23.325 25.755 23.19 26.22C22.635 28.425 20.805 29.805 18.285 29.805H14.205L9.675 32.82C9 33.285 8.09999 32.79 8.09999 31.98V29.805C6.56999 29.805 5.295 29.295 4.41 28.41C3.51 27.51 3 26.235 3 24.705V18.6C3 15.75 4.77 13.785 7.5 13.53C7.695 13.515 7.88999 13.5 8.09999 13.5H18.285C21.345 13.5 23.385 15.54 23.385 18.6Z" fill="white" stroke="#60CB97" stroke-width="2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "add" ? "active" : ""; ?>" id="addBtn">
                        <a href="buyer.php?show=add">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M24.285 3H11.715C6.255 3 3 6.255 3 11.715V24.27C3 29.745 6.255 33 11.715 33H24.27C29.73 33 32.985 29.745 32.985 24.285V11.715C33 6.255 29.745 3 24.285 3ZM24 19.125H19.125V24C19.125 24.615 18.615 25.125 18 25.125C17.385 25.125 16.875 24.615 16.875 24V19.125H12C11.385 19.125 10.875 18.615 10.875 18C10.875 17.385 11.385 16.875 12 16.875H16.875V12C16.875 11.385 17.385 10.875 18 10.875C18.615 10.875 19.125 11.385 19.125 12V16.875H24C24.615 16.875 25.125 17.385 25.125 18C25.125 18.615 24.615 19.125 24 19.125Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "products" ? "active" : ""; ?>" id="productsBtn">
                        <a href="buyer.php?show=products">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M24.285 3H11.715C6.255 3 3 6.255 3 11.715V24.285C3 29.745 6.255 33 11.715 33H24.285C29.745 33 33 29.745 33 24.285V11.715C33 6.255 29.745 3 24.285 3ZM14.955 22.35L11.58 25.725C11.355 25.95 11.07 26.055 10.785 26.055C10.5 26.055 10.2 25.95 9.99 25.725L8.865 24.6C8.415 24.165 8.415 23.445 8.865 23.01C9.3 22.575 10.005 22.575 10.455 23.01L10.785 23.34L13.365 20.76C13.8 20.325 14.505 20.325 14.955 20.76C15.39 21.195 15.39 21.915 14.955 22.35ZM14.955 11.85L11.58 15.225C11.355 15.45 11.07 15.555 10.785 15.555C10.5 15.555 10.2 15.45 9.99 15.225L8.865 14.1C8.415 13.665 8.415 12.945 8.865 12.51C9.3 12.075 10.005 12.075 10.455 12.51L10.785 12.84L13.365 10.26C13.8 9.825 14.505 9.825 14.955 10.26C15.39 10.695 15.39 11.415 14.955 11.85ZM26.34 24.93H18.465C17.85 24.93 17.34 24.42 17.34 23.805C17.34 23.19 17.85 22.68 18.465 22.68H26.34C26.97 22.68 27.465 23.19 27.465 23.805C27.465 24.42 26.97 24.93 26.34 24.93ZM26.34 14.43H18.465C17.85 14.43 17.34 13.92 17.34 13.305C17.34 12.69 17.85 12.18 18.465 12.18H26.34C26.97 12.18 27.465 12.69 27.465 13.305C27.465 13.92 26.97 14.43 26.34 14.43Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                    <div class="item <?php echo $_SESSION["show"] === "combinations" ? "active" : ""; ?>" id="combinationsBtn">
                        <a href="buyer.php?show=combinations">
                            <svg width="28" height="28" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M17.91 3.31499L14.295 11.73H10.68C10.08 11.73 9.49505 11.775 8.92505 11.895L10.425 8.29499L10.485 8.15999L10.575 7.91999C10.62 7.81499 10.65 7.72499 10.695 7.64999C12.435 3.61499 14.385 2.35499 17.91 3.31499Z" fill="white"/>
                                <path d="M28.0951 12.135L28.0651 12.12C27.1651 11.865 26.2501 11.73 25.3201 11.73H15.9301L19.3051 3.88503L19.3501 3.78003C19.5601 3.85503 19.7851 3.96003 20.0101 4.03503L23.3251 5.43003C25.1701 6.19503 26.4601 6.99003 27.2551 7.95003C27.3901 8.13003 27.5101 8.29503 27.6301 8.49003C27.7651 8.70003 27.8701 8.91003 27.9301 9.13503C27.9901 9.27003 28.0351 9.39003 28.0651 9.52503C28.2901 10.29 28.3051 11.16 28.0951 12.135Z" fill="white"/>
                                <path d="M27.435 14.28C26.76 14.085 26.055 13.98 25.32 13.98H10.68C9.65999 13.98 8.69999 14.175 7.79998 14.565C5.18999 15.69 3.35999 18.285 3.35999 21.3V24.225C3.35999 24.585 3.38999 24.93 3.43499 25.29C3.76499 30.06 6.31498 32.61 11.085 32.925C11.43 32.97 11.775 33 12.15 33H23.85C29.4 33 32.325 30.36 32.61 25.11C32.625 24.825 32.64 24.525 32.64 24.225V21.3C32.64 17.985 30.435 15.195 27.435 14.28ZM21.75 25.125H14.25C13.635 25.125 13.125 24.615 13.125 24C13.125 23.385 13.635 22.875 14.25 22.875H21.75C22.365 22.875 22.875 23.385 22.875 24C22.875 24.615 22.365 25.125 21.75 25.125Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
            <div class="logout-btn">
                <a class="button" href="logout.php">
                    <img src="public/images/fi-sr-sign-out-alt.svg" alt="">
                </a>
            </div>
        </div>
    </div>

    <div class="main">
        <div class="header">
            <div class="header-wrap">
                <div class="menu-bar">
                    <img src="public/images/fi-sr-bar.svg" alt="">
                </div>
                <div class="header-left">
                    <div class="header-title">
                        <h1 class="m-0">Buyer Page</h1>
                    </div>
                    <div class="header-logo">
                        <img src="public/images/logo-main.svg" alt="">
                    </div>
                </div>
                <div class="header-right">
                    <div class="search">
                        <div class="icon">
                            <img src="public/images/bi_search-heart-fill.svg" alt="">
                        </div>
                        <input class="form-control" type="search" name="" id="" placeholder="Search your query">
                    </div>
                    <div class="notification">
                        <div class="dropdown-icon">
                            <div class="notif-alert" style="display: none;"></div>
                            <img src="public/images/notification-dark.svg" alt="">
                        </div>
                        <div class="notification-menu <?php echo isset($_GET["notif_type"]) ? 'active' : ''; ?>">
                            <div class="load-notifications" style="display: none;">
                                <a href="javascript:void(0);">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" id="reload">
                                        <path d="M21,11a1,1,0,0,0-1,1,8.05,8.05,0,1,1-2.22-5.5h-2.4a1,1,0,0,0,0,2h4.53a1,1,0,0,0,1-1V3a1,1,0,0,0-2,0V4.77A10,10,0,1,0,22,12,1,1,0,0,0,21,11Z"></path>
                                    </svg>
                                    <span>view new projects</span>
                                </a>
                            </div>
                            <div class="notif-header">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="notif-back-btn">
                                        <a href="javascript:void(0);">Back</a>
                                    </div>
                                    <div class="title">
                                        <h5  class="m-0">Notifications</h5>
                                    </div>
                                    <div class=""></div>
                                </div>
                            </div>
                            <div class="notifs">
                                <div class="d-flex align-items-center justify-content-end mr-10 mt-5 mb-5">
                                    <?php 
                                        if(isset($_SESSION["notif_type"]) && $_SESSION["notif_type"] === 'marked') {
                                            ?>
                                                <a href="?notif_type=all">
                                                    <img width="30" src="public/images/star.svg" alt="">
                                                </a>
                                            <?php
                                        }else {
                                            ?>
                                                <a href="?notif_type=marked">
                                                    <img width="30" src="public/images/star-light.svg" alt="">
                                                </a>
                                            <?php
                                        }
                                    ?>
                                </div>
                                <div class="lists-container">
                                    <?php
                                        $notifications = $notifModel->getBuyerNotifications($uid);

                                        if( $notifications) {
                                            foreach($notifications["data"] as $notification) {
                                                // echo json_encode($notification);
                                                ?>
                                                    <div class="list" data-id="<?php echo $notification["offer_id"]; ?>">
                                                        <div class="info d-flex align-items-center justify-content-between">
                                                            <div class="notif-icon">
                                                                <img src="public/images/notification.svg" alt="">
                                                            </div>
                                                            <div class="p-meta">
                                                                <div class="title mb-10">
                                                                    <div class="">
                                                                        <h6><?php echo $notification["project_name"]; ?></h6>
                                                                        <span class="d-block mt-1 text-muted"><b><?php echo $notification["company_name"]; ?></b></span>
                                                                        <span class="text-muted"><b>Postcode:</b> <?php echo $notification["post_code"]; ?></span>
                                                                    </div>
                                                                    <div class="start">
                                                                        <!-- <img class="star-image" width="20" src="public/images/star-light.svg" alt=""> -->
                                                                        <a class="mark-notifications" href="javascript:void(0);" data-id="<?php echo $notification["offer_id"]; ?>">
                                                                            <?php
                                                                                if($notification["is_marked"] === '0') {
                                                                                    ?>
                                                                                        <img class="star-image" width="20" src="public/images/star-light.svg" alt="">
                                                                                    <?php
                                                                                }else {
                                                                                    ?>
                                                                                        <img class="star-image" width="20" src="public/images/star.svg" alt="">
                                                                                    <?php
                                                                                }
                                                                            ?>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                                <div class="desc">
                                                                    <?php
                                                                        $project_id = $notification["project_id"];
                                                                        $productItems = $projectsModel->getProjectItems($project_id);

                                                                        $offer_data = $notification["offer_data"];
                                                                        $dataArray = json_decode($offer_data, true);
                                                                        foreach ($dataArray as $item) {
                                                                            ?>
                                                                                <div class="amount d-flex">
                                                                                    <span class="text-muted mr-10"><?php echo ucfirst($item['product']) ?>:</span>
                                                                                    <b class="text-muted">+£<?php echo number_format($item['price'], 2) ?></b>
                                                                                </div>
                                                                            <?php
                                                                        }
                                                                    ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="msg-area d-flex align-items-center justify-content-between">
                                                            <div class="w-100 d-flex align-items-center justify-content-between">
                                                                <?php
                                                                    if(!empty($notification["attached_file"])) {
                                                                        ?>
                                                                            <div class="add-attachment">
                                                                                <a target="_blank" href="<?php echo $notification["attached_file"]; ?>">Attachment</a>
                                                                            </div>
                                                                        <?php
                                                                    }
                                                                ?>
                                                                <div class="msg" style="<?php echo empty($notification["attached_file"]) ? 'display: flex; width: 100%; justify-content: end;' : '' ?>">
                                                                    <a href="?add-to-chat=<?php echo $notification["seller_id"]; ?>">
                                                                        <img src="public/images/messages.svg" alt="">
                                                                    </a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php
                                            }
                                        }else {
                                            ?>
                                                <div class="text-center mt-50">
                                                    <p class="no-results text-muted">Nothing to see here!</p>
                                                </div>
                                            <?php
                                        }
                                    ?>
                                </div>
                                <div class="">
                                    <?php

                                        if($notifications && $notifications["total"] >= 20) {
                                            ?>
                                                <div class="load-more-notifications">
                                                    <a href="javascript:void(0);">
                                                        <span>Load More</span>
                                                    </a>
                                                </div>
                                            <?php
                                        };
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="profile">
                        <div class="profile-item">
                            <div class="left">
                                <div class="user-name">
                                    <h6><?php echo $_SESSION["userData"]["company_name"]; ?></h6>
                                </div>
                                <div class="profile-nav">
                                    <!-- <p class="m-0"></p> -->
                                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownMenuLink" role="button" data-bs-toggle="dropdown" aria-expanded="false">My Account</a>
                                </div>
                            </div>
                            <div class="right">
                                <div class="profile-image">
                                    <img src="public/images/<?php echo $_SESSION["userData"]["company_logo"]; ?>" alt="">
                                </div>
                            </div>
                        </div>
                        <div class="">
                            <ul class="dropdown-menu header-dropdown-menu" aria-labelledby="navbarDropdownMenuLink">
                                <li>
                                    <a class="dropdown-item" href="logout.php">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 6.35 6.35" id="logout" opacity="0.8">
                                            <path fill-rule="evenodd" d="M7.953.998a3.024 3.024 0 0 0-3.006 3.004V20a3.024 3.024 0 0 0 3.006 3.004h3.994A3.022 3.022 0 0 0 14.951 20v-4.002c0-1.334-2-1.334-2 0V20a.983.983 0 0 1-1.004 1.004H7.953A.983.983 0 0 1 6.95 20V4.002a.983.983 0 0 1 1.004-1.004h3.994a.983.983 0 0 1 1.004 1.004v4.002c0 1.334 2 1.334 2 0V4.002A3.022 3.022 0 0 0 11.947.998H7.953zM1.957 4.984a1 1 0 0 0-1.01 1.02v11.994a1 1 0 0 0 2 0V6.004a1 1 0 0 0-.982-1.02 1 1 0 0 0-.008 0zm16.037 2.004a1 1 0 0 0-.096.004 1 1 0 0 0-.6 1.713L19.595 11h-9.588a1.006 1.006 0 0 0-.104 0c-1.333.07-1.23 2.071.104 2.002h9.582l-2.29 2.287a1 1 0 1 0 1.411 1.418l4.002-4.002a1 1 0 0 0 0-1.41l-4.002-4a1 1 0 0 0-.715-.307z" color="#000" font-family="sans-serif" font-weight="400" overflow="visible" paint-order="stroke fill markers" transform="scale(.26458)" style="line-height:normal;font-variant-ligatures:normal;font-variant-position:normal;font-variant-caps:normal;font-variant-numeric:normal;font-variant-alternates:normal;font-feature-settings:normal;text-indent:0;text-align:start;text-decoration-line:none;text-decoration-style:solid;text-decoration-color:#000;text-transform:none;text-orientation:mixed;shape-padding:0;isolation:auto;mix-blend-mode:normal"></path>
                                        </svg>
                                        <span class="ml-5 text-muted" style="font-weight: 500;">Logout</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="main-content <?php echo $_SESSION["show"] === "home" ? "show_all" : "show_single";  ?>" style="height: calc(100vh - 78px); overflow-y: scroll; overflow-x: hidden;">

            <!-- <a class="btn btn-primary" data-bs-toggle="modal" href="#editProductModal" role="button">Open first modal</a> -->
            <div class="modal fade" id="editProductModal" aria-hidden="true" aria-labelledby="editProductModalLabel" tabindex="-1">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="editProductModalLabel">Edit Product</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body" id="modal-content">
                            <form action="">
                                <div class="form-group mb-20">
                                    <label for="">Project Name</label>
                                    <input type="text" class="form-control" name="project_name" value="<?php echo $project["project_name"]; ?>" required>
                                </div>
                                <div class="form-group mb-20"></div>
                                <label for="">Description:</label>
                                <textarea name="" id="" cols="30" rows="10"></textarea>
                            </form>
                        </div>
                        <!-- <div class="modal-footer"></div> -->
                    </div>
                </div>
            </div>

            <div class="card rounded-0 m-2 mb-0">
                <form action="" method="post" enctype="multipart/form-data">
                    <div class="card-header">
                        <div class="d-flex justify-content-between ">
                            <div class="">
                                <h4 class="d-flex align-items-center gap-2" style="color: #2c2c2c;">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" id="edit"><path d="M5,18H9.24a1,1,0,0,0,.71-.29l6.92-6.93h0L19.71,8a1,1,0,0,0,0-1.42L15.47,2.29a1,1,0,0,0-1.42,0L11.23,5.12h0L4.29,12.05a1,1,0,0,0-.29.71V17A1,1,0,0,0,5,18ZM14.76,4.41l2.83,2.83L16.17,8.66,13.34,5.83ZM6,13.17l5.93-5.93,2.83,2.83L8.83,16H6ZM21,20H3a1,1,0,0,0,0,2H21a1,1,0,0,0,0-2Z"></path></svg>
                                    Add Materials
                                </h4>
                            </div>
                            <div class="">
                                <a href="?action=delete-project&pid=<?php echo $pid; ?>">
                                    <button class="btn btn-danger mr-15" type="button">Delete Project</button>
                                </a>
                                <button class="btn butn-primary" type="submit" name="update_project" value="1">Update and Publish</button>
                            </div>
                        </div>
                    </div>
    
                    <div class="card-body">
                            <?php
                                if(isset($messages)) {
                                    ?>
                                        <div class="alert alert-<?php echo $messages["status"]; ?> alert-dismissible fade show mb-15" role="alert">
                                            <?php echo $messages["message"]; ?>
                                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                        </div>
                                    <?php
                                }
                            ?>
                            <div class="row">
                                <div class="col-sm-12 col-md-6">
                                    <?php
                                        if(isset($_GET["status"]) && isset($_GET["message"])) {
                                            ?>
                                                <div class="alert alert-<?php echo $_GET["status"]; ?> alert-dismissible fade show mb-25" role="alert">
                                                    <?php echo $_GET["message"]; ?>
                                                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                                </div>
                                            <?php
                                        }
                                    ?>
                                    
                                    <div class="card rounded-0 m-1">
                                        <div class="card-header">
                                            Project Details
                                        </div>
                                        <div class="card-body">
                                            
                                                <input type="hidden" name="pid" value="<?php echo $pid; ?>">
                                                <div class="form-group mb-20">
                                                    <label for="">Project Name</label>
                                                    <input type="text" class="form-control" name="project_name" value="<?php echo $project["project_name"]; ?>" required>
                                                </div>
                                                <div class="form-group">
                                                    <label for="">Postcode</label>
                                                    <input type="text" class="form-control" name="post_code" value="<?php echo $project["post_code"]; ?>" required>
                                                </div>
                                            
                                        </div>
                                    </div>
                                </div>
        
                                <div class="col-sm-12 col-md-6">
                                    <div class="card rounded-0 m-1 mb-3">
                                                
                                        <div class="card-header">
                                            Products
                                        </div>
                                        <div class="card-body" style="max-height: calc(100vh - 212px); overflow: scroll; overflow-x: hidden;">
                                            <table class="table table-hover">
                                                <?php
                                                    $projectItems = $projectsModel->getProjectItems($pid);
                                                    
                                                    if($projectItems) {
                                                        foreach($projectItems as $index => $item) {
                                                            $edit_data = json_decode($item["edit_data"], true);
                                                            ?>
                                                                <tr>
                                                                    <td>
                                                                        <?php echo $item["product_type"]; ?>
                                                                        <input type="hidden" name="item_id[]" value="<?php echo $item["id"]; ?>">
                                                                    </td>
                                                                    <td>
                                                                        <div style="text-align: end;">
                                                                            <a href="?action=delete-material&pid=<?php echo $pid; ?>&item_id=<?php echo $item["id"]; ?>">Delete</a>
                                                                        </div>
                                                                        <div class="form-group product-list mb-15">
                                                                            <label for="">Description</label>
                                                                            <textarea style="height: 100px;" class="form-control" name="description[]" id="" cols="30" rows="5"><?php echo $edit_data ? $edit_data["description"] : $item["description"]; ?></textarea>
                                                                        </div>
                                                                        <div class="row">
                                                                            <div class="col-6">
                                                                                <div class="form-group product-list mb-15">
                                                                                    <label for="">Quantity</label>
                                                                                    <input class="form-control" type="text" name="quantity[]" value="<?php echo $edit_data ? $edit_data["quantity"] : $item["quantity"]; ?>" id="">
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-6">
                                                                                <div class="form-group product-list mb-15">
                                                                                    <label for="">Unit</label>
                                                                                    <input class="form-control" type="text" name="unit[]" value="<?php echo $edit_data ? $edit_data["unit"] : $item["unit"]; ?>" id="">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="form-group product-list mb-15">
                                                                            <label for="">Date Required</label>
                                                                            <input class="form-control" type="text" name="date_required[]" value="<?php echo $edit_data ? $edit_data["date_required"] : $item["date_required"]; ?>" id="">
                                                                        </div>
                                                                        <div class="form-group product-list mb-15">
                                                                            <label class="d-block" for="">Attach File</label>
                                                                            <input type="file" name="product_image[]" id="">
                                                                        </div>
                                                                        <div class="form-group product-list mb-15">
                                                                            <label for="">Open To Similar Brands:</label>
                                                                            <?php
                                                                                $open_to_similar_brands = $item["open_to_similar_brands"];
                                                                                if($edit_data) {
                                                                                    $open_to_similar_brands = $edit_data["open_to_similar_brands"];
                                                                                }
                                                                            ?>
                                                                            <input type="radio" name="open_to_similar_brands[<?php echo $index; ?>]" value="yes" <?php echo $open_to_similar_brands === "yes" ? "checked" : ""; ?>> Yes
                                                                            <input type="radio" name="open_to_similar_brands[<?php echo $index; ?>]" value="no" <?php echo $open_to_similar_brands === "no" ? "checked" : ""; ?>> No
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            <?php
                                                        }
                                                    }else {
                                                        ?>
                                                            <span class="no-offer-msg mt-5 text-center text-muted" style="display: block;">No product available!</span>
                                                            <input type="hidden" name="empty_material" value="1">
                                                        <?php
                                                    }
                                                ?>
                                            </table>
                                        </div>
                                    </div>
    
                                    <!-- Add New Material -->
                                    <div class="card rounded-0 m-1">
                                        <div class="card-header">Add Materials</div>
                                        <div class="card-body">
                                            <div class="form-group product-list mb-20">
                                                <label for="">Product Name</label>
                                                <select class="form-control" name="new_product_name">
                                                    <?php
                                                        $products = $productModel->getAllProducts();
        
                                                        if($products) {
                                                            foreach($products as $product) {
                                                                echo '<option value="'. strtolower($product["name"]). '">'. $product["name"]. '</option>';
                                                            }
                                                        }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="form-group mb-20">
                                                <label for="">Description</label>
                                                <textarea name="new_description" class="form-control" style="height: 100px" id="" cols="30" rows="10"></textarea>
                                            </div>
                                            <div class="row">
                                                <div class="col-6">
                                                    <div class="form-group mb-20">
                                                        <label for="">Quantity</label>
                                                        <input type="number" class="form-control" name="new_quantity" value="">
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="form-group mb-20">
                                                        <label for="">Unit</label>
                                                        <input type="number" class="form-control" name="new_unit" value="">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group mb-20">
                                                <label for="">Date Required</label>
                                                <input type="text" class="form-control" name="new_date_required" value="">
                                            </div>
                                            <div class="form-group mb-20">
                                                <label class="d-block" for="">Attach a photo of the materials to illustrate how you expect them to look</label>
                                                <input type="file" class="" name="new_product_image">
                                            </div>
                                            <div class="form-group">
                                                <div class="box-sm" style="border: 1px solid #e1e1e1; border-radius: 15px; padding: 15px;">
                                                    <span>are you open to similar brands?</span>
                                                    <div class="mt-15" style="display: flex; gap: 10px;">
                                                        <a href="javascript:void(0);" style="border: 1px solid #e1e1e1; padding: 2px 8px; text-decoration: none; border-radius: 8px; display: flex; gap: 5px;">
                                                            <label for="yes" style="display: flex; align-items: center; gap: 5px; margin: 0;">
                                                                <input type="radio" name="new_open_to_similar_brands" value="yes" id="yes" checked> Yes
                                                            </label>
                                                        </a>
                                                        <a href="javascript:void(0);" style="border: 1px solid #e1e1e1; padding: 2px 8px; text-decoration: none; border-radius: 8px; display: flex; gap: 5px;">
                                                            <label for="no" style="display: flex; align-items: center; gap: 5px; margin: 0;">
                                                                <input type="radio" name="new_open_to_similar_brands" value="no" id="no"> No
                                                            </label>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="card-footer" style="text-align: right;">
                                            <button class="btn butn-primary" type="submit" name="add_material" value="1">Add Material</button>
                                            <button class="btn butn-primary" type="submit" name="update_project" value="1">Update and Publish</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
    include './templates/footer.php';
?>

<script>
    $(document).ready(function() {
        $(".menu-bar").click(function() {
            $(".sidebar").toggleClass("active");
        });

        $(".profile-item").click(function() {
            $(".header-dropdown-menu").toggle();
        });

        setInterval(function(){

            checkNewNotifications();
        }, 1500);

        $(".load-notifications a").click(function(){
            // $(".load-notifications").hide();
            updateNewNotifications();
        });

        $(".notif-back-btn").click(function() {
            $(".notification-menu").removeClass("active");
        });

        $(".load-more-notifications").click(function() {
            let last_id = $(".notifs .list").last().data("id");

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "loadMoreBuyerNotifications",
                    last_id: last_id
                },
                success: function(data) {
                    let res = JSON.parse(data);

                    if(res.has_result) {
                        $(".notifs .lists-container").append(res.data);

                        if(res.total < 10)  {
                            $(".load-more-notifications").hide();
                        }
                    }
                }
            });
        });

        $(".dropdown-icon").click(function() {
            updateNewNotifications();

            $(".notification-menu").toggleClass("active");
        });

        function checkNewNotifications() {
            // console.log("Checking new notifications");

            let first_id = $(".notifs .list").first().data("id");

            if(!first_id) {
                first_id = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "checkNewBuyerNotifications",
                    first_id: first_id
                },
                success: function(data) {
                    // console.log(data);
                    let res = JSON.parse(data);

                    if(res.is_found == true) {
                        $(".load-notifications").show();
                        $(".notif-alert").show();
                    }else {
                        // console.log("not new notifications found");
                    }
                    // data && $(".chat-history ul li").append(data);
                }
            });
        }

        function updateNewNotifications() {
            // console.log("Checking new notifications");
            let last_id = $(".notifs .list").first().data("id");

            if(!last_id) {
                last_id = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "getNewBuyerNotifications",
                    last_id: last_id
                },
                success: function(data) {
                    console.log(data);
                    let res = JSON.parse(data);

                    if(res.status == 'success') {
                        $(".no-results").hide();
                        res.data && $(".notifs").prepend(res.data);

                        $(".load-notifications").hide();
                        $(".notif-alert").hide();
                    }
                }
            });
        }

        $(document).on('click','.mark-notifications', function() {
            let offer_id = $(this).data("id");
            var imgElement = $(this).find("img");

            let src = imgElement.attr("src");

            let type = 1;
            if(src === 'public/images/star.svg') {
                type = 0;
            }

            jQuery.ajax({
                type: "POST",
                url: "app/core/notifications.php",
                data: {
                    action: "markBuyerNotification",
                    offer_id: offer_id,
                    type: type
                },
                success: function(data) {
                    // console.log(data);
                    // let res = JSON.parse(data);

                    if(type === 1) {
                        imgElement.attr('src', 'public/images/star.svg');
                    }else {
                        imgElement.attr('src', 'public/images/star-light.svg');
                    }
                }
            });
        });

        $('.edit-product').on('click', function() {
            let itemId = $(this).data('id');

            $.ajax({
                url: 'app/core/products.php',
                data: {
                    action: 'getProductItem',
                    id: itemId
                },
                type: 'POST',
                success: function(data) {
                    var responseData = JSON.parse(data);

                    $('#modal-content').html(`
                        <form action="" method="post">
                            <input type="hidden" name="pid" value="${responseData.project_id}">
                            <input type="hidden" name="item_id" value="${responseData.id}">
                            <div class="form-group mb-20">
                                <label for="">Product Name:</label>
                                <input type="text" class="form-control" value="${responseData.product_type}" disabled>
                            </div>
                            <div class="form-group mb-20">
                                <label for="">Description:</label>
                                <textarea style="height: 150px;" name="description" class="form-control">${responseData.description}</textarea>
                            </div>
                            <div class="form-group mb-20">
                                <button class="btn btn-primary" type="submit" name="update_product" value="1">Update</button>
                            </div>
                        </form>
                    `);

                    $('#editProductModal').modal('show');
                }
            });
        });
    });
</script>