<?php
    class notifications {
        // DB Stuff
        protected $connect;

        public function __construct() {
            // $DB = new Database();
            $this->connect = (new Database())->getConnection();
        }

        public function getNotification($id) {
            $result = $this->connect->query("SELECT * FROM `notifications` WHERE `id` = $id");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);

                return true;
            }
            return false;
        }

        public function offerPrice($seller_id, $project_id, $notif_id, $offer_data, $file) {
            $insert = $this->connect->query("INSERT INTO `price_offers` (`seller_id`, `project_id`, `notif_id`, `offer_data`, `attached_file`, `version`) VALUES ('$seller_id', '$project_id', '$notif_id', '$offer_data', '$file', '2');");
            // $insert = true;
            if($insert) {
                $lastInsertedId = $this->connect->lastInsertId();

                return array("status" => "success", "offer_id" => $lastInsertedId);
            }
            return false;
        }

        public function addToOfferItems($offer_id, $seller_id, $project_id, $item_id, $product_id, $product_name, $product_price, $vat, $delivery_price, $delivery_date, $payment_term, $bid_currency) {
            $insert = $this->connect->query("INSERT INTO `offer_items` (`offer_id`, `seller_id`, `project_id`, `item_id`, `product_id`, `product_name`, `product_price`, `vat`, `delivery_price`, `delivery_date`, `payment_term`, `bid_currency`) VALUES ('$offer_id', '$seller_id', '$project_id', '$item_id', '$product_id', '$product_name', '$product_price', '$vat', '$delivery_price', '$delivery_date', '$payment_term', '$bid_currency');");

            if($insert) {
                $lastInsertedId = $this->connect->lastInsertId();

                // return true;
                return array("status" => "success", "item_id" => $lastInsertedId);
            }
            return false;
        }

        public function updateOfferItem($offer_item_id, $item_id, $product_price, $vat, $delivery_price, $delivery_date, $payment_term, $is_editable = '0', $bid_currency) {
            $result = $this->connect->query("UPDATE `offer_items` SET `product_price` = '$product_price', `vat` = '$vat', `delivery_price` = '$delivery_price', `delivery_date` = '$delivery_date', `payment_term` = '$payment_term', `is_editable` = '$is_editable', `bid_currency` = '$bid_currency' WHERE `id` = $offer_item_id AND `item_id` = $item_id");
            if ($result) {
                return true;
            }
            return false;
        }
        public function updateOfferItemUpdate($item_id, $product_price, $vat, $delivery_price, $delivery_date, $payment_term, $bid_currency) {
            $query = "UPDATE `offer_items` 
                      SET `product_price` = :product_price, 
                          `vat` = :vat, 
                          `delivery_price` = :delivery_price, 
                          `delivery_date` = :delivery_date, 
                          `bid_currency` = :bid_currency, 
                          `payment_term` = :payment_term 
                      WHERE `item_id` = :item_id";
        
            $stmt = $this->connect->prepare($query);
            
            $stmt->bindParam(':product_price', $product_price);
            $stmt->bindParam(':vat', $vat);
            $stmt->bindParam(':delivery_price', $delivery_price);
            $stmt->bindParam(':delivery_date', $delivery_date);
            $stmt->bindParam(':payment_term', $payment_term);
            $stmt->bindParam(':item_id', $item_id, PDO::PARAM_INT);
        
            if ($stmt->execute()) {
                return true;
            }
            return false;
        }
        

        public function checkOffer($seller_id, $notif_id) {
            $result = $this->connect->query("SELECT * FROM `price_offers` WHERE `seller_id` = $seller_id AND `notif_id` = $notif_id");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);

                return array("status" => "success", "result" => $res);
            }
            return array("status" => "error");
        }

        public function getOfferItemsByOfferId($offer_id, $seller_id) {
            $result = $this->connect->query("SELECT * FROM `offer_items` WHERE `offer_id` = $offer_id AND `seller_id` = $seller_id");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);

                return $res;
            }
            return false;
        }

        public function getOfferItemB($offer_id, $product_name, $seller_id) {

        }

        public function deletePriceOffer($offer_id) {
            $result = $this->connect->query("DELETE FROM `price_offers` WHERE `offer_id` = $offer_id");
            
            if($result) {
                return true;
            }
            return false;
        }
        public function deleteOfferItems($offer_id, $seller_id) {
            $result = $this->connect->query("DELETE FROM `offer_items` WHERE `offer_id` = $offer_id AND `seller_id` = $seller_id");
            
            if($result) {
                return true;
            }
            return false;
        }

        public function updateStatus($notif_id) {
            $result = $this->connect->query("UPDATE `notifications` SET `status` = '1' WHERE id = $notif_id;");

            if($result) {
                return true;
            }
            return false;
        }

        public function readAll($uid) {
            $result = $this->connect->query("UPDATE `notifications` SET `status` = '1' WHERE sent_to = $uid;");

            if($result) {
                return true;
            }
            return false;
        }

        public function getUnreadMessages($uid) {
            $unreadNotifications = $this->connect->query("SELECT * FROM `notifications` WHERE `sent_to` = '$uid' AND `status` = '0'");

            $response = array(
                'status' => 'success',
                'unread' => $unreadNotifications->rowCount()
            );

            return $response;
        }

        public function markNotification($user_id, $notif_id, $type) {
            $result = $this->connect->query("UPDATE `notifications` SET `is_marked` = '$type' WHERE id = $notif_id and sent_to = $user_id;");
        
            if($result) {
                return true;
            }
            return false;
        }

        public function getSellerNotifications($uid) {
            $totalNotifications = $this->connect->query("SELECT * FROM notifications WHERE `sent_to` = '$uid'");

            $query = "SELECT 
                    n.*,
                    p.buyer_id,
                    p.post_code,
                    p.is_deleted,
                    p.updated_on,
                    p.is_completed,
                    p.seller_id,
                    u.company_name
                FROM 
                    notifications n
                JOIN 
                    projects p ON n.project_id = p.id
                JOIN 
                    users u ON u.user_id = p.buyer_id
                WHERE 
                    n.sent_to = '$uid'";

            if($_SESSION["notif_type"] === 'marked') {
                $query .= "AND n.is_marked = '1'";
            }

            $query .= "ORDER BY n.id DESC LIMIT 30;";
            

            $result = $this->connect->query($query);

            if ($result->rowCount() > 0) {
                $notifications = $result->fetchAll(PDO::FETCH_ASSOC);

                $response = array(
                    'total' => $totalNotifications->rowCount(),
                    'data' => $notifications
                );

                return $response;
            }
            return false;
        }

        public function checkSellerNotifications($uid, $last_id) {
            // $result = $this->connect->query("SELECT * FROM notifications WHERE id > $last_id AND `sent_to` = 'seller' ORDER BY id DESC");
            $query = "SELECT 
                    n.*,
                    p.buyer_id
                FROM 
                    notifications n
                JOIN 
                    projects p ON n.project_id = p.id
                WHERE 
                    n.sent_to = '$uid' AND 
                    p.is_deleted = '0' AND
                    n.id > $last_id";

            if($_SESSION["notif_type"] === 'marked') {
                $query .= " AND n.is_marked = '1'";
            }

            $query .= " ORDER BY n.id DESC;";

            $result = $this->connect->query($query);



            if ($result->rowCount() > 0) {
                return true;
            }

            return false;
        }

        public function loadMoreNotifications($user_id, $last_id) {
            // $result = $this->connect->query("SELECT * FROM notifications WHERE id > 1 ORDER BY id DESC Limit 10");
            $query = "SELECT 
                    n.*,
                    p.buyer_id,
                    p.post_code,
                    p.open_to_similar_brands,
                    p.is_deleted,
                    p.updated_on,
                    u.company_name
                FROM 
                    notifications n
                JOIN 
                    projects p ON n.project_id = p.id
                JOIN 
                    users u ON u.user_id = p.buyer_id
                WHERE 
                    n.sent_to = '$user_id' AND
                    p.is_deleted = '0' AND
                    n.id < $last_id";

            if($_SESSION["notif_type"] === 'marked') {
                $query .= " AND n.is_marked = '1'";
            }

            $query .= " ORDER BY n.id DESC LIMIT 10;";

            $result = $this->connect->query($query);

            if ($result->rowCount() > 0) {
                $notifications = $result->fetchAll(PDO::FETCH_ASSOC);

                $data = '';
                foreach($notifications as $notification) {
                    $project_id = $notification["project_id"];
                    $productItems = $this->getProjectItems($project_id);

                    $priceInput = '';
                    foreach($productItems as $item) {
                        $priceInput .= '<div class="mt-5 d-flex align-items-center justify-content-between" style="gap: 12px; padding: 15px 0; border-bottom: 1px solid #eee; margin-left: -15px;">
                            <div class="vat-toggle-switch">
                                <label class="switch switch-green">
                                    <input type="checkbox" name="vat_input[]" class="switch-input">
                                    <span class="switch-label" data-on="With VAT" data-off="Without VAT"></span>
                                    <span class="switch-handle"></span>
                                </label>
                            </div>
                        
                            <div class="price" style="max-width: 235px;">
                                <input type="hidden" name="item_id[]" value="'.$item["id"].'">
                                <input type="hidden" name="product_type[]" value="'.$item["product_type"].'">
                                <div class="row">
                                    <div class="col-6 p-0">
                                        <div class="p-1">
                                            <input type="number" name="product_price[]" id="priceInput" placeholder="Enter Price">
                                        </div>
                                    </div>
                                    <div class="col-6 p-0">
                                        <div class="p-1">
                                            <input type="number" name="delivery_price[]" id="priceInput" placeholder="Delivery Price">
                                        </div>
                                    </div>
                                    <div class="col-12 mb-10 mt-10 p-0">
                                        <small class="d-block text-muted mb-5">Total price for required quantity</small>
                                        <input type="number" name="total_price[]" id="priceInput" placeholder="Total Price" readonly>
                                    </div>
                                    <div class="col-6 p-0">
                                        <div class="p-1">
                                            <input type="text" name="delivery_date[]" id="priceInput" placeholder="Delivery Date">
                                        </div>
                                    </div>
                                    <div class="col-6 p-0">
                                        <div class="p-1">
                                            <input type="text" name="payment_term[]" id="priceInput" placeholder="Payment Term">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>';
                    }

                    $description = '';
                    foreach($productItems as $item) {
                        $open_to_similar_brands = '<span class="badge bg-danger">No</span>';
                        if($item["open_to_similar_brands"] === 'yes') {
                            $open_to_similar_brands = '<span class="badge bg-warning">Yes</span>';
                        }

                        $quantity = '';
                        $unit = '';
                        $date_required = '';

                        if($item["quantity"]) {
                            $quantity = '<p><b>Quantity: </b> '.$item["quantity"].'</p>';
                        }
                        if($item["unit"]) {
                            $unit = '<p><b>Unit: </b> '.$item["unit"].'</p>';
                        }
                        if($item["date_required"]) {
                            $date_required = '<p><b>Date Required: </b> '.$item["date_required"].'</p>';
                        }

                        $description .= '<li>
                            <h6 class="mb-0">'.ucfirst($item["product_type"]).'</h6>
                            <p><b>Description: </b> '.$item["description"].'</p>
                            <div class="d-flex; align-items-center">
                                <small class="mr-5 text-muted">Open To Similar Brands: </small>
                                '.$open_to_similar_brands.'
                            </div>
                            '.$quantity.'
                            '.$unit.'
                            '.$date_required.'
                            '.$priceInput.'
                        </li>';
                    }

                    

                    $star = '<img class="star-image" width="20" src="public/images/star-light.svg" alt="">';
                    if($notification["is_marked"] === '1') {
                        $star .= '<img class="star-image" width="20" src="public/images/star.svg" alt="">';
                    }

                    $updateStatus = '';
                    if($notification["updated_on"] && $notification["is_deleted"] !== '1') {
                        $updateStatus = '<div class="mb-20 d-flex align-items-center">
                            <img width="20" style="opacity: 0.7;" src="public/images/edit.svg" alt="">
                            <span class="text-muted ml-10"><i>This one edited by the buyer</i></span>
                        </div>';
                        ?>
                            
                        <?php
                    }

                    $is_deleted = '';
                    if($notification["is_deleted"] === '1') {
                        $is_deleted = '<div class="mb-15">
                            <img width="30" src="public/images/group-64304.png" alt="">
                            <span style="color: #df3079">This one is not Relevant</span>
                        </div>';
                    }
                    
                    $data .= '<div class="list" data-id="'.$notification["id"].'" data-project="'.$notification["project_id"].'">
                        <div class="info">
                            <div class="p-meta">
                                <div class="d-flex justify-content-between">
                                    <div class="title">
                                        '.$updateStatus.'
                                        '.$is_deleted.'
                                        <div class="d-flex gap-3 align-items-center">
                                            <div class="notif-icon">
                                                <img src="public/images/notification.svg" alt="">
                                            </div>
                                            <div class="">
                                                <h6>'.$notification["title"].'</h6>
                                                <p class="mb-0 fw-normal text-muted hide-company-name"><b>'.$notification["company_name"].'</b></p>
                                                <p class="mb-0 fw-normal text-muted"><b>Postcode:</b> '.$notification["post_code"].'</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="star">
                                        <a class="mark-notifications" href="javascript:void(0);" data-id="'.$notification["id"].'">
                                            '.$star.'
                                        </a>
                                    </div>
                                </div>
                                <div class="desc">
                                    <ol class="mb-0" style="padding-left: 15px;">
                                        '.$description.'
                                    </ol>
                                </div>
                            </div>
                        </div>
                        <div class="msg-area">
                            <div class="form-wrapper">
                                <div class="form-content">
                                    <div class="mt-5 d-flex align-items-center justify-content-between">
                                        <div class="msg">
                                            <a href="?show=home&add-to-chat='.$notification["buyer_id"].'">
                                                <img src="public/images/messages-3.svg" alt="">
                                                Send Message
                                            </a>
                                        </div>
                                        <div class="w-100">
                                            <div class="w-100 mb-5 d-flex gap-2 offer-contents">
                                                <div class="add-attachment">
                                                    <label for="file-input-'.$project_id.'">
                                                        <input type="file" id="file-input-'.$project_id.'" class="file-input" accept="image/*, application/pdf">
                                                        <span id="file-text">Add Attachment</span>
                                                    </label>
                                                </div>
                                                <span class="file-contents">Show</span>
                                            </div>
                                            <div class="w-100 btn-submit-price">
                                                <button><img src="public/images/fi-sr-paper-plane.svg" alt="">Send Now</button>
                                                <div class="loading" style="display: none">
                                                    <svg width="30" version="1.1" id="L4" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 0 0" xml:space="preserve">
                                                        <circle fill="#000" stroke="none" cx="6" cy="50" r="6">
                                                            <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.1"></animate>    
                                                        </circle>
                                                        <circle fill="#000" stroke="none" cx="26" cy="50" r="6">
                                                            <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.2"></animate>       
                                                        </circle>
                                                        <circle fill="#000" stroke="none" cx="46" cy="50" r="6">
                                                            <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.3"></animate>     
                                                        </circle>
                                                    </svg>
                                                </div>
                                                <div class="check-icon" style="display: none;">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256" id="check" style="width: 28px;">
                                                        <rect width="25" height="25" fill="none"></rect><polyline fill="none" stroke="#60cb97" stroke-linecap="round" stroke-linejoin="round" stroke-width="24" points="216 72.005 104 184 48 128.005"></polyline>
                                                    </svg>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>';
                }
                
                $response = array(
                    'has_result' => true,
                    'total' => $result->rowCount(),
                    'data' => $data
                );

                return $response;
            }
            return false;
        }

        public function getNewSellerNotifications($user_id, $last_id) {

            $query = "SELECT 
                    n.*,
                    p.buyer_id,
                    p.post_code,
                    p.open_to_similar_brands,
                    u.company_name
                FROM 
                    notifications n
                JOIN 
                    projects p ON n.project_id = p.id
                JOIN 
                    users u ON u.user_id = p.buyer_id
                WHERE 
                    n.sent_to = '$user_id' AND 
                    p.is_deleted = '0' AND
                    n.id > $last_id";
            
            if($_SESSION["notif_type"] === 'marked') {
                $query .= " AND n.is_marked = '1'";
            }

            $query .= " ORDER BY n.id DESC LIMIT 10;";
            
            $result = $this->connect->query($query);

            if ($result->rowCount() > 0) {
                $notifications = $result->fetchAll(PDO::FETCH_ASSOC);

                $data = '';
                foreach($notifications as $notification) {
                    $project_id = $notification["project_id"];
                    $productItems = $this->getProjectItems($project_id);

                    $priceInput = '';
                    foreach($productItems as $item) {
                        $priceInput .= '<div class="mt-5 d-flex align-items-center justify-content-between" style="gap: 12px; padding: 15px 0; border-bottom: 1px solid #eee; margin-left: -15px;">
                            <div class="vat-toggle-switch">
                                <label class="switch switch-green">
                                    <input type="checkbox" name="vat_input[]" class="switch-input">
                                    <span class="switch-label" data-on="With VAT" data-off="Without VAT"></span>
                                    <span class="switch-handle"></span>
                                </label>
                            </div>

                            <div class="price" style="max-width: 235px;">
                                <input type="hidden" name="item_id[]" value="'.$item["id"].'">
                                <input type="hidden" name="product_type[]" value="'.$item["product_type"].'">
                                <div class="row">
                                    <div class="col-6 p-0">
                                        <div class="p-1">
                                            <input type="number" name="product_price[]" id="priceInput" placeholder="Enter Price">
                                        </div>
                                    </div>
                                    <div class="col-6 p-0">
                                        <div class="p-1">
                                            <input type="number" name="delivery_price[]" id="priceInput" placeholder="Delivery Price">
                                        </div>
                                    </div>
                                    <div class="col-12 mb-10 mt-10 p-0">
                                        <small class="d-block text-muted mb-5">Total price for required quantity</small>
                                        <input type="number" name="total_price[]" id="priceInput" placeholder="Total Price" readonly>
                                    </div>
                                    <div class="col-6 p-0">
                                        <div class="p-1">
                                            <input type="text" name="delivery_date[]" id="priceInput" placeholder="Delivery Date">
                                        </div>
                                    </div>
                                    <div class="col-6 p-0">
                                        <div class="p-1">
                                            <input type="text" name="payment_term[]" id="priceInput" placeholder="Payment Term">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>';
                    }

                    $description = '';
                    foreach($productItems as $item) {
                        $open_to_similar_brands = '<span class="badge bg-danger">No</span>';
                        if($item["open_to_similar_brands"] === 'yes') {
                            $open_to_similar_brands = '<span class="badge bg-warning">Yes</span>';
                        }

                        $quantity = '';
                        $unit = '';
                        $date_required = '';

                        if($item["quantity"]) {
                            $quantity = '<p><b>Quantity: </b> '.$item["quantity"].'</p>';
                        }
                        if($item["unit"]) {
                            $unit = '<p><b>Unit: </b> '.$item["unit"].'</p>';
                        }
                        if($item["date_required"]) {
                            $date_required = '<p><b>Date Required: </b> '.$item["date_required"].'</p>';
                        }

                        $description .= '<li>
                            <h6 class="mb-0">'.ucfirst($item["product_type"]).'</h6>
                            <p><b>Description: </b> '.$item["description"].'</p>
                            <div class="d-flex; align-items-center">
                                <small class="mr-5 text-muted">Open To Similar Brands: </small>
                                '.$open_to_similar_brands.'
                            </div>
                            '.$quantity.'
                            '.$unit.'
                            '.$date_required.'
                            <div class="mt-5 d-flex align-items-center justify-content-between" style="gap: 12px; padding: 15px 0; border-bottom: 1px solid #eee; margin-left: -15px;">
                                <div class="vat-toggle-switch">
                                    <label class="switch switch-green">
                                        <input type="checkbox" name="vat_input[]" class="switch-input">
                                        <span class="switch-label" data-on="With VAT" data-off="Without VAT"></span>
                                        <span class="switch-handle"></span>
                                    </label>
                                </div>

                                <div class="price" style="max-width: 235px;">
                                    <input type="hidden" name="item_id[]" value="'.$item["id"].'">
                                    <input type="hidden" name="product_type[]" value="'.$item["product_type"].'">
                                    <div class="row">
                                        <div class="col-6 p-0">
                                            <div class="p-1">
                                                <input type="number" name="product_price[]" id="priceInput" placeholder="Enter Price">
                                            </div>
                                        </div>
                                        <div class="col-6 p-0">
                                            <div class="p-1">
                                                <input type="number" name="delivery_price[]" id="priceInput" placeholder="Delivery Price">
                                            </div>
                                        </div>
                                        <div class="col-12 mb-10 mt-10 p-0">
                                            <small class="d-block text-muted mb-5">Total price for required quantity</small>
                                            <input type="number" name="total_price[]" id="priceInput" placeholder="Total Price" readonly>
                                        </div>
                                        <div class="col-6 p-0">
                                            <div class="p-1">
                                                <input type="text" name="delivery_date[]" id="priceInput" placeholder="Delivery Date">
                                            </div>
                                        </div>
                                        <div class="col-6 p-0">
                                            <div class="p-1">
                                                <input type="text" name="payment_term[]" id="priceInput" placeholder="Payment Term">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>';
                    }
                    
                    $data .= '<div class="list" data-id="'.$notification["id"].'" data-project="'.$notification["project_id"].'">
                        <div class="info">
                            <div class="p-meta">
                                <div class="d-flex justify-content-between">
                                    <div class="title">
                                        <div class="d-flex gap-3 align-items-center">
                                            <div class="notif-icon">
                                                <img src="public/images/notification.svg" alt="">
                                            </div>
                                            <div class="">
                                                <h6>'.$notification["title"].'</h6>
                                                <p class="mb-0 fw-normal text-muted hide-company-name"><b>'.$notification["company_name"].'</b></p>
                                                <p class="mb-0 fw-normal text-muted"><b>Postcode:</b> '.$notification["post_code"].'</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="star">
                                        <a class="mark-notifications" href="javascript:void(0);" data-id="'.$notification["id"].'">
                                            <img class="star-image" width="20" src="public/images/star-light.svg" alt="">
                                        </a>
                                    </div>
                                </div>
                                <div class="desc">
                                    <ol class="mb-0" style="padding-left: 15px;">
                                        '.$description.'
                                    </ol>
                                </div>
                            </div>
                        </div>
                        <div class="msg-area">
                            <div class="form-wrapper">
                                <div class="mt-5 d-flex align-items-center justify-content-between" style="gap: 15px;">
                                    <div class="msg">
                                        <a href="?show=home&add-to-chat='.$notification["buyer_id"].'">
                                            <img src="public/images/messages-3.svg" alt="">
                                            Send Message
                                        </a>
                                    </div>
                                    <div class="w-100">
                                        <div class="w-100 mb-5 d-flex gap-2 offer-contents">
                                            <div class="add-attachment">
                                                <label for="file-input-'.$project_id.'">
                                                    <input type="file" id="file-input-'.$project_id.'" class="file-input" accept="image/*, application/pdf">
                                                    <span id="file-text">Add Attachment</span>
                                                </label>
                                            </div>
                                            <span class="file-contents">Show</span>
                                        </div>
                                        <div class="w-100 btn-submit-price">
                                            <button><img src="public/images/fi-sr-paper-plane.svg" alt="">Send Now</button>
                                            <div class="loading" style="display: none">
                                                <svg width="30" version="1.1" id="L4" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 0 0" xml:space="preserve">
                                                    <circle fill="#000" stroke="none" cx="6" cy="50" r="6">
                                                        <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.1"></animate>    
                                                    </circle>
                                                    <circle fill="#000" stroke="none" cx="26" cy="50" r="6">
                                                        <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.2"></animate>       
                                                    </circle>
                                                    <circle fill="#000" stroke="none" cx="46" cy="50" r="6">
                                                        <animate attributeName="opacity" dur="1s" values="0;1;0" repeatCount="indefinite" begin="0.3"></animate>     
                                                    </circle>
                                                </svg>
                                            </div>
                                            <div class="check-icon" style="display: none;">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256" id="check" style="width: 28px;">
                                                    <rect width="25" height="25" fill="none"></rect><polyline fill="none" stroke="#60cb97" stroke-linecap="round" stroke-linejoin="round" stroke-width="24" points="216 72.005 104 184 48 128.005"></polyline>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>';
                }

                $response = array(
                    'status' => "success",
                    'total' => $result->rowCount(),
                    'data' => $data
                );

                return $response;
            }
            return false;
        }

        public function deleteSellerNotification($id, $seller_id) {
            $result = $this->connect->query("DELETE FROM `notifications` WHERE id = $id AND sent_to = $seller_id");

            if($result) {
                $res = $this->connect->query("SELECT * FROM `price_offers` WHERE notif_id = $id AND seller_id = $seller_id LIMIT 1");
                if ($res->rowCount() > 0) {
                    $offerData = $res->fetch(PDO::FETCH_ASSOC);

                    $offer_id = $offerData["offer_id"];
                    $result = $this->connect->query("DELETE FROM `price_offers` WHERE notif_id = $id AND seller_id = $seller_id");
                    $result = $this->connect->query("DELETE FROM `offer_items` WHERE offer_id = $offer_id AND seller_id = $seller_id");
                }

                return true;
            }
            return false;
        }

        // duplicate
        public function getProjectItems($product_id) {
            $result = $this->connect->query("SELECT * FROM `project_items` WHERE project_id = $product_id;");

            if ($result->rowCount() > 0) {
                $res = $result->fetchAll(PDO::FETCH_ASSOC);

                return $res;
            }
            return false;
        }

        public function getProjectItemsX($product_id) {
            try {
                // Use prepared statements to prevent SQL injection
                $stmt = $this->connect->prepare("SELECT * FROM project_items WHERE project_id = :product_id");
                $stmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
                $stmt->execute();
        
                // Fetch results as an associative array
                $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
                // Close the cursor and release the database connection
                $stmt->closeCursor();
        
                if ($result) {
                    return $result;
                }
        
                return false;
            } catch (PDOException $e) {
                // Handle any exceptions (e.g., database connection issues)
                // You can log the error, throw an exception, or return an error message here
                return false;
            }
        }

        // Buyer
        public function getBuyerNotifications($uid) {
            $totalNotifications = $this->connect->query("SELECT
                po.*,
                p.project_name
            FROM
                price_offers po
            JOIN
                notifications n ON po.notif_id = n.id
            JOIN
                projects p ON po.project_id = p.id
            WHERE
                p.buyer_id = $uid;");

            $query = "SELECT
                    po.*,
                    p.project_name,
                    p.post_code,
                    u.company_name,
                    n.is_marked
                FROM
                    price_offers po
                JOIN
                    notifications n ON po.notif_id = n.id
                JOIN
                    projects p ON po.project_id = p.id
                JOIN 
                    users u ON u.user_id = po.seller_id
                WHERE
                    p.buyer_id = $uid";

            if($_SESSION["notif_type"] === 'marked') {
                $query .= " AND po.is_marked = '1'";
            }

            $query .= " ORDER BY po.offer_id DESC LIMIT 20;";

            $result = $this->connect->query($query);

            if ($result->rowCount() > 0) {
                $notifications = $result->fetchAll(PDO::FETCH_ASSOC);

                $response = array(
                    'total' => $totalNotifications->rowCount(),
                    'data' => $notifications
                );

                return $response;
            }
            return false;
        }

        public function checkBuyerNotifications($user_id, $first_id) {
            $query = "SELECT
                    po.*,
                    p.project_name
                FROM
                    price_offers po
                JOIN
                    notifications n ON po.notif_id = n.id
                JOIN
                    projects p ON po.project_id = p.id
                WHERE
                    p.buyer_id = $user_id AND
                    po.offer_id > $first_id";

            if($_SESSION["notif_type"] === 'marked') {
                $query .= " AND po.is_marked = '1'";
            }

            $result = $this->connect->query($query);
            
            if ($result->rowCount() > 0) {
                return true;
            }
            return false;
        }

        public function loadMoreBuyerNotifications($user_id, $last_id) {
            $query = "SELECT
                    po.*,
                    p.project_name,
                    p.post_code,
                    p.project_description,
                    u.company_name
                FROM
                    price_offers po
                JOIN
                    notifications n ON po.notif_id = n.id
                JOIN
                    projects p ON po.project_id = p.id
                JOIN 
                    users u ON u.user_id = po.seller_id
                WHERE
                    p.buyer_id = $uid AND
                    po.offer_id < $last_id";

            if($_SESSION["notif_type"] === 'marked') {
                $query .= " AND po.is_marked = '1'";
            }

            $query .= " ORDER BY po.offer_id DESC Limit 10;";

            $result = $this->connect->query($query);

            if ($result->rowCount() > 0) {
                $notifications = $result->fetchAll(PDO::FETCH_ASSOC);

                $data = '';
                foreach($notifications as $notification) {
                    $attached_file = '';
                    if(!empty($notification["attached_file"])) {
                        $attached_file = '<div class="add-attachment">
                            <a target="_blank" href="<?php echo $notification["attached_file"]; ?>">Attachment</a>
                        </div>';
                    }

                    $msg = '';
                    if(!empty($notification["message"])) {
                        $msg = '<div class="msg">
                            <img src="public/images/messages.svg" alt="">
                        </div>';
                    }

                    $style = '';
                    if(empty($notification["message"]) && empty($notification["attached_file"])) {
                        $style = 'display: flex; width: 100%; justify-content: end;';
                    }

                    $offer_data = $notification["offer_data"];
                    $dataArray = json_decode($offer_data, true);

                    $price_offers = '';
                    $x = 0;
                    foreach ($dataArray as $item) {
                        // $price_offers .= '<div class="amount d-flex">
                        //     <span class="text-muted mr-10">'.ucfirst($item['product']).':</span>
                        //     <b class="text-muted">+£'.number_format($item['price'], 2).'</b>
                        // </div>';

                        $x++;
                        $vat = $item["vat"] === '1' ? '(With VAT)' : '(Without VAT)';

                        $price_offers .= '<div class="amount">
                            <b class="d-flex gap-1 text-muted mr-10"><span>'. $x.'.</span>'.ucfirst($item['product']).':</b>
                            <div style="margin-left: 20px;">
                                <table class="">
                                    <tr>
                                        <td>Product Price:</td>
                                        <td>
                                            <b class="text-muted">£'.number_format($item['price'], 2).' </b> <span class="text-muted">'.$vat.'</span>
                                        </td>
                                    </tr>';

                            if(isset($item["delivery_price"]) && $item["delivery_price"] !== null) {
                                $price_offers .= '<tr>
                                    <td>Delivery Price:</td>
                                    <td>
                                        <b class="text-muted">£'.number_format($item['delivery_price'], 2).' </b>
                                    </td>
                                </tr>';
                            }
                            if(isset($item["delivery_date"]) && $item["delivery_date"] !== null) {
                                $price_offers .= '<tr>
                                    <td>Delivery Date:</td>
                                    <td>
                                        <b class="text-muted">£'.$item['delivery_date'].' </b>
                                    </td>
                            </tr>';
                            }
                            if(isset($item["payment_term"]) && $item["payment_term"] !== null) {
                                $price_offers .= '<tr>
                                    <td>Payment Term:</td>
                                    <td>
                                        <b class="text-muted">£'.$item['payment_term'].' </b>
                                    </td>
                                </tr>';                        }
                                    
                            $price_offers .= '
                                </table>
                            </div>
                        </div>';
                    }

                    $star = '<img class="star-image" width="20" src="public/images/star-light.svg" alt="">';
                    if($notification["is_marked"] === '1') {
                        $star .= '<img class="star-image" width="20" src="public/images/star.svg" alt="">';
                    }

                    $data .= '<div class="list" data-id="'.$notification["id"].'">
                        <div class="info d-flex align-items-center justify-content-between">
                            <div class="notif-icon">
                                <img src="public/images/notification.svg" alt="">
                            </div>
                            <div class="p-meta">
                                <div class="title mb-10">
                                    <div class="">
                                        <h6>'.$notification["project_name"].'</h6>
                                        <span class="d-block mt-1 text-muted"><b>'.$notification["company_name"].'</b></span>
                                        <span class="text-muted"><b>Postcode:</b> '.$notification["post_code"].'</span>
                                    </div>
                                    <div class="start">
                                        <a class="mark-notifications" href="javascript:void(0);" data-id="'.$notification["offer_id"].'">
                                            '.$star.'
                                        </a>
                                    </div>
                                </div>
                                <div class="desc">
                                    '.$price_offers.'
                                </div>
                            </div>
                        </div>
                        <div class="msg-area d-flex align-items-center justify-content-between">
                            <div class="w-100 d-flex align-items-center justify-content-between">
                                '.$attached_file.'
                                '.$msg.'
                            </div>
                        </div>
                    </div>';
                }
                
                $response = array(
                    'has_result' => true,
                    'total' => $result->rowCount(),
                    'data' => $data
                );

                return $response;
            }
            return false;
        }

        public function getNewBuyerNotifications($user_id, $last_id) {
            $query = "SELECT
                    po.*,
                    p.project_name,
                    p.post_code,
                    p.project_description,
                    u.company_name
                FROM
                    price_offers po
                JOIN
                    notifications n ON po.notif_id = n.id
                JOIN
                    projects p ON po.project_id = p.id
                JOIN 
                    users u ON u.user_id = po.seller_id
                WHERE
                    p.buyer_id = $user_id AND
                    po.offer_id > $last_id";

            if($_SESSION["notif_type"] === 'marked') {
                $query .= " AND po.is_marked = '1'";
            }

            $query .= " ORDER BY po.offer_id DESC";

            $result = $this->connect->query($query);
            
            if ($result->rowCount() > 0) {
                $notifications = $result->fetchAll(PDO::FETCH_ASSOC);

                $data = '';
                foreach($notifications as $notification) {
                    $attached_file = '';
                    if(!empty($notification["attached_file"])) {
                        $attached_file = '<div class="add-attachment">
                            <a target="_blank" href="'.$notification["attached_file"].'">Attachment</a>
                        </div>';
                    }

                    $msg = '';
                    if(!empty($notification["message"])) {
                        $msg = '<div class="msg">
                            <img src="public/images/messages.svg" alt="">
                        </div>';
                    }

                    $style = '';
                    if(empty($notification["message"]) && empty($notification["attached_file"])) {
                        $style = 'display: flex; width: 100%; justify-content: end;';
                    }

                    // $project_id = $notification["project_id"];
                    // $productItems = $this->getProjectItems($project_id);

                    $offer_data = $notification["offer_data"];
                    $dataArray = json_decode($offer_data, true);

                    $price_offers = '';
                    $x = 0;
                    foreach ($dataArray as $item) {
                        // $price_offers .= '<div class="amount d-flex">
                        //     <span class="text-muted mr-10">'.ucfirst($item['product']).':</span>
                        //     <b class="text-muted">+£'.number_format($item['price'], 2).'</b>
                        // </div>';

                        $x++;
                        $vat = $item["vat"] === '1' ? '(With VAT)' : '(Without VAT)';

                        $price_offers .= '<div class="amount">
                            <b class="d-flex gap-1 text-muted mr-10"><span>'. $x.'.</span>'.ucfirst($item['product']).':</b>
                            <div style="margin-left: 20px;">
                                <table class="">
                                    <tr>
                                        <td>Product Price:</td>
                                        <td>
                                            <b class="text-muted">£'.number_format($item['price'], 2).' </b> <span class="text-muted">'.$vat.'</span>
                                        </td>
                                    </tr>';

                            if(isset($item["delivery_price"]) && $item["delivery_price"] !== null) {
                                $price_offers .= '<tr>
                                    <td>Delivery Price:</td>
                                    <td>
                                        <b class="text-muted">£'.number_format($item['delivery_price'], 2).' </b>
                                    </td>
                                </tr>';
                            }
                            if(isset($item["delivery_date"]) && $item["delivery_date"] !== null) {
                                $price_offers .= '<tr>
                                    <td>Delivery Date:</td>
                                    <td>
                                        <b class="text-muted">£'.$item['delivery_date'].' </b>
                                    </td>
                            </tr>';
                            }
                            if(isset($item["payment_term"]) && $item["payment_term"] !== null) {
                                $price_offers .= '<tr>
                                    <td>Payment Term:</td>
                                    <td>
                                        <b class="text-muted">£'.$item['payment_term'].' </b>
                                    </td>
                                </tr>';                        }
                                    
                            $price_offers .= '
                                </table>
                            </div>
                        </div>';
                    }

                    $data .= '<div class="list" data-id="'.$notification["offer_id"].'">
                        <div class="info d-flex align-items-center justify-content-between">
                            <div class="notif-icon">
                                <img src="public/images/notification.svg" alt="">
                            </div>
                            <div class="p-meta">
                                <div class="title mb-10">
                                    <div class="">
                                        <h6>'.$notification["project_name"].'</h6>
                                        <span class="d-block mt-1 text-muted"><b>'.$notification["company_name"].'</b></span>
                                        <span class="text-muted"><b>Postcode:</b> '.$notification["post_code"].'</span>
                                    </div>
                                    <div class="start">
                                        <img class="star-image" width="20" src="public/images/star-light.svg" alt="">
                                    </div>
                                </div>
                                <div class="desc">
                                    '.$price_offers.'
                                </div>
                            </div>
                        </div>
                        <div class="msg-area d-flex align-items-center justify-content-between">
                            <div class="w-100 d-flex align-items-center justify-content-between">
                                '.$attached_file.'
                                '.$msg.'
                            </div>
                        </div>
                    </div>';
                }

                $response = array(
                    'status' => "success",
                    'total' => $result->rowCount(),
                    'data' => $data
                );

                return $response;
            }
            return false;
        }

        public function markBuyerNotification($user_id, $offer_id, $type) {
            $result = $this->connect->query("UPDATE `price_offers` SET `is_marked` = '$type' WHERE offer_id = $offer_id;");
        
            if($result) {
                return true;
            }
            return false;
        }
    }
?>