<?php
    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use PHPMailer\PHPMailer\SMTP;
    use PhpOffice\PhpSpreadsheet\IOFactory;

    include '/var/www/connect/load.php';
    include '/var/www/connect/app/models/Projects.php';
    include '/var/www/connect/app/models/Settings.php';

    // $users = new Users();
    $projects = new Projects();
    $settings = new Settings();

    $temp_items = $projects->getTempItems();

    if($temp_items) {
        foreach($temp_items as $temp) {
            $project_id = $temp["project_id"];
            $seller_id = $temp["seller_id"];
            $buyer_id = $temp["buyer_id"];
    
            $project = $projects->getProject($project_id);
            if($project) {
                $project_name = $project["project_name"];
                $post_code  = $project["post_code"];
    
    
                $projectItems = $projects->getProjectItems($project_id);
        
                foreach($projectItems as $item) {
                    $product_type = $item["product_type"];
        
                    
                    $seller = $projects->getUserById($seller_id);
                    $buyer = $projects->getUserById($buyer_id);
                    
                    $products_list = $seller["products_list"];
                    // echo json_encode($products_list);
        
        
                    $sellerName = 'one of the register buyer who is';
                    if($settings->get_option("hide-seller-name") === "1") {
                        $sellerName = $buyer["company_name"];
                    }
        
                    $subject = "Looking for a new price offer";
                    $message = '<!DOCTYPE html>
                    <html>
                        <head>
                            <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
                        </head>
                        <body><div style="background-color: #f6f6f6;">
                            <div style="width: 600px; margin: auto; background-color: #fff;">
                                <div class="template-header" style="margin: 0 80px; background-color: #60CB97; height: 80px; display: flex; align-items: center; justify-content: center;">
                                    <h1 style="color: #fff; text-transform: uppercase; font-weight: bold; margin: auto; font-size: 32px; text-align: center;">CONNECTION <span style="color: #696969;">SYSTEM</span></h1>
                                </div>
                                <div class="template-body" style="">
                                    <div style="padding: 0 80px">
                                        <h1 style="text-align: center; color: #383838; line-height: 36px; margin-bottom: 0; font-family: serif; font-size: 28px; unicode-bidi: plaintext;">DO YOUR BEST IN ORDER TO BE FIRST PLACE!</h1>
                                        <div class="image" style="margin: auto; padding: 30px 0;">
                                            <img style="width: 100%;" src="https://www.connectionsys.co.uk/public/images/image-1.png" alt="">
                                        </div>
                                    </div>
                                    <div class="box" style="position: relative; padding: 20px 80px; padding-top: 0; background-color: #60CB97;">
                                        <span style="display: block; width: 60%; margin: auto; height: 15px; background-color: #696969;"></span>
                                        <h1 style="text-align: center; text-transform: uppercase; color: #2B454E; font-family: serif; font-size: 38px; margin-top: 15px; margin-bottom: 5px;">NEW OPPORTUNITY</h1>
                                        <h3 style="text-align: center; color: #fff; font-weight: 400; font-size: 21px; line-height: 28px; margin-top: 0; unicode-bidi: plaintext;">you receive a new opportunity from '. $sellerName .' looking to buy:</h3>
                                        <div class="project-history" style="background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px;">
                                            <h3 style="margin-top: 8px; margin-bottom: 5px; text-align: center;">'.$project_name.'</h3>
                                            <p style="margin-top: 0; margin-bottom: 8px; text-align: center; font-size: 13px; color: #696969;"><b>Post Code:</b> '.$post_code.'</p>
                                            <div class="products-wrapper" style="background-color: #fff; margin: 5px; border-radius: 15px; text-align: left;">';
        
                    $products_list_array = explode(',', $products_list);
        
                    // Filter $projectItems based on product types in $products_list_array
                    $matchingProducts = array_filter($projectItems, function ($product) use ($products_list_array) {
                        return in_array($product['product_type'], $products_list_array);
                    });
                    
                    // Reset array keys
                    $matchingProducts = array_values($matchingProducts);
        
                    foreach($matchingProducts as $matchingProduct) {
                        $itemWidth = '100%';
                        if(count($matchingProducts) > 1) {
                            $itemWidth = '50%';
                        }
        
                        $quantity = '';
                        if($matchingProduct["quantity"]) {
                            $quantity = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Quantity:</b> '.$matchingProduct["quantity"].'</p>';
                        }
        
                        $unit = '';
                        if($matchingProduct["unit"]) {
                            $unit = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Unit:</b> '.$matchingProduct["unit"].'</p>';
                        }
        
                        $date_required = '';
                        if($matchingProduct["date_required"]) {
                            $date_required = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Date Required:</b> '.$matchingProduct["date_required"].'</p>';
                        }
        
                        $open_to_similar_brands = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> '.ucfirst($matchingProduct["open_to_similar_brands"]).'</p>';
        
                        $attached_file = '';
                        if(!empty($matchingProduct["product_image"])) {
                            $attached_file = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 12px; text-align: left;"><a href="'. BASE_URL . $matchingProduct["product_image"].'">See the attached file to view how the buyer expects the materials to look.</a></p>';
                        }
                        
                        $message .= '<div class="product-item" style="box-sizing: border-box; width: '.$itemWidth.'; display: inline-block; padding: 7.5px;">
                                <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                                    <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">'.ucfirst($matchingProduct["product_type"]).'</h3>
                                    <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Description:</b> '.$matchingProduct["description"].'</p>
                                    '.$open_to_similar_brands.'
                                    '.$quantity.'
                                    '.$unit.'
                                    '.$date_required.'
                                    '.$attached_file.'
                                </div>
                            </div>';
                    }
        
                    $message .= '</div>
                                    </div>
                                        <div class="button" style="text-align: center;">
                                            <a href="https://www.connectionsys.co.uk/">
                                                <button style="background-color: #696969; border: transparent; height: 36px; padding: 0 18px; border-radius: 5px; font-size: 16px; text-transform: uppercase; color: #fff; font-weight: bold; cursor: pointer;">Price Him</button>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="template-footer" style="margin: 0 auto; text-align: center;padding: 15px 0;">
                                    <span style="display: block; width: 32%; margin: auto; height: 8px; background-color: #60CB97; margin-bottom: 15px;"></span>
                                    <a href="https://www.connectionsys.co.uk/" style="display: block; text-align: center; font-size: 22px; text-decoration: none; color: #60CB97; font-family: Montserrat;">www.connectionsys.co.uk</a>
                                </div>
                            </div>
                        </div>
                        </body></html>';
        
                    $isExists = $projects->checkNotification($project_id, $seller_id);

                    if(!$isExists || $isExists["active"] === '0') {
                        $notif_id = $isExists["id"];
                        $projects->updateNotificationActiveType($notif_id);
                        
                        $email = $seller["email"];
                        $company_name = $seller["company_name"];
    
                        if($seller["newsletter_preference"] === '1') {
                            $mail = new PHPMailer();

                            try {
                                //Server settings
                                // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                                $mail->isSMTP();                                            //Send using SMTP
                                $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                                $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                                $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                                $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                                $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
                            
                                //Recipients
                                $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                                $mail->addAddress($email, $company_name);     //Add a recipient
                                // $mail->addAddress('ellen@example.com');               //Name is optional
                                // $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');
                            
                                //Content
                                $mail->isHTML(true);                                  //Set email format to HTML
                                $mail->Subject = $subject;
                                $mail->Body    = $message;
                                // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
                            
                                $mail->send();
                                // echo 'Message has been sent';
                            } catch (Exception $e) {
                                echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                                exit;
                            }
                        }

                        // delete item from temp
                        $projects->removeFromTemp($project_id, $seller_id);
                    }else {
                        // echo "mail already sent";
                    }
                }
            }
        }
    }

?>