<?php
    session_start();

    include '../../load.php';
    include '../models/Projects.php';

    $projects = new Projects();

    if (isset($_POST['search_key']) && !empty($_POST['search_key'])) {
        $search_key = $_POST["search_key"];
        $buyer_id = $_SESSION["user_id"];
    
        $results = $projects->getProductsBySearchKey($search_key, $buyer_id);
        // echo json_encode($results);
    
        $html = '';
        if ($results) {
            // Loop through results and generate HTML for each project
            foreach ($results as $project) {
                $html .= '<li>';
                $html .= '<a href="buyer.php?action=load-products&pid='.$project["id"].'">' . htmlspecialchars($project['project_name']) . ' - ' . htmlspecialchars($project['project_description']) . '</a>';
                $html .= '</li>';
            }
        } else {
            // Handle case where no results are found
            $html = '<li>No projects found.</li>';
        }
    
        // Return HTML response
        echo $html;
    }else {
        // Handle case where search_key parameter is not provided
        echo '<li>Invalid search request.</li>';
    }
?>