<?php
    session_start();

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use PHPMailer\PHPMailer\SMTP;
    
    include '../../load.php';
    // include '../models/Users.php';
    include '../models/Projects.php';

    // $projects = new Users();
    $projects = new Projects();

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $postcodes = $_POST['postcodes'] ?? [];
        $company = $_POST['company'];
        $email = $_POST['email'];
        $password = $_POST['password'];
        $type = $_POST['account-type'];

        $gr_link = '';
        if(!empty($_POST['gr_link'])) {
            $gr_link = $_POST['gr_link'];
        }

        $product_name = '';
        if (isset($_POST["product_name"]) && is_array($_POST["product_name"])) {
            $product_name = implode(",", $_POST["product_name"]);
        }

        $country = 'all';
        if (isset($_POST["country"]) && is_array($_POST["country"])) {
            $country = implode(",", $_POST["country"]);
        }

        if($type === 'buyer') {
            $accType = 'buyer-register';
        }else {
            $accType = 'seller-register';
        }

        if($country === 'uk,ireland') {
            $country = 'all';
        }

        // List of allowed email domains
        $allowedDomains = array('gmail.com', 'hotmail.com', 'outlook.com');
        if(!isAllowedEmailDomain($email, $allowedDomains)) {
            if(!$projects->emailExists($email)) {
                $key = generateSecretKey(32);
    
                $res = $projects->createUser($company, $email, $password, $type, $product_name, $country, $gr_link, $key, $postcodes);
                // echo json_encode($res);
                
                if($res["status"] === "success") {
                    // $ip = file_get_contents('https://api.ipify.org');
                    $ip = get_client_ip();
                    $locationInfo = getCurrencyAndDateFormatByIp($ip);
                    $inserted_id = $res["inserted_id"];

                    if ($locationInfo) {
                        $userId = $inserted_id;
                        $country = $locationInfo["country"];
                        $currency = $locationInfo["currency"];
                        $dateFormat = $locationInfo["date_format"];
                        updateUserDetails($userId, $country, $currency, $dateFormat);
                    }
                    
    
                    $userData = $projects->getUserById($inserted_id);
                    $_SESSION["user_id"] = $inserted_id;
                    $_SESSION["userData"] = $userData;
                    $_SESSION["show"] = "home";
    
                    if($userData["account_type"] === "seller" && ($userData["country"] === "all" || $userData["country"] === $country)) {
                        if(!empty($product_name)) {
                            // get projects
                            $result = $projects->getProjectsByDate($product_name, $country);
                            // echo json_encode($result);
                            if($result) {
                                foreach($result as $project) {
                                    $project_id = $project["id"];
                                    $seller_id = $inserted_id;
                                    $isExists = $projects->checkNotification($project_id, $seller_id);
                        
                                    if(!$isExists) {
                                        $project_name = $project["project_name"];
                                        $desc = $project["project_description"];
                                        $projects->addToNofications($project_name, $desc, $project_id, $seller_id);
                                    }
                                }

                                // Send notification to user email
                                $subject = "Looking for a new price offer";
                                $message = '<!DOCTYPE html>
                                    <html>
                                        <head>
                                            <style>
                                                @import url("https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap");
                                            </style>
                                        </head>
                                        <body>
                                            <div style="background-color: #f6f6f6;">
                                                <div style="width: 600px; margin: auto; background-color: #fff;">
                                                    <div class="template-header" style="margin: 0 80px; background-color: #60CB97; height: 80px; display: flex; align-items: center; justify-content: center;">
                                                        <h1 style="color: #fff; text-transform: uppercase; font-weight: bold; margin: auto; font-size: 32px; text-align: center;">CONNECTION <span style="color: #696969;">SYSTEM</span></h1>
                                                    </div>
                                                    <div class="template-body">
                                                        <div style="padding: 0 80px">
                                                            <h1 style="text-align: center; color: #383838; line-height: 36px; margin-bottom: 0; font-family: serif; font-size: 28px; text-transform: uppercase; unicode-bidi: plaintext;">Do your best in order to be first place!</h1>
                                                            <div class="image" style="margin: auto; padding: 30px 0;">
                                                                <img style="width: 100%;" src="https://www.connectionsys.co.uk/public/images/image-1.png" alt="">
                                                            </div>
                                                        </div>
                                                        <div class="box" style="position: relative; padding: 20px 80px; padding-top: 0; background-color: #60CB97;">';

                                                        $heading = "New Opportunitiy";
                                                        if(count($result) > 1) {
                                                            $heading = "New Opportunities";
                                                        }

                                                        $message .= '<span style="display: block; width: 60%; margin: auto; height: 15px; background-color: #696969;"></span>
                                                        <h1 style="text-align: center; text-transform: uppercase; color: #2B454E; font-family: serif; font-size: 38px; margin-top: 15px; margin-bottom: 5px;">'.$heading.'</h1>
                                                        <h3 style="text-align: center; color: #fff; font-weight: 400; font-size: 21px; line-height: 28px; margin-top: 0; unicode-bidi: plaintext;">There are '.count($result).' projects waiting for your quotes. Please login to the website to provide your price.</h3>';

                                                        $btnText = "Price him";
                                                        if(count($result) > 1) {
                                                            $btnText = "Price them";
                                                        }

                                $message .= '<div class="button" style="text-align: center; margin-top: 30px;">
                                                        <a href="https://www.connectionsys.co.uk/">
                                                            <button style="background-color: #696969; border: transparent; height: 36px; padding: 0 18px; border-radius: 5px; font-size: 16px; text-transform: uppercase; color: #fff; font-weight: bold; cursor: pointer;">'.$btnText.'</button>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="template-footer" style="margin: 0 auto; text-align: center;padding: 15px 0;">
                                                <span style="display: block; width: 32%; margin: auto; height: 8px; background-color: #60CB97; margin-bottom: 15px;"></span>
                                                <a href="https://www.connectionsys.co.uk/" style="display: block; text-align: center; font-size: 22px; text-decoration: none; color: #60CB97; font-family: Montserrat;">www.connectionsys.co.uk</a>
                                            </div>
                                        </div>
                                    </div>
                                </body></html>';

                                $mail = new PHPMailer();
                                try {
                                    //Server settings
                                    // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                                    $mail->isSMTP();                                            //Send using SMTP
                                    $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                                    $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                                    $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                                    $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                                    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                                    $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
                                
                                    //Recipients
                                    $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                                    $mail->addAddress($email, $company);     //Add a recipient
                                    // $mail->addAddress('ellen@example.com');               //Name is optional
                                    // $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');
                                
                                    //Content
                                    $mail->isHTML(true);                                  //Set email format to HTML
                                    $mail->Subject = $subject;
                                    $mail->Body    = $message;
                                    // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
                                
                                    $mail->send();
                                    // echo 'Message has been sent';
                                } catch (Exception $e) {
                                    echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                                    exit;
                                }
                            }
                        }

                        header("Location: ".BASE_URL."seller.php");
                    }else {
                        header("Location: ".BASE_URL."buyer.php");
                    }
                }else {
                    header("Location: ".BASE_URL."index.php?" . http_build_query($res) . "");
                }
            }else {
                $response = array(
                    "action" => $accType,
                    "status" => "danger",
                    "message" => "Email already exists!"
                );

                header("Location: ".BASE_URL."index.php?" . http_build_query($response) . "");
            }
        } else {
            $response = array(
                "action" => $accType,
                "status" => "danger",
                "message" => "Registration is restricted for company mail only."
            );

            header("Location: ".BASE_URL."index.php?" . http_build_query($response) . "");
        }

        exit;

        // reCAPTCHA validation
        if(isset($_POST['g-recaptcha-response']) && !empty($_POST['g-recaptcha-response'])) {
            // Google secret API
            $secretAPIkey = '6Ld6FwUoAAAAAABdOuLGwmAM2grRQj0zFxxKkwlT';
            // reCAPTCHA response verification
            $verifyResponse = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret='.$secretAPIkey.'&response='.$_POST['g-recaptcha-response']);
            // Decode JSON data
            $response = json_decode($verifyResponse);
            
            if($response->success){
                // $registrationErrors = $projects->validateRegistration();
                
            }else {
                $response = array(
                    "action" => $accType,
                    "status" => "danger",
                    "message" => "Robot verification failed, please try again."
                );

                header("Location: ".BASE_URL."index.php?" . http_build_query($response) . "");
            }
        }else {
            $response = array(
                "action" => $accType,
                "status" => "danger",
                "message" => "Plese check on the reCAPTCHA box."
            );

            header("Location: ".BASE_URL."index.php?" . http_build_query($response) . "");
        }

        // header("Location: ".BASE_URL."index.php?" . http_build_query($response) . "");
    }
    function updateUserDetails($userId, $country, $currency, $dateFormat) {
        $connect = (new Database())->getConnection();
        $query = $connect->query("
            UPDATE `users`
            SET 
                `country` = '$country',
                `currency` = '$currency',
                `date_format` = '$dateFormat'
            WHERE 
                `user_id` = '$userId';
        ");
        if ($query) {
            return true;
        }
        return false;
    }
    function get_client_ip() {
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        else if(isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }
    function getCurrencyAndDateFormatByIp($ip) {
        // Using geoPlugin API for geolocation
        $url = "http://www.geoplugin.net/json.gp?ip={$ip}";
    
        // Initialize cURL session
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
    
        // Decode the JSON response
        $data = json_decode($response, true);
    
        if (isset($data['geoplugin_countryCode'])) {
            $countryCode = $data['geoplugin_countryCode'];
            $currency = getCurrencyByCountry($countryCode);
            $dateFormat = getDateFormatByCountry($countryCode);
    
            return [
                'country' => $countryCode,
                'currency' => $currency,
                'date_format' => $dateFormat
            ];
        } else {
            return null; // If country information is not available
        }
    }
    function getCurrencyByCountry($countryCode) {
        // Currency symbols mapped to countries
        $currencyMap = [
            'US' => '$',  // USD
            'GB' => '£',  // GBP
            'IN' => '₹',  // INR
            'CA' => '$',  // CAD
            'AU' => '$',  // AUD
            'PK' => '₨',  // PKR
            'DE' => '€',  // EUR
            'FR' => '€',  // EUR
            'IT' => '€',  // EUR
            'ES' => '€',  // EUR
            'CN' => '¥',  // CNY
            'JP' => '¥',  // JPY
            'BR' => 'R$', // BRL
            'MX' => '$',  // MXN
            'RU' => '₽',  // RUB
            'KR' => '₩',  // KRW
            'SG' => '$',  // SGD
            'ZA' => 'R',  // ZAR
            'SE' => 'kr', // SEK
            'IL' => '₪',  // ILS (Israeli New Shekel)
        ];
    
        return isset($currencyMap[$countryCode]) ? $currencyMap[$countryCode] : null;
    }
    
    function getDateFormatByCountry($countryCode) {
        // Date formats mapped to countries
        $dateFormatMap = [
            'US' => 'm/d/Y',  // MM/DD/YYYY
            'GB' => 'd/m/Y',  // DD/MM/YYYY
            'IN' => 'd/m/Y',  // DD/MM/YYYY
            'CA' => 'Y-m-d',  // YYYY-MM-DD
            'AU' => 'd/m/Y',  // DD/MM/YYYY
            'PK' => 'd-m-Y',  // DD-MM-YYYY
            'DE' => 'd.m.Y',  // DD.MM.YYYY
            'FR' => 'd/m/Y',  // DD/MM/YYYY
            'IT' => 'd/m/Y',  // DD/MM/YYYY
            'ES' => 'd/m/Y',  // DD/MM/YYYY
            'CN' => 'Y-m-d',  // YYYY-MM-DD
            'JP' => 'Y/m/d',  // YYYY/MM/DD
            'BR' => 'd/m/Y',  // DD/MM/YYYY
            'MX' => 'd/m/Y',  // DD/MM/YYYY
            'RU' => 'd.m.Y',  // DD.MM.YYYY
            'KR' => 'Y-m-d',  // YYYY-MM-DD
            'SG' => 'd/m/Y',  // DD/MM/YYYY
            'ZA' => 'Y/m/d',  // YYYY/MM/DD
            'SE' => 'Y-m-d',  // YYYY-MM-DD
            'IL' => 'd/m/Y',  // DD/MM/YYYY (Common format in Israel)
        ];
    
        return isset($dateFormatMap[$countryCode]) ? $dateFormatMap[$countryCode] : 'Y-m-d';  // Default to YYYY-MM-DD
    }    
?>