<?php
    include '../../load.php';
    include '../models/Users.php';

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use PHPMailer\PHPMailer\SMTP;

    $user = new Users();

    if ($_POST['action'] === 'FORGOT_PASSWORD') {
        $email = $_POST['user_email'];
        $res = $user->checkEmail($email);
        
        if($res) {
            $userData = $user->getUserByEmail($email);
            $company_name = $userData["company_name"];
            $secret_key = $userData["secret_key"];

            // send email
            $subject = "Password Reset Request";
            $message = '
                <div style="margin: 0; padding: 0; font-family: Arial, sans-serif; background-color: #f4f4f4;">
                    <div style="max-width: 600px; margin: 0 auto; padding: 20px; background-color: #ffffff;">
                        <h1 style="color: #333;">Password Reset</h1>
                        <p style="color: #555; margin-bottom: 5px;">Hi there,</p>
                        <p style="color: #555; margin-top: 0;">We received a request to reset your password. Click the link below to reset your password:</p>
                        <p><a href="'.BASE_URL.'reset.php?key='.$secret_key.'" style="color: #007bff; text-decoration: none;">Reset Password</a></p>
                        <p style="color: #555;">If you did not request a password reset, you can ignore this email.</p>
                        <p style="color: #555; margin-bottom: 5px;">Best regards,</p>
                        <p style="color: #555; margin-top: 0;">Connectionsys.co.uk</p>
                    </div>
                </div>
            ';

            $mail = new PHPMailer();

            try {
                //Server settings
                // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                $mail->isSMTP();                                            //Send using SMTP
                $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
            
                //Recipients
                $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                $mail->addAddress($email, $company_name);     //Add a recipient
                // $mail->addAddress('ellen@example.com');               //Name is optional
                // $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');
            
                //Content
                $mail->isHTML(true);                                  //Set email format to HTML
                $mail->Subject = $subject;
                $mail->Body    = $message;
                // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
            
                $mail->send();
                // echo 'Message has been sent';
                $res =  array("status" => "success", "message" => "Check your email for a password reset email.");
            } catch (Exception $e) {
                echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                exit;
            }
        }else {
            $res =  array("status" => "danger", "message" => "The email id you have entered does not match with our records.");
        }

        header("Location: ".BASE_URL."forgot-password.php?" . http_build_query($res) . "");
    }

    if ($_POST['action'] === 'CHANGE_PASSWORD') {
        $key = $_POST['key'];
        $password = $_POST['password'];
        $confirm_password = $_POST['confirm_password'];
        
        $getUser = $user->getUserBySecretKey($key);
        if($getUser) {
            if($password === $confirm_password) {
                $uid = $getUser["user_id"];
                $newKey = generateSecretKey(32);
                $passwordHash = hash("sha256", $password);

                $res = $user->changePassword($uid, $passwordHash, $newKey);
                if($res) {
                    $res =  array("action" => "user-login", "status" => "success", "message" => "Your password has been changed successfully.");

                    header("Location: ".BASE_URL."index.php?" . http_build_query($res) . "");
                }else {
                    $res =  array("status" => "danger", "message" => "Something went wrong. Please try again.");

                    header("Location: ".BASE_URL."forgot-password.php?" . http_build_query($res) . "");
                }
            }else {
                $res =  array("status" => "danger", "message" => "Your password and confirm password do not match.");

                header("Location: ".BASE_URL."forgot-password.php?" . http_build_query($res) . "");
            }
        }else {
            $res =  array("status" => "danger", "message" => "Sorry, your password reset link has expired.");

            header("Location: ".BASE_URL."forgot-password.php?" . http_build_query($res) . "");
        }
        
        // echo json_encode($res);
        // header("Location: ".BASE_URL."forgot-password.php?". http_build_query($res). "");
        // header("Location: ".BASE_URL."index.php?" . http_build_query($res) . "");
    }
?>