
<?php
    session_start();

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use PHPMailer\PHPMailer\SMTP;
    use PhpOffice\PhpSpreadsheet\IOFactory;

    include '../../load.php';
    include '../models/Projects.php';
    include '../models/Products.php';
    include '../models/Settings.php';

    $projects = new Projects();
    $products = new Products();
    $settings = new Settings();

    $uid = $_SESSION["user_id"];
    $authUser = new Users();
    $userInfo = $authUser->getUserDetails($uid);
    $dateFormat = isset($userInfo['date_format']) ? $userInfo['date_format'] : 'd/m/Y';
    $userCurrency = isset($userInfo['currency']) ? $userInfo['currency'] : '£';
    
    if (isset($_POST["action"]) && $_POST['action'] === 'EDIT_PROJECT') {
        parse_str($_POST['formData'], $formData); // Parse serialized form data into an array

        $project_id = $formData['project_id'] ?? null;
        $project_name = $formData['project_name'] ?? '';
        $project_description = $formData['project_description'] ?? '';
        $project_address = $formData['project_address'] ?? '';

        if (empty($project_id) || empty($project_name) || empty($project_description) || empty($project_address)) {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'All fields are required.']);
            exit;
        }

        $result = $projects->updateProject($project_id, $project_name, $project_description, $project_address);


        if($result) {
            $response  = array("status" => "success", "project_id" => $project_id, "message" => "Project updated successfully.");
        }else {
            $response  = array("status" => "error", "project_id" => $project_id, "message" => "Failed to update project.");
        }

        echo json_encode($response);
    }
    if (isset($_POST["action"]) && $_POST['action'] === 'ADD_PROJECT') {
        $buyer_id = $_SESSION["user_id"];
        $project_name = addslashes($_POST['project_name']);
        $description = addslashes($_POST['description']);
        $post_code = addslashes($_POST['post_code']);

        $result = $projects->addProject($buyer_id, $project_name, $description, $post_code);
        $project_id = $result["insert_id"];
        $html = '<div class="single-project" data-id="'.$project_id.'" data-type="redirect">
            <div class="product-name">
                <div class="">
                    <h6 class="mb-0">'.$project_name.' <small><sup class="text-muted project-status">[Draft]</sup></small> </h6>
                    <span class="text-muted" style="font-size: 10px;">0 Products</span>
                </div>
            </div>
            <div class="product-actions">
                <ul class="d-flex align-items-center justify-center-center list-unstyled mb-0" style="gap: 10px">
                    <li>
                        <a href="?action=edit-project&amp;project-id='.$project_id.'" class="text-decoration-none" style="font-size: 13px;">Edit</a>
                    </li>
                    <li>
                        <a href="javascript:void(0);" class="delete-project">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="20" fill="red" id="delete"><path d="M24.2,12.193,23.8,24.3a3.988,3.988,0,0,1-4,3.857H12.2a3.988,3.988,0,0,1-4-3.853L7.8,12.193a1,1,0,0,1,2-.066l.4,12.11a2,2,0,0,0,2,1.923h7.6a2,2,0,0,0,2-1.927l.4-12.106a1,1,0,0,1,2,.066Zm1.323-4.029a1,1,0,0,1-1,1H7.478a1,1,0,0,1,0-2h3.1a1.276,1.276,0,0,0,1.273-1.148,2.991,2.991,0,0,1,2.984-2.694h2.33a2.991,2.991,0,0,1,2.984,2.694,1.276,1.276,0,0,0,1.273,1.148h3.1A1,1,0,0,1,25.522,8.164Zm-11.936-1h4.828a3.3,3.3,0,0,1-.255-.944,1,1,0,0,0-.994-.9h-2.33a1,1,0,0,0-.994.9A3.3,3.3,0,0,1,13.586,7.164Zm1.007,15.151V13.8a1,1,0,0,0-2,0v8.519a1,1,0,0,0,2,0Zm4.814,0V13.8a1,1,0,0,0-2,0v8.519a1,1,0,0,0,2,0Z"></path></svg>
                        </a>
                    </li>
                </ul>
                
                <ul class="d-flex align-items-center justify-center-center list-unstyled mb-0" style="gap: 5px; display: none !important;">
                    <li>
                        <a href="javascript:void(0);" class="text-decoration-none publish-project" data-project-id="'.$project_id.'" data-location="2"  style="font-size: 13px; color: #60CB97;">Publish</a>
                    </li>
                </ul>
            </div>
        </div>';

        echo json_encode(array('status' => 'success', 'project_id' => $project_id, 'data' => $html));
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'ADD_PROJECT_ITEM') {
        $project_id = $_POST['project_id'];
        $description = $_POST['description'];
        $product_name = $_POST['product_name'];
        $open_to_similar_brands = $_POST['open_to_similar_brands'];
        $quantity = $_POST['quantity'];
        $unit = $_POST['unit'];
        $date_required = $_POST['date_required'];

        $uploadPath = '';
        if(!empty($_FILES['product_image']['tmp_name'])) {
            $allowedTypes = ['jpg', 'jpeg', 'png'];
            $fileType = strtolower(pathinfo($_FILES['product_image']['name'], PATHINFO_EXTENSION));

            if (!in_array($fileType, $allowedTypes)) {
                // echo 'Error: Invalid file type. Allowed types are JPEG and PNG.';
            } else {
                // Validate file size (max: 5MB)
                $maxFileSize = 5 * 1024 * 1024; // 5MB in bytes
                if ($_FILES['product_image']['size'] > $maxFileSize) {
                    // echo 'Error: File size exceeds the maximum limit (5MB).';
                } else {
                    
                }
            }

            // Generate a unique filename to avoid overwriting existing files
            $fileName = uniqid('img_') . '_' . $_FILES['product_image']['name'];
            $uploadDir = "uploads/";
            
            if(is_dir("../../" . $uploadDir) && is_writable("../../" . $uploadDir)) {
                // Move the uploaded file to the destination directory
                if (move_uploaded_file($_FILES['product_image']['tmp_name'], "../../" . $uploadPath)) {
                    // echo 'File uploaded successfully.';
                    $uploadPath = $uploadDir . $fileName;
                }
            }else {
                // echo 'Error: Failed to create directory or write permissions.';
            }

        }

        $res = $projects->addToProjectItems($project_id, $description, $product_name, $open_to_similar_brands, $quantity, $unit, $date_required, $uploadPath);

        if($res) {
            $response  = array("status" => "success", "project_id" => $project_id, "message" => "Material successfully added.");
        }else {
            $response  = array("status" => "error", "project_id" => $project_id, "message" => "Something went wrong!");
        }

        // header("Location: ".BASE_URL."add-materials.php?pid=" . $project_id . "&" . http_build_query($response) . "");

        echo json_encode($response);
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'EDIT_PROJECT_ITEM') {
        // echo json_encode($_POST);

        $project_id = $_POST['project_id'];
        $item_id = $_POST['item_id'];
        
        // $product_name = $_POST['product_name'];
        $description = $_POST['description'];
        $quantity = $_POST['quantity'];
        $unit = $_POST['unit'];
        $date_required = $_POST['date_required'];
        $open_to_similar_brands = $_POST['open_to_similar_brands'];

        
        $projectData = $projects->getProject($project_id);
        
        if($projectData["status"] === '0') {
            $result = $projects->updateProjectItem($item_id, $description, $quantity, $unit, $date_required, $open_to_similar_brands);
        }else {
            $itemArray = array(
                "description" => $description,
                "quantity" => $quantity,
                "unit" => $unit,
                "date_required" => $date_required,
                "open_to_similar_brands" => $open_to_similar_brands
            );
    
            $result = $projects->updateProjectItemEditData($item_id, json_encode($itemArray));
            // $projects->updateOfferItemEditable($project_id, $item_id, 1);
        }

        if($result) {
            $response  = array("status" => "success", "project_id" => $project_id, "message" => "Material updated successfully.");
        }else {
            $response  = array("status" => "error", "project_id" => $project_id, "message" => "Something went wrong!");
        }

        echo json_encode($response);
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'PUBLISH_PROJECT') {
        $project_id = $_POST["project_id"];

        $projectData = $projects->getProject($project_id);
        $project_name = $projectData["project_name"];
        $post_code = $projectData["post_code"];

        // Select all project items
        $projectItems = $projects->getProjectItems($project_id);

        $sellerName = 'one of the register buyer who is';
        if($settings->get_option("hide-seller-name") === "1") {
            $sellerName = $_SESSION["userData"]["company_name"];
        }

        function modifyEmptyString($data) {
            if(!empty($data)) {
                return $data;
            }
            
            return '-';
        }

        if($projectData && $projectData["status"] === '0') {
            $projects->publishProduct($project_id);
    
            foreach($projectItems as $item) {
                $product_type = $item["product_type"];
                $projects->updateProjectItemsStatus($project_id, '1');
                
                $sellers = $projects->searchByKeywords($product_type);
                // echo json_encode($sellers);
                // exit;

                if($sellers) {
                    foreach($sellers as $seller) {
                        $seller_id = $seller["user_id"];
                        $products_list = $seller["products_list"];

                        $subject = "Looking for a new price offer";
                        $message = '<!DOCTYPE html>
                            <html>
                                <head>
                                    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
                                </head>
                                <body><div style="background-color: #f6f6f6;">
                                    <div style="width: 600px; margin: auto; background-color: #fff;">
                                        <div class="template-header" style="margin: 0 80px; background-color: #60CB97; height: 80px; display: flex; align-items: center; justify-content: center;">
                                            <h1 style="color: #fff; text-transform: uppercase; font-weight: bold; margin: auto; font-size: 32px; text-align: center;">CONNECTION <span style="color: #696969;">SYSTEM</span></h1>
                                        </div>
                                        <div class="template-body" style="">
                                            <div style="padding: 0 80px">
                                                <h1 style="text-align: center; color: #383838; line-height: 36px; margin-bottom: 0; font-family: serif; font-size: 28px; unicode-bidi: plaintext;">DO YOUR BEST IN ORDER TO BE FIRST PLACE!</h1>
                                                <div class="image" style="margin: auto; padding: 30px 0;">
                                                    <img style="width: 100%;" src="https://www.connectionsys.co.uk/public/images/image-1.png" alt="">
                                                </div>
                                            </div>
                                            <div class="box" style="position: relative; padding: 20px 80px; padding-top: 0; background-color: #60CB97;">
                                                <span style="display: block; width: 60%; margin: auto; height: 15px; background-color: #696969;"></span>
                                                <h1 style="text-align: center; text-transform: uppercase; color: #2B454E; font-family: serif; font-size: 38px; margin-top: 15px; margin-bottom: 5px;">NEW OPPORTUNITY</h1>
                                                <h3 style="text-align: center; color: #fff; font-weight: 400; font-size: 21px; line-height: 28px; margin-top: 0; unicode-bidi: plaintext;">you receive a new opportunity from '. $sellerName .' looking to buy:</h3>
                                                <div class="project-history" style="background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px;">
                                                    <h3 style="margin-top: 8px; margin-bottom: 5px; text-align: center;">'.$projectData["project_name"].'</h3>
                                                    <p style="margin-top: 0; margin-bottom: 8px; text-align: center; font-size: 13px; color: #696969;"><b>Post Code:</b> '.$projectData["post_code"].'</p>
                                                    <div class="products-wrapper" style="background-color: #fff; margin: 5px; border-radius: 15px; text-align: left;">';

                        $products_list_array = explode(',', $products_list);

                        // Filter $projectItems based on product types in $products_list_array
                        $matchingProducts = array_filter($projectItems, function ($product) use ($products_list_array) {
                            return in_array($product['product_type'], $products_list_array);
                        });
                        
                        // Reset array keys
                        $matchingProducts = array_values($matchingProducts);

                        foreach($matchingProducts as $matchingProduct) {
                            $itemWidth = '100%';
                            if(count($matchingProducts) > 1) {
                                $itemWidth = '50%';
                            }
            
                            $quantity = '';
                            if($matchingProduct["quantity"]) {
                                $quantity = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Quantity:</b> '.$matchingProduct["quantity"].'</p>';
                            }
            
                            $unit = '';
                            if($matchingProduct["unit"]) {
                                $unit = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Unit:</b> '.$matchingProduct["unit"].'</p>';
                            }
            
                            $date_required = '';
                            if($matchingProduct["date_required"]) {
                                $date_required = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Date Required:</b> '.$matchingProduct["date_required"].'</p>';
                            }

                            $open_to_similar_brands = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> '.ucfirst($matchingProduct["open_to_similar_brands"]).'</p>';
            
                            // $product = $products->getProductByName($matchingProduct["product_type"]);

                            // if(!empty($matchingProduct["product_image"])) {
                            //     $img_url = BASE_URL . $matchingProduct["product_image"];
                            // }else {
                            //     if(!empty($product["image"])) {
                            //         $img_url = BASE_URL . $product["image"];
                            //     }else {
                            //         $img_url = 'https://rakanonline.com/wp-content/uploads/2022/08/default-product-image.png';
                            //     }
                            // }

                            // <div class="">
                            //     <img style="width: 50px; margin-bottom: 5px;" src="'.$img_url.'" alt="'.ucfirst($matchingProduct["product_type"]).'" />
                            // </div>

                            $attached_file = '';
                            if(!empty($matchingProduct["product_image"])) {
                                $attached_file = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 14px;text-align: left;"><a href="'. BASE_URL . $matchingProduct["product_image"].'">See the attached file to view how the buyer expects the materials to look.</a></p>';
                            }
                            
                            $message .= '<div class="product-item" style="box-sizing: border-box; width: '.$itemWidth.'; display: inline-block; padding: 7.5px;">
                                <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                                    
                                    <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">'.ucfirst($matchingProduct["product_type"]).'</h3>
                                    <p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Description:</b> '.$matchingProduct["description"].'</p>
                                    '.$open_to_similar_brands.'
                                    '.$quantity.'
                                    '.$unit.'
                                    '.$date_required.'
                                    '.$attached_file.'
                                </div>
                            </div>';
                        }
                
                        $message .= '</div>
                                        </div>
                                            <div class="button" style="text-align: center;">
                                                <a href="https://www.connectionsys.co.uk/">
                                                    <button style="background-color: #696969; border: transparent; height: 36px; padding: 0 18px; border-radius: 5px; font-size: 16px; text-transform: uppercase; color: #fff; font-weight: bold; cursor: pointer;">Price Him</button>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="template-footer" style="margin: 0 auto; text-align: center;padding: 15px 0;">
                                        <span style="display: block; width: 32%; margin: auto; height: 8px; background-color: #60CB97; margin-bottom: 15px;"></span>
                                        <a href="https://www.connectionsys.co.uk/" style="display: block; text-align: center; font-size: 22px; text-decoration: none; color: #60CB97; font-family: Montserrat;">www.connectionsys.co.uk</a>
                                    </div>
                                </div>
                            </div>
                            </body></html>';

                        // echo $message;
                        
                        $isExists = $projects->checkNotification($project_id, $seller_id);
                        if(!$isExists) {
                            $email = $seller["email"];
                            $company_name = $seller["company_name"];

                            
                            $description = $item["description"];

                            $desc = json_encode($description);
                            $projects->addToNofications($project_name, $desc, $project_id, $seller_id);
        
                            $mail = new PHPMailer();
                            try {
                                //Server settings
                                // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                                $mail->isSMTP();                                            //Send using SMTP
                                $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                                $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                                $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                                $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                                $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
                            
                                //Recipients
                                $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                                $mail->addAddress($email, $company_name);     //Add a recipient
                                // $mail->addAddress('ellen@example.com');               //Name is optional
                                // $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');
                            
                                //Content
                                $mail->isHTML(true);                                  //Set email format to HTML
                                $mail->Subject = $subject;
                                $mail->Body    = $message;
                                // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
                            
                                // $mail->send();
                                // echo 'Message has been sent';
                            } catch (Exception $e) {
                                echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                                exit;
                            }
                        }
                    }
                }
            }
        }else {
            $uniqueProductTypes = [];
            // Create a new array to store items with unique product types
            $uniqueProjectItems = [];

            foreach ($projectItems as $item) {
                $productType = $item['product_type'];

                // Check if the product type is already in the unique array
                if (!in_array($productType, $uniqueProductTypes)) {
                    // Add the product type to the unique array
                    $uniqueProductTypes[] = $productType;
                    
                    // Add the item to the unique items array
                    $uniqueProjectItems[] = $item;
                }
            }

            $uniqueSellerIds = [];
            foreach($uniqueProjectItems as $item) {
                $product_type = $item["product_type"];
                $sellers = $projects->searchByKeywords($product_type);

                if($sellers) {
                    foreach($sellers as $seller) {
                        $seller_id = $seller["user_id"];
                        $country = $seller["country"];

                        $isPriceSent = $projects->isPriceSent($project_id, $seller_id);

                        $added_on = $projectData["added_on"];

                        // Get the current timestamp
                        $currentTimestamp = time();

                        // Calculate the difference in seconds
                        $timeDifference = $currentTimestamp - strtotime($added_on);

                        // if ($timeDifference >= 10 * 60) { // 10 minutes = 10 * 60 seconds // 24 hours = 24 * 3600 seconds
                        //     echo "The article was added 10 minutes ago or more.";
                        // } else {
                        //     echo "The article was added less than 10 minutes ago.";
                        // }

                        if($isPriceSent || $timeDifference >= 24 * 3600) {
                            if($country === "all" || $_SESSION["userData"]["country"] === $country) {
                                if (!in_array($seller_id, $uniqueSellerIds)) {
                                    $products_list = $seller["products_list"];

                                    $subject = "Looking for a new price offer";
                                    $message = '<!DOCTYPE html>
                                        <html>
                                            <head>
                                                <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">
                                            </head>
                                            <body><div style="background-color: #f6f6f6;">
                                                <div style="width: 600px; margin: auto; background-color: #fff;">
                                                    <div class="template-header" style="margin: 0 80px; background-color: #60CB97; height: 80px; display: flex; align-items: center; justify-content: center;">
                                                        <h1 style="color: #fff; text-transform: uppercase; font-weight: bold; margin: auto; font-size: 32px; text-align: center;">CONNECTION <span style="color: #696969;">SYSTEM</span></h1>
                                                    </div>
                                                    <div class="template-body" style="">
                                                        <div style="padding: 0 80px">
                                                            <h1 style="text-align: center; color: #383838; line-height: 36px; margin-bottom: 0; font-family: serif; font-size: 28px; unicode-bidi: plaintext;">DO YOUR BEST IN ORDER TO BE FIRST PLACE!</h1>
                                                            <div class="image" style="margin: auto; padding: 30px 0;">
                                                                <img style="width: 100%;" src="https://www.connectionsys.co.uk/public/images/image-1.png" alt="">
                                                            </div>
                                                        </div>
                                                        <div class="box" style="position: relative; padding: 20px 80px; padding-top: 0; background-color: #60CB97;">
                                                            <span style="display: block; width: 60%; margin: auto; height: 15px; background-color: #696969;"></span>
                                                            <h1 style="text-align: center; text-transform: uppercase; color: #2B454E; font-family: serif; font-size: 38px; margin-top: 15px; margin-bottom: 5px;">This project was edit</h1>
                                                            <h3 style="text-align: center; color: #fff; font-weight: 400; font-size: 21px; line-height: 28px; margin-top: 0; unicode-bidi: plaintext;">you receive a new opportunity from '. $sellerName .' looking to buy:</h3>
                                                            <div class="project-history" style="background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px;">
                                                                <h3 style="margin-top: 8px; margin-bottom: 5px; text-align: center;">'.$project_name.'</h3>
                                                                <p style="margin-top: 0; margin-bottom: 8px; text-align: center; font-size: 13px; color: #696969;"><b>Post Code:</b> '.$post_code.'</p>';
                                                                
                                                                // if($projectData["project_name"] !== $project_name) {
                                                                //     $message .= '<div>
                                                                //         <div style="width: 46%; display: inline-block; padding: 7.5px;">
                                                                //             <p style="margin-top: 5px; margin-bottom: 5px;">'.$projectData["project_name"].'</p>
                                                                //         </div>
                                                                //         <div style="width: 46%; display: inline-block; padding: 7.5px;">
                                                                //             <p style="margin-top: 5px; margin-bottom: 5px;">'.$project_name.'</p>
                                                                //         </div>
                                                                //     </div>';
                                                                // }
                                                                    
                                    $message .= '<div class="products-wrapper" style="background-color: #fff; margin: 5px; border-radius: 15px; text-align: left;">';


                                    foreach ($projectItems as $item) {
                                        $item_id = $item["id"];
                                        $product_type = $item["product_type"];
                                        $itemData = $products->getProjectItem($item_id);

                                        $is_edited = false;
                                        $edit_data = array();
                                        $itemStyle = '';

                                        $descStyles = '';
                                        $qtyStyles = '';
                                        $unitStyles = '';
                                        $drStyles = '';
                                        $openToSimilarBrandsStyles = '';

                                        if(!empty($item["edit_data"])) {
                                            $is_edited = true;
                                            $edit_data = json_decode($item["edit_data"], true);
                                            $itemStyle = "color: #df3079; text-decoration: line-through;";

                                            $nw_description = $edit_data["description"];
                                            $nw_quantity = $edit_data["quantity"];
                                            $nw_unit = $edit_data["unit"];
                                            $nw_date_required = $edit_data["date_required"];
                                            $nw_open_to_similar_brands = $edit_data["open_to_similar_brands"];

                                            if($item["description"] !== $nw_description) {
                                                $descStyles = "color: #df3079; text-decoration: line-through;";
                                            }

                                            if($item["quantity"] !== $nw_quantity) {
                                                $qtyStyles = "color: #df3079; text-decoration: line-through;";
                                            }

                                            if($item["unit"] !== $nw_unit) {
                                                $unitStyles = "color: #df3079; text-decoration: line-through;";
                                            }

                                            if($item["date_required"] !== $nw_date_required) {
                                                $drStyles = "color: #df3079; text-decoration: line-through;";
                                            }

                                            if($item["open_to_similar_brands"] !== $nw_open_to_similar_brands) {
                                                $openToSimilarBrandsStyles = "color: #df3079; text-decoration: line-through;";
                                            }

                                            $projects->updateProjectItem($item_id, $nw_description, $nw_quantity, $nw_unit, $nw_date_required, $nw_open_to_similar_brands);
                                            $projects->updateProjectItemEditData($item_id, '');
                                            // update offer items edit_permission
                                            $projects->updateOfferItemsEditPermission($project_id, $product_type, 1);
                                            $projects->updateOfferItemEditable($project_id, $item_id, 1);
                                        }
                                        
                                        $projects->updateProjectItemsStatus($project_id, '1');
                                        
                                        $listAray = explode(",", $products_list);
                                        if(in_array($product_type, $listAray)) {
                                            $beforeDesc = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; text-align: left; opacity: 70%;"><b style="color: #000;">Description: </b> <span style="'.$descStyles.'">'.modifyEmptyString($itemData["description"]).'</span></p>';
                                            $afterDesc = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Description: </b> '.modifyEmptyString($is_edited ? $edit_data["description"] : $itemData["description"]).'</p>';
                                            
                                            $beforeOpenToSimilarBrands = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> <span style="'.$openToSimilarBrandsStyles.'">'.ucfirst($itemData["open_to_similar_brands"]).'</span></p>';
                                            $afterOpenToSimilarBrands = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b style="color: #000;">Open To Similar Brands: </b> '.ucfirst($is_edited ? $edit_data["open_to_similar_brands"] : $itemData["open_to_similar_brands"]).'</p>';
                        
                                            $beforeQty = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; text-align: left; opacity: 70%;"><b style="color: #000;">Quantity:</b> <span style="'.$qtyStyles.'">'.modifyEmptyString($itemData["quantity"]).'</span></p>';
                                            $afterQty = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Quantity:</b> '.modifyEmptyString($is_edited ? $edit_data["quantity"] : $itemData["quantity"]).'</p>';
                        
                                            $beforeUnit = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; text-align: left; opacity: 70%;"><b style="color: #000;">Unit:</b> <span style="'.$unitStyles.'">'.modifyEmptyString($itemData["unit"]).'</span></p>';
                                            $afterUnit = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Unit:</b> '.modifyEmptyString($is_edited ? $edit_data["unit"] : $itemData["unit"]).'</p>';
                        
                                            $beforeDr = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; text-align: left; opacity: 70%;"><b style="color: #000;">Date Required:</b> <span style="'.$drStyles.'">'.modifyEmptyString($itemData["date_required"]).'</span></p>';
                                            $afterDr = '<p style="margin-bottom: 0; margin-top: 0; font-size: 12px; color: #000; text-align: left; opacity: 70%;"><b>Date Required:</b> '.modifyEmptyString($is_edited ? $edit_data["date_required"] : $itemData["date_required"]).'</p>';
                        
                                            $beforeFile = '';
                                            $afterFile = '';
                                            if($itemData["product_image_old"]) {
                                                $beforeFile = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 12px; line-height: 15px; text-align: left;"><a style="text-decoration: none;" href="'. BASE_URL . $itemData["product_image_old"].'">See the attached file to view how the buyer expects the materials to look.</a></p>';
                                            }

                                            if($itemData["product_image"]) {
                                                $afterFile = '<p style="margin-bottom: 2px; margin-top: 8px; font-size: 12px; line-height: 15px; text-align: left;"><a style="text-decoration: none;" href="'. BASE_URL . $itemData["product_image"].'">See the attached file to view how the buyer expects the materials to look.</a></p>';
                                            }
                        
                                            $message .= '<div class="product-item" style="box-sizing: border-box; width: 50%; display: inline-block; padding: 7.5px;">
                                                <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                                                    <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">'.ucfirst($itemData["product_type"]).'</h3>
                                                    '.$beforeDesc.'
                                                    '.$beforeOpenToSimilarBrands.'
                                                    '.$beforeQty.'
                                                    '.$beforeUnit.'
                                                    '.$beforeDr.'
                                                    '.$beforeFile.'
                                                </div>
                                            </div>';
                        
                                            $message .= '<div class="product-item" style="box-sizing: border-box; width: 49%; display: inline-block; padding: 7.5px;">
                                                <div style="padding: 5px 10px; border: 1px dashed #696969; border-radius: 10px;">
                                                    <h3 style="margin-top: 0; margin-bottom: 5px; font-weight: 600; font-size: 16px; text-align: left;">'.ucfirst($itemData["product_type"]).'</h3>
                                                    '.$afterDesc.'
                                                    '.$afterOpenToSimilarBrands.'
                                                    '.$afterQty.'
                                                    '.$afterUnit.'
                                                    '.$afterDr.'
                                                    '.$afterFile.'
                                                </div>
                                            </div>';
                                        }
                                    }

                                    $message .= '</div>
                                                    </div>
                                                        <div class="button" style="text-align: center;">
                                                            <a href="https://www.connectionsys.co.uk/">
                                                                <button style="background-color: #696969; border: transparent; height: 36px; padding: 0 18px; border-radius: 5px; font-size: 16px; text-transform: uppercase; color: #fff; font-weight: bold; cursor: pointer;">Price Him</button>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="template-footer" style="margin: 0 auto; text-align: center;padding: 15px 0;">
                                                    <span style="display: block; width: 32%; margin: auto; height: 8px; background-color: #60CB97; margin-bottom: 15px;"></span>
                                                    <a href="https://www.connectionsys.co.uk/" style="display: block; text-align: center; font-size: 22px; text-decoration: none; color: #60CB97; font-family: Montserrat;">www.connectionsys.co.uk</a>
                                                </div>
                                            </div>
                                        </div>
                                    </body></html>';

                                    // echo $message;

                                    $email = $seller["email"];
                                    $company_name = $seller["company_name"];
            
                                    // $desc = json_encode($description);
                                    // $projectsModel->addToNofications($project_name, $desc, $pid, $seller_id);
                
                                    $mail = new PHPMailer();
                                    try {
                                        //Server settings
                                        // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                                        $mail->isSMTP();                                            //Send using SMTP
                                        $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                                        $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                                        $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                                        $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                                        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                                        $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
                                    
                                        //Recipients
                                        $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                                        $mail->addAddress($email, $company_name);     //Add a recipient
                                        // $mail->addAddress('ellen@example.com');               //Name is optional
                                        // $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');
                                    
                                        //Content
                                        $mail->isHTML(true);                                  //Set email format to HTML
                                        $mail->Subject = $subject;
                                        $mail->Body    = $message;
                                        // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
                                    
                                        $mail->send();
                                        // echo 'Message has been sent';
                                    } catch (Exception $e) {
                                        echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                                        exit;
                                    }
    
                                    // Add the seller ID to the list of processed IDs
                                    $uniqueSellerIds[] = $seller_id;
                                }
                            }
                        }
                    }
                }               
            }
        }

        echo json_encode(array("status" => "success", "message" => "Project is Successfully Published"));;
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'DELETE_PROJECT') {
        $action_type = $_POST["action_type"];
        $project_id = $_POST["project_id"];

        $type = 1;
        if($action_type === 'project_only') {
            $type = 2;
        }

        $res = $projects->deleteProject($project_id, $type);

        if($res) {
            $response  = array("status" => "success", "message" => "Project deleted successfully.");
        }else {
            $response  = array("status" => "error", "message" => "Something went wrong!");
        }

        echo json_encode($response);
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'DELETE_PRODUCT') {
        $item_id = $_POST["item_id"];
        $project_id = $_POST["project_id"];

        $res = $projects->deleteProjectItem($item_id, $project_id);

        if($res) {
            $response  = array("status" => "success", "message" => "Product deleted successfully.");
        }else {
            $response  = array("status" => "error", "message" => "Something went wrong!");
        }

        echo json_encode($response);
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'LOAD_PRODUCTS') {
        $project_id = $_POST["project_id"];

        $results = $projects->getProjectItems($project_id);
        // echo json_encode($results);

        $projectData = $projects->getProject($project_id);

        $project_name = '';
        if($projectData) {
            $project_name = $projectData['project_name'];
        }

        $html = '';
        if($results) {
            $sn = 1;
            foreach ($results as $item) {
                $price_offers = $projects->getPriceOffers($project_id);
                $po_count = 0;
                if($price_offers) {
                    $po_count = count($price_offers);
                }

                // echo $_SESSION['vat-type'];
                $combinations = $projects->getBestCombinationItem($project_id, $item["id"]);
                // echo json_encode($combinations);
                // echo $item["id"];

                $html .= '<div class="product" data-id="'.$item["id"].'" data-project="'.$project_id.'" style="cursor: pointer;"> 
                            <div class="">
                                <div class="product-header">
                                    <h6 class="product-title">'.$sn.'. '.$item["product_type"].' <small class="product-qty text-muted" style="font-size: 10px;">QTY: '.$item["quantity"].'</small></h6>
                                </div>
                                <div class="product-details mb-5" style="font-size: 12px; color: #6A6A6A;">'.$item["description"].'</div>
                                <div class="bids" style="font-size: 12px; color: #6A6A6A;">Bids: '.$po_count.'</div>
                            </div>
                        <div class="product-status">
                            <div class="status-exploring mb-5" style="font-size: 12px; color: #6A6A6A; font-weight: 500">Status: Exploring</div>';

                if($combinations) {
                    $best_unit_price = PHP_INT_MAX;
                    $best_total_price = PHP_INT_MAX;
                    $best_delivery_price = PHP_INT_MAX;
                    $best_seller_names = [];
                    
                    foreach ($combinations as $combination) {
                        $bid_currency = $combination["bid_currency"];
                        if (empty($bid_currency)) {
                            $bid_currency = $userCurrency;
                        }
                        $product_price = (float)$combination['product_price'];
                        $total_price = (float)$combination['total_price'];
                        $delivery_price = (float)$combination['delivery_price'];
                    
                        // Check for best unit price
                        if ($product_price < $best_unit_price) {
                            $best_unit_price = $product_price;
                            // $best_seller_names = [$combination['supplier_name']];
                        } elseif ($product_price == $best_unit_price) {
                            // $best_seller_names[] = $combination['supplier_name'];
                        }
    
                        $best_seller_names[] = $combination['supplier_name'];
                    
                        // Check for best total price
                        if ($total_price < $best_total_price) {
                            $best_total_price = $total_price;
                        }
                    
                        // Check for best delivery price
                        if ($delivery_price < $best_delivery_price) {
                            $best_delivery_price = $delivery_price;
                        }
                    }
    
                    // Convert seller names array to a string
                    $best_seller_names_str = implode(', ', $best_seller_names);
    
                    $html .= '<div style="font-size: 12px; color: #60CB97;">Best Unit Price: '.$bid_currency.$best_unit_price.'</div>
                            <div style="font-size: 12px; color: #60CB97;">Best Seller Name: '.$best_seller_names_str.'</div>
                            <div style="font-size: 12px; color: #60CB97; margin-left: -28px;">';
                    if(count($combinations) > 1) {
                        $html .= '<a style="position: relative; text-decoration: none;" href="javascript:void(0);" data-offer-id="'.$combinations[0]["offer_id"].'" class="scroll-to-bestcomb" style="text-decoration: none;">
                            <span style="position: absolute; right: 3px; background-color: red; width: 15px; height: 15px; color: #fff; font-weight: bold; border-radius: 50%; font-size: 8px; align-items: center; display: flex; justify-content: center;">'.count($combinations).'</span>    
                            <svg xmlns="http://www.w3.org/2000/svg" enable-background="new 0 0 32 32" width="24" viewBox="0 0 32 32" id="notification">
                                    <g id="notification">
                                        <circle fill="red" cx="24.705" cy="8.175" r="3.412"></circle>
                                        <path fill="#60CB97" d="M27.16 21.543c-.911-1.518-1.392-3.255-1.392-5.025v-3.241c-.343.071-.698.11-1.063.11-2.874 0-5.212-2.338-5.212-5.212 0-1.778.898-3.347 2.261-4.288C20.139 2.706 18.154 2 16 2c-5.395 0-9.768 4.373-9.768 9.768v4.752c0 1.769-.481 3.506-1.392 5.023l-.714 1.189c-.677 1.127.135 2.562 1.45 2.562h20.847c1.314 0 2.126-1.434 1.45-2.561L27.16 21.543zM11.862 27.093C12.481 28.789 14.092 30 16 30s3.519-1.211 4.138-2.907H11.862z"></path>
                                    </g>
                                </svg>
                            </a>';
                    }        
                    
                    $html .= 'Best Total Price: '.$bid_currency.$best_total_price.'</div>
                            <div style="font-size: 12px; color: #60CB97;">Best Delivery Price: '.$bid_currency.$best_delivery_price.'</div>';
                }

                $html .= ' </div></div>';

                $sn++;
            }
        }else {
            $html = '<div class="text-center py-4">No Products found.</div>';
        }

        // Return HTML response
        // echo $html;
        echo json_encode(array('status' => 'success', 'project_name' => $project_name, 'data' => $html));
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'LOAD_BIDS') {
        $item_id = $_POST["item_id"];
        $project_id = $_POST["project_id"];

        $projectData = $projects->getProject($project_id);

        $project_name = '';
        if($projectData) {
            $project_name = $projectData['project_name'];
        }

        // echo json_encode($results);
        $project_item = $projects->getProjectItem($item_id);
        
        $html = '<div class="price-offers" data-project="'.$project_id.'" data-item="'.$item_id.'">
            <div class="pb-20">
            <h5 style="margin-top: 0;">'.ucfirst($project_item["product_type"]).'</h5>
            <p style="margin: 5px 0; color: #898989;">'.$project_item["description"].'</p>
            </div>';
        $product_name = ucfirst($project_item["product_type"]);
        $results = $projects->getPriceOffers($project_id);
        if($results) {
            $combinations = $projects->getBestCombinationItem($project_id, $item_id);

            $first_comb = null;
            $second_comb = null;
            if($combinations && count($combinations) > 1) {
                $first_comb = $combinations[0]["offer_id"];
                $second_comb = $combinations[1]["offer_id"];
            }

            // echo json_encode($combinations);

            $bid_length = 0;
            foreach ($results as $item) {
                // echo json_encode($item);
                $seller_id = $item["seller_id"];
                $offer_item = $projects->getOfferItem($seller_id, $item_id);

                if($offer_item) {
                    $vat_type = $offer_item["vat"];
                    try {
                        $delivery_date = DateTime::createFromFormat('d/m/Y', $offer_item['delivery_date']);
                        if ($delivery_date === false) {
                            throw new Exception('Invalid date format: ' . $offer_item['delivery_date']);
                        }
                        $offer_item['delivery_date'] = $delivery_date->format($dateFormat);
                    } catch (Exception $e) {
                        // Handle the error gracefully (e.g., log it or display a message)
                        echo 'Error parsing delivery date: ' . $e->getMessage();
                    }
                    $bid_currency = $offer_item["bid_currency"];
                    if (empty($bid_currency)) {
                        $bid_currency = $userCurrency;
                    }
                    $product_price = 0;
                    $vat_amount = 0;
                    $delivery_price = 0;
                    if($vat_type === '0') {
                        $product_price = $offer_item["product_price"];
                        $vat_amount = $product_price * 1.2 - $offer_item["product_price"];
                        $delivery_price = $offer_item["delivery_price"] * 1.2;
                    }else {
                        $product_price = ($offer_item["product_price"] * 100) / 120;
                        $vat_amount = $offer_item["product_price"] - $product_price;
                        $delivery_price = $offer_item["delivery_price"];
                    }
    
                    // echo $product_price;
                    // echo $vat_amount;
                    // $project_item["quantity"];
    
                    // echo json_encode($offer_items);

                    $projectData = $projects->getProject($project_id);
                    $is_completed = $projectData["is_completed"];

                    $statusType = null;
                    $is_ordered = '';
                    $is_declined = '';
                    $is_not_complete = '';
                    $is_order_out_of_website = '';

                    $select_style = '';
                    $select_prop = '';
                    if($is_completed === '1') {
                        $statusType = 'ordered';
                        $is_ordered = 'selected';
                        $select_prop = 'disabled';
                        $select_style = 'opacity: 0.5;';
                    }else if($is_completed === '2') {
                        $statusType = 'declined';
                        $is_declined = 'selected';
                        // $select_prop = 'disabled';
                    }else if($is_completed === '3') {
                        $statusType = 'order-out-of-website';
                        $is_order_out_of_website = 'selected';
                        // $select_prop = 'disabled';
                    }else {
                        $is_not_complete = 'selected';
                    }

                    $retings = $projects->getReviews($seller_id);

                    $sellerReview = '0.0 (0)';
                    if($retings && $retings["total_reviews"] > 0) {
                        $sellerReview = $retings["average_rating"] . ' <span style="display: inline-block; transform: translateY(-1px);">(</span>' .$retings["total_reviews"] . '<span style="display: inline-block; transform: translateY(-1px);">)</span>';
                    }
    
                    $html .= ' <div class="offer-item" data-id="'.$item["offer_id"].'" data-item="'.$item_id.'"  data-project="'.$project_id.'" style="margin-bottom: 10px; border-radius: 8px;">
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <div>
                                <strong>Supplier Name - '.$item["supplier_name"].'</strong>
                            </div>
                            <a href="reviews.php?uid='.$seller_id.'" style="text-decoration: none;">
                                <div class="seller-rating" style="background-color: #F5F5F5; border-radius: 10px; padding: 1px 8px; display: flex; align-items: center; gap: 5px;">
                                    <span style="font-size: 15px; color: #ff9800;">&#9733;</span> <span style="font-size: 12px; font-weight: 500; color: black;">'.$sellerReview.'</span>
                                </div>
                            </a>
                        </div>
                        <div style="margin: 10px 0;">
                            <p style="margin: 5px 0; color: #898989; font-size: 12px;">Product price: <b>'. $bid_currency.number_format($product_price, 2).'</b> (ex VAT) &nbsp;&nbsp; VAT price: <b>'.$bid_currency.number_format($vat_amount, 2).'</b> &nbsp;&nbsp; Product price: <b>'.$bid_currency.number_format($product_price + $vat_amount, 2).'</b> (inc VAT)</p>
                            <p style="margin: 5px 0; color: #898989; font-size: 12px;">Quantity: <b>'.$project_item["quantity"].'</b> &nbsp;&nbsp; Total for quantity (inc VAT): <b>'.$bid_currency.number_format(($product_price + $vat_amount) * $project_item["quantity"], 2).'</b> &nbsp;&nbsp; Delivery price (inc VAT): <b>'.$bid_currency.number_format($delivery_price, 2).'</b></p>
                            <p style="margin: 5px 0; color: #898989; font-size: 12px;">Total price (delivery + products (inc VAT)): <b>'.$bid_currency.number_format(($product_price + $vat_amount) * $project_item["quantity"] + $delivery_price, 2).'</b></p>
                            <p style="margin: 5px 0; color: #898989; font-size: 12px;">Delivery date: <b>'.$offer_item["delivery_date"].'</b> &nbsp;&nbsp; Payment terms: <b>'.$offer_item["payment_term"].'</b></p>
                        </div>
                        <div class="offer-actions d-flex" style="gap: 15px; padding-top: 10px; align-items: center;">
                            <div class="msg-icon" data-id="'.$seller_id.'" style="background-color: #73D0A3; padding: 8px; border-radius: 15px; cursor: pointer;">
                                <img src="public/images/messages-3.png" alt="messages" style="width: 26px;" />
                            </div>
                            <div class="update-pstatus" data-project-id="'.$project_id.'">
                                <select class="form-control" name="status_type" id="statusType" style="background-color: #f5f5f5; font-size: 14px; height: 40px; '.$select_style.'" '.$select_prop.'>
                                    <option value="" disabled '.$is_not_complete.'>Status</option>
                                    <option value="ordered" '.$is_ordered.'>Ordered</option>
                                    <option value="declined" '.$is_declined.'>Declined</option>
                                    <option value="order-out-of-website" '.$is_order_out_of_website.'>Out Of Website</option>
                                </select>
                            </div>';

                    if($first_comb && $second_comb) {
                        if($item["offer_id"] == $first_comb) {
                            $html .= '<div style="position: relative;">
                                    <button type="button" class="btn btn-primary scrollto-nextcomb" data-offer-id="'.$second_comb.'" style="background-color: #73D0A3; height: 40px; border: 1px solid #73D0A3; padding-right: 32px;">Go to Second Best Total Price <span style="position: absolute; top: 5px;"><svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" fill="none" viewBox="0 0 128 128" id="arrow-down"><path stroke="#fff" stroke-linecap="round" stroke-linejoin="round" stroke-width="7" d="M44 73L64 93L84 73"></path><path stroke="#fff" stroke-linecap="round" stroke-width="7" d="M64 35L64 93"></path></svg></span></button>
                                </div>';
                        }
                    }

                    $html .= '</div>';

                    if($statusType !== 'ordered') {
                        $html .= '
                            <div class="review-form mt-15" data-ofer-id="'.$item["offer_id"].'" style="display: none;">
                                <form action="" method="post">
                                    <div class="input-group ml-10 mb-10">
                                        <div class="rating">
                                            <input type="radio" id="star1" name="rating" value="5" required /><label for="star1"></label>
                                            <input type="radio" id="star2" name="rating" value="4" required /><label for="star2"></label>
                                            <input type="radio" id="star3" name="rating" value="3" required /><label for="star3"></label>
                                            <input type="radio" id="star4" name="rating" value="2" required /><label for="star4"></label>
                                            <input type="radio" id="star5" name="rating" value="1" required /><label for="star5"></label>
                                        </div>
                                    </div>
                                    <div class="input-group">
                                        <input type="hidden" name="project_id" value="'.$project_id.'" />
                                        <input type="hidden" name="item_id" value="'.$item_id.'" />
                                        <input type="hidden" name="offer_id" value="'.$item["offer_id"].'" />
                                        <input type="hidden" name="seller_id" value="'.$seller_id.'" />
                                        <input type="text" name="comment" id=""  placeholder="Enter a review" required>
                                         <button type="submit" class="btn-submit" id="submitForm" name="add-review" value="1">
                                            Submit
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>';
                    }

                    if($is_completed === '1') {
                        if($seller_id === $projectData['seller_id']) {
                            $reviewData = $projects->getProjectReview($project_id, $item["offer_id"]);
                            // echo json_encode($reviewData);

                            $html .= '
                                <div style="padding: 10px; background-color: #f1f1f1; border-radius: 5px; margin-top: 15px;">
                                    <div class="d-flex" style="gap: 15px; align-items: center;">
                                    <h6 class="mb-0" style="font-size: 16px;">My Review:</h6>    
                                    <div class="" style="background-color: #fff; border-radius: 10px; padding: 1px 8px; display: flex; align-items: center; gap: 5px;">
                                        
                                    <span style="font-size: 15px; color: #ff9800;">&#9733;</span> <span style="font-size: 12px; font-weight: 500; color: black;">'.number_format($reviewData['rating'], 1).'</span>
                                        
                                    </div>
                                </div>
                                <div style="margin-top: 5px;">
                                    <p class="text-muted mb-1">'.$reviewData["comment"].'</p>
                                </div>
                            </div>
                            ';
                        }
                    }

                    $html .= '<hr style="opacity: 0.1">';


                    $bid_length++;
                }
            }

            if($bid_length < 1) {
                $html .= '<div class="text-center py-4">No offers found.</div>';
            }
        }else {
            $html .= '<div class="text-center py-4">No offers found</div>';
        }

        $html .= '</div>';

        // Return HTML response
        // echo $html;
        echo json_encode(array('status' => 'success', 'project_name' => $project_name, 'data' => $html, 'product_name' => $product_name));
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'LOAD_NEW_BIDS') {
        $item_id = $_POST["item_id"];
        $project_id = $_POST["project_id"];

        $last_id = isset($_POST["last_id"]) ? $_POST["last_id"] : null;
        
        if(!$last_id) {
            return false;
        }

        $results = $projects->getPriceOffers($project_id, $last_id);
        // echo json_encode($results);

        $html = '';
        if($results) {
            $project_item = $projects->getProjectItem($item_id);

            $html .= '<div class="price-offers" data-project="'.$project_id.'" data-item="'.$item_id.'">
                <div class="pb-20">
                    <h5 style="margin-top: 0;">1. '.ucfirst($project_item["product_type"]).'</h5>
                    <p style="margin: 5px 0; color: #898989;">'.$project_item["description"].'</p>
                </div>';

            foreach ($results as $item) {
                // echo json_encode($item);
                $seller_id = $item["seller_id"];
                $offer_item = $projects->getOfferItem($seller_id, $item_id);

                if($offer_item) {
                    $vat_type = $offer_item["vat"];
    
                    $product_price = 0;
                    $vat_amount = 0;
                    $delivery_price = 0;
                    if($vat_type === '0') {
                        $product_price = $offer_item["product_price"];
                        $vat_amount = $product_price * 1.2 - $offer_item["product_price"];
                        $delivery_price = $offer_item["delivery_price"] * 1.2;
                    }else {
                        $product_price = ($offer_item["product_price"] * 100) / 120;
                        $vat_amount = $offer_item["product_price"] - $product_price;
                        $delivery_price = $offer_item["delivery_price"];
                    }
    
                    // echo $product_price;
                    // echo $vat_amount;
                    // $project_item["quantity"];
    
                    // echo json_encode($offer_items);

                    $retings = $projects->getReviews($seller_id);

                    $sellerReview = '0.0 (0)';
                    if($retings && $retings["total_reviews"] > 0) {
                        $sellerReview = $retings["average_rating"] . ' <span style="display: inline-block; transform: translateY(-1px);">(</span>' .$retings["total_reviews"] . '<span style="display: inline-block; transform: translateY(-1px);">)</span>';
                    }
    
                    $html .= ' <div class="offer-item" data-id="'.$item["offer_id"].'"  data-project="'.$project_id.'" style="margin-bottom: 10px; border-radius: 8px;">
                        <div style="display: flex; justify-content: space-between; align-items: center;">
                            <div>
                                <strong>Supplier Name - '.$item["supplier_name"].'</strong>
                            </div>
                            <a href="reviews.php?uid='.$seller_id.'" style="text-decoration: none;">
                                <div class="seller-rating" style="background-color: #F5F5F5; border-radius: 10px; padding: 1px 8px; display: flex; align-items: center; gap: 5px; ">
                                    <span style="font-size: 15px; color: #ff9800;">&#9733;</span> <span style="font-size: 12px; font-weight: 500; color: black;">'.$sellerReview.'</span>
                                </div>
                            </a>
                        </div>
                        <div style="margin: 10px 0;">
                            <p style="margin: 5px 0; color: #898989; font-size: 12px;">Product Price: '.$userCurrency.number_format($product_price, 2).' (ex VAT) &nbsp;&nbsp; VAT Price: '.$userCurrency.number_format($vat_amount, 2).' &nbsp;&nbsp; Product Price: '.$userCurrency.number_format($product_price + $vat_amount, 2).' (In VAT)</p>
                            <p style="margin: 5px 0; color: #898989; font-size: 12px;">Quantity: '.$project_item["quantity"].' &nbsp;&nbsp; Total Per Quantity (In VAT): '.$userCurrency.number_format(($product_price + $vat_amount) * $project_item["quantity"], 2).' &nbsp;&nbsp; Delivery Price (In VAT): '.$userCurrency.number_format($delivery_price, 2).'</p>
                            <p style="margin: 5px 0; color: #898989; font-size: 12px;">Total price (Delivery + Products (In VAT)): '.$userCurrency.number_format(($product_price + $vat_amount) * $project_item["quantity"] + $delivery_price, 2).'</p>
                            <p style="margin: 5px 0; color: #898989; font-size: 12px;">Delivery Date: '.$offer_item["delivery_date"].' &nbsp;&nbsp; Payment Term: '.$offer_item["payment_term"].'</p>
                        </div>
                        <div class="d-flex" style="gap: 15px; padding-top: 10px;">
                            <div class="msg-icon" data-id="'.$seller_id.'" style="background-color: #73D0A3; padding: 8px; border-radius: 15px; cursor: pointer;">
                                <img src="public/images/messages-3.png" alt="messages" style="width: 26px;" />
                            </div>
                            <div class="status">
                                <select class="form-control" name="status_type" id="" style="background-color: #f5f5f5; font-size: 14px; height: 40px;">
                                    <option value="" disabled selected>Status</option>
                                    <option value="ordered">Ordered</option>
                                    <option value="declined">Declined</option>
                                    <option value="order-out-of-website">Out Of Website</option>
                                </select>
                            </div>
                        </div>
                    </div>
    
                    <hr style="opacity: 0.1">';
                }

            }

            $html .= '</div>';
        }
        
        // Return HTML response
        echo $html;
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'PRODUCT_LIST') {
        $project_id = $_POST["project_id"];
        $user_id = $_SESSION["user_id"];
        $filter_option = $_POST["filter_option"];
        $sort_option = isset($_POST["sort_option"]) ? $_POST["sort_option"] : null;  // Sorting option (e.g., 'asc' or 'desc')
    
        $results = $projects->getPriceOffers($project_id, null, $user_id);
    
        $html = '';
        $count = 0;
        $offers_with_prices = [];
    
        if ($results) {
            foreach ($results as $item) {
                $seller_id = $item["seller_id"];
                $supplier_name = $item["supplier_name"];
                $offer_data = json_decode($item["offer_data"], true);
    
                if (is_array($offer_data)) {
                    foreach ($offer_data as $offer) {
                        $item_id = $offer["item_id"];
                        $project_item = $projects->getProjectItem($item_id);
                        $offer_item = $projects->getOfferItem($seller_id, $item_id);
                        $vat_type = $offer_item["vat"] ?? '';
    
                        // Calculate product price, VAT amount, and delivery price
                        $product_price = 0;
                        $vat_amount = 0;
                        $delivery_price = 0;
                        if ($vat_type === '0') {
                            $product_price = $offer_item["product_price"];
                            $vat_amount = $product_price * 1.2 - $offer_item["product_price"];
                            $delivery_price = $offer_item["delivery_price"] * 1.2;
                        } else {
                            $product_price = isset($offer_item["product_price"]) ? $offer_item["product_price"] : 0;
                            $vat_amount = isset($offer_item["product_price"]) ? ($offer_item["product_price"] - $product_price) : 0;
                            $delivery_price = isset($offer_item["delivery_price"]) ? $offer_item["delivery_price"] : 0;

                            $product_name = isset($offer_item["product_name"]) ? $offer_item["product_name"] : 'Unknown';

                        }
    
                        // Assuming $project_item["quantity"] is available, or set to 1 if not
                        $quantity = isset($project_item["quantity"]) ? $project_item["quantity"] : 1;
    
                        // Calculate total price
                        $total_price = ($product_price + $vat_amount) * $quantity + $delivery_price;
    
                        // Apply filter if filter_option is set
                        if ($filter_option) {
                            // Check if the offer's product matches the filter option
                            if (strtolower($offer_item["product_name"]) === strtolower($filter_option)) {
                                // Store the offer with its total price and HTML row
                                $offers_with_prices[] = [
                                    'html' => generateHtmlRow($offer_item, $supplier_name,  $product_price, $vat_amount, $quantity, $delivery_price, $total_price, $project_item),
                                    'total_price' => $total_price
                                ];
                            }
                        } else {
                            // If no filter, add the offer to the list
                            $offers_with_prices[] = [
                                'html' => generateHtmlRow($offer_item, $supplier_name,  $product_price, $vat_amount, $quantity, $delivery_price, $total_price, $project_item),
                                'total_price' => $total_price
                            ];
                        }
                    }
                }
            }
    
            // Sort the filtered offers by total price if $sort_option is provided
            if ($sort_option === 'high-to-low') {
                usort($offers_with_prices, function($a, $b) {
                    return $b['total_price'] <=> $a['total_price'];  // Sort descending (high to low)
                });
            } else if ($sort_option === 'low-to-high') {
                usort($offers_with_prices, function($a, $b) {
                    return $a['total_price'] <=> $b['total_price'];  // Sort ascending (low to high)
                });
            }
    
            // Generate the final HTML by concatenating the sorted rows
            foreach ($offers_with_prices as $offer) {
                $html .= $offer['html'];
                $count++;
            }
        }
    
        if ($count == 0) {
            $html .= '<tr><td class="text-muted" colspan="10" align="center">No products found for this project.</td></tr>';
        }
    
        // Return HTML response
        echo $html;
    }
    function isTwoWords($string) {
        return str_word_count($string) == 2;
    }
    function generateHtmlRow($offer_item, $supplier_name, $product_price, $vat_amount, $quantity, $delivery_price, $total_price, $project_item) {
        $uid = $_SESSION['user_id'];
        $authUser = new Users();
        $userInfo = $authUser->getUserDetails($uid);
        $dateFormat = isset($userInfo['date_format']) ? $userInfo['date_format'] : 'd/m/Y';
        $userCurrency = isset($userInfo['currency']) ? $userInfo['currency'] : '£';
        // Assuming $offer_item["delivery_date"] contains a value like '1.12', '12', or '01/12/2024'
        $deliveryDate = $offer_item["delivery_date"] ?? '';
        
       
        try {
            // Check if the deliveryDate matches the expected format
            $delivery_date = DateTime::createFromFormat($dateFormat, $deliveryDate);
        
            if ($delivery_date && $delivery_date->format($dateFormat) === $deliveryDate) {
                // Successfully parsed date
                $offer_item["delivery_date"] = $delivery_date->format($dateFormat);
            } else {
                // Invalid date format
                $offer_item["delivery_date"] = 'Invalid date';
            }
        } catch (Exception $e) {
            // Handle any unexpected exceptions
            $offer_item["delivery_date"] = 'Invalid date';
        }        
        

    
        return '<tr>
            <td class="text-end">' . ucfirst($offer_item["product_name"] ?? '') . '</td>
            <td class="text-center">' . ucfirst($supplier_name) . '</td>
            <td class="text-end">' . $userCurrency . number_format($product_price ?? 0, 2) . '</td>
            <td class="text-end">' . $userCurrency . number_format($vat_amount ?? 0, 2) . '</td>
            <td class="text-end">' . $userCurrency . number_format(($product_price ?? 0) + ($vat_amount ?? 0), 2) . '</td>
            <td class="text-center">' . ($project_item["quantity"] ?? 1) . '</td>
            <td class="text-end">' . $userCurrency . number_format((($product_price ?? 0) + ($vat_amount ?? 0)) * ($project_item["quantity"] ?? 1), 2) . '</td>
            <td class="text-end">' . $userCurrency . number_format($delivery_price ?? 0, 2) . '</td>
            <td class="text-end">' . $userCurrency . number_format($total_price ?? 0, 2) . '</td>
            <td class="text-center">' . ($offer_item["delivery_date"] ?? '') . '</td>
            <td class="text-end">' . ($offer_item["payment_term"] ?? '') . '</td>
        </tr>';
    }    
    

    if (isset($_POST["action"]) && $_POST['action'] === 'PRODUCT_LIST_X') {
        $project_id = $_POST["project_id"];
        $filter_option = $_POST["filter_option"];

        $results = $projects->getPriceOffers($project_id);

        $html = '';
        $count = 0;
        if ($results) {
            foreach ($results as $item) {
                // echo json_encode($item);
                $seller_id = $item["seller_id"];
                $offer_data = json_decode($item["offer_data"], true);

                // Check if json_decode was successful
                if (is_array($offer_data)) {
                    foreach ($offer_data as $offer) {
                        // echo json_encode($offer);

                        $item_id = $offer["item_id"];
                        $project_item = $projects->getProjectItem($item_id);
                        // echo json_encode($project_item);


                        // $seller_id = $item["seller_id"];
                        $offer_item = $projects->getOfferItem($seller_id, $item_id);
                        // echo json_encode($offer_item);
                        $vat_type = $offer_item["vat"];

                        $product_price = 0;
                        $vat_amount = 0;
                        $delivery_price = 0;
                        if($vat_type === '0') {
                            $product_price = $offer_item["product_price"];
                            $vat_amount = $product_price * 1.2 - $offer_item["product_price"];
                            $delivery_price = $offer_item["delivery_price"] * 1.2;
                        }else {
                            $product_price = ($offer_item["product_price"] * 100) / 120;
                            $vat_amount = $offer_item["product_price"] - $product_price;
                            $delivery_price = $offer_item["delivery_price"];
                        }

                        if($filter_option) {
                            if($offer_item["product_name"] === $filter_option) {
                                // Ensure $project_item is a valid array
                                if (is_array($project_item)) {
                                    $html .= '<tr>
                                            <td class="">' . ucfirst($offer_item["product_name"]) . '</td>
                                            <td class="">$' . number_format($product_price, 2) . '</td>
                                            <td class="">$' . number_format($vat_amount, 2) . '</td>
                                            <td class="">$' . number_format($product_price + $vat_amount, 2) . '</td>
                                            <td class="">' . $project_item["quantity"] . '</td>
                                            <td class="">$' . number_format(($product_price + $vat_amount) * $project_item["quantity"], 2) . '</td>
                                            <td class="">$' . number_format($delivery_price, 2) . '</td>
                                            <td class="">$' . number_format(($product_price + $vat_amount) * $project_item["quantity"] + $delivery_price, 2) . '</td>
                                            <td class="">' . $offer_item["delivery_date"] . '</td>
                                            <td class="">' . $offer_item["payment_term"] . '</td>
                                        </tr>';
                                } else {
                                    // Handle error if $project_item is not a valid array
                                    $html .= '<tr><td class="text-muted" colspan="10" align="center">Error fetching project item for item ID ' . $item_id . '</td></tr>';
                                }

                                $count++;
                            }
                        }else {
                            // Ensure $project_item is a valid array
                            if (is_array($project_item)) {
                                $html .= '<tr>
                                        <td class="">' . ucfirst($offer_item["product_name"]) . '</td>
                                        <td class="">$' . number_format($product_price, 2) . '</td>
                                        <td class="">$' . number_format($vat_amount, 2) . '</td>
                                        <td class="">$' . number_format($product_price + $vat_amount, 2) . '</td>
                                        <td class="">' . $project_item["quantity"] . '</td>
                                        <td class="">$' . number_format(($product_price + $vat_amount) * $project_item["quantity"], 2) . '</td>
                                        <td class="">$' . number_format($delivery_price, 2) . '</td>
                                        <td class="">$' . number_format(($product_price + $vat_amount) * $project_item["quantity"] + $delivery_price, 2) . '</td>
                                        <td class="">' . $offer_item["delivery_date"] . '</td>
                                        <td class="">' . $offer_item["payment_term"] . '</td>
                                    </tr>';
                            } else {
                                // Handle error if $project_item is not a valid array
                                $html .= '<tr><td class="text-muted" colspan="10" align="center">Error fetching project item for item ID ' . $item_id . '</td></tr>';
                            }

                            $count++;
                        }
                    }
                } else {
                    // Handle error if $offer_data is not a valid array
                    $html .= '<tr><td class="text-muted" colspan="10" align="center">Error decoding offer data for seller ID ' . $seller_id . '</td></tr>';
                }
            }
        } else {
            // Handle case where no results were found
            // $html .= '<tr><td class="text-muted" colspan="10" align="center">No price offers found for project ID ' . $project_id . '</td></tr>';
        }

        if($count == 0) {
            $html .= '<tr><td class="text-muted" colspan="10" align="center">No products found for this project.</td></tr>';
        }

        // Return HTML response
        echo $html;
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'GET_FILTER_PRODUCTS') {
        $user_id = $_SESSION["user_id"];
        $project_id = $_POST["project_id"];

        if($project_id) {
            $project_items = $projects->getProjectItems($project_id);
            // echo json_encode($project_items);
        }else {
            $project_items = $projects->getAllProjectItems($user_id);
        }


        $products = array();

        if($project_items) {
            foreach ($project_items as $item) {
                $products[] = $item["product_type"];
            }
        }

        // filter uniqe products
        $unique_products = array_unique($products);
        // echo json_encode($unique_products);

        $html = '<li class="active" data-id="'.$project_id.'" data-product="" style="padding: 5px 10px; cursor: pointer;">All</li>';

        if(!empty($unique_products)) {
            foreach ($unique_products as $product) {
                $html.= '<li class="" data-id="'.$project_id.'" data-product="'. $product. '" style="padding: 5px 10px; cursor: pointer;">'.ucfirst($product).'</li>';
            }
        }


        echo $html;
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'UPDATE_STATUS') {
        // echo json_encode($_POST);
        // exit;

        $project_id = $_POST['project_id'];
        $offer_id = $_POST['offer_id'];
        $item_id = $_POST['item_id'];
        $status = $_POST['status'];

        $offer = $projects->getOfferById($offer_id);
        $seller_id = $offer["seller_id"];

        $res = $projects->updateStatus($project_id, $offer_id, $item_id, $seller_id, $status);

        if($res) {
            $response  = array("status" => "success", "message" => "Status successfully changed.");
        }else {
            $response  = array("status" => "error", "message" => "Something went wrong!");
        }

        echo json_encode($response);
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'ADD_REVIEW') {
        // echo json_encode($_POST);
        // exit;

        $user_id = $_SESSION["user_id"];
        $seller_id = $_POST["seller_id"];
        $project_id = $_POST['project_id'];
        $offer_id = $_POST['offer_id'];
        $item_id = $_POST['item_id'];
        $rating = $_POST['rating'];
        $comment = $_POST['comment'];

        $res =  $projects->updateStatus($project_id, $offer_id, $item_id, $seller_id, 'ordered');
        
        if($res) {
            $projects->addReview($user_id, $seller_id, $project_id, $offer_id, $item_id, $rating, $comment);

            $response  = array("status" => "success", "message" => "Review added successfully.");
        }else {
            $response  = array("status" => "error", "message" => "Something went wrong!");
        }

        echo json_encode($response);
    }

    if (isset($_POST["add-review"])) {
        $user_id = $_SESSION["user_id"];
        $seller_id = $_POST["seller_id"];
        $project_id = $_POST['project_id'];
        $offer_id = $_POST['offer_id'];
        $item_id = $_POST['item_id'];
        $rating = $_POST['rating'];
        $comment = $_POST['comment'];
        
        $redirect = '';
        if(isset($_POST['redirect'])) {
            $redirect = 'admin';
        }

        $res = $projects->addReview($user_id, $seller_id, $project_id, $offer_id, $item_id, $rating, $comment);

        if($res) {
            $response  = array("status" => "success", "project_id" => $project_id, "message" => "Review added successfully.");

            if($redirect === 'admin') {
                header("Location: ".BASE_URL."admin.php?" . http_build_query($response) . "");
            }else {
                header("Location: ".BASE_URL."buyer.php?" . http_build_query($response) . "");
            }
        }else {
            $response  = array("status" => "error", "project_id" => $project_id, "message" => "Something went wrong!");

            header("Location: ".BASE_URL."buyer.php?" . http_build_query($response) . "");
        }
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'updateProjectIPublished') {
        $project_id = $_POST['project_id'];

        $projectData = $projects->getProject($project_id);

        if($projectData) {
            $projectItems = $projects->getProjectItems($project_id);

            $data = '<div class="single-project" data-id="' . $project_id . '">
                <div class="product-name">
                    <div class="">
                        <h6>' . $projectData["project_name"] . '</h6>
            
                        <span class="text-muted"><b>Postcode:</b> ' . $projectData["post_code"] . '</span>
                    </div>
                    <div class="toggle-arrow">
                        <img src="public/images/arrow.svg" alt="" class="" />
                    </div>
                </div>
                <div class="item" data-id="' . $project_id . '" style="display: none">
                    <div class="d-flex justify-content-end mt-10 pr-10">
                        <a class="text-decoration-none" style="color: #60cb97" href="edit-project.php?pid=' . $project_id . '">Edit Project</a>
                    </div>
                    <hr />
                    <div class="product-info d-flex align-items-center justify-content-between">
                        <div class="products">';
                        
            foreach($projectItems as $item) {
                $product = $products->getProductByName($item["product_type"]);
                $productName = !empty($product["name"]) ? $product["name"] : 'Unknown';

                $data .= '<div class="" data-type="' . $item["id"] . '">
                    <div class="product d-flex align-items-center">
                        <div class="p-img">
                            <img class="lazyload" src="' . $product["image"] . '" alt="' . ucfirst($item["product_type"]) . '">
                        </div>
                        <div class="p-name">
                            <h6>' . $productName . '</h6>
                        </div>
                    </div>
                    <div class="suppliers">
                        <div class="table-head">
                            <h6 class="m-0">Suppliers</h6>
                        </div>
                        <div class="">
                            <div class="offers-wrapper">
                                <span class="no-offer-msg mt-10 mb-10 text-center text-muted" style="display: none">No offers found!</span>
                            </div>
                        </div>
                    </div>
                </div>';
            }

            $data .= '</div>
                        </div>
                    </div>
                </div>';
        }

        echo $data;


    }

    if (isset($_POST["action"]) && $_POST['action'] === 'updatePriceOffers') {
        $user_id = $_SESSION["user_id"];
        
        $res = $projects->updatePriceOffers($user_id);

        if($res) {
            echo json_encode(array("status" => "success", "result" => $res));
        }else {
            echo json_encode(array("status" => "error"));
        }
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'updateBestCombination') {
        $user_id = $_SESSION["user_id"];
        $last_id = $_POST["last_id"];
        
        $res = $projects->updateBestCombination($user_id, $last_id );

        if($res) {
            echo json_encode($res);
        }else {
            echo json_encode(array("status" => false));
        }
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'updateBestCombinationItem') {
        $user_id = $_SESSION["user_id"];
        
        $res = $projects->updateBestCombinationItem($user_id);

        if($res) {
            echo json_encode(array("status" => "success", "result" => $res));
        }else {
            echo json_encode(array("status" => "error"));
        }
    }

    if (isset($_POST["action"]) && $_POST['action'] === 'getPriceIOffer') {
        $user_id = $_SESSION["user_id"];
        $last_id = $_POST["last_id"] ?? '';
        $project_id = $_POST["project_id"] ?? '';

        $res = $projects->updateProductIOffer($user_id, $last_id, $project_id);

        if($res) {
            echo json_encode($res);
        }else {
            echo json_encode(array("status" => false));
        }
    }
?>