<?php
    include '../../load.php';
    include '../models/Products.php';

    $products = new Products();
    if(isset($_POST["add-new-product"])) {
        $product_name = $_POST["product_name"];

        if ($_FILES['product_image']['error'] === UPLOAD_ERR_OK && is_uploaded_file($_FILES['product_image']['tmp_name'])) {
            $file = $_FILES["product_image"];
            
            $uploadDirectory = "uploads/";
            $maxSizeKB = 200; // Maximum size in KB
            $maxWidth = 800; // Maximum width for resized image
            $quality = 75; // Initial quality for compression
            
            // Generate a new file name for the compressed image
            $newFileName = generateSecretKey(8);
            $compressedFileName = "product_" . $newFileName . "." . pathinfo($file["name"], PATHINFO_EXTENSION);
            $compressedFilePath = "../../" . $uploadDirectory . $compressedFileName;
            
            // Compress and resize the image
            if (compressAndResizeImage($file["tmp_name"], $compressedFilePath, $quality, $maxWidth)) {
                // Check the file size
                $fileSizeKB = filesize($compressedFilePath) / 1024;
        
                // Debugging: Output the compressed file size
                // echo "Compressed file size: " . $fileSizeKB . " KB\n";
        
                // Add the compressed and resized image path to the database
                $res = $products->addProduct($product_name, $compressedFilePath);
        
                if($res) {
                    $response =  array("type" => "p-msg", "status" => "success", "message" => "Product added successfully.");
                } else {
                    $response =  array("type" => "p-msg", "status" => "danger", "message" => "Something went wrong!");
                }
            } else {
                $response =  array("type" => "p-msg", "status" => "danger", "message" => "Error compressing and resizing product image.");
            }
        
            // Optionally, remove the original uploaded file
            unlink($file["tmp_name"]);
        
        } else {
            $response =  array("type" => "p-msg", "status" => "danger", "message" => "Product image is required.");
        }

        header("Location: ".BASE_URL."admin.php?" . http_build_query($response) . "");
    }

    if(isset($_POST["action"]) && $_POST["action"] === "getProductItem") {
        $itemId = $_POST["id"];

        $res = $products->getProjectItem($itemId);

        echo json_encode($res);
    }
?>