<?php
    session_start();

    use PHPMailer\PHPMailer\PHPMailer;
    use PHPMailer\PHPMailer\Exception;
    use PHPMailer\PHPMailer\SMTP;

    include '../../load.php';
    include '../models/Messages.php';
    include '../models/Users.php';

    $messages = new Messages();
    $users = new Users();

    if(isset($_POST['action']) && $_POST['action'] == 'SEND_MESSAGE') {
        $sender_id = $_SESSION['user_id'];
        $receiver_id = $_POST['receiver_id'];
        $message_text = $_POST['message_text'];

        $uploadedFilePath = '';
        $file_name = '';
        if(isset($_FILES["file"])) {
            $file = $_FILES["file"];

            $uploadDirectory = "uploads/";
            $newFileName = generateSecretKey(32);
            $uploadedFilePath = $uploadDirectory . $newFileName . "." . pathinfo($file["name"], PATHINFO_EXTENSION);
            $file_name = $file["name"];

            // echo $uploadedFilePath;
            if (move_uploaded_file($file["tmp_name"], "../../" . $uploadedFilePath)) {
                // echo $file["name"] . "File has been uploaded successfully.";
            } else {
                // echo "Failed to upload the file.";
                $uploadedFilePath = '';
                $file_name = '';
            }
        }
        
        $message = $messages->getLastMessage($sender_id, $receiver_id);
        if($message) {
            $message_id = $message["message_id"];
            $sent_at = $message["sent_at"];
            // 1 hour ago datetime
            // $date = '2023-10-11 17:47:33';
            $oneHourAgo = date('Y-m-d H:i:s', strtotime('-1 hour'));
    
            if($sent_at < $oneHourAgo) {
                // send message to receiver email
                $receiver = $users->getUserById($receiver_id);
                $email = $receiver["email"];
                $company_name = $receiver["company_name"];
    
    
                $subject = "Connection system";
                $message = '<!DOCTYPE html>
                    <html>
                        <head>
                            <style>
                                @import url("https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600&family=Montserrat:wght@300;400;500;600;700&display=swap");
                            </style>
                        </head>
                        <body>
                            <div style="background-color: #f6f6f6;">
                                <div style="width: 600px; margin: auto; background-color: #fff;">
                                    <div class="template-header" style="margin: 0 80px; background-color: #60CB97; height: 80px; display: flex; align-items: center; justify-content: center;">
                                        <h1 style="color: #fff; text-transform: uppercase; font-weight: bold; margin: auto; font-size: 32px; text-align: center;">CONNECTION <span style="color: #696969;">SYSTEM</span></h1>
                                    </div>
                                    <div class="template-body">
                                        <div style="padding: 0 80px">
                                            <h1 style="text-align: center; color: #383838; line-height: 36px; margin-bottom: 0; font-family: serif; font-size: 28px; unicode-bidi: plaintext;">You have a new chat message.</h1>
                                            <div class="image" style="width: 70%; margin: auto; padding: 30px 0;">
                                                <img style="width: 100%;" src="https://www.connectionsys.co.uk/public/images/image-3.png" alt="">
                                            </div>
                                        </div>
                                        <div class="box" style="position: relative; padding: 20px 80px; padding-top: 0; background-color: #60CB97;">
                                            <span style="display: block; width: 60%; margin: auto; height: 15px; background-color: #696969;"></span>
                                            <h1 style="text-align: center; text-transform: uppercase; color: #2B454E; font-family: serif; font-size: 38px; margin-top: 15px; margin-bottom: 5px;"Chat Message</h1>
                                            <h3 style="text-align: center; color: #fff; font-weight: 400; font-size: 21px; line-height: 28px; margin-top: 0; unicode-bidi: plaintext;">You receive a new message from '.$_SESSION["userData"]["company_name"].'</h3>
                                            <div class="project-history" style="background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px;">
                                                <p style="margin-top: 8px; margin-bottom: 8px; text-align: center; font-size: 13px; color: #696969; font-family: Montserrat;">'.$message_text.'</p>
                                            </div>';

                if($uploadedFilePath != '') {
                    $message .= '<div class="project-history" style="display: flow-root; background-color: #F5F5F5; border: 5px solid #fff; border-radius: 15px; margin-bottom: 30px; padding: 15px;">
                        <a href="'. BASE_URL .''. $uploadedFilePath.'" style="text-decoration: none;">
                            <div>
                                <div class="file-icon" style="margin-right: 20px; float: left;">
                                    <img style="width: 40px;" src="https://www.connectionsys.co.uk/public/images/file-icon.png" alt="">
                                </div>
                                <div class="attachment-info" style="width: 100%;">
                                    <div style="float: left;">
                                        <h4 style="margin-top: 0; margin-bottom: 5px; font-weight: 500; color: #000; font-size: 16px; width: 290px; text-align: left;">'.$file_name.'</h4>
                                        <p style="margin: 0; font-size: 13px; color: #60CB97; text-align: left;">View Attachment</p>
                                    </div>
                                    <img style="width: 20px; float: right; padding-top: 15px;" src="https://www.connectionsys.co.uk/public/images/download-icon.png" alt="">
                                </div>
                            </div>
                        </a>
                    </div>';
                }
    
                $message .= '<div class="button" style="text-align: center;">
                                        <a href="https://www.connectionsys.co.uk/">
                                            <button style="background-color: #696969; border: transparent; height: 36px; padding: 0 18px; border-radius: 5px; font-size: 16px; text-transform: uppercase; color: #fff; font-weight: bold; cursor: pointer;">Check Messages</button>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="template-footer" style="margin: 0 auto; text-align: center;padding: 15px 0;">
                                <span style="display: block; width: 32%; margin: auto; height: 8px; background-color: #60CB97; margin-bottom: 15px;"></span>
                                <a href="https://www.connectionsys.co.uk/" style="display: block; text-align: center; font-size: 22px; text-decoration: none; color: #60CB97; font-family: Montserrat;">www.connectionsys.co.uk</a>
                            </div>
                        </div>
                    </div>
                </body></html>';
    
                $mail = new PHPMailer();
                try {
                    //Server settings
                    // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output
                    $mail->isSMTP();                                            //Send using SMTP
                    $mail->Host       = 'smtp.gmail.com';                     //Set the SMTP server to send through
                    $mail->SMTPAuth   = true;                                   //Enable SMTP authentication
                    $mail->Username   = 'no-reply@connectionsys.co.uk';                     //SMTP username
                    $mail->Password   = 'ukpomcbjcycpnxkq';                               //SMTP password
                    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;            //Enable implicit TLS encryption
                    $mail->Port       = 587;                                    //TCP port to connect to; use 587 if you have set `SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS`
                
                    //Recipients
                    $mail->setFrom('no-reply@connectionsys.co.uk', 'Connection Systems');
                    $mail->addAddress($email, $company_name);     //Add a recipient
                    // $mail->addAddress('ellen@example.com');               //Name is optional
                    // $mail->addReplyTo('no-reply@connectionsys.co.uk', 'Information');
                
                    //Content
                    $mail->isHTML(true);                                  //Set email format to HTML
                    $mail->Subject = $subject;
                    $mail->Body    = $message;
                    // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';
                
                    $mail->send();
                    // echo 'Message has been sent';
                } catch (Exception $e) {
                    echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
                    exit;
                }
    
            }
        }

        // echo $message_text;
        $res = $messages->sendMessage($sender_id, $receiver_id, $message_text, $uploadedFilePath, $file_name);
        echo $res;
    }


    if(isset($_POST['action']) && $_POST['action'] == 'updateChatUser') {
        $uid = $_SESSION['user_id'];


        $activeUserId = '';
        if(isset($_POST['activeUserId']) && !empty($_POST['activeUserId'])) {
            $activeUserId = $_POST['activeUserId'];
        }

        $res = $messages->updateChatUser($uid, $activeUserId);
        echo json_encode($res);
    }

    if(isset($_POST['action']) && $_POST['action'] == 'loadMoreMessages') {
        $user1 = $_SESSION['user_id'];
        $user2 = $_POST["receiver_id"];
        $first_id = $_POST["first_id"];

        $res = $messages->loadMoreMessages($user1, $user2, $first_id);
        if($res) {
            echo json_encode(array("status" => "success", "total" => $res["total"], "result" => $res["chats"]));
        }else {
            echo json_encode(array("status" => "error"));
        }
    }

    if(isset($_POST['action']) && $_POST['action'] == 'updateMessages') {
        $user1 = $_SESSION['user_id'];
        $user2 = $_POST["receiver_id"];
        $last_msg_id = $_POST["last_msg_id"];

        $res = $messages->updateMessages($user1, $user2, $last_msg_id);
        echo $res;
    }

    if(isset($_POST['action']) && $_POST['action'] == 'unreadMessagesCount') {
        $user_id = $_SESSION['user_id'];

        $res = $messages->unreadMessagesCount($user_id);
        if($res) {
            $response = array('status' => 'success', 'unread_count' => $res['unread_count']); 
        }else {
            $response = array('status' => 'error');
        }

        echo json_encode($response);
    }
?>