<?php
    session_start();

    include '../../load.php';
    include '../models/Users.php';

    $user = new Users();

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // $ip = file_get_contents('https://api.ipify.org');
        $ip = get_client_ip();
        $locationInfo = getCurrencyAndDateFormatByIp($ip);
        $email = $_POST['email'];
        $password = $_POST['password'];
    
        // reCAPTCHA validation
        if(isset($_POST['g-recaptcha-response']) && !empty($_POST['g-recaptcha-response'])) {
            // Google secret API
            $secretAPIkey = '6Ld6FwUoAAAAAABdOuLGwmAM2grRQj0zFxxKkwlT';
            // reCAPTCHA response verification
            $verifyResponse = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret='.$secretAPIkey.'&response='.$_POST['g-recaptcha-response']);
            // Decode JSON data
            $response = json_decode($verifyResponse);
            
            if($response->success){
                // code will be here
            }else {
                $response = array(
                    "action" => "user-login",
                    "status" => "danger",
                    "message" => "Robot verification failed, please try again."
                );
            }
        }else {
            $response = array(
                "action" => "user-login",
                "status" => "danger",
                "message" => "Plese check on the reCAPTCHA box."
            );
        }

        $passwordHash = hash("sha256", $password);
        $res = $user->authenticate($email, $passwordHash);
        // echo json_encode($res);
        // exit;

        if($res) {
            $_SESSION["user_id"] = $res["user_id"];
            $_SESSION["userData"] = $res;
            $_SESSION["show"] = "home";

            $_SESSION["add-new-project"] = 'show';
            if ($locationInfo) {
                $userId = $res["user_id"];
                $country = $locationInfo["country"];
                $currency = $locationInfo["currency"];
                $dateFormat = $locationInfo["date_format"];
            
                $user->updateUserDetails($userId, $country, $currency, $dateFormat);
            }
            
            if($res["account_type"] === "admin") {
                header("Location: ".BASE_URL."admin.php");
            }else if($res["account_type"] === "seller") {
                header("Location: ".BASE_URL."seller.php?login=success");
            }else {
                header("Location: ".BASE_URL."buyer.php?login=success");
            }
                
        }else {
            $response =  array(
                "action" => "user-login",
                "status" => "danger",
                "message" => "Incorrect email address or password."
            );
        }

        header("Location: ".BASE_URL."index.php?" . http_build_query($response) . "");
    }
    function get_client_ip() {
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP']))
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_X_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        else if(isset($_SERVER['HTTP_FORWARDED']))
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        else if(isset($_SERVER['REMOTE_ADDR']))
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }
    function getCurrencyAndDateFormatByIp($ip) {
        // Using geoPlugin API for geolocation
        $url = "http://www.geoplugin.net/json.gp?ip={$ip}";
    
        // Initialize cURL session
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
    
        // Decode the JSON response
        $data = json_decode($response, true);
    
        if (isset($data['geoplugin_countryCode'])) {
            $countryCode = $data['geoplugin_countryCode'];
            $currency = getCurrencyByCountry($countryCode);
            $dateFormat = getDateFormatByCountry($countryCode);
    
            return [
                'country' => $countryCode,
                'currency' => $currency,
                'date_format' => $dateFormat
            ];
        } else {
            return null; // If country information is not available
        }
    }
    function getCurrencyByCountry($countryCode) {
        // Currency symbols mapped to countries
        $currencyMap = [
            'US' => '$',  // USD
            'GB' => '£',  // GBP
            'IN' => '₹',  // INR
            'CA' => '$',  // CAD
            'AU' => '$',  // AUD
            'PK' => '₨',  // PKR
            'DE' => '€',  // EUR
            'FR' => '€',  // EUR
            'IT' => '€',  // EUR
            'ES' => '€',  // EUR
            'CN' => '¥',  // CNY
            'JP' => '¥',  // JPY
            'BR' => 'R$', // BRL
            'MX' => '$',  // MXN
            'RU' => '₽',  // RUB
            'KR' => '₩',  // KRW
            'SG' => '$',  // SGD
            'ZA' => 'R',  // ZAR
            'SE' => 'kr', // SEK
            'IL' => '₪',  // ILS (Israeli New Shekel)
        ];
    
        return isset($currencyMap[$countryCode]) ? $currencyMap[$countryCode] : null;
    }
    
    function getDateFormatByCountry($countryCode) {
        // Date formats mapped to countries
        $dateFormatMap = [
            'US' => 'm/d/Y',  // MM/DD/YYYY
            'GB' => 'd/m/Y',  // DD/MM/YYYY
            'IN' => 'd/m/Y',  // DD/MM/YYYY
            'CA' => 'Y-m-d',  // YYYY-MM-DD
            'AU' => 'd/m/Y',  // DD/MM/YYYY
            'PK' => 'd-m-Y',  // DD-MM-YYYY
            'DE' => 'd.m.Y',  // DD.MM.YYYY
            'FR' => 'd/m/Y',  // DD/MM/YYYY
            'IT' => 'd/m/Y',  // DD/MM/YYYY
            'ES' => 'd/m/Y',  // DD/MM/YYYY
            'CN' => 'Y-m-d',  // YYYY-MM-DD
            'JP' => 'Y/m/d',  // YYYY/MM/DD
            'BR' => 'd/m/Y',  // DD/MM/YYYY
            'MX' => 'd/m/Y',  // DD/MM/YYYY
            'RU' => 'd.m.Y',  // DD.MM.YYYY
            'KR' => 'Y-m-d',  // YYYY-MM-DD
            'SG' => 'd/m/Y',  // DD/MM/YYYY
            'ZA' => 'Y/m/d',  // YYYY/MM/DD
            'SE' => 'Y-m-d',  // YYYY-MM-DD
            'IL' => 'd/m/Y',  // DD/MM/YYYY (Common format in Israel)
        ];
    
        return isset($dateFormatMap[$countryCode]) ? $dateFormatMap[$countryCode] : 'Y-m-d';  // Default to YYYY-MM-DD
    }
    
        
    
?>