<?php
    session_start();

    include '../../load.php';
    include '../models/Projects.php';
    include '../models/Notifications.php';
  
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $input = json_decode(file_get_contents('php://input'), true);
        $project_id = $input['project_id'] ?? null;
        $notify_id = $input['notify_id'] ?? null;
        $status = $input['status'] ?? 'all';
        $uid = $_SESSION["user_id"];
        if ($project_id && $notify_id) {
            $notifModel = new Notifications();
            $checkOffer = $notifModel->checkOffer($uid, $notify_id);
            if($checkOffer["status"] === "success") {
                $offer = $checkOffer["result"][0];
                $offer_id = $offer["offer_id"];

                // echo json_encode($offer);

                $offer_items = $notifModel->getOfferItemsByOfferId($offer_id, $uid);
            }
            $projectModel = new Projects();
            $projectItems = $projectModel->getProjectItems($project_id, $status);
    
            if ($projectItems) {
                echo json_encode(['success' => true, 'projectItems' => $projectItems, 'offerItems' => $offer_items]);
            } else {
                echo json_encode(['success' => false, 'message' => 'No items found.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid project ID.']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    }
?>