<?php
    session_start();

    include '../../load.php';
    include '../models/Users.php';

    $users = new Users();

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST["change-password"])) {
        $uid = $_SESSION["user_id"];

        if($uid) {
            $currentPassword = $_POST["current-password"];
            $newPassword = $_POST["new-password"];
            $confirmPassword = $_POST["confirm-password"];
    
            if($newPassword !== $confirmPassword) {
                $response = array(
                    "status" => "danger",
                    "message" => "New password and confirm password do not match"
                );
            } else {
                $encryptedCurrentPass = hash("sha256", $currentPassword);

                $loginCredentials = $users->getLoginCredentials($uid);
                $dbPassword = $loginCredentials["password"];
                
                if($dbPassword !== $encryptedCurrentPass) {
                    $response = array(
                        "status" => "danger",
                        "message" => "Current password is incorrect"
                    );
                } else {
                    $encryptedPass = hash("sha256", $newPassword);
                    $newKey = generateSecretKey(32);
                    $response = $users->changePassword($uid, $encryptedPass, $newKey);

                    if($response) {
                        $response = array(
                            "status" => "success",
                            "message" => "Password changed successfully"
                        );
                    } else {
                        $response = array(
                            "status" => "danger",
                            "message" => "Failed to change password"
                        );
                    }
                }
            }

            if($_SESSION["userData"]["account_type"] === "buyer") {
                header("Location: ".BASE_URL."change-password.php?" . http_build_query($response) . "");
            }else {
                header("Location: ".BASE_URL."edit.php?" . http_build_query($response) . "");
            }
        }else {
            header("Location: ".BASE_URL."login.php");
        }
    }
?>